/*
 * User-space parport hogger (for stress-testing parport).
 *
 * Copyright (c) 1998 Tim Waugh <tim@cyberelk.demon.co.uk>
 */

#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/parport.h>
#include "ppuser.h"

int main (int argc, char * argv [])
{
	int p;

	/* Check we've been told which device to open */
	if (argc < 2) {
		fprintf (stderr, "Hog which parport?\n");
		return 1;
	}

	/* Open the device */
	p = open (argv[1], O_RDWR);
	if (p < 0) {
		fprintf (stderr, "Couldn't open %s\n", argv[1]);
		return 2;
	}

	/* Now hog the port. */
	for (;;) {
		const struct timespec w = {0, 250000000}; /* 250ms */

		/* Claim the port */
		if (ioctl (p, PPCLAIM, 0)) {
			printf ("Couldn't claim port!\n");
			continue;
		}

		/* Wait for a while */
		nanosleep (&w, NULL);

		/* Release the port */
		if (ioctl (p, PPRELEASE, 0))
			printf ("Couldn't release port!\n");

		putchar ('.');
		fflush(NULL);
	}
	
	return 0;
}
