/*	PiHelp.h - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-96 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - help strings
*/


typedef struct
	{
	char	*topic;
	char	*help[8];
	}PIHELP;

#ifdef	PDGLOB
char *piclhlp[] = {
"1. Essential LOADICE.INI File contents:",
"  Items in [..] are optional",
"  Command Line arguments override 'ini' file parameters",
"  Use any of \" ,:=[](){}\" these break characters in input",
"   ('ini' file may be specified by the environment variable LOADICE)",
"   i.e. 'set LOADICE=loadice2.ini' and in UNIX etc. also 'export LOADICE'",
" PARAMETERS IN THE 'INI' FILE:",
" 'output=name[:address]' - serial device name (and optional address in DOS)",
" 'baud=rate' - 1200,2400,4800,9600,19200,57600",
" 'parallel=[lpt]n[:address]' - parallel (down-load only) device name",
" 'pponly=[lpt]n[:address]' - bidirectional parallel device name",
" 'ppbus=[lpt]n[:address]' - parallel down-load only bus cable in use",
" 'fastport=hostname' - specify Ethernet FastPort hostname",
" 'rom=[id:]size' - set emulation size, for one or all ROMs",
" 'socket=[id:]size' - when socket is wired for a larger ROM than emulating",
" 'map [0|1]' - display range of data being down-loaded, also 'nomap'",
" 'fill=[id:]hex' - specify ROM fill character - ROMs filled before loading",
" 'word=size[byteOrder]' - specify word size and byte order i.e 'word=16 1 0'",
" 'file=name.hex fileaddress=[id:]romaddress[word,byteOrder]' - hex file specs",
" 'image=name.bin skip=[id:]romaddress[word,byteOrder]' - binary file",
" 'noverify' - don't verify downloaded data, use for faster loading",
" 'noaddrerr [1]' - ignore address out of range error / 1 - show bad records",
" 'nocursor - disable the spinning cursor, handy on some displays",
" 'dialog' - enter dialog mode",
"-more (press ENTER or <CR>)",
" PARAMETERS IN THE 'INI' FILE: (contd.)",
" 'load' - load files before entering dialog mode",
" 'checksum [id:]start end store x|a|A size' -checksum ROM after loading",
" ' store one two or four bytes depending on size, default is one",
" any line in 'ini' file that begins with a '.' will be executed immediately",
" this fact can be used to operate the entire interface from a batch file",
" or you may use the 'begin' command that starts up the comm link",
"-more (press ENTER or <CR>)",
" ESSENTIAL PARAMETERS ON THE COMMAND LINE:",
" . - if first char is '.' don't look for any ini file",
" @ - if first char is '@' use the following string as 'ini' file",
" Example '@new.ini -d' will process the new.ini file and go into dialog mode",
" -o name[:address] - serial output device",
" -b rate - baud rate",
" -p [lpt]n[:address] - parallel down-load only port",
" -q [lpt]n[:address] - parallel port for bidirectional i/o",
" -fp hostname - Ethernet FastPort hostname",
" -n # - number of PROMICE units connected (UNIX and daisy-chains only)",
" -r [id:]size - emulation size for ROM(s)",
" -f [id:]hex - fill character",
" -w size,byteOrder - emulation word size",
" filename fileInfo - hex file specs",
" -i filename fileInfo - binary file specs",
" -v - don't verify down-loaded data",
" -x [1] - don't check hex record checksum 1/display bad records",
" -z [1] - ignore address out of range errors 1/display bad records",
" -F - don't fill ROMs (override -f or fill in ini file)",
" -O [0|1] - turn data range display ON or OFF (default is ON)",
" -d - go into dialog mode",
" -l - load ROMs before going into dialog mode",
" -L - don't load ROMs before entering dialog mode",
0
};

PIHELP pxhelp[] = {
"?",
{"Dialog mode command help: USE '? topic' for more help; some topics are:",
"  compare,config,dump,display,edit,exit,fill,file,go,image,light,load",
"  save,socket,status,stop,word,checksum,scmd,find",
"  - (see more commands in the manual) items in '[..]' are optional.",
"  Flash related commands: fon,spd,man,chip,sec,bpe,see,cee,flog,",
"  - fion & fr",
"  - you may use ? with one or more letters to select a topic",0},
/* bpe command */
"bpe",
{"create byte program error in Flash",
"	syntax:	bpe{a|A|o|O|t|T|x|X} #",
"	 use bpe with a=AND, o=OR, t=Timeout, x=restore",
"	 hex data pattern is AND'd OR'd or just a timeout occurs",
"	 Capital letters indicate make error on all BP instructions",
"	 else error occurs only on next operation",
"	 example: 'bpea e7' AND requested program data with 0xE7 ",0},
/* cee command */
"cee",
{"create chip erase error in Flash",
"	syntax:	cee{a|A|t|T|x|X} #",
"	 use cee with a=AND, t=Timeout, x=restore",
"	 hex data pattern is AND'd or just a timeout occurs",
"	 Capital letters indicate make error on all CE instructions",
"	 else error occurs only on next operation",
"	 example: 'ceet' create timeout (ETL) on next CE",0},
/* chip command */
"chip",
{"display statistics on the entire Flash Chip",
"	syntax:	chip",
"	 check out the accumulated stats",
"	",
"	",
"	",
"	",0},
/*  c [[id:][start end]] */
"compare",
{"compares file data with down-loaded data",
" syntax:  c",
"  compares PROMICE contents against file data",
"  instead of down-loading, data is uploaded and compared",
"  if partial down-load was specified with the file(s)",
"  then only data in specified range is uploaded and compared",
"  mismatches are reported",0},
/* cfg code - display config */
"config",
{"display configuration information: various things may be requested:",
" syntax: C type - where type can be:",
"  all - display all the information",
"  link - display only the PROMICE link information",
"  rom - display information about each emulation module",
"  file - display information about each file",
"  cfg - display current rom configuration",0},
/*  d [[id:]address1] [address2] */
"dump",
{"dump one or more bytes of ROM space, hex and ASCII data is displayed",
" syntax:  d [id:][start, end]",
"  - dumps either per current config (can be changed with 'word')",
"  - or from the specified ROM, data is displayed in hex as well",
"  - as ASCII characters.",
"  - a <CR> will result in repeated dumps at subsequent address ranges",
"  ",0},
/*  D # - change display level */
"display",
{"change the output level of LoadICE:",
" syntax:   D ff - the hex value sets the mask for display levels within",
"  - LoadICE application.  The eight bits represent eight levels",
"  - very-high, high, medium-high, medium,",
"  - medium-low, low, low-low, very-low",
"  Default levels are very-high and high.",
"  Try different levels and see how much detail can be seen",0},
/*  e [[id:]address][data] */
"edit",
{"edit ROM contents:",
" syntax:  e [id:][address] [data, data, ....]",
"  - if address and data list is given, edit and done else interactive",
"  - the addressed location will be changed to given data",
"  - in multibyte configuration the entire word is changed",
"  - if no data is given the location is opened and displayed",
"  - type new data, x or . for exit, <cr> for next loc, ^ to backup pointer",0},
/*  f [id:]start end data */
"fill",
{"fill one or more ROM locations with pattern",
" syntax:  f [id:][start] [end] [data1, data2] [size]",
"  - if no arguments are given then all ROMs are filled",
"  - with their previously specified 'fill-character'",
"  - if one arg given then it is 'data1', if two args given then",
"  - they are 'start' address and 'data1', else all three are given",
"  - if 'size'>32 then also give 'data2', if no ID fill current config",0},
/*  file name offset=[id:]addr word/byte order */
"file",
{"specifies a file for down loading",
" syntax:  h name [offset=[id:]address word byte order (start end)]",
"  - 'h' is for hex files",
"  - use 'i' for binary files and 'j' for formatted binaries",
"  - use 'offset' and 'address' to map file to the right place",
"  - don't specify ID if word info is given",
"  - specify partial load range in '(' ')'",0,},
/* fion command */
"fion",
{"turn on the flash emulation in FlashICE",
"	syntax:	fion",
"	 when LoadICE connects with FlashICE, FlashICE turns off emulation",
"	 then LoadICE must issue fion for flash emulation turned back on",
"	 this keeps things clean while connecting",
"	 'fioff' can turn emulation off",
"	 with fioff its just a rom emulator",0},
/* flog command */
"flog",
{"log all the flash traffic to a file",
"	syntax:	flog [filename]",
"	 use it to log all the Flash traffic to a file",
"	 filename is flashice.log by default",
"	 use flog utility to view the log",
"	 log is a binary file",
"	",0},
/* fon command */
"fon",
{"turn the Flash Monitor on",
"	syntax:	fon #",
"	 starts the Flash Monitor on the Host",
"	 the host does all the emulation of flash device",
"	 use 'fon 0' if you don't want verbose output",
"	 you may want to do that if logging stuff to a file",
"	 use 'foff' to stop the monitor",0},
/*  file name offset=[id:]addr word/byte order */
"image",
{"specifies a binary file for down loading",
" syntax:  i name [skip=[id:]address word byte order (start end)]",
"  - 'skip' is the amount of data to skip from begining of the file",
"  - ",
"  - use  'address' to map file to the right place",
"  - don't specify ID if word info is given",
"  - specify partial load range in '(' ')'",0,},
/*  go - into emulation */
"go",
{"put units into emulation mode",
" syntax:  go",
"  - put units into emulation mode",
"  - undoes 'stop'",
"  - allows the target to execute (releases reset)",
"  - after editing loading dumping etc.",
"  - you may use the ESC key for toggling this mode",0,},
/*  l [[id:]start end] */
"load",
{"load file data to the PROMICE chain",
" syntax:  l [fileInfo]",
"  - load all files specified",
"   - if [fileInfo] then load the",
"   - specified hex file only",
"   - same as '.h' followed by 'l'",
"   - use 'li' if binary file in [fileInfo]",0},
/* man command */
"man",
{"set the manufacturer's code",
"	syntax:	man #",
"	 use this command to set 8-bit manufacturer's code",
"	 by default it is set to 01 - AMD",
"	 use 'dev ##' to set device code",
"	",
"	",0},
/* opt command */
"opt",
{"set operating options for FlashICE",
"	syntax:	opt #",
"	 number is 0,1,2,or 3",
"	 0 - AND data to location and ETL if 0->1 attempted",
"	 1 - ETL if location is not FF",
"	 2 - AND data to location, period",
"	 3 - MOVE data to location",0},
/*  s name [id:][start, end] */
"save",
{"save ROM contents to disk file",
" syntax:  s name [id:][start, end]",
"  - save data to file 'name'd",
"  - if ID is given only save that ROM",
"  - else data is saved per config",
"  - 'start' and 'end' allow partial save",
"  ",0},
/* sec command */
"sec",
{"show statistics on the sector",
"	syntax:	sec #",
"	 show accumulated statistics on sec# given",
"	",
"	",
"	",
"	",0},
/* see command */
"see",
{"create sector erase error in Flash",
"	syntax:	see{a|A|t|T|x|X} #",
"	 use see with a=AND, t=Timeout, x=restore",
"	 hex data pattern is AND'd or just a timeout occurs",
"	 Capital letters indicate make error on all SE instructions",
"	 else error occurs only on next operation",
"	 example: 'seeT' create timeout (ETL) on all SEs",0},
/* spd command */
"spd",
{"sets sector protection data",
"	syntax:	spd #",
"	 set the hex value as sector protection byte",
"	 each bit corresponds with the sector number (or group)",
"	 a bit set implies that sector is protected",
"	 by default all sectors are unprotected, i.e. spd=00",
"	 Example: 'spd 80' will protect sector #7",0},
/*  stop - stop emulation */
"stop",
{"stop emulation",
" syntax:  stop",
"  - put unit(s) in load mode",
"  - target is stopped (reset asserted)",
"  - allows editing loading dumping",
" ",
"  - use the ESC key to toggle this mode",0},
/*  w size[/order] */
"word",
{"change the ROM configuration",
" syntax:  w size[byte order]",
"  - change the current word size",
"  - by specifying the IDs making up the word",
" ",
" ",
" ",0},
/*  x */
"checksum",
{"compute checksum / or ignore checksum errors in user file",
" syntax:  k [id:][start,end,store]/a|A|x size",
"  - compute checksum on the ROM given using either",
"  - a|A='add all bytes' or x='xor all bytes' method",
"  - checksum is stored at the given address",
"  - size is the length of result in bytes to store",
"  - a=store 2's complement A=store 1's complement x=store result",0},
/*  z # */
"ignore",
{"ignore address-out-of-range errors in user data files",
" syntax:  z #",
"  - if # = 0 don't print records with errors",
"  - if # = 1 print records with error",
"  - ",
"  ",
"  ",0},
/*  !string */
"scmd",
{"escape a command to the host shell",
" syntax:  !string",
"  - if your system supports this feature",
"  - then the 'string' is passed to the host",
"  - operating system via the 'system()' syscall",
"  ",
"  ",0},
/*  find or search */
"find",
{"find data or string in memory",
" syntax:  find|F start end length data OR search|S start end string",
"  find finds binary data bytes and search searches strings",
"  use find of F and search of S",
"  both command keep looking for more matches",
"  use <CR> to terminate operation",
"  ",0},
/*  show target status */
"status",
{"report target system status",
" syntax:  st",
"  report target system status if emulating.",
"  if the micro-code supports it then LoadICE",
"  will show if target power is ON and if the",
"  target is accessing ROM",
"  ",0},
/*  set socket size */
"socket",
{"set the socket size of target system for AI use",
" syntax:  socket size",
"  allows setting of socket size where the unit",
"  is plugged into. This allows for proper addressing",
"  of the AI interface from the host when",
"  the interface is running in transparant mode",
"  size is specified in the same way as ROM size",0},
0};

#else
extern char *piclhlp[];
extern PIHELP pxhelp[];
#endif
