#	Makefile for Borland TURBO-C
#	File:       makefile.tcc
#	Target:     loadice.exe
#	Created:    Dec. 18, 1994
#	Grammar Engine, Inc.

MAKEFILE = makefile.tcc
CDEFINES  = -G -O -Z -c -w4 -mh -DTCC -DMSDOS -DANSI
CDEFINESS  = -G -O -Z -c -w4 -ms -DTCC -DMSDOS -DANSI

CC = tcc
LL = tlink -x
TL = \tc\lib

all:	loadice.exe	vlog.exe flog.exe

piglob.obj: \
		piglob.c \
		piconfig.h \
		pistruct.h \
		piscript.h \
		pierror.h \
		pihelp.h \
		pidata.h \
		pisyn.h
	$(CC) $(CDEFINES)  piglob.c

loadice.obj: \
		loadice.c \
		piconfig.h \
		pistruct.h
	$(CC) $(CDEFINES)  loadice.c

pishell.obj: \
		pishell.c \
		piconfig.h \
		piscript.h \
		pistruct.h \
		pierror.h \
		pihelp.h
	$(CC) $(CDEFINES) pishell.c

pisetup.obj: \
		pisetup.c
	$(CC) $(CDEFINES) pisetup.c

pisyn.obj: \
		pisyn.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pisyn.h
	$(CC) $(CDEFINES) pisyn.c

pisynf.obj: \
		pisynf.c \
		piconfig.h \
		piscript.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h \
		pihelp.h \
		pisyn.h
	$(CC) $(CDEFINES)  pisynf.c

piedit.obj: \
		piedit.c \
		piconfig.h \
		pistruct.h \
		pierror.h
	$(CC) $(CDEFINES)  piedit.c

pifile.obj: \
		pifile.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pifile.h \
		pidata.h
	$(CC) $(CDEFINES)  pifile.c

pimap.obj: \
		pimap.c \
		piconfig.h \
		pistruct.h
	$(CC) $(CDEFINES) pimap.c

piconfig.obj: \
		piconfig.c \
		piconfig.h \
		pistruct.h
	$(CC) $(CDEFINES)  piconfig.c

pierror.obj: \
		pierror.c \
		piconfig.h \
		pistruct.h \
		pierror.h
	$(CC) $(CDEFINES)  pierror.c

picore.obj: \
		picore.c \
		piconfig.h \
		pistruct.h \
		piscript.h \
		pierror.h \
		pidata.h \
		pidriver.h \
		pisyn.h
	$(CC) $(CDEFINES)  picore.c

piutil.obj: \
		piutil.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h
	$(CC) $(CDEFINES)  piutil.c

fiutil.obj: \
		fiutil.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h
	$(CC) $(CDEFINES)  fiutil.c

pitrace.obj: \
		pitrace.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h
	$(CC) $(CDEFINES)  pitrace.c

pidriver.obj: \
		pidriver.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidev.h
	$(CC) $(CDEFINES)  pidriver.c

pimsdos.obj: \
		pimsdos.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h \
		pidev.h
	$(CC) $(CDEFINES)  pimsdos.c

li.lib:	piglob.obj \
		pishell.obj \
		pisetup.obj \
		pisyn.obj \
		pisynf.obj \
		piedit.obj \
		pifile.obj \
		pimap.obj \
		piconfig.obj \
		pierror.obj \
		picore.obj \
		piutil.obj \
		fiutil.obj \
		pitrace.obj \
		pidriver.obj \
		pimsdos.obj
		tlib li -+piglob -+pishell -+pisyn -+pisynf -+piedit\
		 -+pifile -+pimap -+piconfig -+pierror
		tlib li -+pisetup -+picore -+piutil -+fiutil -+pitrace\
		-+pidriver -+pimsdos
loadice.exe: li.lib loadice.obj
		$(LL) $(TL)\c0h loadice,loadice,, $(TL)\ch $(TL)\emu $(TL)\mathh li

vlog.obj: vlog.c
	$(CC) $(CDEFINESS)  vlog.c

vlog.exe: vlog.obj 
		$(LL) $(TL)\c0s vlog,vlog,, $(TL)\cs $(TL)\emu $(TL)\maths

flog.obj: flog.c
	$(CC) $(CDEFINESS)  flog.c

flog.exe: flog.obj 
		$(LL) $(TL)\c0s flog,flog,, $(TL)\cs $(TL)\emu $(TL)\maths

clean:
	del *.obj
	del li.lib
	del li.bak
