/*	PiUNIX.c - Edit 3

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	S Y S T E M  S P E C I F I C   D E V I C E  I/O  R O U T I N E S
	For UNIX systems
	- 4/23/92 - added stuff for BSD derivatives, different IOCTLs
	- 3/17/93 - added support for parallel port I/O
*/

/* Worked on by Tom Trebisky 9-2012
 * Assumes UNIX and ANSI are defined and these have been applied by hand.
 */

#include <stdio.h>

#ifdef LINUX
#include <unistd.h>
#include <termios.h>
#include <time.h>
#else
#include <sys/termio.h>
#endif

#include <sys/ioctl.h>
#include <fcntl.h>
#include <sgtty.h>
#include <sys/types.h>
#include <sys/time.h>

#include "piconfig.h"
#include "pistruct.h"
#include "pierror.h"
#include "pidriver.h"
#include "pidata.h"
#include "pidev.h"
#include "ppreg.h"

long pi_raw(void);
long pi_toggle(void);
void pi_cook(void);
long pi_switch(void);
void pi_sleep(short time);
void pi_setime(time_t time);
long pi_chktime();
void pi_put(char data);
void pi_putp(char data);
void pi_puts(char *str);
long pi_get(char *data);
long pi_getp(char *data);
void pi_putp(char data);
void pi_putp2(char data);
void pi_ccw(void);
void pi_cccw(void);
void do_outp(int a, int b);
char do_inp(int a);

char *pxaicstr = "MCON 000 000";

extern short pptwo;
static time_t pithen;
static time_t ttime;
static long to;

int umodem;
int picuct;

/* `pi_raw` - set serial port to raw mode or mess with the parallel port */

long pi_raw ( void )
{
#ifdef BSD
	struct sgttyb arg;
	int flags, baud;
#else
	struct termio arg;
	char baud;
	int flags;
	short tflag = 1;
#endif

#ifdef	HP
	if ((pxlink.saddr = open(pxlink.name,O_RDWR)) < 0)
		return(PGE_BAA);
	close(pxlink.saddr);
#endif

	if (!(pxlink.flags&PLPQ) || (piflags&PiAI && !(piflags&PiXP)))
		{
		switch (pxlink.brate)
			{
			case 1200:
				baud = B1200;
				break;
			case 2400:
				baud = B2400;
				break;
			case 4800:
				baud = B4800;
				break;
			case 9600:
				baud = B9600;
				break;
			case 19200:
				baud = B19200;
				break;
			default:
				printf("Invalid baud rate %ld changing to 19200\n",pxlink.brate);
				baud = B19200;
				pxlink.brate = 19200;
				break;
			}


		printf("Opening serial device '%s' at %ld Baud\n",pxlink.name,pxlink.brate);

		if ((pxlink.saddr = open(pxlink.name,O_RDWR)) < 0)
			return(PGE_IOE);
		if ((flags = fcntl(pxlink.saddr, F_GETFL, 0)) == -1)
			return(PGE_IOE);
		if (fcntl(pxlink.saddr, F_SETFL, flags | O_NDELAY) == -1)
			return(PGE_IOE);
#ifdef BSD
		if (ioctl(pxlink.saddr, TIOCGETP, &arg) < 0)
			return(PGE_IOE);

		arg.sg_ispeed = baud;
		arg.sg_ospeed = baud;
		arg.sg_flags = RAW;

		if (ioctl(pxlink.saddr, TIOCSETP, &arg) <0)
			return(PGE_IOE);
#else
		if (ioctl(pxlink.saddr, TCGETA, &arg) < 0)
			return(PGE_IOE);
		arg.c_iflag = 0;
		arg.c_oflag = 0;

#ifdef HP
		arg.c_cflag = baud | CREAD | CS8;
#else
		arg.c_cflag = baud | CREAD | CS8 | CLOCAL;
#endif

		arg.c_lflag = 0;
		arg.c_cc[VMIN] = 1;
		arg.c_cc[VTIME] = 1;
		if (ioctl(pxlink.saddr, TCSETA, &arg) < 0)
			return(PGE_IOE);

		pi_toggle();
		if (piflags&PiAI)
			{
			/*pi_put((char)pxaibchr); */
			pi_toggle();
			pi_toggle();
			pi_toggle();
			}
		tflag = 0;
#ifdef	AISWITCH
		if (piflags&PiSW)
			if (ioctl(pxlink.saddr, TCSBRK, 0) < 0)
				return(PGE_IOE);
		if (ioctl(pxlink.saddr, TCFLSH, TCIOFLUSH) < 0)
			return(PGE_IOE);
#endif
		}
#endif
#ifdef MAGMASP
	if (pxlink.flags&(PLPP|PLPQ))
		{
		printf("Opening parallel device '%s\n'",pxlink.pname);
		if ((pxlink.paddr = open(pxlink.pname,O_RDWR)) < 0)
			return(PGE_IOE);
		pxlink.ppin = PP_STS;
		pxlink.ppout = PP_CTL;
		pxlink.ppdat = PP_DAT;
		}
	if (pxlink.flags&PLPQ)
		{
		if (tflag)
			{
			pi_toggle();
			if (piflags&PiAI)
				{
				pi_toggle();
				pi_toggle();
				pi_toggle();
				}	
			}
		}
#endif
	return(PGE_NOE);
}

/* `pi_toggle` - toggle the PROMICE reset interrupt line */

long pi_toggle ( void )
{
	if (!(pxlink.flags&PLPQ) || (piflags&PiAI && !(piflags&PiXP)))
		{
#ifdef BSD
		if (pxdisp&PXVL)
			printf("^");
		if (ioctl(pxlink.saddr, TIOCSDTR, 0) < 0)
			return(PGE_IOE);
		pi_sleep(1);
		if (ioctl(pxlink.saddr, TIOCCDTR, 0) < 0)
			return(PGE_IOE);
#endif
#ifdef SUN
		if (pxdisp&PXVL)
			printf("^");
		if (ioctl(pxlink.saddr, TIOCMGET, &umodem) < 0)
			return(PGE_IOE);
		umodem |= TIOCM_DTR;
		if (ioctl(pxlink.saddr, TIOCMSET, &umodem) < 0)
			return(PGE_IOE);
		/*pi_sleep(1); */
		umodem &= ~TIOCM_DTR;
		if (ioctl(pxlink.saddr, TIOCMSET, &umodem) < 0)
			return(PGE_IOE);
#endif
		}
#ifdef MAGMASP
	else
		{
		if (pxdisp&PXVL)
			printf("|");
		do_outp(pxlink.ppout, PP_INITS);
		pi_sleep(1);
		do_outp(pxlink.ppout, PP_INITC);
		}
#endif
}

/* `pi_cook` - restore the serial port */

void pi_cook ( void )
{
#ifdef MAGMASP
	if (pxlink.flags&(PLPQ|PLPP))
		(void)close(pxlink.paddr);
#endif
	if (!(pxlink.flags&PLPQ))
		(void)close(pxlink.saddr);
}

/* `pi_xmt` - send a block of data over the i/o device */

long pi_xmt(char *buf, long ct)
{
	int i, cnt, offset, n_write;

	pi_setime(PIC_TOT);

	if (pxlink.flags&(PLPP|PLPQ)) {
		if (write(pxlink.paddr,buf,ct) < 0)
			return(PGE_IOE);
	} else {
		cnt = ct;
		offset = 0;
		while ((n_write = write(pxlink.saddr, buf+offset, cnt)) != cnt)
			{
			if (n_write > 0)
				{
				pi_chktime();
				offset += n_write;
				cnt -= n_write;
				}
			}
	}

	return(PGE_NOE);
}

/* `pi_rcv` - receive a standard response from the PROMICE */

long pi_rcv ( void )
{
	long i,j=0,k,l;
	
	pi_setime(PIC_TOT);
	if (pxlink.flags&PLPQ)
		{
		if (read(pxlink.paddr,pxrsp,260)<0)
			return(PGE_IOE);
		pxrspl = pxrsp[PICT] + 3;
		if (pxrspl == 3)
			pxrspl = 259;
		}
	else
		{
		i=l=0;
		k=4;
		while(k)
			{
			while ((i=read(pxlink.saddr,&pxrsp[l],k)) < 0)
				if (pxerror || (j++>pxtout))
					{
					if (!pxerror)
						pi_chktime();
					if (pxtout)
						return(PGE_TMO);
					}
			l+=i;
			k-=i;
			}
		if (pxrsp[PICT] == 0)
			pxrspl = PIC_MP;
		else
			pxrspl = (pxrsp[PICT]&0xff) + 3;
		i=l=4;
		k=pxrspl-4;
		while(k)
			{
			while ((i=read(pxlink.saddr,&pxrsp[l],k)) < 0)
				if (pxerror || (j++>PIC_DLY))
					{
					if (!pxtout)
						pi_chktime(PIC_TOT);
					if (pxtout)
						return(PGE_TMO);
					}
			l+=i;
			k-=i;
			}
		}
	return(PGE_NOE);
}


/* `pi_setime`  - set timeout time */

void pi_setime ( time_t ttime )
{
	time_t t;
	pxtout = 0;
	t = time(NULL);
	pithen = t+ttime;
}

/* `pi_chktime`  - check if timeout happened */	


long pi_chktime ( void )
{
	time_t t;
	
	if (pxnotot || piflags&PiNT)
		return(1);


	t = time(NULL);
	if (pithen > t)
		return(1);

	pxtout = 1;
	return(0);
}


/* `pi_put` - send byte over serial port */

void pi_put(char data)
{
	if (pxlink.flags&PLPQ) {
		pi_putp(data);
	} else {
		if (pxdisp&PXVL)
			printf(" %02x",data&0xff);
		while (write(pxlink.saddr,&data,1)<0);
	}

	if (pxdisp&PXVL)
		printf("+");
}

void pi_putp(char data)
{
#ifdef MAGMASP
	if (pptwo)
		{
		pi_putp2(data);
		return;
		}
	if (pxdisp&PXVL)
		printf(" %02x",data&0xff);

	while(((char)do_inp(pxlink.ppin) & BUSY));
	do_outp(pxlink.ppdat, data);
	while(((char)do_inp(pxlink.ppin) & BUSY));
	do_outp(pxlink.ppout, B_ACK);
	do_outp(pxlink.ppout, STROFF);

	if (pxdisp&PXVL)
		printf(">");
#endif
}

 /* use Autofeed as strobe and Out of paper as busy */

void pi_putp2(char data)
{
#ifdef MAGMASP
	if (pxdisp&PXVL)
		printf(" %02x",data&0xff);

	while((char)do_inp(pxlink.ppin) & PAPER);

	do_outp(pxlink.ppdat, data);
	do_outp(pxlink.ppout, AUTOON);
	do_outp(pxlink.ppout, AUTOOFF);

	while(((char)do_inp(pxlink.ppin) & PAPER));

	do_outp(pxlink.ppout, B_ACK);
	do_outp(pxlink.ppout, AUTOOFF);

	if (pxdisp&PXVL)
		printf("*");
#endif
}

/* `pi_getp` - read possible byte from the parallel port */

long pi_getp(char *cp)
{
#ifdef MAGMASP
	if (pxlink.flags&PLPQ)
		{
		if ((char)do_inp(pxlink.ppin) & BUSY)
			{
			do_outp(pxlink.ppout, B_ACK);
			*cp = (char)(((char)do_inp(pxlink.ppin)) >> 3) & (char)0x0f;
			do_outp(pxlink.ppout, STROFF);
			while(((char)do_inp(pxlink.ppin) & BUSY));
			do_outp(pxlink.ppout, B_ACK);
			do_outp(pxlink.ppout, STROFF);
			while(!((char)do_inp(pxlink.ppin) & BUSY));
			do_outp(pxlink.ppout, B_ACK);
			*cp = *cp|(char)(((char)do_inp(pxlink.ppin)<<(char)1)&(char)0xf0);
			do_outp(pxlink.ppout, STROFF);
			while((char)do_inp(pxlink.ppin) & BUSY);
			do_outp(pxlink.ppout, B_ACK);
			do_outp(pxlink.ppout, STROFF);
			if (pxdisp&PXVL)
				printf("<%02X",*cp&0xff);
			return(PGE_NOE);
			}
		return(PGE_EOF);
		}
	else
#endif
		return(PGE_IOE);
}

/* `pi_get` - read possible byte from the serial or parallel port */

long pi_get(char *cp)
{
	if (pxlink.flags&PLPQ) {
		pi_getp(cp);
	} else {
		if (read(pxlink.saddr,cp,1)>0)
			{
			if (pxdisp&PXVL)
				printf("-%02X",*cp&0xff);
			return(PGE_NOE);
			}
		return(PGE_EOF);
	}
}

void do_outp( int a, int b )
{
#ifdef MAGMASP
        int rc = 0;
        char x;

        x = (char)b;

        switch (a) {
                case PP_CTL:
                        rc = ioctl(pxlink.paddr,PPIOCSETC,&x);
                        break;
                case PP_DAT:
                        rc = ioctl(pxlink.paddr,PPIOCSETD,&x);
                        break;
                default:
                        printf("PPIOCTL bad register\n");
                        break;
	}
 
        if (rc<0) {
                perror("PPIOCTL failed:");
		exit(1);
	}
#endif
}
 
char do_inp ( int a )
{
#ifdef MAGMASP
        int rc = 0;
        char x=0;

        if (a == PP_STS) {
                rc = ioctl(pxlink.paddr,PPIOCGETS,&x);
	} else {
                printf("PPDO_INP bad register\n");
	}

        if (rc<0)
                perror("PP_INP ioctl failed:");

        return(x);
#endif
}

/* `pi_sleep` - waste some time */

void pi_sleep(short t)
{
	sleep(1);
}

/* `pi_ccw` - make the cursor spin */

void pi_ccw ( void )
{
	switch (picuct++ % 4)
		{
		case 0:
			printf("|\b");
			break;
		case 1:
			printf("/\b");
			break;
		case 2:
			printf("-\b");
			break;
		case 3:
			printf("\\\b");
			break;
		}
}

/* `pi_cccw` - and now the other way */

void pi_cccw ( void )
{
	switch (picuct++ % 4)
		{
		case 0:
			printf("|\b");
			break;
		case 1:
			printf("\\\b");
			break;
		case 2:
			printf("-\b");
			break;
		case 3:
			printf("/\b");
			break;
		}
}

/* `pi_beep` - make a beep sound */

void pi_beep ( void )
{
	printf("\7");
}

/* `pi_switch` - connect thru the switch */

long pi_switch ( void )
{
#ifdef AISWITCH
	char c;
	char aiport[PIC_CL];
	short i,j;

	pi_put(13);
	pi_sleep(1);
	ioctl(pxlink.saddr, TCFLSH, TCOFLUSH);
	do
		{
		while (pi_get(&c));
		} while (c != '>');
	pi_puts("ai");
	i = 0;
	j = 0;
	do
		{
		while (pi_get(&c));
		aiport[i++] = c;
		} while (c != '>');

	*(pxaicstr+5) = aiport[i-6];
	*(pxaicstr+6) = aiport[i-5];
	*(pxaicstr+7) = aiport[i-4];
	if (pxdisp&PXHI)
		printf("Connecting via AISwitch, command '%s'\n",pxaicstr);
	pi_puts(pxaicstr);
	return(PGE_NOE);
#endif
}

void pi_puts(char *str)
{
	char c,ec;

	while (*str)
		{
		c = *str++;
		pi_put(c);
		while(pi_get(&c));
		}
	pi_put(13);
	while (pi_get(&c));
}

/* THE END */
