/*	PiSynF.c - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - PROMICE/functions called from the parser
	global variables are initialized by the parser
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#include "piconfig.h"
#include "pistruct.h"
#include "pierror.h"
#include "pidriver.h"
#include "pidata.h"
#include "pihelp.h"
#include "pisyn.h"

#ifdef ANSI
extern void piconfig(short cd);
extern void picline(void);
extern void pidohlp(void);
extern void pifixcfg(void);
extern void piinitf(void);
extern void pcdump(void);
extern void pcedit(void);
extern void pcfill(void);
extern void pcxfill(void);
extern void pcksum(void);
extern void pcxksum(void);
extern void pcinit(void);
extern void pcmove(void);
extern void pcsave(void);
extern void pcfind(void);
extern	void pcstring(void);
extern void pcrstt(short id, short time);
extern void pctest(short id, short count);
extern void pilod(void);
extern void piemu(void);
extern void pcexit(void);
extern void pifile(void);
extern void pi_put(char data);
extern long pi_get(char *dp);
static PICONFIG *pigetcfg(void);
static void piload(void);
static void pifname(void);
static void pifmore(PIFILE *cf);

#else
extern void piconfig();
extern void picline();
extern void pidohlp();
extern void pifixcfg();
extern void piinitf();
extern void pcdump();
extern void pcedit();
extern void pcfill();
extern void pcxfill();
extern void pcksum();
extern void pcxksum();
extern void pcinit();
extern void pcmove();
extern void pcsave();
extern void pcfind();
extern void pcstring();
extern void pcrstt();
extern void pctest();
extern void pilod();
extern void piemu();
extern void pcexit();
extern void pifile();
extern long pi_get();
extern void pi_put();

static PICONFIG *pigetcfg();
static void piload();
static void pifname();
static void pifmore();
#endif

short pftype = PFHEX;
static PICONFIG *pftcfg;
extern char *liver;

/* `pcload` - down load user data files */

void pcload()
	{
	if ((!(pxflags&POCP)) && (piflags&PiFM)) /* if not comparing and do fill */
		pcxfill();
	if (pxerror)
		return;
	for (pxcfile=0,pxdlc=0; pxcfile<pxnfile; pxcfile++)	/* load all files */
		{
		pifile();
		if (pxerror)
			break;
		}
	if (!pxerror)
		{
		pxcfg = pxpcfg;
		if ((!(pxflags&POCP)) && (piflags&PiEL))
			pcedit();		/* if not comparing and have an edit list */
		if (pxdisp&PXHI)
			{
			if (pxflags&POCP)
				printf("Verified");
			else
				printf("Transferred");

			printf(" %ld (0x%lx) data bytes\n",pxdlc,pxdlc);
			}
		if ((!(pxflags&POCP)) && (piflags&PiCK))	/* compute checksum */
			pcxksum();
		}
	}

/* `piailoc` - 'a' - set ailoc address */

static void piailoc()
	{
	short i,id=0;

	if (pxdisp&PXMH)
		printf(" >PiAiloc()");
	if (ps_id>=0)
		id = ps_id;
	if (ps_i<2)
		{
		pxerror = PGE_BAA;
		return;
		}
	pxailoc = ps_num[0];
	pxaiid = id;
	piflags |= PiAI;		/* so we know */
	pxaibr = ps_num[1];
	pxaiws = 0;
	pxaibrc = 0;
	switch(ps_num[1])
		{
		case 0:
			piflags |= PiXP;
			break;
		default:
			for (i=0; pxbauds[i]; i+=2)	/* look for baud rate */
				{
				if (pxaibr == pxbauds[i])
					{
					pxaibrc = pxbauds[i+1];
					break;
					}
				}	
			if (!pxaibrc)			/* did not find it */
				pxerror = PGE_BRT;
			piflags &= ~PiXP;
			break;
		}
	ps_i -= 2;
	if (ps_i)		/* if more arguments then its a break character */
		{
		ps_i--;
		piflags |= PiBC;
		pxaibchr = (char)ps_num[2];
		}
	else
		{
		piflags &= ~PiBC;
		pxaibchr = 0;
		}
	if (ps_i)		/* yet more is number of reset intterrupt to ignore */
		pxhints = (short)ps_num[3];
	else
		pxhints = 0xff;
	}

/* `pibrate` - 'b' - set baud rate */

static void pibrate()
	{
	short i;
	
	if (pxdisp&PXMH)
		printf(" >PiBrate()");
	pxlink.brate = 0;
	for (i=0; pxbauds[i]; i+=2)
		{
		if (ps_num[0] == pxbauds[i])
			{
			pxlink.brate = ps_num[0];
			break;
			}
		}
	if (!pxlink.brate)
		pxerror = PGE_BRT;
	}

/* `picompare` - 'c' - compare PROMICE data */

static void picompare()
	{
	if (pxdisp&PXMH)
		printf(" >PiCompare()");
	if (piflags&PiMU)
		pxerror = PGE_EMU;
	else
		{
		pxflags |= POCP;		/* set the compare flag and do load */
		piload();
		pxflags &= ~POCP;		/* clear the flag now */
		}
	}

/* `pidump` - 'd' - dump PROMICE contents */

static void pidump()
	{
	long tmp;

	if (pxdisp&PXMH)
		printf(" >PiDump()");
	
	if (piflags&PiCR)			/* if just CR typed then dump next range */
		{
		if (!(piflags&PiDF))
			{
			tmp = pxdend - pxdstart;
			pxdstart = pxdend + 1;
			pxdend = pxdstart + tmp;
			if (pxdend > pxmax)
				pxdend = pxmax;
			}
		}
	else	/* depending on the number the arguments vary */
		{
		if (ps_li--)
			{
			pxdstart = ps_numl[0];
			if (ps_li)
				pxdend = ps_numl[1];
			else
				{
				pxdend = pxdstart + PIC_DS;
				if (pxdend > pxmax)
					pxdend = pxmax;
				}
			}
		else
			{
			pxdstart = 0;
			pxdend = PIC_DS;
			}
		}
	if (piflags&PiMU)		/* hey! we are emulating */
		{
		pxerror = PGE_EMU;
		piflags |= PiDF;
		}
	else
		{
		if (pigetcfg())		/* set up the config to dump from */
			{
			pcdump();		/* dump - in PICORE */
			pxcfg = pftcfg;	/* restore config */
			pifixcfg();
			}
		}
	}

/* `piedit` - 'e' - edit PROMICE or IMAGE contents */

static void piedit()
	{
	short i;

	if (pxdisp&PXMH)
		printf(" >PiEdit()");
	if (ps_i)					/* if data already given */
		{
		pxestart = ps_num[0];
		for (i=0; i<ps_li; i++)
			pxelist[i] = ps_numl[i];
		pxelcnt = ps_li;
		}
	else
		{
		pxestart = 0;
		pxelcnt = 0;
		}
	if (piflags&(PiiX|PiII))	/* if in dialog mode or '.' in 'ini' */
		{
		if (piflags&PiMU)		/* emulating? */
			pxerror = PGE_EMU;
		else
			{
			if (pigetcfg())
				pcedit();		/* go to editor */
			pxcfg = pftcfg;
			pifixcfg();
			}
		}
	else
		piflags |= PiEL;		/* not interactive - edit after load */
	}

/* `pifilc` - 'f'  - fill character - from 'ini' file */

static void pifilc()
	{
	short i;
	
	if (pxdisp&PXMH)
		printf(" >PiFilc()");

	if (ps_id >= 0)				/* if ID given */
		{
		if (ps_id >= PIC_NR)
			pxerror = PGE_BIG;
		else
			{
			pxrom[ps_id].fillc = (short)ps_num[0];
			pxrom[ps_id].flags |= PRFL;
			}
		}
	else						/* else all ROMs */
		{
		for (i=0; i<PIC_NR; i++)
			{
			pxrom[i].fillc = (short)ps_num[0];
			pxrom[i].flags |= PRFL;
			}
		}
	if (piflags&PiII)
		{
		if (piflags&PiMU)
			pxerror = PGE_EMU;
		else
			pcfill();	/* now */
		}
	else
		piflags |= PiFM;	/* or later - after load */
	}

/* `pifill` - 'g'  - fill ROM space - dialog mode command */

static void pifill()
	{
	if (pxdisp&PXMH)
		printf(" >PiFill()");

	if (pigetcfg())	/* setup config - sets pxmax */
		{
		pxfstart = pxcfg->start;
		pxfend = pxmax;
		pxfdata = 0xffffffff;
		pxcfg->flags |= PCFL;
		switch (ps_li)			/* number or args determine their type */
			{
			case 0:
				pxfdata = pxrom[0].fillc;
				break;
			case 1:
				pxfdata = ps_numl[0];
				break;
			case 2:
				pxfstart = ps_numl[0];
				pxfend = ps_numl[1];
				break;
			case 3:
				pxfstart = ps_numl[0];
				pxfend = ps_numl[1];
				pxfdata = ps_numl[2];
				break;
			default:
				pxerror = PGE_NUM;
				break;
			}
		if (!pxerror)
			{
			if (piflags&PiMU)		/* if not emulating */
				pxerror = PGE_EMU;
			else
				pcfill();
			}
		}
	pxcfg = pftcfg;	/* restore config */
	pifixcfg();
	}

/* `pihigh` - 'h'  - high speed response */

static void pihigh()
	{
	if (pxdisp&PXMH)
		printf(" >PiHigh()");
	if (ps_i)	/* if arg the ON or OFF */
		{
		if (ps_num[0])
			piflags |= PiHI;
		else
			piflags &= ~PiHI;
		}
	else
		piflags |= PiHI;
	}

/* `pihso` - 'i' - set HSO polarity */

static void pihso()
	{
	if (pxdisp&PXMH)
		printf(" >PiHso()");
	piflags |= PiHO;
	if (ps_i--)
		{
		pxhso = ps_num[0];
		if (ps_i--)
			{
			piflags |= PiRQ;
			pxreq = ps_num[1];
			if (ps_i)
				pxack = ps_num[2];
			}
		}
	}

/* `pisearch` - 'j' - find something */

static void pisearch()
	{
	long i,j;

	if (pxdisp&PXMH)
		printf(" >PiSearch()");
	
	if (pigetcfg())
		{
		pxlstart = pxcfg->start;
		pxlend = pxmax;

		if (ps_str)			/* searching for a string */
			{
			if (ps_i--)
				pxlstart = ps_num[0];
			if (ps_i)
				pxlend = ps_num[1];
			piflags |= PiSS;
			pxlstr = ps_str;
			if (pxlend < pxlstart)
				pxerror = PGE_BAA;
			else
				pcstring();
			}
		else				/* else binary search */
			{
			piflags &= ~PiSS;
			if (ps_i<4)
				pxerror = PGE_BAA;
			else
				{
				pxlstart = ps_num[0];
				pxlend = ps_num[1];
				pxlsize = ps_num[2];
				if ((pxlend < pxlstart) || (ps_i < (pxlsize+3))
				 || (pxlsize > PIC_SS))
					pxerror = PGE_BAA;
				else
					{
					for (j=3,i=0; i<pxlsize; i++,j++)
						pxldata[i] = (char)ps_num[j];
					pcfind();
					}
				}
			}
		}
	pxcfg = pftcfg;
	pifixcfg();
	}

/* `pichksum` - 'k' - compute checksum */

static void pichksum()
	{
	short i;

	if (pxdisp&PXMH)
		printf(" >PiChksum()");
	if (ps_i < 3)
		pxerror = PGE_BAA;
	else
		{
		if (ps_char == 'a')		/* addition or exlusive OR */
			pxflags |= POKA;
		else
			pxflags &= ~POKA;
		if (ps_id>=0)			/* one ROM */
			{
			pxrom[ps_id].kstart = ps_num[0];
			pxrom[ps_id].kend = ps_num[1];
			pxrom[ps_id].kstore = ps_num[2];
			if (ps_i>3)
				pxrom[ps_id].ksize = ps_num[3]/8;
			else
				pxrom[ps_id].ksize = 1;
			pxrom[ps_id].flags |= PRCK;
			}
		else
			{
			for (i=0; i<PIC_NR; i++)	/* or all ROMs */
				{
				pxrom[i].kstart = ps_num[0];
				pxrom[i].kend = ps_num[1];
				pxrom[i].kstore = ps_num[2];
				if (ps_i>3)
					pxrom[i].ksize = ps_num[3]/8;
				else
					pxrom[i].ksize = 1;
				pxrom[i].flags |= PRCK;
				}
			}
		if (piflags&(PiiX|PiII))	/* right away */
			{
			if (pigetcfg())
				{
				pxkstart = ps_num[0];
				pxkend = ps_num[1];
				pxkstore = ps_num[2];
				if (ps_i>3)
					pxksize = ps_num[3];
				else
					pxksize = 1;
				if (piflags&PiMU)
					pxerror = PGE_EMU;
				else
					pcksum();
				pxcfg = pftcfg;
				pifixcfg();
				}
			else
				piflags |= PiCK;	/* no config found - may be later */
			}
		else
			piflags |= PiCK;		/* later */
		}
	}

/* `piload` - 'l'  - load PROMICE */

static void piload()
	{
	if (pxdisp&PXMH)
		printf(" >PiLoad()");
	if (ps_str)					/* file name is given with command */
		{
		piflags |= PiII;
		pifname();				/* do file name processing */
		piflags &= ~PiII;
		}
	if (!pxerror)
		{
		if (piflags&(PiiX|PiII))
			{
			if (!pxprom)		/* if link is not up */
				{
				pcinit();		/* initilize the link */
				pilod();		/* put units in load mode */
				}
			if (!pxerror)
				{
				if (piflags&PiII)	/* from 'ini' file '.' command */
					pcload();
				else				/* from dialog mode */
					{
					if (piflags&PiMU)
						pxerror = PGE_EMU;
					else
						pcload();
					}
				}
			}
		else
			{
			pxflags |= POLO;		/* else load later */
			}
		}
	}

/* `pimove` - 'm' - move image data around */

static void pimove()
	{
	if (pxdisp&PXMH)
		printf(" >PiMove()");

	if (piflags&PiMU)
		pxerror = PGE_EMU;
	else
		{
		if (ps_i > 2)
			{
			if (pigetcfg())
				{
				pxmstart = ps_num[0];
				pxmend = ps_num[1];
				pxmdest = ps_num[2];
				pcmove();
				pxcfg = pftcfg;
				pifixcfg();
				}
			}
		else
			pxerror = PGE_BAA;
		}
	}

/* `pinumber` - 'n'  - set number of PROMICE units */

static void pinumber()
	{
	if (pxdisp&PXMH)
		printf(" >PiNumber()");
	if (ps_i)
		pxnpiu = (short)ps_num[0];
	}

/* `piouput` - 'o'  - set output serial port */

static void piouput()
	{
	int l;
	
	if (pxdisp&PXMH)
		printf(" >PiOuput()");
	l = strlen(ps_str);	/* for others its device name */
	if (l < PIC_SN)
		strcpy(pxlink.name,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)			/* port address is also given */
		{
		pxlink.saddr = (int)ps_num[0];
		pxlink.flags |= PLSU;
		}
	pxlink.flags &= ~PLPQ;	/* definitely not pponly */
	}

/* `pistdpp` - 'p'  - set standard parallel port */

static void pistdpp()
	{
	int l;
	
	if (pxdisp&PXMH)
		printf(" >PiStdpp()");
#ifndef UNIX
	ps_str = "LPT0";
	if (ps_emb<=0)
		ps_emb = 1;
	*(ps_str+3) = (char)((char)ps_emb+'0');
#endif
	l = strlen(ps_str);
	if (l < PIC_SN)
		strcpy(pxlink.pname,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)				/* port address given */
		{
		pxlink.paddr = (int)ps_num[0];
		pxlink.flags |= PLPU;
		}
	pxlink.flags |= PLPP;
	}

/* `pibidipp` - 'q'  - set bidirectional parallel port */

static void pibidipp()
	{
	int l;
	
	if (pxdisp&PXMH)
		printf(" >PiBidipp()");
#ifndef UNIX
	ps_str = "LPT0";
	if (ps_emb<=0)
		ps_emb = 1;
	*(ps_str+3) = (char)((char)ps_emb+'0');
#endif
	l = strlen(ps_str);
	if (l < PIC_SN)
		strcpy(pxlink.pname,ps_str);
	else
		pxerror = PGE_NTL;
	if (ps_i)				/* port address */
		{
		pxlink.paddr = (int)ps_num[0];
		pxlink.flags |= PLPU;
		}
	pxlink.flags |= PLPQ;
	}

/* `piromsize` - 'r'  - set emulation ROM size */

static void piromsize()
	{
	PICONFIG *tcfg;
	register short i;

	if (pxdisp&PXMH)
		printf(" >PiRomsize()");
	
	for (i=0; pxromx[i]; i+=2)		/* look for a valid size */
		{
		if (ps_emb == pxromx[i])
			{
			ps_emb = pxromx[i+1];
			break;
			}
		}
	if (!pxromx[i])					/* none found */
		pxerror = PGE_ROM;
	else
		{
		if (ps_id >= 0)				/* only for one unit */
			{
			pxrom[ps_id].esize = ps_emb;
			if (!(piflags&PiSK))
				pxrom[ps_id].ssize = ps_emb;
			}
		else
			{
			for (i=0; i<PIC_NR; i++)	/* for all units */
				{
				pxrom[i].esize = ps_emb;
				if (!(piflags&PiSK))
					pxrom[i].ssize = ps_emb;
				}
			}
		}
	if (pxcfg)		/* if a current config */
		pifixcfg();	/* fix up config parameters */
	tcfg = pxcfg;
	for (i=0; i<(short)pxnfile; i++)	/* also if any file configs */
		{
		pxcfg = pxfile[i].pfcfg;
		if (pxcfg)
			pifixcfg();
		}
	pxcfg = tcfg;
	}

/* `pistop` - 's' - stop emulation */

static void pistop()
	{
	static short once=0;

	if (pxdisp&PXMH)
		printf(" >PiStop()");
	pilod();
	piflags |= PiST;
	if (!once)			/* tell user first time only */
		{
		once = 1;
		printf("Use 'go' later to emulate\n");
		}
	}

/* `pitest` - 't'  - test unit */

static void pitest()
	{
	short id=0,ct=1;
	long ad,i;

	if (pxdisp&PXMH)
		printf(" >PiTest()");
	
	if (!(piflags&PiiX))
		{
		pxdebug = 0;
		if (!ps_i)
			ps_num[0] = 9600;
		switch(ps_num[0])
			{
			case 0:
				pxdebug = 0x80;
				break;
			default:
				for (i=0; pxbauds[i]; i+=2)	/* look for baud rate */
					{
					if (ps_num[0] == pxbauds[i])
						{
						pxdebug = pxbauds[i+1];
						break;
						}
					}	
				if (!pxdebug)			/* did not find it */
					pxerror = PGE_BRT;
			}
		piflags |= PiGT;
		return;
		}
	if (piflags&PiMU)	/* not if emulating */
		{
		pxerror = PGE_EMU;
		return;
		}
	if (ps_id >= 0)		/* unit ID given */
		{
		id = ps_id;
		if (ps_i)		/* pass count also */
			ct = (short)ps_num[0];
		}
	else
		{
		if (ps_i--)		/* no : but a number is an ID */
			{
			id = (short)ps_num[0];
			if (ps_i)	/* and may be a passcout too */
				ct = (short)ps_num[1];
			}
		}
	if (id >= pxnrom)
		{
		pxerror = PGE_BIG;
		return;
		}
	pctest(id,ct);			/* run test - report results */
	if (pxrsp[PICT] != 1)
		{
		ad = ~pxrom[id].amask & 
			(((long)(pxrsp[PIDT]&0xFF)<<16)|((long)(pxrsp[PIDT+1]&0xFF)<<8)
											|((long)(pxrsp[PIDT+2]&0xFF)));
		printf("\n Unit %d failed test @loc %lX",id,ad);
		}
	else
		printf("\n Unit %d passes test",id);
	}

/* `piserial` - 'u' - return serial# */

static void piserial()
	{
	short id;

	if (pxdisp&PXMH)
		printf(" >PiSerial()");
	if (ps_id >= 0)
		id = ps_id;
	else
		{
		if (ps_i)
			id = (short)ps_num[0];
		else
			id = 0;
		}
	if (id >= pxprom)
		pxerror = PGE_BIG;
	else					/* modified version command */
		{
		picmd((char)id,PI_VS|0x10,1,0,0,0,0,0);		
		printf("serial#=%02X%02X%02X%02x\n",
		 pxrsp[PIDT]&0x0FF,pxrsp[PIDT+1]&0x0FF,
		 pxrsp[PIDT+2]&0x0FF,pxrsp[PIDT+3]&0x0FF);
		}
	}

/* `piverify` - 'v' - set verify option */

static void piverify()
	{
	short f=0;

	if (pxdisp&PXMH)
		printf(" >PiVerify()");
	if (ps_i)
		f = (short)ps_num[0];
	if (f)
		pxflags |= POVF;
	else
		pxflags &= ~POVF;
	}

/* `piword` - 'w' - set word size */

static void piword()
	{
	PICONFIG *cx,*cy;
	short u,w,b,n;

	if (pxdisp&PXMH)
		printf(" >PiWord()");
	if (!ps_i)			/* if no args then 8-bit */
		ps_num[0] = 8;
	if (!(ps_num[0]%8))	/* better be multiple of 8 */
		{
		w = (short)ps_num[0]/8;	/* word size in bytes */
		if (ps_li)				/* if ID list given */
			{
			if (ps_li%w)		/* better be right number of units */
				pxerror = PGE_IDL;
			}
		else					/* no ID list given */
			{
			n = pxnrom;
			if ((!n) || (!pxprom))	/* link is not up so assume unit count */
				{
				n = w;
				pxnrom = w;
				piflags |= PiNL;
				}
			else
				{
				if (n<w)			/* else enough ROMs to do the word? */
					{
					pxerror = PGE_BCF;
					return;
					}
				}
			for (b=0; b<(n/w); b++) /* no ID list so make it up */
				{
				for (u=w*b; u<(w*(b+1)); u++)
					ps_numl[u] = u;
				}
			ps_li = n;
			}
		if (!pxerror)		/* if no errors then build config */
			{
			b = ps_li/w;	/* number of banks */
			cx = pxpcfg;
			cy = (PICONFIG *)0;
			if (cx)	/* free any previous configs */
				{
				while (cx->next)
					cx = cx->next;
				cx->next = pxfcfg;
				pxfcfg = pxpcfg;
				pxpcfg = (PICONFIG *)0;
				}
			for (u=0; u<b; u++)
				{
				cx = pxfcfg;	/* get a free config structure */
				if (!pxpcfg)	/* if no physical config set */
					{
					pxpcfg = cx;
					pxcfg = cx;
					}
				if (cx)			/* got one */
					{
					pxfcfg = cx->next;	/* remove from freeList */
					cx->next = (PICONFIG *)0;
					cx->words = w;		/* set word size */
					for (n=0; n<w; n++)	/* and ID list */
						cx->uid[n] = (short)ps_numl[w*u+n];
					if (cy)				/* if chaining banks */
						cy->next = cx;
					cy = cx;
					}
				else			/* no config structures left?!! */
					{
					pxerror = PGE_CFG;
					break;
					}
				}
			pifixcfg();	/* fix all config parameters */
			}
		}
	else
		pxerror = PGE_WDS;
	}

/* `pinocksm` - 'x' - no-check checksum */

static void pinocksm()
	{
	if (pxdisp&PXMH)
		printf(" >PiNoCksm()");
	if (ps_i)
		{
		if (ps_num[0])
			pxflags |= PODK;
		else
			pxflags &= ~PODK;
		}
	pxflags |= PONK;
	}

/* `delay` - 'y' - set delay time out */

static void pidelay()
	{
	if (pxdisp&PXMH)
		printf(" >PiDelay()");
	if (ps_i)
		pxdelay = ps_num[0];
	else
		pxdelay = 0;
	pxnotot = pxdelay;
	}

/* `pinoadder` - 'z' - set to ignore address errors */

static void pinoaddr()
	{
	if (pxdisp&PXMH)
		printf(" >PiNoaddr()");
	if (ps_i)
		{
		if (ps_num[0])
			pxflags |= PODO;
		else
			pxflags &= ~PODO;
		}
	pxflags |= PONO;
	}

/* `piaisw` - 'A' - LoadICE is talking through the AISwitch */

static void piaisw()
	{
	extern char *pxaicstr;

	if (pxdisp&PXMH)
		printf(" >PiAisw()");

	if ((!ps_i) || (ps_num[0] < 0))
		{
		pxerror = PGE_BAA;
		return;
		}
	if (ps_num[0] > PIC_NR)
		pxerror = PGE_BIG;
	else					/* store Switch port# in connect string */
		{
		*(pxaicstr+9) = (char)((char)(ps_num[0]/100)+'0');
		*(pxaicstr+10) = (char)((char)((char)((ps_num[0]%100)/10)+'0'));
		*(pxaicstr+11) = (char)((char)((char)((ps_num[0]%100)%10)+'0'));
		}
	piflags |= PiSW|PiPH;	/* remember the Switch */
	}

/* `piaitty` - 'B' - operate transparent tty mode - does not work */

static void piaitty()
	{
	char c;

	if (pxdisp&PXMH)
		printf(" >PiAITTY()");

	if (piflags&PiAI)
		{
		picmd((char)pxaiid,PI_MO|CM_NORSP|CM_AITTY,3,1,0,(char)0xff,0,0);
		pxailoc |= pxrom[pxaiid].amask;
		picmd((char)pxaiid,PI_RS|CM_NORSP|CM_CINIT,5,(char)PIC_XCODE,
			(char)(pxailoc>>16),(char)(pxailoc>>8),(char)pxailoc,(char)pxaibr);
		}
	else
		{
		pxerror = PGE_IOE;
		return;
		}
	for (;;)
		{
		if (pi_get(&c))
			continue;
		else
			printf("%c",c);
		}
	}
	
/* `pidiscfg` - 'C' - display configuration */

static void pidiscfg()
	{
	short cd;
	
	if (pxdisp&PXMH)
		printf(" >PiDisCfg()");
	if (ps_str == NULL)
		ps_str = "a";
	switch (*ps_str)
		{
		case 'a':
			cd = PcALL;
			break;
		case 'l':
			cd = PcLNK;
			break;
		case 'f':
			cd = PcFLE;
			break;
		case 'r':
			cd = PcROM;
			break;
		case 'p':
			cd = PcPCF;
			break;
		case 'c':
			cd = PcCFG;
			break;
		default:
			printf("Unknown config type - doing all\n");
			cd = PcALL;
		}
	piconfig(cd);
	}

/* `pidisply` - 'D' - change display level */

static void pidisply()
	{
	if (pxdisp&PXMH)
		printf(" >PiDisply()");
	if (ps_i)
		pxdisp = (short)ps_num[0];
	else
		pxdisp = 0xC0;
	}

/* `pisystem` - 'E' - escape command to system */

static void pisystem()
{
	if (pxdisp&PXMH)
		printf(" >PiSystem()");

	(void)system(ps_str);
}

/* `pifname` - 'F' - specifies file name - do whole buch of stuff */

static void pifname()
	{
	PICONFIG *cx;
	PIFILE *cf;
	int ref,l;
	char htype=0;
	
	if (pxdisp&PXMH)
		printf(" >PiFname()");

	if (pftype == PFHEX)			/* if hexfile then read one byte */
		if ((ref = open(ps_str, O_RDONLY)) >= 0) {	/* does it exits? */
			(void)read(ref,&htype,1);
			(void)close(ref);
		} else
			htype = 'h';			/* generic */

	if (piflags&PiII)		/* 'ini' '.' command */
		pxnfile = 0;

	pxcfile = pxnfile;
	piinitf();			/* clear out file structure */

	cf = &pxfile[pxnfile];		/* start filling in stuff */
	cf->type = pftype;
	cf->htype = htype;
	l = strlen(ps_str);

	if (l < PIC_FN) {			/* if name not too long */
		strcpy(cf->name,ps_str);
		if (pftype == PFBIN) {
			if (ps_i) {
				ps_i--;
				cf->skip = ps_num[0];
			}
			if (ps_i)
				cf->offset = ps_num[1];
		} else {
			if (ps_i) {
				ps_i--;
				cf->offset = ps_num[0];
			}
			if (ps_i)
				cf->offset = ps_num[1] - ps_num[0];
		}

		cx = cf->pfcfg;
		if (cx && (cx != pxpcfg)) {	/* free any previous file configs */
			while (cx->next)
				cx = cx->next;
			cx->next = pxfcfg;
			pxfcfg = cf->pfcfg;
		}
		cf->pfcfg = (PICONFIG *)0;
		pifmore(cf);				/* split for stupid optimizer */
	} else
		pxerror = PGE_NTL;
}

#ifdef ANSI
static void pifmore(PIFILE *cf)
#else
static void pifmore(cf)
PIFILE *cf;
#endif
	{
	PICONFIG *cx,*cy=0;
	short u,w,b,n;

	if (ps_li)	/* if we have a config */
		{
		ps_li--;
		if (ps_numl[0]%8)
			{
			pxerror = PGE_IDL;
			return;	
			}
		w = (short)ps_numl[0]/8;	/* word size */
		if (ps_li && !(ps_li%w) && (ps_li <= PIC_NR))
			{
			b = ps_li/w;	/* number of banks */
			if (b<=0)
				b = 1;
			for (u=0; u<b; u++)
				{
				cx = pxfcfg;
				if (!cf->pfcfg)
					cf->pfcfg = cx;
				if (cx)
					{
					pxfcfg = cx->next;
					cx->next = (PICONFIG *)0;
					cx->words = w;
					for (n=0; n<w; n++)
						if (ps_li)
							cx->uid[n] = (short)ps_numl[u*w+n+1];
						else
							cx->uid[n] = ps_id++;
					if (cy)
						cy->next = cx;
					cy = cx;
					}
				else
					{
					pxerror = PGE_CFG;
					break;
					}
				}
			}
		else
			pxerror = PGE_IDL;
		ps_li++;
		}
	else	/* no config given */
		{
		if (ps_id >= 0)
			{
			cx = pxpcfg;	/* check if existing one would work */
			while (cx)
				{
				if (cx->uid[0] == ps_id)
					{
					cf->pfcfg = cx;
					break;
					}
				cx = cx->next;
				}
			if (!cx)	/* if none found make a 8-bit config */
				{
				cx = pxfcfg;
				cf->pfcfg = cx;
				if (cx)
					{
					pxfcfg = cx->next;
					cx->next = 0;
					cx->words = 1;
					cx->uid[0] = ps_id;
					}
				}
			}
		}
		
	if (ps_sli && !pxerror)	/* partial transfer addresses */
		{
		if (!(ps_sli%2))
			{
			cf->saddr = ps_numl[ps_li++];
			cf->eaddr = ps_numl[ps_li];
			cf->flags |= PFPL;
			}
		else
			pxerror = PGE_INP;
		}
	if (pxprom)			/* if link is up then update config data */
		{
		if (cf->pfcfg)
			{
			pxcfg = cf->pfcfg;
			pifixcfg();
			}
		}
	if (!pxerror)
		pxnfile++;
	if (pxprom)
		{
		pxcfg = pxpcfg;
		pifixcfg();
		}
	}

/* `pigo` - 'G' - unitinandoutofemulation */

static void pigo()
	{
	if (pxdisp&PXMH)
		printf(" >PiGo()");
	piemu();
	}

/* `pihelp` - 'H' - display help file */

static void pihelp()
	{
	char *is,*ts,*t,**hs;
	PIHELP *h;
	
	is = ps_str;
	if (is == NULL)
		is = "?";
	while (*is == ' ' || *is == '\t')
		is++;
	h = pxhelp;
	while (h->topic)
		{
		t = h->topic;
		ts = is;
		while (*ts)
			{
			if (*ts++ == *t++)
				continue;
			else
				{
				h++;
				--ts;
				break;
				}
			}
		if (!*ts)
			break;
		}
	if (h->topic)
		{
		hs = h->help;
		while (*hs)
			{
			printf("%s\n",*hs);
			hs++;
			}
		}
	else
		printf("No help available on topic '%s'\n",is);
	}

/* `piimage` - 'I'  - binary file specification */

static void piimage()
	{
	if (pxdisp&PXMH)
		printf(" >PiImage()");
	pftype = PFBIN;
	pifname();
	pftype = PFHEX;
	}

/* `pisocket` - 'J'  - set rom socket size */

static void pisocket()
	{
	register short i;

	if (pxdisp&PXMH)
		printf(" >PiSocket()");

	for (i=0; pxromx[i]; i+=2)		/* look for a valid size */
		{
		if (ps_emb == pxromx[i])
			{
			ps_emb = pxromx[i+1];
			break;
			}
		}
	if (!pxromx[i])					/* none found */
		pxerror = PGE_ROM;
	else
		{
		if (ps_id >= 0)				/* only for one unit */
			{
			pxrom[ps_id].ssize = ps_emb;
			}
		else
			{
			for (i=0; i<PIC_NR; i++)	/* for all units */
				{
				pxrom[i].ssize = ps_emb;
				}
			}
		piflags |= PiSK;
		}
	}

/* `pifkeys` - 'K' - assign function keys */

static void pifkeys()
	{
	if (pxdisp&PXMH)
		printf(" >PiFkeys()");
	if (!ps_i)
		pxerror = PGE_BAA;
	else
		{
		if (ps_str == NULL)
			pxerror = PGE_BAA;
		else
			{
			if (pxuline[0] == 'a')	/* alt key */
				ps_num[0] += 12;
			ps_num[0]--;
			pxkeys[ps_num[0]] = (char *)calloc(strlen(ps_str)+1,1);
			if (pxkeys[ps_num[0]])
				strcpy(pxkeys[ps_num[0]],ps_str);
			}
		}
	}
			
/* `piiload` - 'L'  - load binary file */

static void piiload()
	{
	if (pxdisp&PXMH)
		printf(" >PiiLoad()");
	if (piflags&PiMU)
		{
		pxerror = PGE_EMU;
		return;
		}
	if (ps_str)
		{
		piflags |= PiII;
		pftype = PFBIN;
		pifname();
		pftype = PFHEX;
		piflags &= ~PiII;
		}
	if (!pxerror)
		{
		if (!pxprom)
			pcinit();
		if (!pxerror)
			pcload();
		}
	}

/* `piulock` - 'M' - set flag for locked units (only when talking directly) */

static void piulock()
	{
	if (pxdisp&PXMH)
		printf(" >PiUlock()");
	piflags |= PiPH;
	}

/* `pinofil` - 'N' - don't do filling */

static void pinofil()
	{
	if (pxdisp&PXMH)
		printf(" >PiNofil()");
	piflags &= ~PiFM;
	}

/* `pimemap` - 'O' - change memory map display */

static void pimemap()
	{
	if (pxdisp&PXMH)
		printf(" >PiMeMap()");
	if (ps_i)
		{
		if (ps_num[0])
			{
			pxflags |= POMP;
			return;
			}
		}
	pxflags &= ~POMP;
	}

/* `pirecover` - 'P' - restart the link */

static void pirecover()
	{
	if (pxdisp&PXMH)
		printf(" >PiRecover()");

	pxprom = 0;
	piflags &= ~PiUP;
	pcexit();
	pcinit();
	}
	
/* `pireset` - 'R' - reset the target */

static void pireset()
	{
	short id, dt;

	if (pxdisp&PXMH)
		printf(" >PiReset()");
	if (ps_i)			/* time period specified */
		{
		dt = (short)ps_num[0]/9;
		}
	else
		{
		dt = pxrtime;
		}
	id = (ps_id <0) ? 0 : ps_id;
	if (piflags&(PiiX|PiII))
		pcrstt(id,dt);
	else
		pxrtime = dt;
	}

/* `pisave` - 'S' - save PROMICE contents to a file */

static void pisave()
	{
	if (pxdisp&PXMH)
		printf(" >PiSave()");
	if (piflags&PiMU)
		{
		pxerror = PGE_EMU;
		return;
		}
	if (pigetcfg())
		{
		pxsstart = pxcfg->start;
		pxsend = pxmax;
		if (ps_li--)
			{
			pxsstart = ps_numl[0];
			if (ps_li)
				pxsend = ps_numl[1];
			else
				pxsend = pxmax;
			}
		pcsave();
		pxcfg = pftcfg;
		pifixcfg();
		}
	}

/* `pippmode` - 'T' - set parallel mode */

static void pippmode()
	{
	if (pxdisp&PXMH)
		printf(" >PiPpMode()");
	pxflags |= POSP;
	}	

/* `piautor` - 'U' - recover from error automatically */

static void piautor()
	{
	if (pxdisp&PXMH)
		printf(" >PiAutoRecover()");

	if (!ps_i)
		pxflags &= ~POAR;
	else
		if (ps_num[0])
			pxflags |= POAR;
		else
			pxflags &= ~POAR;
	}

/* `piversion` - 'V' - report PROMICE uC version# */

static void piversion()
	{
	short id;

	if (pxdisp&PXMH)
		printf(" >PiVersion()");
	if (ps_id >= 0)
		{
		id = ps_id;
		}
	else
		{
		if (ps_i)
			{
			id = (short)ps_num[0];
			}
		else
			{
			id = 0;
			}
		}
	if (id >= pxprom)
		pxerror = PGE_BIG;
	else
		printf("%s / PROMICE microCode version %s\n",liver, pxrom[id].ver);
	}

/* `piwrenb` - 'W' - enable write from target (only on some units) */

static void piwrenb()
	{
	short id=0;
	short cd=1;

	if (pxdisp&PXMH)
		printf(" >PiWrenb()");
	if (ps_id >= 0)
		{
		id = ps_id;
		}
	if (ps_i)
		{
		cd = (short)ps_num[0];
		}
	
	if (id >= pxprom)
		pxerror = PGE_BIG;
	else
		picmd((char)id,PI_MO|0x10,1,(char)cd,0,0,0,0);
	}

/* `piexit` - 'X' - Set Exit Code */

static void piexit()
	{
	if (pxdisp&PXMH)
		printf(" >PiExit()");
	pxflags |= POXX;
	if (ps_i--)
		pxcode = ps_num[0];
	if (ps_i)
		pxctry = ps_num[1];
	}

/* `pifast` - 'Y' - fast host */

static void pifast()
	{
	if (pxdisp&PXMH)
		printf(" >PiFast()");
	piflags |= PiZZ;
	if (ps_li--)
		ppxdl0 = ps_numl[0];
	if (ps_li--)
		ppxdl1 = ps_numl[1];
	if (ps_li)
		ppxdl2 = ps_num[2];
	}

/* `pidialog` - 'Z' - enter dialog mode */

static void pidialog()
	{
	if (pxdisp&PXMH)
		printf(" >PiDialog()");
	pxflags |= POIX;
	}

/* `piundef` - UNDEFINED */

static void piundef()
	{
	if (pxdisp&PXMH)
		printf(" >PiUndef()");
	}

/* `pigetcfg` - find an existing one or build an alternate config */

static PICONFIG *pigetcfg()
	{
	pftcfg = pxcfg;
	if (ps_id >= 0)
		{
		if (ps_id >= pxprom)
			{
			pxerror = PGE_BIG;
			return(0);
			}
		pxcfg = &pxaltcfg;
		pxcfg->words = 1;
		pxcfg->uid[0] = ps_id;
		}
	pifixcfg();
	return(pxcfg);
	}

/*	table of function pointers -
	- this table is used by the input parser
	- to call the appropriate routine as
	- specied in the current script
*/
void (*psynf[])() = {
	piailoc,	/* a - set up ailoc for AITTY */
	pibrate,	/* b - baud rate */
	picompare,	/* c - comapre */
	pidump,		/* d - dump */
	piedit,		/* e - edit */
	pifilc,		/* f - fill char */
	pifill,		/* g - fill now */
	pihigh,		/* h - high speed */
	pihso,		/* i - hso polarity */
	pisearch,	/* j - search for stuff */
	pichksum,	/* k - checksum */
	piload,		/* l - load*/
	pimove,		/* m - move ROM data around */
	pinumber,	/* n - number of unit */
	piouput,	/* o - serial device */
	pistdpp,	/* p - parallel port */
	pibidipp,	/* q - bidirectional pp */
	piromsize,	/* r - rom size */
	pistop,		/* s - go in to load mode */
	pitest,		/* t - test unit */
	piserial,	/* u - return unit's serial number */
	piverify,	/* v - verify */
	piword,		/* w - word size */
	pinocksm,	/* x - no-check checksum */
	pidelay,	/* y - set timeout delay */
	pinoaddr,	/* z - ignore address out of range errors */
	piaisw,		/* A - loadice talking through the AISwitch */
	piaitty,	/* B - go into transparent mode*/
	pidiscfg,	/* C - display config */
	pidisply,	/* D - change display level */
	pisystem,	/* E - escape command to system */
	pifname,	/* F - hex file name */
	pigo,		/* G - go in to emulation */
	pihelp,		/* H - give out help */
	piimage,	/* I - image file */
	pisocket,	/* J - set socket size */
	pifkeys,	/* K - assign function keys */
	piiload,	/* L - load one binary file */
	piulock,	/* M - locked units */
	pinofil,	/* N - don't do filling */
	pimemap,	/* O - change map display status */
	pirecover,	/* P - recover from failure */
	piundef,	/* Q - Undefined function */
	pireset,	/* R - reset target */
	pisave,		/* S - save to file */
	pippmode,	/* T - set fast parallel transfer mode */
	piautor,	/* U - autorecover */
	piversion,	/* V - report uCode ver# */
	piwrenb,	/* W - enable or disable write signal */
	piexit,		/* X - set exit code */
	pifast,		/* Y - fast host */
	pidialog	/* Z - enter dialog mode */
	};

