/*	PiShell.c - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - PROMICE shell.  It is called direclty from the user interface.
	It looks for the variable LOADICE in the environment for an initial
	command and parameter input.  If it does not find it then it will
	try to open a file named 'loadice.ini' in the current directory.
	However, if the first character of the user command line is a '.'
	then it will skip this step all together.  It will then process any
	command line input.  Finally it will serve the user in dialog mode.
*/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include <errno.h>

#include "piconfig.h"
#include "piscript.h"
#include "pistruct.h"
#include "pierror.h"
#include "pihelp.h"

// char *pidefs1 = "output=/dev/ttyS0";
char *pidefs1 = "output=/dev/ttyUSB0";
char *pidefs2 = "baud=19200";


#ifdef LINUX
static char utimes[16];
#else
static char *utimes = "DDD:HH:MM:SS";
#endif

#ifdef ANSI
extern void (*psynf[])(void);
extern char *getenv(char *var);
extern void piemu(void);
extern void pilod(void);
extern void pcinit(void);
extern void pcexit(void);
static void utime(short code);

#else
extern void (*psynf[])();
extern char *getenv();
extern void piemu();
extern void pilod();
extern void pcinit();
extern void pcexit();
static void utime();

#endif

/* This might as well be "main" as main() in loadice.c calls this
 * after a bit of setup.  When this returns, the application
 * cleans up and exits.
 * See pihelp.h
 */
void
pishell(void)
{
	short i;
	short skip;
	FILE *cf;
	unsigned char c;
	char *cstr,**hp;
	char ifile[PIC_FN];

	utime(0);	/* init timer */

	/* A --- handle help requests.
	 * if user typed just 'loadice ?' or 'loadice help'
	 * we give them help and then exit.
	 */

	if (pxcline[0] == '?' || !strcmp(pxcline,"help")) {
		hp = piclhlp;
		while(*hp) {
			printf(" %s\n",*hp);
			if (**hp == '-')
				(void)fgets(pxuline,PIC_CL,stdin);
			hp++;
		}
		return;
	}

	/* B - Parse these two "builtin" lines for default values */
	pisyn(pidefs1,pcmfsyn,psynf);
	pisyn(pidefs2,pcmfsyn,psynf);

	/* if 'ini' file is on the command line as '@inifile' */

	if (pxcline[0] == '@') {
		cstr = ifile;
		for (i=0; ((i<(short)strlen(pxcline)) && (i<(PIC_FN-1))); i++)
			if (pxcline[i+1] == ' ')
				break;
			else
				ifile[i] = pxcline[i+1];
		ifile[i] = '\0';
	} else {
		/* look for environment variable or use default */
		cstr = getenv("LOADICE");
		if (cstr == NULL)
			cstr = "loadice.ini";
	}


	/* if the command line starts with '.' then
	 * bypass loadice.ini, otherwise:
	 *
	 * C - process loadice.ini
	 */
	if (pxcline[0] != '.') {
		if (pxdisp&PXHI)
			printf("Opening command file '%s'\n",cstr);

		if ((cf = fopen(cstr,"r")) != NULL) {
			while (fgets(pxuline,PIC_CL,cf) != NULL) {
				if (pxuline[0] == '*')	/* ignore comment lines */
					continue;
				if (pxuline[0] == '.') { /* execute command NOW */
					pxuline[0] = ' ';
					piflags |= PiII;
				} else
					piflags &= ~PiII;

				/* call parser */
				pisyn(pxuline,pcmfsyn,psynf);

				if (pxerror) {
					pierror();
					(void)fclose(cf);
					return;
				}
			}
			(void)fclose(cf);
		} else {
			if (pxdisp&PXHI)
				printf("File not found '%s' - proceeding\n",cstr);
			errno = 0;
		}
	} else
		pxcline[0] = ' '; /* get rid of the '.' */

	/* D - process command line arguments
	 */
	if (pxcline[0] != '\0') {
		if (pxdisp&PXHI)
			printf("Executing command line '%s'\n",pxcline);
		pisyn(pxcline,pcmlsyn,psynf);
	}

	if (pxerror)
		pierror();
	else {	/* possibly dialog mode */
		piflags |= PiiX;

		/* E - user wants to load, has files,
		 * and no dialog mode requested */

		if (pxflags&POLO || (pxnfile && !(pxflags&POIX))) {

			pisyn("l",pusrsyn,psynf);

			if (pxerror) {
				pierror();
				piemu();
				pcexit();
				return;
			}
		}

		/* F -  dialog mode requested or
		 *       no files given (force dialog)
		 */

		if ((pxflags&POIX) || !pxnfile) {
			if (pxdisp&PXHI)
				printf("Entering dialog mode\n");
			pcinit();

			if (!pxerror) {
				for(;;) {
					if (pxerror)
						pierror();
					else
						piflags &= ~PiER;

					if (!(piflags&PiUP)) {
						if (pxdisp&PXVH)
							printf("Link is down!\n");
						if (pxflags&POAR) {
							if (pxdisp&PXVH)
								printf(" Auto-recovery...\n");

							/* link down, try to recover */
							pisyn("restart",pusrsyn,psynf);

							if (pxerror)
								continue;
						}
					}

					/* Give interactive prompt */
					if (pxdisp&PXVH) {
						utime(1);
						printf("%s LoadICE: ",utimes);
					}

					piflags &= ~PiCR;

					// tjt 12-22-2018, keeping the newline is OK
					/* if (gets(pxuline)) ... */
					if (fgets(pxuline,PIC_CL,stdin)) {
						if (!strlen(pxuline)) {
							pxuline[0] = pxfirst;
							piflags |= PiCR;
						}
						pxfirst = pxuline[0];

						/* 'x' to exit */
						if (pxuline[0] == 'x') {
							break;
						}

						/* '.' means immediate */
						if (pxuline[0] == '.')
							piflags |= PiII;
						else
							piflags &= ~PiII;

						/* reset timer */
						utime(0);

						/* do the command */
						pisyn(pxuline,pusrsyn,psynf);

						if (pxerror)
							pierror();
					}

					if (pxflags&POXX)
						break;
				} /* end of forever loop for dialog */
			} else
				pierror();
			}
		pcexit();	/* shut down link to PROMICEs */
		}
}

/* `utime` - time stamp the prompt */

static void utime(short code)
{
	static time_t t;
	time_t tt;
	short day,hour,minute;

	/* Reset the timer */
	if ( code == 0 ) {
		t = time(NULL);
		return;
	}

	day = hour = minute = 0;

	tt = time(NULL) - t;

	if (tt >= 86400) {
	    day = tt/86400;
	    tt %= 86400;
	}
	if (tt >= 3600) {
	    hour = tt/3600;
	    tt %= 3600;
	}
	if (tt >= 60) {
	    minute = tt/60;
	    tt %= 60;
	}

	if (day) {
	    sprintf(utimes,"%03d|%02d:%02d:%02d:",day,hour,minute,tt);
	    return;
	}
	if (hour) {
	    sprintf(utimes,"%02d:%02d:%02d:",hour,minute,tt);
	    return;
	}
	if (minute) {
	    sprintf(utimes,"%02d:%02d:",minute,tt);
	    return;
	}
	sprintf(utimes,"%02d:",tt);
}

/* THE END */
