/*	pscript.h - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - This file contains the syntax for all parsing operations 
	
	Format: break characters are 'bt,/:='
	literal command &
	$ - read a string
	# - read a decimal number
	* - read a hex number
	: - read unit id
	% - read embedded number
	@ - read a list of zero or more hex numbers
	& - read a list of zero or more decimal numbers
*/

#ifdef ANSI
void pisyn(char *in, char *scripts[], void (*psynf[])(void));
#else
void pisyn();
#endif

#ifdef PDGLOB
char	*pcmfsyn[] = {
/*	high */
	"high&#(h",
/* fast - we have a fast host */
	"fast&@(Y",
/*	noverify */
	"noverify&(v",
/*	nochecksum [1] */
	"nochecksum&#(x",
/*	noaddrerr [1] */
	"noaddrerr&#(z",
/* noautorecover */
	"noautorecovery&(U",
	"noautorecover&(U",
	"auto&*(U",
/* nomap [#] */
	"nomap&#(O",
	"map&#(O",
/*	rom=[id:]size */
	"rom&:%(r",
/* socket=[id:]size */
	"socket&:%(J",
/*	number=number */
	"number&#(n",
/*	word=size/byteorder */
	"word&#&(w",
/*	baud=rate */
	"baud&#(b",
/*	output=device[:addr] */
#ifdef MSDOS
	"output&%*(o",
#else
	"output&$(o",
#endif
/*	fill=[id:]char */
	"fill&:*(f",
/*	ffill=[id:]char */
	"ffill&:*(f",
/*	parallel [lpt1[:],lpt2,..][:addr] */
#ifdef UNIX
	"parallel&$(p",
#else
	"parallel&%*(p", 
#endif
/*	pponly [lpt1[:],lpt2,..][:addr] */
#ifdef UNIX
	"pponly&$(q",
#else
	"pponly&%*(q",
#endif
/*	reset [nnn] */
	"reset&#(R",
/* enter test mode */
	"test&#(t",
/*	file=name [offset=[id:]address][/size/byteorder] */
	"hex&$*:*&(F",
	"file&$*:*&(F",
/*	image=name [offset=[id:]address][/size/byteorder] */
	"binary&$*:*&(I",
	"bin&$*:*&(I",
	"image&$*:*&(I",
/*	display # - change display level */
	"display&*(D",
/*	dialog - enter dialog mode */
	"dialog&(Z",
/*	load - down-load data before entering dialog mode */
	"load&(l",
/*	config [type] - show config */
	"config&$(C",
/*	edit - specify edit functions */
	"edit&:*@(e",
/* cheksum - specify checksum information */
	"checksum&:***+#(k",
/* move - move stuff around */
	"move&:***(m",
/* compare - compare data */
	"compare&(c",
/* delay - set timeout dealy */
	"delay&#(y",
/* dump - dump stuff */
	"dump&:@(d",
/* set parallel transfer mode */
	"ppmode&@(T",
/* ailoc [id:]## - specify the address of AI port and baud rate */
	"ailoc&:*#*#(a",
/* aiswitch port# - loadice talking through the AISwitch */
	"aiswitch&#(A",
/* ulock - support for locked units */
	"ulock&(M",
/* hso - set target interrupt and REQ/ACK polarity */
	"hso&***(i",
/* exit - set exit code */
	"exit&##(X",
/* f#=string - process function keys */
	"f&#$(K",
	"altf&#$(K",
	0
	};

char	*pcmlsyn[] = {

/*	command line arguments: */
	
/* -a [id:]#### - ailoc for AITTY wordsize, baud rate + break char and ints */
	"-a&:*#*#(a",
/*	-b rate */
	"-b&#(b",
/* -delay amount - set delay */
	"-delay&#(y",
/*	-d */
	"-d&(Z",
/*	-e [id:]addr data data data ... */
	"-e&:*@(e",
/*	-ff [id:]fillchar */
	"-ff&:*(f",
/*	-f [id:]fillchar */
	"-f&:*(f",
/*	-h */
	"-h&#(h",
/*	-i filename fileInfo */
	"-i&$*:*&(I",
/*	-j offset filename word/byteorder */
	"-j&$*:*&(J",
/*	-k [id:]start end store x|a */
	"-k&:***+#(k",
/*	-l */
	"-l&(l",
/*	-m [id:]start end dest */
	"-m&:***(m",
/* -n # number of unit in the chain */
	"-n&#(n",
/*	-o name[:addr] */
#ifdef MSDOS
	"-o&%*(o",
#else
	"-o&$(o",
#endif
/*	-p [lpt][n][:][:addr] */
#ifdef UNIX
	"-p&$(p",
#else
	"-p&%*(p",
#endif
/*	-q [lpt][n][:][:addr] */
#ifdef UNIX
	"-q&$(q",
#else
	"-q&%*(q",
#endif
/*	-r [id:]size */
	"-r&:%(r",
/* -s [id:]size */
	"-s&:%(J",
/*	-v verify on */
	"-v&(v",
/*	-w size[/byteorder] */
	"-w&#&(w",
/*	-x [1] - don't check checksum */
	"-x&#(x",
/*	-z [1] - ignore address out of range errors */
	"-z&#(z",
/* -A port# - loadice talking through the AISwitch */
	"-A&#(A",
/*	-C [type] - display config */
	"-C&$(C",
/*	-D # - change display level */
	"-D&*(D",
/* -F - don't do filling */
	"-F&(N",
/* -H - fast host */
	"-H&@(Y",
/* -I - hso polarity */
	"-I&***(i",
/* -M - locked unit support */
	"-M&#(M",
/*	-O - change map display status */
	"-O&#(O",
/* -P - change parallel port parameter */
	"-P&@(T",
/*	-R milliseconds - reset the target system */
	"-R&#(R",
/* -U - autorecovery */
	"-U&*(U",
/* @filename - just skip this file */
	"@&$(U",
/*	default is like file */
	"~$*:*&(F",
	0
	};

char	*pusrsyn[] = {

/*	interactive dialog mode commands: */
	
/* ai - tty mode */
	"ai&:*#*#(B",
/* autoreocvery */
	"auto&*(U",
/* B - bus handshake mode */
	"B&***(i",
/*	C - display config */
	"C&$(C",
	"config&$(C",
/*	c - compare */
	"compare&(c",
	"c&(c",
/*	D # - change display level */
	"display&*(D",
	"D&*(D",
/*	exit - exit the application */
	"exit&(X",
	"quit&(X",
/*	e [[id:]address][data] */
	"edit&:*@(e",
	"e&:*@(e",
/* delay # - set delay */
	"delay&#(y",
/*	d [[id:]address1] [address2] */
	"dump&:@(d",
	"d&:@(d",
/*	f [id:]start end data */
	"fill&:@(g",
	"file&$*:*&(F",	/* hex file */

/* find - star end length data */
	"find&*******(j",
	"f&:@(g",
	"F&*******(j",
/* go - emulate */
	"go&(G",
/* help - give help */
	"help&$(H",
/*	h name [offset=[id:]address][/size/byteorder][(start end)] */
	"hex&$*:*&(F",
	"h&$*:*&(F",
/*	i name [skip=[id:]address][/size/byteorder][(start end)] */
	"image&$*:*&(I",
	"binary&$*:*&(I",
	"bin&$*:*&(I",
	"i&$*:*&(I",
/*	j name [offset=[id:]address][/size/byteorder][(start end)] */
	"j&$*:*&(J",
/*	.h name [offset=[id:]address][/size/byteorder][(start end)] */
	".file&$*:*&(F",	/* hex file */
	".hex&$*:*&(F",
	".h&$*:*&(F",
/*	.i name [offset=[id:]address][/size/byteorder][(start end)] */
	".image&$*:*&(I",
	".binary&$*:*&(I",
	".bin&$*:*&(I",
	".i&$*:*&(I",
/*	.j name [offset=[id:]address][/size/byteorder][(start end)] */
	".j&$*:*&(J",
/* k [id:]start end store /x/a - do checksum */
	"checksum&:***+#(k",
	"chksum&:***+#(k",
	"k&:***+#(k",
/*	li - load binary file (optionally just this file) */
	"limage&$*:*&(L",
	"lbinary&$*:*&(L",
	"lbin&$*:*&(L",
	"li&$*:*&(L",
/*	l - load (optionally just this file) */
	"load&$*:*&(l",
	"l&$*:*&(l",
/*	m [id:]start end dest */
	"move&:***(m",
	"map&#(O",	/* map on or off */
	"m&:***(m",
/*	r time */
	"restart&(P",
	"reset&#(R",
	"rom&:%(r",
	"r&#(R",
/*	R [id:]size */
	"R&:%(r",
/* socket [id:]size */
	"socket&:%(J",
/* stop - stop emulation */
	"stop&(s",
/* search - stuff */
	"search&**$(j",
	"S&**$(j",
/*	s name[id:][start end] */
	"save&$:@(S",
	"serial&:#(u",
	"s&$:@(S",
/* S [id:] - return serial # */
	"S&:#(u",
/*	t [id:] count */
	"test&:##(t",
	"t&:##(t",
/*	v [id] */
	"version&:#(V",
	"ver&:#(V",
	"v&:#(V",
/*	w size[/order] */
	"word&#&(w",
	"w&#&(w",
/* W [id:]# - enable write signal */
	"W&:*(W",
/*	x [1] */
	"nocserr&#(X",
	"X&#(X",
/*	z [1] */
	"noaddrerr&#(z",
	"z&#(z",
/*	? */
	"?&$(H",
/*	!string */
	"!&!(E",
	0
	};
#else
extern char *pcmfsyn[];
extern char *pcmlsyn[];
extern char *pusrsyn[];
#endif
