/*	PiError.h - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - error codes and messages
*/

#define	PGE_NOE	0		/* NO ERROR */
#define	PGE_SYN	1		/* error in script syntax */
#define	PGE_CMD	2		/* no script to process command */
#define	PGE_NUM 3		/* to many numeric items in script */
#define	PGE_LST 4		/* too many items for numeric list */
#define	PGE_INP 5		/* expected item not in input */
#define	PGE_FNM 6		/* file name error */
#define	PGE_BRT	7		/* invalid baud rate */
#define	PGE_ROM	8		/* invalid ROM size */
#define	PGE_WDS	9		/* invalid word size */
#define	PGE_IDL	10		/* invalid unit ID list */
#define	PGE_OPN	11		/* open failed */
#define	PGE_SKP	12		/* unable to skip file data */
#define	PGE_IOE	13		/* device I/O error */
#define	PGE_BPN	14		/* bad port name */
#define	PGE_EOF	15		/* end-o-file */
#define	PGE_CFT	16		/* bad paramter to `picmd()` */
#define	PGE_COM	17		/* communication error */
#define	PGE_NTL	18		/* name is too long */
#define	PGE_TMO	19		/* timed out */
#define	PGE_NYI	20		/* unimplemented feature */
#define	PGE_VFE	21		/* verify failed */
#define	PGE_BIG	22		/* ID out of range */
#define	PGE_AOR	23		/* data address out of range */
#define	PGE_CFG	24		/* ran out of config space */
#define	PGE_BAA	25		/* bad arguments */
#define	PGE_CHK	26		/* bad checksum in record */
#define	PGE_UNF	27		/* feature not supported */
#define	PGE_DRV	28		/* bad argument for driver call */
#define	PGE_BAD	29		/* bad data in hex record */
#define	PGE_LOK	30		/* unit is locked */
#define	PGE_BCF 31		/* bad unit in config */
#define	PGE_PWR	32		/* mem size 0 check power on unit */
#define	PGE_USR	33		/* operation terminated at user request */
#define	PGE_OVR	34		/* data over-run on serial i/o */
#define	PGE_KEY 35		/* no key assigned */
#define	PGE_EMU	36		/* unit is emulating */
#define	PGE_LOD	37		/* unit is in load mode */
#define	PGE_NOP	38		/* no operation */
#define	PGE_MAX	39		/* Max value for `pxerror` */

#ifdef	PDGLOB
char *pxerrmsg[] =
		{
		"No error",
		"LoadICE parser internal error #1",
		"Invalid input",
		"LoadICE parser internal error #2",
		"Too many numeric items in input",
		"Expected argument not in input",
		"Filename error",
		"Invalid baud-rate",
		"Invalid ROM size",
		"Invalid word-size",
		"Invalid ID list",
		"Open failed",
		"Unable to skip file data",
		"Device I/O error",
		"Bad port name",
		"End-o-File",
		"Bad parameters to picmd()",
		"Communication error",
		"Name too long",
		"Timed out waiting for PROMICE",
		"FEATURE NOT IMPLEMENTED YET!",
		"Verify failed",
		"Invalid unit ID",
		"Address out of range",
		"Out of config resource",
		"Bad arguments",
		"Bad checksum in record",
		"Feature not supported by the Host system",
		"Bad argument to 'pidrvr'",
		"Bad data in hex record",
		"Unit is LOCKED",
		"Not enough units to emulate the word-size",
		"Memory size ZERO! cycle power on unit",
		"Operation terminated by user",
		"Data over-run",
		"Key NOT Assigned",
		"Emulating!",
		"Not emulating!",
		"No operation!"
		};
#else
extern char *pxerrmsg[];
#endif
extern long pxerror;
extern char *pi_estr1;
extern char *pi_estr2;
extern char *pi_eloc;
extern long pi_enum1;
extern long pi_enum2;
extern short pi_eflags;
#define PIE_NUM	0x0001			/* display numbers */

#ifdef ANSI
void pierror(void);
#else
void pierror();
#endif
extern short pi_endx;
