/*	PiError.c - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - Display error
*/

#include <stdio.h>

#include "piconfig.h"
#include "pistruct.h"
#include "pierror.h"

#include <errno.h>

void pierror ( void )
{
	if (pxerror == PGE_NOP) {
		pxerror = PGE_NOE;
		return;
	}

	if (pxerror) {
		if (pxerror >= PGE_MAX) {
			printf("-UNKNOWN ERROR > %ld\n",pxerror);
		} else {
			printf("-ERROR: %ld - %s\n",pxerror, pxerrmsg[pxerror]);
			if (pi_estr1 != (char *)0) {
				printf("-ERROR-STRING: `%s`\n",pi_estr1);
				pi_estr1 = (char *)0;
			} if (pxdisp&PXMI) {
				if (pi_eloc != (char *)0) {
					printf("-ERROR-LOCATION: `%s`\n",pi_eloc);
					pi_eloc = (char *)0;
				}
				if (pi_estr2 != (char *)0) {
					printf("-ERROR-STRING2: `%s`\n",pi_estr2);
					pi_estr2 = (char *)0;
				}
				if (pi_eflags&PIE_NUM) {
					printf("-ERROR-DATA: %lX / %lX\n",pi_enum1,pi_enum2);
					pi_eflags &= ~PIE_NUM;
				}
			} if (errno) {
#ifdef MACAPPL
				printf("-SYSTEM ERROR: CODE (errno) = %d\n",errno);
#else
				perror("-SYSTEM ERROR: \n");
#endif
				errno = 0;
			}
		}
		piflags |= PiER;
	}

	if (pxerror == PGE_TMO)
		piflags &= ~PiUP;		/* link is not up */

	if (piflags&PiiX)
		pxerror = PGE_NOE;
	else
		pxexitv = PI_FAILURE;
}

/* THE END */
