/*	pidriver.h - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/* P R O M I C E   D E V I C E   I N T E R F A C E  */

/* PROMICE Commands*/

#define	PI_BR	0x03		/* used for establishing baudrate */
#define	PI_ID 	0x00		/* establish unit ID */

#define	PI_LP	0x00		/* load data pointer */
#define	PI_WR	0x01		/* write data to promice */
#define	PI_RD	0x02		/* read data from promice */
#define	PI_RS	0x03		/* restart unit */
#define	PI_MO	0x04		/* set mode */
#define	PI_TS	0x05		/* test ram */
#define	PI_RT	0x06		/* reset target */
#define	PI_MB	0x07		/* modify a byte using REQ/ACK*/
#define	PI_CX	0x08		/* set communications link */
#define	PI_CW	0x09		/* write com data */
#define	PI_CR	0x0A		/* read com data */
#define	PI_CM	0x0B		/* change com mode */
#define	AI_BR	0x0C		/* AI break-point */
#define	AI_HT	0x0D		/* AI hardware trap */
#define	PI_EX	0x0E		/* extended command */
#define	PI_VS	0x0F		/* read version */

/* Command byte modifiers for various commands */

#define	CM_PICOM	0x80	/* PiCOM bit in com commands */
#define	CM_ASYNC	0x40	/* async response */
#define	CM_CHANGE	0x40	/* change mode per data */
#define	CM_AITTY	0x40	/* put AI in tty mode */
#define	CM_CINIT	0x40	/* initialize control area */
#define	CM_NORSP	0x20	/* No response bit for all commands */
#define	CM_INTT		0x10	/* interrupt the target */
#define	CM_FILLC	0x10	/* do fill instead of PI_TS */
#define	CM_CKSUM	0x40	/* do checksum instead of PI_TS */
#define	CM_FAIL		0x10	/* command failed (in RSP) */

/* Mode byte flags for PI_MO command */

#define	MO_FAST		0x80	/* response at full baud rate */
#define	MO_DBUG		0x40	/* set debug bit in PROMICE */
#define	MO_PPGO		0x04	/* fast parallel port load */
#define	MO_AUTO		0x02	/* enable auto-reset */
#define	MO_LOAD		0x01	/* put unit in load mode */
#define	MO_EMU		0x00	/* back to emulate mode */

/* Mode byte flags for PI_CM command */

#define	MO_COMON	0x80	/* turn link on */
#define	MO_ASYNC	0x40	/* global async read */
#define	MO_REQH		0x20	/* reqest is hi asserted */
#define	MO_ACKH		0x10	/* ack is hi asserted */
#define	MO_INTH		0x08	/* int to target is hi asserted */
#define	MO_GRINT	0x04	/* global async read interrupt */


/* PiCOM status bits */

#define	PS_TDA	0x01		/* target data available */
#define	PS_HDA	0x02		/* host data available */
#define	PS_ACK	0x04		/* interrupt acknowledge */
#define	PS_ERR	0x10		/* command error */
#define	PS_BUSY	0x10		/* interface busy */
#define	PS_ENB	0x80		/* interface enabled */

/* driver function prototypes */

#ifdef ANSI
void picmd(char id,char cmd,char ct,char d0,char d1,char d2,char d3,char d4);
void pirsp(void);
long pi_cmd(void);
long pi_rsp(void);
long pi_open(void);
long pi_close(void);
long pi_write(void);
long pi_read(void);
void pi_sleep(short time);
void pi_tochk(void);

#else
void picmd();
void pirsp();
long pi_cmd();
long pi_rsp();
long pi_open();
long pi_close();
long pi_write();
long pi_read();
void pi_sleep();
void pi_tochk();
#endif
