/*	PiCore.c - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - LoadICE CORE functions:
		pcinit() - initialize the link to PROMICEs
		pcfill() - fill ROM
		pcedit() - edit ROM contents
		pcdump() - dump ROM contents
		pcsave() - save ROM contents to file
		pcksum() - checksum ROM etc.
		pcmove() - move ROM contents
		pcrstt() - reset target system
		pctest() - test emulation memory
		pcexit() - shutdown PROMICE, unlink
*/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#ifdef MSDOS
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include "piconfig.h"
#include "pistruct.h"
#include "piscript.h"
#include "pierror.h"
#include "pidata.h"
#include "pidriver.h"
#include "pisyn.h"

#ifdef MAGMASP
#include <sys/ioctl.h>
#include "ppreg.h"
#endif

#ifdef ANSI
extern void (*psynf[])(void);
extern void pifixcfg(void);
extern void pifile(void);
extern void piconfig(short code);
extern void piread(void);
extern void piwrite(void);
extern void pidoedit(void);
extern void pidodump(void);
extern void pi_beep(void);

void pcedit(void);
void pcxfill(void);
void pcxksum(void);

#else
extern void (*psynf[])();
extern void pifixcfg();
extern void pifile();
extern void piconfig();
extern void piread();
extern void piwrite();
extern void pidoedit();
extern void pidodump();
extern void pi_beep();

void pcedit();
void pcxfill();
void pcxksum();
#endif

/* `pcinit` - initialize the link to PROMICE */

void pcinit()
	{
	short i,j;
	short hicode = 1;
	
	if (piflags&PiUP)
		return;
	pxprom = 0;
	if (pxdisp&PXHI)
		printf("Establishing link with PROMICE (please WAIT)\n");
	pxerror = pi_open();
	if (pxerror)
		return;
	if (pxdisp&PXHI)
		printf("Link is up\n");

	/* program the HSO interrupt polarity now, also REQ and ACK */
	if (piflags&PiHO)
		{
		switch(pxhso)
			{
			case 0:
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				break;
			case 1:
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				break;
			case 2:
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				break;
			case 5:
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				break;
			case 10:
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pi_sleep(1);
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				break;
			case 13:
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pxcmo |= MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				pi_sleep(1);
				pxcmo &= ~MO_INTH;
				picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
				break;
			default:
				pxerror = PGE_BAA;
				return;
			}
		}

	if (piflags&PiRQ)
		{
		if (pxreq)
			pxcmo |= MO_REQH;
		else
			pxcmo &= ~MO_REQH;
		if (pxack)
			pxcmo |= MO_ACKH;
		else
			pxcmo &= ~MO_ACKH;
			picmd(0,PI_CM | CM_CHANGE | CM_NORSP,1,pxcmo,0,0,0,0);
		}

	/* check PROMICE memory size */
	for (i=0; i<pxprom; i++)
		{
		if (piflags&PiGT)
			picmd((char)i,PI_MO,1,MO_DBUG|pxdebug,0,0,0,0);
		picmd((char)i,PI_MO,1,MO_EMU,0,0,0,0);
		if (pxerror)
			return;
		pxrom[i].size = pxroms[pxrsp[PIDT]&0x0f];
		if (!(piflags&PiGT))		/* if not testing */
			{
			if (!pxrom[i].size)		/* damn! size is zero */
				{
				pxerror = PGE_PWR;
				return;
				}
			if (pxrom[i].esize > pxrom[i].size)
				{
				if (pxdisp&PXHI)
					{
					pi_beep();
					printf("WARNING! down-sizing emulation!\n");
					}
				pxrom[i].esize = pxrom[i].size;
				}
			}
		if (!pxrom[i].esize)	/* default emulation size, when not given */
			pxrom[i].esize = pxrom[i].size;
		if (!pxrom[i].ssize)
			pxrom[i].ssize = pxrom[i].esize;
		pxrom[i].amask = PIC_MM - pxrom[i].ssize;
		picmd((char)i,PI_VS,1,0,0,0,0,0);	/* get MicroCode version# */
		if (pxerror)
			return;
		for (j=0; j<4; j++)
			pxrom[i].ver[j] = pxrsp[PIDT+j];
		if (pxrom[i].ver[0] < '6')
			hicode = 0;
		if (pxrom[i].ver[0] < '7')
			pxrom[i].smask = 0x000000;
		else
			if ((pxrom[i].ver[2] == '1') &&
					((pxrom[i].ver[3] == 'a') || (pxrom[i].ver[3] == 'A')))
				pxrom[i].smask = 0x000000;
			else
				{
				if (pxrom[i].size <= 131072)
					pxrom[i].smask = 0x060000;
				else
					{
					if (pxrom[i].size == 262144)
						pxrom[i].smask = 0x040000;
					else
						pxrom[i].smask = 0x000000;
					}
				}
		}
	if (pxnrom > pxprom)
		{
		pxerror = PGE_BCF;
		return;
		}
	piflags |= PiUP;
	pxnrom = pxprom;
	if (!pxcfg)	/* if no config */
		{
		sprintf(pxuline,"word=8");	/* fake a 'word' command */
		pisyn(pxuline,pcmfsyn,psynf);
		}
	else
		{
		if (piflags&PiNL)
			{
			piflags &= ~PiNL;
			sprintf(pxuline,"word=%d",pxcfg->words*8);
			pisyn(pxuline,pcmfsyn,psynf);
			}
		}
	for (i=0; i<pxnfile; i++)	/* fix any file configs */
		{
		pxcfg = pxfile[i].pfcfg;
		if (pxcfg)
			pifixcfg();
		}
	pxcfg = pxpcfg;
	pifixcfg();
	if (pxdisp&PXHI)
		piconfig(PcROM);
	if (pxerror)
		return;
	if (hicode && !(pxflags&POSP) && pxlink.flags&(PLPQ|PLPP))
		{
		for (i=0; i<pxprom; i++)
			picmd((char)i,PI_MO|CM_NORSP,1,MO_EMU|MO_PPGO,0,0,0,0);
#ifdef	MAGMASP
		ioctl(pxlink.paddr,PPIOCSETF,0);
#endif
		piflags |= PiFP;
		}
	if ((!pxflags&POIX) && piflags&PiFM)	/* if fill reqired */
		pcxfill();
	if ((!pxnfile) && (piflags&PiEL))	/* if no files then do edit - maybe */
		pcedit();
	}
/* `pcfill` - fill ROM space */

void pcfill()
	{
	long i,tct,w,b;

	if (pxcfg->flags & PCFL)	/* if filling config or partial ROM */
		{
		if ((pxfstart>pxfend) || (pxfstart<0) || (pxfend<0))
			{
			pxerror = PGE_BAA;
			return;
			}
		if ((pxfstart>pxmax) || (pxfend>pxmax))
			{
			pxerror = PGE_AOR;
			return;
			}
		if (pxdisp&PXHI)
			{
			printf("Filling config from %lX to %lX fill char=%lX\n",
				pxfstart, pxfend, pxfdata);
			if (pxdisp&PXMH)
				piconfig(PcCFG);
			}
		tct = pxfend - pxfstart + 1;
		pxxloc = pxfstart;
		pxdlc = 0;
		while (tct && !pxerror)		/* keep going till done or error */
			{
			if (tct > PIC_BS)
				pxxbc = PIC_BS;
			else
				pxxbc = tct;
			tct -= pxxbc;
			w = pxcfg->words;
			for (i=0; i<pxxbc; i+=w)
				for (b=0; b<w; b++)
					pxxbf[i+b] =(char)(pxfdata >> (w-1-b)*8);
			piwrite();
			pxxloc += pxxbc;
			}
		if (!pxerror && (pxdisp&PXHI))
			printf("Transferred %ld (0x%lx) fill characters\n",pxdlc,pxdlc);
		}
	else
		pcxfill();
	}

/* `pcxfill` - fill whole ROMs */

void pcxfill()
	{
	char mo,fc;
	long i,j,tct;
	PICONFIG *tcfg;

	tcfg = pxcfg;
	for (i=0; i<pxprom; i++)
		{
		if (pxrom[i].flags&PRFL)
			{
			fc = (char)pxrom[i].fillc;
			if (pxdisp&PXHI)
				printf("Filling ROM[ID=%ld]/char=%02X",i,fc&0xff);

			if (pxrom[i].ver[0] >= '5') /* can MicroCode do it? */
				{
				if (pxdisp&PXHI)
					printf(" (via uCode)\n");
				if (pxlink.flags & PLHI)
					mo = MO_LOAD | MO_FAST;
				else
					mo = MO_LOAD;
				if (piflags&PiPH)
					{
					picmd((char)i,PI_MO,1,mo,0,0,0,0);
					if (pxrsp[PIDT] == PIC_LOCK)
						{
						pxerror = PGE_LOK;
						return;
						}
					}
				else
					picmd((char)i,PI_MO|CM_NORSP,1,mo,0,0,0,0);
				piflags |= PiNT;
				picmd((char)i,PI_TS|CM_FILLC,1,(char)pxrom[i].fillc,0,0,0,0);
				piflags &= ~PiNT;
				}
			else		/* else fill brute force */
				{
				if (pxdisp&PXHI)
					printf("\n");
				pxcfg = &pxaltcfg;
				pxcfg->words = 1;
				pxcfg->uid[0] = (short)i;
				pifixcfg();
				tct = pxrom[i].esize;
				pxxloc = pxcfg->start;
				pxdlc = 0;
				while (tct && !pxerror)
					{
					if (tct > PIC_BS)
						pxxbc = PIC_BS;
					else
						pxxbc = tct;
					tct -= pxxbc;
					for (j=0; j<pxxbc; j++)
						pxxbf[j] =fc;
					piwrite();
					pxxloc += pxxbc;
					}
				if (!pxerror && (pxdisp&PXHI))
					printf("Transferred %ld (0x%lx) fill characters\n",
						pxdlc,pxdlc);
				}
			}
		}
	pxcfg = tcfg;
	}
					
/* `pcedit` - edit ROM contents */

void pcedit()
	{
	extern void pidoedit();

	pidoedit();		/* in PIEDIT */
	}

/* `pcdump` - dump ROM contents */

void pcdump()
	{
	extern void pidodump();
	
	pidodump();		/* in PIEDIT */
	}

/* `pcsave` - save ROM contents */

void pcsave()
	{
	long sct;
	int ref,rc;
	
	if ((pxsstart<0) || (pxsstart>pxsend) || (pxsend<0) )
		{
		pxerror = PGE_BAA;
		return;
		}
	if ((pxsstart>pxmax) || (pxsend>pxmax))
		{
		pxerror = PGE_AOR;
		return;
		}
#ifdef MSDOS
	if ((ref = open(ps_str,O_WRONLY|O_CREAT|O_TRUNC|O_BINARY,S_IWRITE)) >= 0)
#else
	if ((ref = open(ps_str,O_WRONLY|O_CREAT|O_TRUNC)) >= 0)
#endif
		{
		sct = pxsend - pxsstart + 1;
		if (pxdisp&PXHI)
			printf("Saving to file '%s' (data count=%ld)\n",ps_str,sct);
		pxyloc = pxsstart;
		while(sct)
			{
			if (sct > PIC_BS)
				pxybc = PIC_BS;
			else
				pxybc = sct;
			sct -= pxybc;
			piread();
			if (!pxerror)
				{
				rc = write(ref,pxybf,(unsigned int)pxybc);
				if (rc <0)
					{
					pxerror = PGE_IOE;
					break;
					}
				}
			pxyloc += pxybc;
			}
		close(ref);
		}
	else
		pxerror = PGE_OPN;
	}

/* `pcksum` - checksum ROM etc. */

void pcksum()
	{
	long kct,ksum,i;
	
	if ((pxkstart<0)||(pxkend<0)||(pxkend<pxkstart)||(pxkstore<0)||(pxksize>4))
		{
		pxerror = PGE_BAA;
		return;
		}
	if ((pxkstart>pxmax) || (pxkend>pxmax) || (pxkstore>pxmax))
		{
		pxerror = PGE_AOR;
		return;
		}
	kct = pxkend - pxkstart + 1;
	ksum = 0;
	pxyloc = pxkstart;
	while(kct)
		{
		if (kct > PIC_BS)
			pxybc = PIC_BS;
		else
			pxybc = kct;
		kct -= pxybc;
		piread();
		if (!pxerror)
			{
			for (i=0; i<pxybc; i++)
				{
				if (pxflags&POKA)
					ksum += pxybf[i];
				else
					ksum ^= pxybf[i];
				}
			}
		else
			break;
		pxyloc += pxybc;
		}
	if (!pxerror)
		{
		pxxloc = pxkstore;
		pxxbc = pxksize;
		if (pxflags&POKA)
			ksum = -ksum;
		printf("Storing ROM checksum @%lX\n",pxxloc);
		if (pxflags&POKA)
			printf("Checksum computed by addition, and is =");
		else
			printf("Checksum computed by exclusive OR, and is =");

		for (i=pxksize-1; i>=0; i--) {
			pxxbf[i] = (char)(ksum>>(i*8));
			printf("%02X",pxxbf[i]&0x0ff);
		}
		printf ( "\n" );

		piwrite();
		}
	}

/* `pcxksum` - checksum whole ROMs */

void pcxksum()
	{
	char mo;
	long i,j;
	long kct,ksum;
	PICONFIG *tcfg;

	ksum = 0;
	tcfg = pxcfg;
	for (i=0; i<pxprom; i++)
		{
		if (pxrom[i].flags&PRCK)
			{
			if (pxdisp&PXHI)
				printf("Checksuming ROM[ID=%d]\n",i);
			pxcfg = &pxaltcfg;
			pxcfg->words = 1;
			pxcfg->uid[0] = (short)i;
			pifixcfg();
			if (pxerror)
				return;
			kct = pxrom[i].kend - pxrom[i].kstart + 1;
			while(kct)
				{
				if (kct > PIC_BS)
					pxybc = PIC_BS;
				else
					pxybc = kct;
				kct -= pxybc;
				piread();
				if (!pxerror)
					{
					for (j=0; j<pxybc; j++)
						{
						if (pxflags&POKA)
							ksum += pxybf[j];
						else
							ksum ^= pxybf[j];
						}
					}
				else
					break;
				pxyloc += pxybc;
				}
			if (!pxerror)
				{
				pxxloc = pxrom[i].kstore;
				pxxbc = pxrom[i].ksize;
				if (pxflags&POKA)
					ksum = -ksum;
				printf("Storing ROM checksum @%lX\n",pxxloc);
				if (pxflags&POKA)
					printf("Checksum computed by addition, and is =");
				else
					printf("Checksum computed by exclusive OR, and is =");
				for (j=pxrom[i].ksize-1; j>=0; j--)
					{
					pxxbf[j] = (char)(ksum>>(j*8));
					printf("%02x",pxxbf[j]&0x0ff);
					}

				printf ( "\n" );
				piwrite();
				}
			pxcfg = tcfg;
			}
		}
	}

/* `pcmove` - move ROM data */

void pcmove()
	{
	long mct,i;
	
	if ((pxmstart<0) || (pxmend<0) || (pxmend<pxmstart) || (pxmdest<0))
		{
		pxerror = PGE_BAA;
		return;
		}
	if ((pxmstart>pxmax) || (pxmend>pxmax) || (pxmdest>pxmax))
		{
		pxerror = PGE_AOR;
		return;
		}
	mct = pxmend - pxmstart + 1;
	pxxloc = pxmdest;
	pxyloc = pxmstart;
	while(mct && !pxerror)
		{
		if (mct > PIC_BS)
			pxybc = PIC_BS;
		else
			pxybc = mct;
		mct -= pxybc;
		piread();
		if (!pxerror)
			{
			for (i=0; i<pxybc; i++)
				pxxbf[i] = pxybf[i];
			pxxbc = pxybc;
			piwrite();
			}
		pxxloc += pxxbc;
		pxyloc += pxybc;
		}
	}

/* `pcfind` - find stuff in memory */

void pcfind()
	{
	long here,tct,i,j,k,l;

	tct = pxlend - pxlstart + 1;
	pxyloc = pxlstart;
	here = k = 0;
	while (tct && !pxerror)
		{
		if (tct > PIC_BS)
			pxybc = PIC_BS;
		else
			pxybc = tct;
		tct -= pxybc;
		piread();
		if (!pxerror)
			{
			for (i=0; i<pxybc;)
				{
				for (j=k; j<pxlsize; j++)
					{
					if (pxybf[i++] == pxldata[j])
						{
						if ((i==pxybc) && (j<(pxlsize-1)))
							{
							k = j+1;
							break;
							}
						if (!here)
							here = pxyloc + i - 1;
						}
					else
						{
						here = 0;
						k = 0;
						break;
						}
					}
				if (!k && here)
					{
					printf("%08lX: ",here);
					for (j=0; j<pxlsize; j++)
						printf("%02X",pxldata[j]&0x0ff);
					printf ( "\n" );
					here = 0;
					}
				}
			}
		pxyloc += pxybc;
		}
	}


/* `pcstring` - find string in memory */

void pcstring()
	{
	long here,tct,i,j,k,l;
	unsigned char *tsp;

	tct = pxlend - pxlstart + 1;
	pxyloc = pxlstart;
	here = k = 0;
	pxlsize = strlen(pxlstr);
	tsp = pxlstr;
	while (tct && !pxerror)
		{
		if (tct > PIC_BS)
			pxybc = PIC_BS;
		else
			pxybc = tct;
		tct -= pxybc;
		piread();
		if (!pxerror)
			{
			for (i=0; i<pxybc;)
				{
				for (j=k; j<pxlsize; j++)
					{
					if (pxybf[i++] == *tsp++)
						{
						if ((i==pxybc) && (j<(pxlsize-1)))
							{
							k = j+1;
							break;
							}
						if (!here)
							here = pxyloc + i - 1;
						}
					else
						{
						here = 0;
						k = 0;
						tsp = pxlstr;
						break;
						}
					}
				if (!k && here)
					{
					printf("%08lX: %s\n",here,pxlstr);
					here = 0;
					tsp = pxlstr;
					}
				}
			}
		pxyloc += pxybc;
		}
	}


/* `pcrstt` - reset target system */

#ifdef ANSI
void pcrstt(short id, short tm)
#else
void pcrstt(id, tm)
short id,tm;
#endif
	{
	picmd((char)id,PI_RT,1,(char)tm,0,0,0,0);
	}

/* `pctest` - test emulation memory */

#ifdef ANSI
void pctest(short id, short ct)
#else
void pctest(id, ct)
short id,ct;
#endif
	{
	char mo=MO_LOAD;
	
	if (pxlink.flags & PLHI)
		mo |= MO_FAST;
	if (piflags&PiPH)		/* support LOCKED unit */
		{
		picmd((char)id,PI_MO,1,mo,0,0,0,0);
		if (pxrsp[PIDT] == PIC_LOCK)
			{
			pxerror = PGE_LOK;
			return;
			}
		}
	else
		picmd((char)id,PI_MO|CM_NORSP,1,mo,0,0,0,0);
	piflags |= PiNT;								/* don't timeout */
	picmd((char)id,PI_TS,1,(char)ct,0,0,0,0);
	piflags &= ~PiNT;
	}

/* `pcexit` - shutdown the link to PROMICE */

void pcexit( void )
	{
	short i;
	char mo=MO_EMU;
	char bc=0;
	unsigned long aip;
	
	if (!(piflags&PiUP))
		{
		pi_close();
		return;
		}
	if (pxlink.flags & PLHI)
		mo |= MO_FAST;
	
	if (piflags&PiBC)
		bc = 1;
	if (piflags&PiXP)
		pxaibr = 0x0ff;		/* parallel port AiCOM usage */
	if (piflags&PiAI)		/* if AI xprt mode then set that up */
		{
		if (!pxaiws)
			pxaiws = pxcfg->words;
		aip = (pxailoc/pxaiws) | 0x03 |
				pxrom[pxaiid].smask | pxrom[pxaiid].amask;
		for (i=pxprom-1; i>=0; i--)	/* make sure emulating and set params */
			{
			picmd((char)i,PI_MO|CM_NORSP,1,mo,0,0,0,0);
			picmd((char)i,PI_MO|CM_NORSP|CM_AITTY,3,
				bc,pxaibchr,(char)pxhints,0,0);
			}
		for (i=pxprom-1; i>=0; i--)
			{
			if (i==pxaiid)	/* this one get the AI paramters */
				{
				if (pxdisp&PXHI)
					{
					printf(" PROMICE ID-%d putting AI in transparant mode\n",i);
					printf(" AILOC=0x%lX, HostLink - ",aip);

					if (piflags&PiXP)
						printf("parallel port\n");
					else
						printf("serial port @ %ld baud\n",pxaibr);

					if (bc)
						printf(" BreakCharacter = 0x%02X\n",pxaibchr);
					else
						printf(" Binary transparency - no breakCharacter\n");

					printf(" Host interrupts (DTR/INIT toggles) to ignore: ");
					if (pxhints == 0x0ff)
						printf("ALL\n");
					else
						printf("%d\n",pxhints);
					}

				picmd((char)pxaiid,PI_RS|CM_NORSP|CM_CINIT,
					5,(char)PIC_XCODE,(char)(aip>>16),
					(char)(aip>>8),(char)aip,(char)pxaibrc);
				}
			else			/* others just pass thru data */
				picmd((char)i,PI_RS|CM_NORSP,1,(char)(pxaibrc|0x080),0,0,0,0);
			}
		}
	else		/* standard stuff, just emulate and restore units */
		{
		for (i=pxprom-1; i>=0; i--)
			{
			picmd((char)i,PI_MO|CM_NORSP,1,mo,0,0,0,0);
			picmd((char)i,PI_RS | CM_NORSP,1,0,0,0,0,0);
			}
		}
	if (pxerror)
		pierror();
	pxprom = 0;
	pxerror = pi_close();
	}

/* THE END */
