/*	PiConfig.c - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - Display config
*/

#include <stdio.h>

#include "piconfig.h"
#include "pistruct.h"

#ifdef ANSI
static void pidcfg(PICONFIG *cx,char *hdr);
void piconfig(short cd)
#else
static void pidcfg();

void piconfig(cd)
short cd;
#endif
	{
	short i;
	
	if (cd&PcLNK)
		{
		if (pxprom)
			{
			if (pxlink.flags&(PLPP|PLPQ))
				{
#ifdef MAC
				printf(" Parallel link:@%X\n",pxlink.ppdat);
#else
				printf(" Parallel link:%s(\n%X)",pxlink.pname,pxlink.paddr);
#endif
				}
			if (!(pxlink.flags&PLPQ))
				{
#ifdef MSDOS
				printf(" Serial link:%s(%X) @%ld baud\n",
					    pxlink.name,pxlink.saddr,pxlink.brate);
#else
				printf(" Serial link:%s @%ld baud\n",pxlink.name,pxlink.brate);
#endif
				if (piflags&PiHI)
					printf(" (high speed response is on)\n");
				}
			}
		else
			printf(" Link: not established\n");
		}

	if (cd&PcROM) {
		if (!pxnrom)
			printf(" No ROMs!\n");
		else {
			printf(" PROMICE units:\n");
			for (i=0; i<pxnrom; i++)
				printf("  ID %d uCVer:%4s MemSize=%ld EmuSize=%ld FillChar=%02X\n",
					i,pxrom[i].ver,pxrom[i].size,pxrom[i].esize,pxrom[i].fillc);
		}
	}
	
	if (cd&PcFLE) {
		if (!pxnfile)
			printf(" No files are specified\n");
		if (piflags&PiCK)
			printf(" Checksum in effect\n");
		for (i=0; i<pxnfile; i++)
			{
			printf(" File-%d %12s type-",i+1, pxfile[i].name);
			switch (pxfile[i].type) {
				case PFHEX:
					switch (pxfile[i].htype)
						{
						case 's':
						case 'S':
							printf("Motorola Hex");
							break;
						case ':':
							printf("Intel Hex");
							break;
						case ';':
							printf("Tektronics Hex");
							break;
						default:
							printf("Hex");
							break;
						}
						break;
					case PFBIN:
						printf("Binary");
						break;
					default:
						printf("Unknown");
						break;
			}							

			printf(" offset=%08lX skip=%08lX\n\t(if partial load): start/%08lX end/%08lX\n",
				pxfile[i].offset,pxfile[i].skip,pxfile[i].saddr,pxfile[i].eaddr);

			if (pxfile[i].pfcfg)
				pidcfg(pxfile[i].pfcfg,"  data config:");
		}
	    }

	if (cd&PcPCF)
		{
		if (!pxpcfg)
			printf(" No ROM configuration\n");
		else
			pidcfg(pxpcfg,"  ROM config:\n");
		}
	}

#ifdef ANSI
static void pidcfg(PICONFIG *cx,char *hdr)
#else
static void pidcfg(cx, hdr)
PICONFIG *cx;
char *hdr;
#endif
{
	short i=0;
	
	printf("%s totalRange=[%08lX-%08lX]\n",hdr,(long)0,cx->max);

	while (cx) {
		printf("    (%06X): word=%d IDs=",cx,cx->words*8);
		for (i=0; i<cx->words; i++)
		    printf(" %d",cx->uid[i]);
		printf(" addressRange=[%06lX-%06lX]",cx->start,cx->end);
		cx = cx->next;
		if (cx)
		    printf(" (linked)\n");
	}
}

/* THE END */
