/*	PiHelp.h - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - help strings
*/


typedef struct
	{
	char	*topic;
	char	*help[8];
	}PIHELP;

#ifdef	PDGLOB
char *piclhlp[] = {
"LoadICE Initialization File and Command Line parameters:",
" Items in [..] are optional",
" Command Line arguments override 'ini' file",
" Use any of \" ,:=[](){}\" these break characters in input",
" Following may be specified in an initialization file 'loadice.ini'",
"  ('ini' file may be specified by the environment variable LOADICE)",
" i.e. 'set LOADICE=loadice2.ini' and in UNIX etc. also 'export LOADICE'",
" INI FILE:",
" 'f#=string and altf#=string define the function keys for use in dialog mode",
" 'output=name[:address]' - serial device name (and optional address in DOS)",
" 'baud=rate' - 1200,2400,4800,9600,19200,57600",
" 'parallel=[lpt]n[:address]' - parallel (down-load only) device name",
" 'pponly=[lpt]n[:address]' - bidirectional parallel device name",
" 'high' - send back response at full baudrate (use with 3/486's only)",
" 'rom=[id:]size' - set emulation size, for one or all ROMs",
" 'map [0|1]' - display range of data being down-loaded, also 'nomap'",
" 'fill=[id:]hex' - specify ROM fill character - ROMs filled before loading",
" 'word=size[byteOrder]' - specify word size and byte order i.e 'word=16 1 0'",
" 'file=name offset=[id:]address[word,byteOrder]' - hex file specs",
" 'image=name skip=[id:]address[word,byteOrder]' - binary file",
" 'imagef=name skip=[id:]address[word,byteOrder]' - formatted binary file",
" 'noverify' - don't verify downloaded data",
" 'nochecksum [1]' - don't check hex record checksum / 1 - show bad records",
" 'noaddrerr [1]' - ignore address out of range error / 1 - show bad records",
" 'auto # | noautorecovery - turn auto recovery of link to PROMICE on/off",
"-more (press ENTER or <CR>)",
" 'fast' - we have a fast host (486 or 40MHZ 386) use long strobe on pport",
" 'reset=nnn' - set target reset time to 'nnn' milliseconds",
" 'display hex' - set LoadICE output level - eight levels HI to LO",
" 'dialog' - enter dialog mode",
" 'load' - load files before entering dialog mode",
" 'edit [id:]addr data, data...' - edit ROMs after loading the files",
" 'config [type]' - display configuration information",
" 'checksum [id:]start end store x|a size' -checksum ROM after loading xor|add",
" ' store one two or four bytes depending on size {default is one]",
" 'move [id:]start end destination' - move ROM data",
" 'compare' - compare PROMICE contents with file data",
" 'dump [id:]start end' - dump ROM contents",
" 'hso a [b c]' - define polarity of HSO and optionally [REQ and ACK] lines",
" ' a = 0|1 for low or high, 2|5 for a lo-hi-lo or hi-lo-hi assertion",
" ' or A|D for lo-hi-lo or hi-lo-hi with extra long pulse",
" ' b and c are zero or non-zero",
" 'ailoc addr,baud[,brkchar,int-count]' - program AI tty mode at LoadICE exit",
" 'aiswitch #' - PROMICE is connected to AISwitch (data-pbx) port",
" 'number=#' - number of PROMICE units connected (UNIX only)",
" 'ulock' - support LOCKED units (special feature not normally available)",
" any line in 'ini' file that begins with a '.' will be executed immediately",
" this fact can be used to operate the entire interface from a batch file",
"-more (press ENTER or <CR>)",
" on the Command Line the arguments correspondingly are:",
" . - if first char is '.' don't processes any ini file",
" @ - if first char is '@' use the following string as 'ini' file",
" Example '@new.ini -d' will process the new.ini file and go into dialog mode",
" -o name[:address] - serial output device",
" -b rate - baud rate",
" -p [lpt]n[:address] - parallel down-load only port",
" -q [lpt]n[:address] - parallel port for bidirectional i/o",
" -e [id:]addr data, data, ... - edit list",
" -h - high speed response",
" -H - fast host, make pport strobes longer",
" -k [id:]start end store x|a size - compute checksum xor or add method",
"    store one two or four bytes per size [default is one]",
" -m [id:]start end destination - move ROM data",
" -n # - number of PROMICE units connected (UNIX only)",
" -r [id:]size - emulation size for ROM(s)",
" -f [id:]hex - fill character",
" -w size,byteOrder - emulation word size",
"-more (press ENTER or <CR>)",
" filename fileInfo - hex file specs",
" -i filename fileInfo - binary file specs",
" -j filename fileInfo - formatted binary file",
" -v - don't verify down-loaded data",
" -x [1] - don't check hex record checksum 1/display bad records",
" -z [1] - ignore address out of range errors 1/display bad records",
" -D hex - change output display level 8-levels 1 per bit",
" -F - don't fill ROMs (override -f or fill in ini file)",
" -I a b c - sets HSO control as REQ/ACK polarity, see ini file help",
" -R time - set target reset time",
" -C type - display config type=all,rom,file,link",
" -M - support LOCKED units (special feature not normally available)",
" -O [0|1] - turn data range display ON or OFF (default is ON)",
" -a addr,baud,breakchar,ints - support for AI tty mode operation",
" -A # - PROMICE unit connected to AISwitch (data-pbx) port",
" -d - go into dialog mode",
" -U # - turn auto-recovery on or off",
" -l - load ROMs before going into dialog mode",0
};

PIHELP pxhelp[] = {
"?",
{"Dialog mode command help: USE '? topic' for more help; topics are:",
"  compare,config,dump,display,edit,exit,fill,file,go,ignore,load,map,move",
"  ROM,reset,restart,rv,save,stop,test,version,serial#,word,checksum,scmd,find",
"  - in the command syntax items in '[..]' are optional.",
"  - if an ID is given the operation is specific to that unit(ROM).",
"  - variable number of args have different interpretation (see fill).",
"  - you may use ? with one or more letters to select a topic",0},
/*  c [[id:][start end]] */
"compare",
{"compares file data with down-loaded data",
" syntax:  c",
"  compares PROMICE contents against file data",
"  instead of down-loading, data is uploaded and compared",
"  if partial down-load was specified with the file(s)",
"  then only data in specified range is uploaded and compared",
"  mismatches are reported",0},
/* cfg code - display config */
"config",
{"display configuration information: various things may be requested:",
" syntax: C type - where type can be:",
"  all - display all the information",
"  link - display only the PROMICE link information",
"  rom - display information about each emulation module",
"  file - display information about each file",
"  cfg - display current rom configuration",0},
/*  d [[id:]address1] [address2] */
"dump",
{"dump one or more bytes of ROM space, hex and ASCII data is displayed",
" syntax:  d [id:][start, end]",
"  - dumps either per current config (can be changed with 'word')",
"  - or from the specified ROM, data is displayed in hex as well",
"  - as ASCII characters.",
"  ",
"  ",0},
/*  D # - change display level */
"display",
{"change the output level of LoadICE:",
" syntax:   D ff - the hex value sets the mask for display levels within",
"  - LoadICE application.  The eight bits represent eight levels",
"  - very-high, high, medium-high, medium,",
"  - medium-low, low, low-low, very-low",
"  Default levels are very-high and high.",
"  Try different levels and see how much detail can be seen",0},
/*  e [[id:]address][data] */
"edit",
{"edit ROM contents:",
" syntax:  e [id:][address] [data, data, ....]",
"  - if address and data list is given, edit and done else interactive",
"  - the addressed location will be changed to given data",
"  - in multibyte configuration the entire word is changed",
"  - if no data is given the location is opened and displayed",
"  - type new data, x or . for exit, <cr> for next loc, ^ to backup pointer",0},
/*  exit - exit the application */
"exit",
{"exit the loadice application",
" syntax: x",
"  - leave the 'dialog' mode and exit LoadICE",
"  - if in 'edit' mode then simply exit edit mode",
"  - effectively exit the current level, (this may be",
"  - applicable when LoadICE is performing some interactive",
"  - function with the ROM or within the host).",0},
/*  f [id:]start end data */
"fill",
{"fill one or more ROM locations with pattern",
" syntax:  f [id:][start][end][data]",
"  - if no arguments are given then all ROMs are filled",
"  - with their previously specified 'fill-character'",
"  - if one arg given then it is 'data', if two args given then",
"  - they are 'start' address and 'data', else all three are given",
"  - if an ID is given operation is done to ROM else to config",0},
/*  file name offset=[id:]addr word/byte order */
"file",
{"specifies a file for down loading",
" syntax:  h name [offset=[id:]address word byte order (start end)]",
"  - 'h' is for hex files",
"  - use 'i' for binary files and 'j' for formatted binaries",
"  - use 'offset' and 'address' to map file to the right place",
"  - don't specify ID if word info is given",
"  - specify partial load range in '(' ')'",0,},
/*  go - into emulation */
"go",
{"put units into emulation mode",
" syntax:  go",
"  - put units into emulation mode",
"  - undoes 'stop'",
"  - allows the target to execute (releases reset)",
"  - after editing loading dumping etc.",
"  - you may use the ESC key for toggling this mode",0,},
/*  l [[id:]start end] */
"load",
{"load file data to the PROMICE chain",
" syntax:  l [fileInfo]",
"  - load all files specified",
"   - if [fileInfo] then load the",
"   - specified hex file only",
"   - same as '.h' followed by 'l'",
"   - use 'li' if binary file in [fileInfo]",0},
/* map [0|1] - data range display */
"map",
{"display data range being down-loaded",
" syntax:  map 0|1",
"  - display the range of data being down-loaded",
"  - the default is to display the data",
"  - turn it off by using 'map 0'",
" ",
" ",0},
/*  m [id:]start end dest */
"move",
{"move ROM data around",
" syntax:  m [id:]start, end, destination",
"  - if ID is given then move that ROMs data",
"  - else move data in the current config",
"  - data is actually up-loaded and then down-loaded",
"  - in order to move it",
"  - overlapping end and dest produce interesting results",0},
/*  r time */
"reset",
{"reset the target system",
" syntax:  r time",
"  - time is in milliseconds",
"  - max time is 2400 milliseconds",
"  - reset signal must be hooked from PROMICE unit ID-0 to the target",
"  - reset signal polarity can be selected by switch#1 on back of PROMICE",
"  ",0},
/*  restart */
"restart",
{"restart the link to the PROMICE",
" syntax:  restart",
"  - resetablish the link with PROMICE",
"  ",
"  ",
"  ",
"  ",0},
/*  s name [id:][start, end] */
"save",
{"save ROM contents to disk file",
" syntax:  s name [id:][start, end]",
"  - save data to file 'name'd",
"  - if ID is given only save that ROM",
"  - else data is saved per config",
"  - 'start' and 'end' allow partial save",
"  ",0},
/*  stop - stop emulation */
"stop",
{"stop emulation",
" syntax:  stop",
"  - put unit(s) in load mode",
"  - target is stopped (reset asserted)",
"  - allows editing loading dumping",
"  - of the PROMICE contents",
"  - you may use the ESC key to toggle this mode",0},
/*  t [id:] count */
"test",
{"test the memory in the PROMICE unit",
" syntax:  t [id:][count]",
"  - test given unit 'count' times",
"  - if ID is given test only that unit",
"  - if no 'count' given then test once",
"  - if no args, test all units once",
"  - test will store 'ff,fe,fd...' in all of ROM",0},
/*  v [id] */
"version",
{"report PROMICE micro code version #",
" syntax:  v [id:]",
"  - if no ID then report version# of all units",
"  - most common version# are 2.1g,3.1a,5.0b,6.0a",
"  - higher versions support some LoadICE features",
"  - in micro-code, however, loadice can do all those",
"  - functions otherwise",0},
/*  w size[/order] */
"word",
{"change the ROM configuration",
" syntax:  w size[byte order]",
"  - change the current word size",
"  - by specifying the IDs making up the word",
"  - operations can be performed on any config",
"  - configuration remain active until changed",
"  - ID specification in other commands use temp 8 bit config",0},
/*  x */
"checksum",
{"compute checksum / or ignore checksum errors in user file",
" syntax:  k [id:][start,end,store]/a|x size",
"  - compute checksum on the ROM given using either",
"  - 'add all bytes' or 'xor all bytes' method",
"  - checksum is stored at the given address",
"  - size is the length of result in bytes to store",
"  - default is to store one byte",0},
/*  z # */
"ignore",
{"ignore address-out-of-range errors in user data files",
" syntax:  z #",
"  - if # = 0 don't print records with errors",
"  - if # = 1 print records with error",
"  - ",
"  ",
"  ",0},
/*  !string */
"scmd",
{"escape a command to the host shell",
" syntax:  !string",
"  - if your system supports this feature",
"  - then the 'string' is passed to the host",
"  - operating system via the 'system()' syscall",
"  ",
"  ",0},
/*  find or search */
"find",
{"find data or string in memory",
" syntax:  find|F start end length data OR search|S start end string",
"  find finds binary data bytes and search searches strings",
"  use find of F and search of S",
"  both command keep looking for more matches",
"  use <CR> to terminate operation",
"  ",0},
/*  ROM change emulation size */
"ROM",
{"change emulation size",
" syntax:  R [id:]size",
"  - change emulation size of one or more ROMs",
"  ",
"  ",
"  ",
"  ",0},
/*  serial# */
"serial",
{"report units serial # (not always implemented)",
" syntax:  S [id:]",
"  - reports the serial# in the micro code",
"  - not always implemented",
"  - might display garbage or version (in binary)",
"  ",
"  ",0},
/*  ROMview */
"rv",
{"enter ROMview interface (not always implemented)",
" syntax:  rv [cpu]",
"  - specify the target cpu type",
"  - requires that target be running",
"  - the RemoteView ROM monitor",
"  - also requires AI or PI interface",
"  ",0},
0};

#else
extern char *piclhlp[];
extern PIHELP pxhelp[];
#endif
