/*	LoadICE.c - Edit 4

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - LoadICE application: A ROM management utility for the PromICE
	
*/

/* Worked on substantially to run on a modern Linux system 9-15-2012
 *
 * First fix some header file issues, add -DLINUX to the Makefile
 * errno is now set up by magic in a header file, no longer an extern int
 * Getting segfaults in psbreak(), took a long time discovering it was
 *  trying to modify a string constant.
 *  Rearranged code in pisyn.c to get around this.
 * Change default serial port and baud rate in pishell.c
 *  (incidentally, these were the constant strings causing the prior problem.)
 * I couldn't stand it any longer, so I changed all printfs to put the \n
 *  at the end of messages rather than the start.
 *  No doubt this has screwed up some of the message formatting.
 *
 * Then I actually connected up the unit, and to my amazement it connects:
 *	Opening serial device '/dev/ttyS0' at 19200 Baud
 *	Link is up
 *	 PROMICE units:
 *	   ID 0 uCVer:5.0b MemSize=131072 EmuSize=4096 FillChar=FF
 * But I then get a segfault in pishell/utime(), another constant string
 *   being modified, easy to fix, and now it is connecting and giving me
 *   a prompt.
 *
 * Now it is connecting and apparently working, but after it has connected
 *   once, it will sometimes fail to connect again without power cycling
 *   the unit.
 * It is using the ancient termio interface, and it might be better 
 *   to recode piunix.c using the new and proper termios interface.
 *   When I get ready to tackle this, an example is:
 *   	trona:Orient/orient.c
 *
 * Looking at my old makefiles for 8751 projects, I usually put a line in
 *   my makefile so I can do "make load" which runs "loadice project.hex"
 *   The file loadice.ini should also be in the current directory, and
 *   that is where all the details go.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#ifdef MSDOS
#include <process.h>
#endif

#include "piconfig.h"
#include "pistruct.h"

/* loadice version string */
/* char *liver="LoadICE Version 2.4a"; */
char *liver="LoadICE Version 2.4-tjt";

#ifdef notdef
void ttexit ( void )
{
	printf ( "Bailing out -- tjt\n" );
	exit ( 1 );
}
#endif

#ifdef ANSI
extern void piinit(void);
extern void pishell(void);
extern void pi_beep(void);
extern void pcexit(void);
void licatch(int sig);

void main(int argc,char **argv)

#else
extern void piinit();
extern void pishell();
extern void pi_beep();
extern void pcexit();
void licatch();

void main(argc,argv)
int argc;
char **argv;
#endif

{
	char *tp;
	
	piinit(); /* init globals */

	setbuf(stdout, NULL);

	if (pxdisp&PXVH)
	    printf("%s\nCopyright (C) 1990-1994 Grammar Engine, Inc.\n",liver);

	/* reconstruct command line in 'pxcline' */
	/* this is all but the first word (excludes "./loadice") */
	if (argc > 1) {
		tp = pxcline;
		while (--argc) {
			strcpy(tp, *++argv);
			tp += strlen(tp);
			*tp++ = ' ';
		}
		*--tp = '\0';
	}

	signal(SIGINT,licatch);

	pishell();	/* call shell for all else */

	if (pxdisp&PXVH)
		printf("Exiting LoadICE\n");

	exit(pxexitv);	/* return some exit value */
}

/* `licatch` - signal catcher to terminate the application */

#ifdef ANSI
void licatch(int sig)
#else
void licatch()
#endif
	{
	piflags &= ~PiUP;
	pcexit();

	printf("Terminating LoadICE\n");

	exit(pxexitv);
	}
