/*
   SBus Centronic Parallel Controller Driver
   Version 1.0  
   Copyright (C) 1993-94  Grammar Engine, Inc.
 */
#ident "%Z%%M% %I% %E% Grammar Engine, Inc."

#include "ppreg.h"			/* register definitions */

#include <sun/vddrv.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/syslog.h>
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/errno.h>
#include <sys/file.h>
#include <sys/conf.h>
#include <sundev/mbvar.h>
#include <machine/psl.h>
#include <sun/openprom.h>

#define LOADABLE 1	/* for use with 'modload' command */
#define	PIDLY	1	/* micro seconds between pp I/O */
/*
 * Buffers for use by physio().
 */
struct buf ppbuf[3];
#define	PPBUFSIZ	260	
#define MAXPPS		3
/*
 * software state structure, one for each printer
 */
struct pp_unit {
	int		pp_flags;	/* printer state: */
#define	PP_OPEN		0x01		/* currently open */
#define	PP_TOUT		0x02		/* timeout on some operation */
#define	PP_TURBO	0x04		/* TURBO mode down-load */
#define	PP_TIMER	0x08		/* watchdog timer is running */
#define	PP_BUSY		0x10		/*	i/o in progress */
	char		pp_timer;	/* for detecting timeout situations*/
	struct dev_info *devinfo_p;	/* pointer to dev_info */
	struct buf 	*pp_bp;		/* pointer to current 'buf' */
	char		pp_buf[PPBUFSIZ]; /* buffer */
	char		*pp_cp;	/* current byte in current buffer */
	int		pp_count;	/* number of bytes left to print */
	struct pp_reg	*pp_regbase;	/* device register base in Sbus space */
};

#define	PPREG_DATA	(pp->pp_regbase->pp_data)
#define	PPREG_DATA_IN	(pp->pp_regbase->pp_data_in)
#define	PPREG_CTRL	(pp->pp_regbase->pp_cntrl)
#define	PPREG_STAT	(pp->pp_regbase->pp_stat)

#define	BUSY	0x80
#define	STRON	0x05
#define	STROFF	0x04
#define	B_ACK	0x0C

#define	PAPER	0x20
#define	AUTOON	0x06
#define	AUTOOFF	0x04

#define	PPUNIT(dev)	(minor(dev) & 0xf)
#define	PPDIAG(dev)	(minor(dev) & 0x10)

extern  int hz;
#define	PPTICKS		7

int ppidentify(), ppattach(), ppintr(), pptimeout(), pppoll();
int ppopen(), ppclose(), ppread(), ppwrite(), ppioctl();
void show_devinfo(),ppdismiss();

struct dev_ops pp_ops = {
	1,
	ppidentify,
	ppattach,
	};

#if	defined(LOADABLE)
extern int nulldev();
extern int seltrue();
struct cdevsw pp_cdevsw = {
ppopen, ppclose, ppread, ppwrite, ppioctl, nulldev, seltrue, 0, 0
 };

struct vdldrv pp_drv = {
	VDMAGIC_DRV,			/* Drv_magic	*/
	"PROMICE pp",			/* Drv_name	*/
	&pp_ops,			/* Drv_dev_ops */
	NULL,				/* Drv_bdevsw	*/
	&pp_cdevsw,			/* Drv_cdevsw	*/
	0,				/* Drv_blockmajor */
	0				/* Drv_charmajor */
	};

#endif 

static u_char npps=0;

static struct pp_unit *pp_unit_array 	= NULL;
static u_char logpri = 0;

ppidentify(name)
	char *name;
	{
	if(strcmp(name,"ELTK,pp") == 0)
		{
		if(npps < MAXPPS)
			{
			npps++;
			 return(1);    /* match one again */
			}
		else      
		uprintf("pp_identify: too many pps (%d).\n",npps);
		}
	return(0); 				/* no match or over limit */
	}

ppattach(devinfo_p)
	register struct dev_info *devinfo_p;
	{	
	register struct pp_unit *pp;
	struct dev_reg *dev_reg_p;
	struct dev_intr *dev_intr_p;
	u_int 	i,unit_no;
	u_int 	interrupt_pri=0;
	static int unit_count = 0;
	register int s;

	if(pp_unit_array == NULL)
		{
		pp_unit_array=(struct pp_unit *)
			kmem_zalloc(npps * sizeof (struct pp_unit));
		}	
	unit_no = unit_count++;
	devinfo_p->devi_unit = unit_no;
	pp_unit_array[unit_no].devinfo_p = devinfo_p;
	
	(void) show_devinfo(devinfo_p);

	pp=&pp_unit_array[unit_no];
	dev_reg_p = devinfo_p->devi_reg;
	pp_unit_array[unit_no].pp_regbase =  (struct pp_reg *)
	map_regs(dev_reg_p->reg_addr,sizeof(struct pp_reg),
					 dev_reg_p->reg_bustype);
	if(pp_unit_array[unit_no].pp_regbase == NULL)
		{
		uprintf("pp_attach: map_regs failed!\n");
		return(-1);
		}
	report_dev(devinfo_p);
	PPREG_CTRL = PC_OFF;
	return(0);
	}
	 
ppopen(dev, flags)
	dev_t dev;
	int flags;
	{
	register struct pp_unit *pp = &pp_unit_array[PPUNIT(dev)];
	u_char	unit_no;


	unit_no = PPUNIT(dev);
	if (unit_no >= npps)
		return(ENXIO);
	
	if (pp->pp_flags & PP_OPEN) 	/* enforce exclusive access */
		return(EBUSY);

	PPREG_CTRL = PC_OFF;		/* disable interrupts */
	DELAY(500); /* adjust */
	if ((pp->pp_flags & PP_TIMER)  ==  0) /*watchdog timer not running*/
		{
		/*
		 * Kick off watchdog timer.
		 */
		timeout(pptimeout, (caddr_t)pp, hz); 
		pp->pp_timer = 0;
		pp->pp_flags |= PP_TIMER;
		}

	pp->pp_flags |= PP_OPEN;
#ifdef	PPDBUG
	uprintf("\nPi_OPEN ");
#endif
	return(0);
	}

/*
 * ppclose:
 *	Close the printer device.
 */
ppclose(dev)
	dev_t dev;
	{
	register struct pp_unit *pp = &pp_unit_array[PPUNIT(dev)];

	untimeout(pptimeout, (caddr_t)pp);
	pp->pp_flags = 0;
#ifdef	PPDBUG
	uprintf("\nPi_CLOSE ");
#endif
	}

ppread(dev, uio)
	dev_t dev;
	struct uio *uio;
	{
	int ppstrategy();
	void ppminphys();

	return(physio(ppstrategy, &ppbuf[PPUNIT(dev)], dev, B_READ,
	    ppminphys, uio));
	}

ppwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
	{
	int ppstrategy();
	void ppminphys();

	return(physio(ppstrategy, &ppbuf[PPUNIT(dev)], dev, B_WRITE,
	    ppminphys, uio));
	}
/*
 * ppstrategy:
 */
ppstrategy(bp)
	register struct buf *bp;
	{
	register struct pp_unit *pp = &pp_unit_array[PPUNIT(bp->b_dev)];
	int s;
	int len,i;
	unsigned char c,uid;

	pp->pp_bp = bp;
	pp->pp_count = bp->b_bcount;
	pp->pp_cp = pp->pp_buf;

	if (bp->b_flags&B_READ)	/* read from PROMICE */
		{
#ifdef	PPDBUG
		uprintf("\nPi_READ ");
#endif
		pp->pp_flags |= PP_BUSY; 
		pp->pp_flags &= ~PP_TOUT;
		pp->pp_timer = PPTICKS;		/* set timer */
		if (pp->pp_flags&PP_TURBO)
			{
			while(!(PPREG_STAT&BUSY) && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK;
			DELAY(PIDLY);
			PPREG_CTRL = STROFF;
			DELAY(PIDLY);
			}
		for (i=0; i<4; i++)
			{
			while(PPREG_STAT&BUSY && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			c = (char)((PPREG_STAT>>3)&0x0f); DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			while(!(PPREG_STAT&BUSY) && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			while(PPREG_STAT&BUSY && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			c |= (char)((PPREG_STAT<<1)&0xf0); DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			while(!(PPREG_STAT&BUSY) && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			*pp->pp_cp = c;
			pp->pp_cp++;
#ifdef	PPDBUG
			uprintf("%2x< ",c);
#endif
			}
		if (pp->pp_flags&PP_TOUT)
			{
			bp->b_flags |= B_ERROR;
			bp->b_error = EFAULT;
			ppiodone(pp);
			return;
			}
		pp->pp_count = 4;
		len = (int)(*(pp->pp_buf+2));
		if (!len)
			len = 256;
		len += 3;
		for (i=4; i<len; i++)
			{
			while(PPREG_STAT&BUSY && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			c = (char)((PPREG_STAT>>3)&0x0f); DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			while(!(PPREG_STAT&BUSY) && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			while(PPREG_STAT&BUSY && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			c |= (char)((PPREG_STAT<<1)&0xf0); DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			while(!(PPREG_STAT&BUSY) && !(pp->pp_flags&PP_TOUT))
				DELAY(PIDLY);
			PPREG_CTRL = B_ACK; DELAY(PIDLY);
			PPREG_CTRL = STROFF; DELAY(PIDLY);
			*pp->pp_cp = c;
			pp->pp_cp++;
			pp->pp_count++;
#ifdef	PPDBUG
			uprintf("%2x< ",c);
#endif
			}
		bp->b_bcount = pp->pp_count;
		if(copyout(pp->pp_buf, bp->b_un.b_addr, (u_int) bp->b_bcount))
			{
			bp->b_flags |= B_ERROR;
			bp->b_error = EFAULT;
			ppiodone(pp);
			return;
			}
		}
	else	/* write to the PROMICE */
		{
		if (copyin(bp->b_un.b_addr, pp->pp_buf, (u_int) bp->b_bcount))
			{
			bp->b_flags |= B_ERROR;
			bp->b_error = EFAULT;
			ppiodone(pp);
			return;
			}

		pp->pp_flags |= PP_BUSY; 
		pp->pp_flags &= ~PP_TOUT;
		pp->pp_timer = PPTICKS;		/* set timer */
		uid = *pp->pp_buf;
#ifdef	PPDBUG
		uprintf("\nPi_WRITE(%d:%d) ",uid,pp->pp_count);
#endif
		while (pp->pp_count && !(pp->pp_flags&PP_TOUT))
			{
			if (uid<2)
				{
#ifdef	PPDBUG
				uprintf("%2x",*pp->pp_cp);
#endif
				while(!(PPREG_STAT&BUSY) && !(pp->pp_flags&PP_TOUT))
					DELAY(PIDLY);
				PPREG_DATA = *pp->pp_cp;
				DELAY(PIDLY);
				PPREG_CTRL = STRON;
				DELAY(PIDLY);
				PPREG_CTRL = STROFF;
				DELAY(PIDLY);
				if (!(pp->pp_flags&PP_TURBO))
					{
					while(!(PPREG_STAT&BUSY) &&
						 !(pp->pp_flags&PP_TOUT))
						DELAY(PIDLY);
					PPREG_CTRL = B_ACK;
					DELAY(PIDLY);
					PPREG_CTRL = STROFF;
					DELAY(PIDLY);
					}
#ifdef	PPDBUG
				uprintf("> ");
#endif
				}
			else
				{
#ifdef	PPDBUG
				uprintf("%2x",*pp->pp_cp);
#endif
				while((PPREG_STAT&PAPER) && !(pp->pp_flags&PP_TOUT))
					DELAY(PIDLY);
				PPREG_DATA = *pp->pp_cp;
				DELAY(PIDLY);
				PPREG_CTRL = AUTOON;
				DELAY(PIDLY);
				PPREG_CTRL = AUTOOFF;
				DELAY(PIDLY);
				if (!(pp->pp_flags&PP_TURBO))
					{
					while((PPREG_STAT&PAPER) &&
						 !(pp->pp_flags&PP_TOUT))
						DELAY(PIDLY);
					PPREG_CTRL = B_ACK;
					DELAY(PIDLY);
					PPREG_CTRL = AUTOOFF;
					DELAY(PIDLY);
					}
#ifdef	PPDBUG
				uprintf("* ");
#endif
				}
			pp->pp_cp++;
			pp->pp_count--;
			}
		}
	pp->pp_timer = 0;		/* turn off timer */
	if (pp->pp_flags&PP_TOUT) 
		{
		bp->b_flags |= B_ERROR;
		bp->b_error = EFAULT;
		ppiodone(pp);
		return;
		}
	ppiodone(pp);
	}

void
ppminphys(bp)
	register struct buf *bp;
	{
	if (bp->b_bcount > PPBUFSIZ)
		bp->b_bcount = PPBUFSIZ;
	}

/*
 * ppintr:
 *	PROMICE does not cause any interrupts 
 */
ppintr(unit_no)
u_int unit_no;
	{
	return(1);
	}

/*
 * pptimeout:
 *	Check occasionally for lost interrupts or
 *	printer errors (no paper, printer off line, etc.).
 */
pptimeout(arg)
	caddr_t arg;
	{
	register struct pp_unit *pp = (struct pp_unit *)arg;

	if ((pp->pp_flags & PP_OPEN)  ==  0) /* dev not open */
		{
		return;
		}
	else 
		if (pp->pp_timer <= 0) /* timer not currently active */
			{
			timeout(pptimeout, (caddr_t)pp, hz);
			return;
			}

	    if (--pp->pp_timer == 0)
		{
		/*
		 * Timer has expired - see what's wrong.
		 */
#ifdef	PPDBUG
		uprintf("\nPi_TOUT ");
#endif
		pp->pp_flags |= PP_TOUT;
		}
	timeout(pptimeout, (caddr_t)pp, hz);
	}


/*ARGSUSED*/
ppioctl(dev, cmd, data, flag)
	dev_t dev;
	int cmd;
	caddr_t data;
	int flag;
	{
	register struct pp_unit *pp = &pp_unit_array[PPUNIT(dev)];
	unsigned char *udata;

	udata = (unsigned char *) data;
	switch(cmd) 
		{
		case PPIOCGETS:
			*udata = PPREG_STAT;
			break;
		case PPIOCGETC:
			*udata = PPREG_CTRL;
			break;
		case PPIOCSETC:
			PPREG_CTRL = *udata;
			break;
		case PPIOCGETD:
			*udata = PPREG_DATA_IN;
			break;
		case PPIOCSETD:
			PPREG_DATA= *udata;
			break;
		case PPIOCSETF:
			pp->pp_flags |= PP_TURBO;
			break;
		default:
			return(ENOTTY);
		}
	return(0);
	}


/*
 * ppiodone:
 *	Private version of 'biodone()'.
 */
ppiodone(pp)
	register struct pp_unit *pp;
	{
	register struct buf *bp = pp->pp_bp;
  
	bp->b_flags |= B_DONE;
	pp->pp_flags &= ~PP_BUSY;  
#ifdef	PPDBUG
	uprintf("\nPi_IODONE");
#endif
	}


/*
 * Handle a polling Parallel Printer interrupt.
 */
pppoll()
{
	return(1);
}

static void
show_devinfo(devinfo_p)
	register struct dev_info	*devinfo_p;
{
	struct dev_reg 	*dev_reg_p;
	struct dev_intr	*dev_intr_p;
	u_int	counter;

	dev_reg_p = devinfo_p->devi_reg;
	for(counter=1; counter <= devinfo_p->devi_nreg; ++counter,++dev_reg_p){
		if(dev_reg_p == NULL) break;
	}
      dev_intr_p = devinfo_p -> devi_intr;
      for(counter=1; counter <= devinfo_p->devi_nintr; ++counter,++dev_intr_p){
		if(dev_intr_p == NULL) break;
	}
	return;
}

#if 	defined(LOADABLE)

int ppvdcmd(command, vdp, vdi, vds)
	int			command;
	struct	vddrv		*vdp;
	struct	vdioctl_load	*vdi;
	struct	vdstat		*vds;
{
	struct	vdconf		*vdconf_p;
	char			*string_p;
	u_int			pp_unit_no;
	int			status = 0;
	switch(command){
		case VDLOAD:
			if(vdi != NULL){
				if(vdi->vdi_userconf != NULL) {
				  vdconf_p = vdi->vdi_userconf;
				  if(vdconf_p->vdc_type != VDCEND) {
					uprintf("........OK.\n");
					}
				  while(vdconf_p->vdc_type != VDCEND){
					switch(vdconf_p->vdc_type){
					case VDCCONTROLLER:
						string_p="(VDCCONTROLLER)";
						break;
                                        case VDCDEVICE: 
                                                string_p="(VDCDEVICE)"; 
                                                break; 
                                        case VDCBLOCKMAJOR: 
                                                string_p="(VDCBLOCKMAJOR)"; 
                                                break; 
                                        case VDCCHARMAJOR: 
                                                string_p="(VDCCHARMAJOR)"; 
                                                break; 
                                        case VDCSYSCALLNUM: 
                                                string_p="(VDCSYSCALLNUM)"; 
                                                break; 
                                        default:
                                                string_p="(SWITCH ERROR!)"; 
                                                break; 
					}
					vdconf_p++;	
				   }   /* while */
				} 
			}
			vdp->vdd_vdtab = (struct vdlinkage *)&pp_drv;
			break;
		case VDUNLOAD:
			for(pp_unit_no =0;pp_unit_no < npps;pp_unit_no++){
				if(pp_unit_array[pp_unit_no].pp_flags != 0)
					status = EBUSY;
			}
			if(status == 0) {
				(void) ppdismiss();
				}
			break;
		case VDSTAT:
			break;	
		default:
			status=EINVAL;
			break;
		}
		return(status);
}
static void
ppdismiss()
{
}

#endif
		
