/*	PiVMS.c - Edit 3

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	S Y S T E M  S P E C I F I C   D E V I C E  I/O  R O U T I N E S
	For VAX/VMS systems
*/

#ifdef VMS
#include <stdio.h>
#include <iodef.h>
#include <ssdef.h>
#include <ttdef.h>
#include <tt2def.h>
#include <file.h>
#include <stat.h>

#include "piconfig.h"
#include "pistruct.h"
#include "pierror.h"
#include "pidriver.h"
#include "pidata.h"
#include "pidev.h"

#ifdef ANSI
long pi_raw(void);
long pi_toggle(void);
void pi_cook(void);
long pi_switch(void);
void pi_sleep(short time);
void pi_put(char data);
void pi_putp(char data);
void pi_puts(char *str);
long pi_get(char *data);
long pi_getp(char *data);
void pi_putp(char data);
void pi_putp2(char data);
void pi_ccw(void);
void pi_cccw(void);
#else
long pi_raw();
long pi_toggle();
void pi_cook();
long pi_switch();
void pi_sleep();
void pi_put();
long pi_get();
void pi_ccw();
void pi_cccw();
#endif

struct	vax_string
	{
	long	v_string_length;
	char	*v_string_pointer;
	} term_buf;

short	term_chan;
short	iosb[4];
short	iosb2[4];
long	term_sense[3];
long	rom_sense[3];
long	p1_block[2];
long	tmask[2];

char *pxaicstr = "MCON 000 000";

int picuct;

/* `pi_raw` - set serial port to raw mode or mess with the parallel port */

long pi_raw()
	{
	short baud;

	switch (pxlink.brate)
		{
		case 1200: 
			baud = TT$C_BAUD_1200;
			break;
		case 2400:
			baud = TT$C_BAUD_2400;
			break;
		case 4800:
			baud = TT$C_BAUD_4800;
			break;
		case 9600:
			baud = TT$C_BAUD_9600;
			break;
		case 19200:
			baud = TT$C_BAUD_19200;
			break;
		default:
			printf("Changing the baud rate to 19200\n");
			pxlink.brate=19200;
			baud = TT$C_BAUD_19200;
			break;
		}
	iosb2[1] = -1;
	tmask[0] = tmask[1] = 0;
	term_buf.v_string_pointer = pxlink.name;
	term_buf.v_string_length = (long)strlen(pxlink.name);

	printf("\nOpening serial device '%s' @BR-%ld",pxlink.name,pxlink.brate);

	if (!(sys$assign(&term_buf,&term_chan,0,0) & 1))
		return(PGE_OPN);

	if (!(sys$qiow(0,term_chan,IO$_SENSEMODE,iosb,0,0,term_sense,
		 12,0,0,0,0) & 1))
		return(PGE_IOE);

	rom_sense[0] = term_sense[0];
	rom_sense[1] = term_sense[1] | (TT$M_EIGHTBIT | TT$M_MECHFORM |
		TT$M_MECHTAB | TT$M_NOBRDCST | TT$M_NOECHO);
	rom_sense[2] = term_sense[2] | (TT2$M_PASTHRU);
	rom_sense[1] &= ~(TT$M_CRFILL | TT$M_ESCAPE | TT$M_HALFDUP |
		TT$M_HOSTSYNC | TT$M_LFFILL | TT$M_READSYNC | TT$M_TTSYNC |
		TT$M_WRAP);
	rom_sense[2] &= ~(TT2$M_LOCALECHO);
	if (!(sys$qiow(0,term_chan,IO$_SETMODE,iosb,0,0,rom_sense,
		 12,baud,0,0,0) & 1))
		return(PGE_IOE);
	p1_block[0] = ((long)TT$M_DS_DTR) << 16;
	sys$qiow(0,term_chan,IO$_SETMODE|IO$M_SET_MODEM|IO$M_MAINT,
		iosb,0,0,p1_block,8,0,0,0,0);
	sys$cancel(term_chan);
	pi_sleep(1);
	p1_block[0] = ((long)TT$M_DS_DTR) << 24;
	sys$qiow(0,term_chan,IO$_SETMODE|IO$M_SET_MODEM|IO$M_MAINT,
		iosb,0,0,p1_block,8,0,0,0,0);
	return(PGE_NOE);
	}

/* `pi_cook` - restore port to original state */

void pi_cook()
	{
	sys$cancel(term_chan);
	sys$qiow(0,term_chan,IO$_SETMODE,iosb,0,0,term_sense,12,0,0,0,0);
	sys$dassgn(term_chan);
	}

/* `pi_toggle` - toggle the PROMICE reset interrupt line */

long pi_toggle()
	{
	sys$qiow(0,term_chan,IO$_SETMODE|IO$M_SET_MODEM|IO$M_MAINT,
		iosb,0,0,p1_block,8,0,0,0,0);
	sys$cancel(term_chan);
	pi_sleep(1);
	p1_block[0] = ((long)TT$M_DS_DTR) << 24;
	sys$qiow(0,term_chan,IO$_SETMODE|IO$M_SET_MODEM|IO$M_MAINT,
		iosb,0,0,p1_block,8,0,0,0,0);
	return(PGE_NOE);
	return(PGE_NOE);
	}

/* `pi_xmt` - send a block of data over the i/o device */

#ifdef ANSI
long pi_xmt(char *buf, long ct)
#else
long pi_xmt(buf, ct)
char *buf;
long ct;
#endif
	{
	while (ct--)
		pi_put(*buf++);
	return(PGE_NOE);
	}

/* `pi_rcv` - receive a standard response from the PROMICE */

void pi_rcv()
	{
	long i,j=0,k,l;
	
	for (i=0; i<4; i++)
		while(pi_get(&pxrsp[i]))
			if (pxerror || (j++>PIC_DLY))
				{
				if (!pxerror)
					pi_tochk();
				if (pxerror)
					return;
				else
					j = 0;
				}
	if (pxrsp[PICT] == 0)
		pxrspl = PIC_MP;
	else
		pxrspl = (pxrsp[PICT]&0xff) + 3;
	for (i=4; i<pxrspl; i++)
		while(pi_get(&pxrsp[i]))
			if (pxerror || (j++>PIC_DLY))
				{
				if (!pxerror)
					pi_tochk();
				if (pxerror)
					return;
				else
					j = 0;
				}
	}

/* `pi_put` - send byte over serial port */

#ifdef ANSI
void pi_put(char data)
#else
void pi_put(data)
char data;
#endif
	{
	if (pxdisp&PXVL)
		printf(" %02x",data&0xff);
	sys$qiow(0,term_chan,IO$_WRITEVBLK | IO$M_NOFORMAT,
		iosb,0,0,&byte,1,0,0,0,0);
	if (pxdisp&PXVL)
		printf("+");
	}

/* `pi_get` - read possible byte from the serial or parallel port */

#ifdef ANSI
long pi_get(char *cp)
#else
long pi_get(cp)
char *cp;
#endif
	{
	static char cc;

	if (iosb2[1] == 1)
		{
		*cp = cc;
		iosb2[1] = 0;
		sys$qio(0,term_chan,IO$_READVBLK | IO$M_NOFILTR | IO$M_NOECHO,
		 iosb2,0,0,&cc,1,0,tmask,0,0);
		if (pxdisp&PXVL)
			printf("-%c",*cp&0xff);
		return(PGE_NOE);
		}
	if (iosb2[1] == -1)
		{
		iosb2[1] = 0;
		sys$qio(0,term_chan,IO$_READVBLK | IO$M_NOFILTR | IO$M_NOECHO,
		 iosb2,0,0,&cc,1,0,tmask,0,0);
		if (pxdisp&PXVL)
			printf("-%c",*cp&0xff);
		return(PGE_NOE);
		}
	return(PGE_EOF);
	}

/* `pi_sleep` - waste some time */

#ifdef ANSI
void pi_sleep(short time)
#else
void pi_sleep(time)
short time;
#endif
	{
	sleep(1);
	}

/* `pi_ccw` - make the cursor spin */

void pi_ccw()
	{
	switch (picuct++ % 4)
		{
		case 0:
			printf("|\b");
			break;
		case 1:
			printf("/\b");
			break;
		case 2:
			printf("-\b");
			break;
		case 3:
			printf("\\\b");
			break;
		}
	}

/* `pi_cccw` - and now the other way */

void pi_cccw()
	{
	switch (picuct++ % 4)
		{
		case 0:
			printf("|\b");
			break;
		case 1:
			printf("\\\b");
			break;
		case 2:
			printf("-\b");
			break;
		case 3:
			printf("/\b");
			break;
		}
	}

/* `pi_beep` - make a beep sound */

void pi_beep()
	{
	printf("\7");
	}

/* `pi_switch` - connect thru the switch */

long pi_switch()
	{
	pxerror = PGE_NYI;
	}
#endif
