/*	PiMac.c - Edit 3

	LoadICE Version 2.4
	Copyright (C) 1990-94 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	S Y S T E M  S P E C I F I C   D E V I C E  I/O  R O U T I N E S
	For Macintosh Computers
*/

#ifdef	MAC
#include <stdio.h>

#include "piconfig.h"
#include "pistruct.h"
#include "pierror.h"
#include "pidriver.h"
#include "pidata.h"
#include "pidev.h"

#include <CursorCtl.h>
#include <Serial.h>
#include <Files.h>
#include <Devices.h>
#include <Slots.h>
#include <errors.h>
#include <SysEqu.h>
#include <time.h>
#include <Power.h>

#ifdef MACAPPL
#include "flTuple.h"
#endif

long pi_raw();
void pi_cook();
void pi_sleep();
void pi_setime();
void pi_put();
long pi_get();
long pi_getp();
void pi_putp();
void pi_putp2();
void pi_ccw();
void pi_cccw();
long pi_chksts(unsigned char *addr, char data, char bit);
static void do_back(void);
static void do_back2(void);

static short portRefNum, vrfyRefNum;
extern short pptwo;
int picuct=0;
//short ppslow; 
static time_t pithen;
char *pxaicstr = "MCON 000 000";
unsigned char serial_port;

/*  L O C A L   R O U T I N E S  */

/* `pi_raw` - set serial port to raw mode */

long pi_raw()
	{
	SpBlockPtr mySpBlockPtr;
	SpBlock mySpBlock;
	SInfoRecord mySInfoRecord;
	SInfoRecPtr mySInfoRecPtr;
	int result,baud,Index;
	unsigned char *control;
	OSErr err;
	short *stuff,portNum=0;
	char *addrMode=false32b;
	
	if (pxlink.flags&(PLPP|PLPQ))
		{
		if (!(pxlink.flags&PLPU))
			{
			printf("\nMust specify SLOT#: example LPT1:E\n");
			return(PGE_BAA);
			}
		else
			printf("\n Using SLOT %x for parallel adapter\n",pxlink.paddr);
		for (Index = pxlink.paddr; Index <= 14; ++Index)
			{
			/* init parameters for SReadInfo */
			mySInfoRecPtr = &mySInfoRecord; /* provide space for results */
			mySpBlockPtr = &mySpBlock;
			mySpBlockPtr->spResult = (long) mySInfoRecPtr;
			mySpBlockPtr->spSlot = Index; /* which slot to look at */
			err = SReadInfo (mySpBlockPtr);
			stuff = ((short *)TimeDBRA);
//			ppslow = 1000;
	
			if (err)
				return(PGE_IOE);
			
			if (mySInfoRecPtr->siInitStatusA == smEmptySlot)
				continue;

			/* init parameters for sNextTypesRsrc */
			/* Look in slot (Index) and printf the name of the card */
			mySpBlockPtr = &mySpBlock;
			mySpBlockPtr->spSlot = Index;
			mySpBlockPtr->spID = 0;
			mySpBlockPtr->spExtDev = 0;
			mySpBlockPtr->spCategory = 1;
			mySpBlockPtr->spCType = 0;
			mySpBlockPtr->spDrvrSW = 0;
			mySpBlockPtr->spDrvrHW = 0;
			
			err = SNextTypeSRsrc (mySpBlockPtr);
			if (err)
				return(PGE_IOE);

			/* init parameters for SGetCString */
			mySpBlockPtr->spID = 32; /* sRsrc_id */

			/* write out information */
			err = SReadWord (mySpBlockPtr);
			if (err)
				return(PGE_IOE);

			if((mySpBlockPtr->spResult & 0x0000ffff) == unigatePP)
				{
				++portNum;
				pxlink.ppdat = (unsigned char *)((long)Index * (long)0x100000);
				pxlink.ppin = (unsigned char *)((long)Index * (long)0x100000 + (long)4);
				pxlink.ppout = (unsigned char *)((long)Index * (long)0x100000 + (long)0xc);
				control = (unsigned char *)((long)Index * (long)0x100000 + (long)0xc);
				*addrMode = GetMMUMode();
				if(*addrMode == true32b)
					{
					pxlink.ppdat = (unsigned char *)((long)Index * (long)0x1000000);
					pxlink.ppin = (unsigned char *)((long)Index * (long)0x1000000 + (long)4);
					pxlink.ppout = (unsigned char *)((long)Index * (long)0x1000000 + (long)0xc);
					control = (unsigned char *)((long)Index * (long)0x1000000 + (long)0xc);
					pxlink.ppdat = (pxlink.ppdat + 0xF0000000);
					pxlink.ppin = (pxlink.ppin + 0xF0000000);
					pxlink.ppout = (pxlink.ppout + 0xF0000000);
					control = (control + 0xF0000000);
					}
				if (pxdisp&PXHI)
					{
					printf ("\nUsing parallel port @ %X ",pxlink.ppdat);
					*control = 0x82;
					}
				*control = 0x0a;
				*control = 0x0f;
				*control = 0x01;
					}
			else
				{
				printf("\nCan't find parallel port");
				exit(1);
				}
			}
		}
	if (pxlink.flags&PLPQ)
		{
		*pxlink.ppout = PP_INITS;
		pi_sleep(1);
		*pxlink.ppout = PP_INITC;
		pi_sleep(1);
		return(PGE_NOE);
		}
	if (pxlink.flags&PLPQ)
		return(PGE_NOE);
		
	if (pxdisp&PXHI)
		printf("\nOpening serial device `%s` @BR-%d",pxlink.name,pxlink.brate);
	if (!strcmp(pxlink.name, "modem"))
		serial_port = sPortA;
	else
		if (!strcmp(pxlink.name, "printer"))
			serial_port = sPortB;
		else
			{
			pi_estr1 = pxlink.name;
			return(PGE_BPN);
			}
	
	switch (pxlink.brate)
		{
		case 1200: 
			baud = baud1200 | stop20 | noParity | data8;
			break;
		case 2400:
			baud = baud2400 | stop20 | noParity | data8;
			break;
		case 4800:
			baud = baud4800 | stop20 | noParity | data8;
			break;
		case 9600:
			baud = baud9600 | stop20 | noParity | data8;
			break;
		case 19200:
			baud = baud19200 | stop20 | noParity | data8;
			break;
		case 57600:
			baud = baud57600 | stop20 | noParity | data8;
			break;
		default:
			baud = baud57600 | stop20 | noParity | data8;
			pxlink.brate = 57600;
			if (pxdisp&PXHI)
				printf("\nBaudRate changed to 57600");
			break;
		}

	if (serial_port == sPortA)
		{
		result = OpenDriver("\p.AOut", &portRefNum);
//		AOn();
		}
	else
		{
		result = OpenDriver("\p.BOut", &portRefNum);
//		BOn();
		}
	if (result)
		{
		pi_estr1 = pxlink.name;
		return(PGE_OPN);
		}	

	if (serial_port == sPortA)
		result = OpenDriver("\p.AIn", &vrfyRefNum);
	else
		result = OpenDriver("\p.BIn", &vrfyRefNum);
		
	if (result)
		{
		pi_estr1 = pxlink.name;
		return(PGE_OPN);
		}	
		
	if (SerReset(portRefNum,baud))
		return(PGE_IOE);
	if ((vrfyRefNum) && (SerReset(vrfyRefNum,baud)))
		return(PGE_IOE);

	SerSetBuf(vrfyRefNum,(char *)0,0); /* dump data in buffer */
	Control(portRefNum,17,0); /* toggle HSO(DTR) to reset PROMICE */
	pi_sleep(1);
	Control(portRefNum,18,0);
	pi_sleep(1);
	return(PGE_NOE);
	}

/* `pi_toggle` - toggle reset signal to PROMICE */

void pi_toggle()
	{
	if (pxlink.flags&PLPQ)
		{
		*pxlink.ppout = PP_INITS;
		pi_sleep(1);
		*pxlink.ppout = PP_INITC;
		}
	else
		{
		Control(portRefNum,17,0); /* toggle HSO(DTR) to reset PROMICE */
		pi_sleep(1);
		Control(portRefNum,18,0);
		}
	}

/* `pi_cook` - restore the serial port */

void pi_cook()
	{
	if (!(pxlink.flags&PLPQ))
		{
		if (pxdisp&PXLO)
			printf("\nClosing serial device `%s`",pxlink.name);
//		if (serial_port == sPortA)
//			AOff();
//		else
//			BOff();
		if (portRefNum)
			CloseDriver(portRefNum);
		if (vrfyRefNum)
			CloseDriver(vrfyRefNum);
		}
	}

/* `pi_xmt` - send a block of data over the i/o device */

#ifdef ANSI
int pi_xmt(char *buf, long ct)
#else
int pi_xmt(buf, ct)
char *buf;
long ct;
#endif
	{
	pi_setime(PIC_TOT);
	if (pxlink.flags&(PLPP|PLPQ))
		{
		if (*(buf+PIID) < 2)
			pptwo = 0;
		else
			pptwo = 1;
		while (ct-- && !pxtout)
			pi_putp(*buf++);
		}
	else
		{
		return(FSWrite(portRefNum,&ct,buf));
		}
	if (pxtout)
		return(PGE_TMO);
	else
		return(PGE_NOE);
	}

/* `pi_rcv` - receive a standard response from the PROMICE */

long pi_rcv()
	{
	long i,count = 0,rcount,j=0,k,l;
	char *trp;

	pi_setime(PIC_TOT);
	if (piflags&PiFP)
		{
		if (pptwo)
			do_back2();
		else
			do_back();
		}
	if (pxlink.flags&PLPQ)
		{
		for (i=0; i<4 && !pxtout; i++)
			while(pi_getp(&pxrsp[i]) && !pxtout);
		if (!pxtout)
			{
			if (pxrsp[PICT] == 0)
				pxrspl = PIC_MP;
			else
				pxrspl = (pxrsp[PICT]&0xff) + 3;
			for (i=4; i<pxrspl; i++)
				while(pi_getp(&pxrsp[i]) && !pxtout);
			}
		}
	else
		{
		while (count < 4)
			{
			SerGetBuf(vrfyRefNum,&count);
			if (!pxerror)
				pi_chktime();
			if (pxtout)
				return(PGE_TMO);
			}
		trp = pxrsp;			
		FSRead(vrfyRefNum,&count,trp);
		if (pxrsp[PICT] == 0)
			pxrspl = PIC_MP;
		else
			pxrspl = (pxrsp[PICT]&0xff) + 3;
		trp += 4;
		k=pxrspl-4;
		count=0;
		while (k)
			{
			while (!count)
				SerGetBuf(vrfyRefNum,&count);
			FSRead(vrfyRefNum,&count,trp);
			k-=count;
			trp+=count;
			if (!pxerror)
				pi_chktime();
			if (pxtout)
				return(PGE_TMO);
			}
		}
	return(PGE_NOE);
	}

/* `pi_put` - send byte over serial port */

void pi_put(char data)
	{
	long count=1;
	
	if (pxlink.flags&PLPQ)
		{
		pi_putp(data);
		}
	else
		{
		if (pxdisp&PXVL)
			printf(" %02x",data&0xff);
		FSWrite(portRefNum,&count,&data);
		if (pxdisp&PXVL)
			printf("+");
		}
	}

static	void pi_putp(char data)
	{
	short c;
	if (pptwo)
		{
		pi_putp2(data);
		return;
		}
	if (pxdisp&PXVL)
		printf(" %02x",data&0xff);
	if (pi_chksts(pxlink.ppin,PP_BUSY,0))
		{
		*pxlink.ppdat = data;
		*pxlink.ppout = PP_STRON;
//		for (c=0;c < ppslow;c++);
		*pxlink.ppout = PP_STROFF;
		if (!(piflags&PiFP))
			do_back();
		}
	if (!pxtout && pxdisp&PXVL)
		printf(">");
	}

void do_back()
	{
	int i;
	
	if (pi_chksts(pxlink.ppin,PP_BUSY,0))
		{
 		*pxlink.ppout = PP_BACK;
//		for (i=0;i < ppslow;i++);
		*pxlink.ppout = PP_BACKOFF;
		}
	}


 /* use Autofeed as strobe and Out of paper as busy */

static	void pi_putp2(char data)
	{
	short c;
	if (pxdisp&PXVL)
		printf(" %02x",data&0xff);
	if (pi_chksts(pxlink.ppin,PP_PAPER,0))
		{
		*pxlink.ppdat = data;
		*pxlink.ppout = PP_AUTOON;
//		for (c=0;c < ppslow;c++);
		*pxlink.ppout = PP_AUTOOFF;
		if (!(piflags&PiFP))
			do_back2();
		}
	if (!pxtout && pxdisp&PXVL)
		printf("*");
	}

static void do_back2(void)
	{
	int i;
	
	if (pi_chksts(pxlink.ppin,PP_PAPER,0))
		{
		*pxlink.ppout = PP_BACK;
//		for (i=0;i < ppslow;i++);
		*pxlink.ppout = PP_BACKOFF;
		}
	}

/* `pi_getp` - read possible byte from the parallel port */

long pi_getp(char *cp)
	{
	short i;
	unsigned char c;
	static long delay=0;

	if (pxlink.flags&PLPQ)
		{
		if ((*pxlink.ppin & PP_BUSY))
			{
			if (pxdisp&PXVL)
				printf("<");
			delay = 0;
			*pxlink.ppout = PP_BACK;
			c = PIPT1[*pxlink.ppin&0x1f];
			*pxlink.ppout = PP_BACKOFF;
			if (pi_chksts(pxlink.ppin,PP_BUSY,0))
				{
				*pxlink.ppout = PP_BACK;
//				for (i=0;i < ppslow;i++);
				*pxlink.ppout = PP_BACKOFF;
				if (pi_chksts(pxlink.ppin,PP_BUSY,1))
					{
					*pxlink.ppout = PP_BACK;
					*cp = (PIPT1[*pxlink.ppin&0x1f]<<4)|c;
					*pxlink.ppout = PP_BACKOFF;
					if (pi_chksts(pxlink.ppin,PP_BUSY,0))
						{
						*pxlink.ppout = PP_BACK;
//						for (i=0;i < ppslow;i++);
						*pxlink.ppout = PP_BACKOFF;
						if (pxdisp&PXVL)
							printf("%02X ",*cp&0xff);
						return(PGE_NOE);
						}
					}
				}
			return(PGE_TMO);
			}
		if (delay++ > PIC_DLY)
			pi_chktime();
		return(PGE_EOF);
		}
	else
		return(PGE_IOE);
	}

/* `pi_get` - read possible byte from the serial or parallel port */

long pi_get(char *cp)
	{
	long count;
		
	if (pxlink.flags&PLPQ)
		{
		return(pi_getp(cp));
		}

	SerGetBuf(vrfyRefNum,&count);
	if (count)
		{
		count = 1;
		if (pxdisp&PXVL)
			printf("-");
		if(FSRead(vrfyRefNum,&count,cp))
			return(PGE_IOE);
		else
			{
			if (pxdisp&PXVL)
				printf("%02X ",*cp&0xff);
			return(PGE_NOE);
			}
		}
	else
		return(PGE_EOF);
	}
/* `pi_chksts` - check i/o status and timeout */

long pi_chksts(unsigned char *port,char data,char bit)
	{
	long to;
	char pdata;

	if (pxtout)
		return(0);
	if (bit)
		{
		do
			{
			to = 0;
			while ((!(pdata=(char)((*port) & PP_BUSY))) && (to++<PIC_DLY));
			if (pdata)
				return(1);
			pi_chktime();
			} while (!pxtout);
		return(0);
		}
	else
		{
		do
			{
			to = 0;
			while ((pdata=(char)((*port)&data)) && (to++<PIC_DLY));
			if (!pdata)
				return(1);
			pi_chktime();
			} while (!pxtout);
		return(0);
		}
	}
	
/* `pi_sleep` - waste some time */

#define MacTicker	(*(long*)0x16A)
void pi_sleep(int secs)
	{
	register long beginticks,endticks;

	beginticks = MacTicker;
	endticks = beginticks + secs * 10;
	while (MacTicker < endticks)
		;
	}

/* `pi_setime` - set timeout time */

void pi_setime(time_t ttime)
	{
	time_t t;

	pxtout = 0;
	t = time(NULL);
	pithen = t+ttime;
	}

/* `pi_chktime`  - check if timeout happened */	


long pi_chktime()
	{
	time_t t;
	
	if (pxnotot || piflags&PiNT)
		return(1);


	t = time(NULL);
	if (pithen > t)
		return(1);
	pxtout = 1;
	return(0);
	}

/* `beep` - make a beep */

void pi_beep()
	{
	SysBeep(5);
	}

/* `pi_ccw` - make the cursor spin */

void pi_ccw()
	{
	Show_Cursor(HIDDEN_CURSOR);
	SpinCursor(-8*picuct++);
	}

/* `pi_cccw` - and now the other way */

void pi_cccw()
	{
	static short icurse=0;
	
	if (!icurse)
		{
		InitCursorCtl(NULL);
		icurse = 1;
		}
	Show_Cursor(HIDDEN_CURSOR);
	SpinCursor(8*picuct++);
	}

/* `pi_switch` - for talking to PROMICEs connected to the AISwitch */

void pi_switch()
	{
	}
#endif
