/* --------------------------------------------------------------------------
  FILE        : load_file.c                                                   
  PROJECT     : OMAP-L1x/C674x PRU Development
  DESC        : OMAP-L1x/C674x PRU Program Loader (using fileio)
 ----------------------------------------------------------------------------- */

/************************************************************
* Include Files                                             *
************************************************************/

// C standard I/O library
#include <stdlib.h>
#include <stdio.h>

#include "stdlib.h"

// General type include
#include "tistdtypes.h"

// Device Specific CSL / Functions
#include "device.h"

// This module's header file
#include "load_file.h"

#include "pru.h"


/************************************************************
* Explicit External Declarations                            *
************************************************************/

extern __FAR__ Uint32 PRU0_DATA_START, PRU0_DATA_SIZE;
extern __FAR__ Uint32 PRU0_INST_START, PRU0_INST_SIZE;
extern __FAR__ Uint32 PRU1_DATA_START, PRU1_DATA_SIZE;
extern __FAR__ Uint32 PRU1_INST_START, PRU1_INST_SIZE;


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
************************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/


/************************************************************
* Global Function Definitions                               *
************************************************************/

Int32 main (void)
{

  FILE	*fPtr;
  Uint8	*fileDataPtr = NULL;
  Uint8 pruNum = 0xFF;
  Int32	fileSize = 0;
  Int8  fileName[256];
 // DEVICE_pruCtrlRegs *hPru;

  printf("Starting PRU Program Loader.\r\n");

  // Get the desired PRU core
  while ((pruNum != 0) && (pruNum != 1))
  {
    printf("What PRU do you wish to execute in (0 or 1)?\r\n");
    scanf("%d",&pruNum);
    fflush(stdin);
  }
   
  // Read the file from host
  printf("Enter the binary PRU program filename:\r\n");
  scanf("%s",&fileName);
  fflush(stdin);
  
  // Open an File from the hard drive
	fPtr = fopen(fileName, "rb");
  if(fPtr == NULL)
  {
    printf("\tERROR: File %s open failed.\r\n",fileName);
	}

  // Read file size
  fseek(fPtr,0,SEEK_END);
  fileSize = ftell(fPtr);

  if(fileSize == 0)
  {
    printf("\tERROR: File read failed.. Closing program.\r\n");
    fclose (fPtr);
    return E_FAIL;
  }

  fseek(fPtr,0,SEEK_SET);

  fileDataPtr = malloc(fileSize);

  if (fileSize != fread(fileDataPtr, 1, fileSize, fPtr))
  {
    printf("\tWARNING: File Size mismatch.\r\n");
  }

  fclose (fPtr);

  // Make sure PRU sub system is first disabled/reset  
  PRU_disable();
  
  // Enable and load the code to the specified pru
  printf("\tINFO: Loading PRU core instruction memory.\r\n");
  PRU_load(pruNum, (Uint32*)fileDataPtr, fileSize>>2);
  
  printf("\tINFO: Executing loaded PRU program.\r\n");
  PRU_run(pruNum);

   // FIXME - wait for some condition from the PRU
   // Wait for the PRU to call the HALT command
  if (PRU_waitForHalt(pruNum,-1) == E_PASS)
  {
    printf("\tINFO: PRU halted successfully.\r\n");
  }
  else
  {
    printf("\tINFO: PRU halt failed.\r\n");
  }
  
  PRU_disable();
  return 0;
}


/************************************************************
* Local Function Definitions                                *
************************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/
