-stack          0x00000800 /* Stack Size */  
-heap           0x00000800 /* Heap Size */

MEMORY
{
  DRAM        org=0xC0000000 len=0x04000000 /* SDRAM */
  L2_RAM			org=0x11800000 len=0x00040000 /* DSP Internal L2 RAM */
  SHARED_RAM  org=0x80000000 len=0x00020000 /* Shared L3 */
  AEMIF       org=0x60000000 len=0x02000000 /* AEMIF CS2 region */
  AEMIF_CS3   org=0x62000000 len=0x02000000 /* AEMIF CS3 region */

  /* PRU Memories */
  PRU0_DATA_RAM        : o = 0x01C30000, l = 0x00000200  //    512  B
  PRU1_DATA_RAM        : o = 0x01C32000, l = 0x00000200  //    512  B
  PRU0_PROG_RAM        : o = 0x01C38000, l = 0x00001000  //      4 KB
  PRU1_PROG_RAM        : o = 0x01C3C000, l = 0x00001000  //      4 KB  
}

SECTIONS
{
  .text :
  {
  } > L2_RAM
  .const :
  {
  } > L2_RAM
  .bss :
  {
  } > L2_RAM
  .far :
  {
  } > L2_RAM
  .stack :
  {
  } > L2_RAM
  .data :
  {
  } > L2_RAM
  .cinit :
  {
  } > L2_RAM
  .sysmem :
  {
  } > L2_RAM
  .cio :
  {
  } > L2_RAM
  .switch :
  {
  } > L2_RAM
  
  .ddrram	 :
  {
    . += 0x04000000;
  } > DRAM, type=DSECT, START(_EXTERNAL_RAM_START), END(_EXTERNAL_RAM_END)
  
  .PRU0InstRAM:
  {
    . += 0x1000;
  } load=PRU0_PROG_RAM, type=DSECT, FILL=0x00000000, START(_PRU0_INST_START), SIZE(_PRU0_INST_SIZE)

  .PRU1InstRAM:
  {
    . += 0x1000;
  } load=PRU1_PROG_RAM, type=DSECT, FILL=0x00000000, START(_PRU1_INST_START), SIZE(_PRU1_INST_SIZE)
    
  .PRU0DataRAM
  {
    . += 0x200;
  } load=PRU0_DATA_RAM, type=DSECT, FILL=0x00000000, START(_PRU0_DATA_START), SIZE(_PRU0_DATA_SIZE)
  
  .PRU1DataRAM
  {
    . += 0x200;
  } load=PRU1_DATA_RAM, type=DSECT, FILL=0x00000000, START(_PRU1_DATA_START), SIZE(_PRU1_DATA_SIZE)
    
}