/* --------------------------------------------------------------------------
  FILE        : load.c                                                   
  PROJECT     : OMAP-L1x/C674x PRU Development
  DESC        : OMAP-L1x/C674x PRU Program Loader (from embedded constant array)
 ----------------------------------------------------------------------------- */

/************************************************************
* Include Files                                             *
************************************************************/

// Standard header files
#include <stdlib.h>
#include <stdio.h>
#include "tistdtypes.h"

// PRU Function header file
#include "pru.h"

// This module's header file
#include "load.h"


/************************************************************
* Explicit External Declarations                            *
************************************************************/


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
************************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/

#include "adder_bin.h"


/************************************************************
* Global Function Definitions                               *
************************************************************/

void main (void)
{
  Uint8 pruNum = 0xFF;

  printf("Starting PRU Program Loader.\r\n");

  // Get the desired PRU core
  while ((pruNum != 0) && (pruNum != 1))
  {
    printf("What PRU do you wish to execute in (0 or 1)?\r\n");
    scanf("%d",&pruNum);
    fflush(stdin);
  }

  // Make sure PRU sub system is first disabled/reset  
  PRU_disable();
  
  // Enable and load the code to the specified pru
  printf("\tINFO: Loading example.\r\n");
  PRU_load(pruNum, (Uint32*)PRU_Code, (sizeof(PRU_Code)/sizeof(Uint32)));

  printf("\tINFO: Executing loaded PRU program.\r\n");
  PRU_run(pruNum);
  
  // Wait for PRU to halt
  if (PRU_waitForHalt(pruNum, -1))
  {
    printf("\tINFO: PRU halted successfully.\r\n");
  }
  else
  {
    printf("\tINFO: PRU halt failed.\r\n");
  }
  
  printf("Program loaded and ran successfully.");
  
  // Disable the PRUSS when done
  PRU_disable();
}


/************************************************************
* Local Function Definitions                                *
************************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/
