//
// Source: adder.p
// Revision: 1.0
//
// Dummy adder - proof that PRU works.

// This dummy program reads two words from local data memory
// and adds them together, storing result back to third
// word of data memory.
//
// Parameter Table: 
//
// 31________24________16________8________0
// |                PARAM1                |
// |______________________________________|
// |                PARAM2                |
// |______________________________________|
// |                RESULT                |
// |______________________________________| 
//
  .origin 0
  .entrypoint ADDER

#include "adder.hp"

ADDER:
    // Load the ADDER input parameters from data RAM
    LBCO adder_param1, C3, #0x00, 8

    // Perform addition op
    ADD  adder_result, adder_param1, adder_param2

ADDER_EXIT:
    // Store the result back to data RAM
    SBCO adder_result, C3, #0x08, 4
    
    HALT
    
