/* --------------------------------------------------------------------------
  FILE        : util.c                                                   
  PROJECT     : DA8xx/OMAP-L138/C674x PRU Development
  DESC        : This file provides simple utility functions
-------------------------------------------------------------------------- */ 

/************************************************************
* Include Files                                             *
************************************************************/

// General type include
#include "tistdtypes.h"

// This module's header file
#include "util.h"

/************************************************************
* Explicit External Declarations                            *
************************************************************/


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
************************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/


/************************************************************
* Global Function Definitions                               *
************************************************************/

void UTIL_memcpy (Uint32 dst, Uint32 src, Uint32 cnt)
{
  unsigned char *restrict d = (unsigned char *) dst;
  unsigned char *restrict s = (unsigned char *) src;

  while (cnt--)
    *d++ = *s++;
}

/*! Boot Loader 1 - memset
*/
void UTIL_memset (Uint32 dst, Uint32 val, Uint32 cnt)
{
  unsigned char *restrict d = (unsigned char *) dst;

  while (cnt--)
    *d++ = val;
}


void UTIL_waitLoop (Uint32 cycles)
{
  Uint32 i;
  for (i = 0; i < cycles; i++)
  {
    asm(" nop ");
  }
}

// Accurate cycles = ((t us * f MHz) - 5) / 1.65 
void UTIL_waitLoopAccurate (Uint32 cycles)
{
#if defined(_TMS320C6X)
//  asm ("      SUB     B15, 8, B15     ");                 // Done by compiler 
//  asm ("      STW     A4, *+B15[1]    ");                 // Done by compiler 
  asm ("      STW     B0, *+B15[2]    ");
  asm ("      SUB     A4, 24, A4      ");          // Total cycles taken by this function, with n = 0, including clocks taken to jump to this function 
  asm ("      CMPGT   A4, 0, B0       ");
  asm ("loop:                         ");
  asm (" [B0] B       loop            ");
  asm (" [B0] SUB     A4, 6, A4       ");          // Cycles taken by loop 
  asm ("      CMPGT   A4, 0, B0       ");
  asm ("      NOP     3               ");
  asm ("      LDW     *+B15[2], B0    ");
//  asm ("      B       B3              ");                 // Done by compiler 
//  asm ("      ADD     B15, 8, B15     ");                 // Done by compiler 
//  asm ("      NOP     4     
#elif defined(_TMS320C5XX) || defined(__TMS320C55X__)
  UTIL_waitLoop(cycles);
#elif defined(_TMS320C28X)
  UTIL_waitLoop(cycles);
#elif (defined(__TMS470__) || defined(__GNUC__))
  UTIL_waitLoop(cycles);
#endif
}


/***********************************************************
* End file                                                 *
***********************************************************/


