/* --------------------------------------------------------------------------
  FILE        : device.c 				                             	 	        
  PROJECT     : DA8xx/OMAP-L138/C674x Device Definitions
  DESC        : This file provides low-level init functions.
  VERSION     : 1.0   
-------------------------------------------------------------------------- */ 

/************************************************************
* Include Files                                             *
************************************************************/

// General type include
#include "tistdtypes.h"

// CSL header files
#include "csl/cslr.h"
#include "csl/soc_OMAPL138.h"
#include "csl/cslr_psc_OMAPL138.h"

// This module's header file
#include "device.h"


/************************************************************
* Explicit External Declarations                            *
************************************************************/


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
************************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/


/************************************************************
* Global Function Definitions                               *
************************************************************/

Uint32 DEVICE_LPSCTransition(Uint8 pscnum, Uint8 module, Uint8 domain, Uint8 state)
{
  CSL_PscRegsOvly PSC;
  
  if (pscnum == CSL_PSC_0)
    PSC = (CSL_PscRegsOvly) CSL_PSC_0_REGS;
  else if(pscnum == CSL_PSC_1)
    PSC = (CSL_PscRegsOvly) CSL_PSC_1_REGS;
  else
    return E_FAIL; 

  // Wait for any outstanding transition to complete
  while ( (PSC->PTSTAT) & (0x00000001 << domain) );
  
  // If we are already in that state, just return
  if ( CSL_FEXT(PSC->MDSTAT[module], PSC_MDSTAT_STATE) == state )
  {
    return E_PASS;
  }
    
  // Perform transition
  CSL_FINS(PSC->MDCTL[module], PSC_MDCTL_NEXT, state);
  PSC->PTCMD |= (0x00000001 << domain);

  // Wait for transition to complete
  while ( (PSC->PTSTAT) & (0x00000001 << domain) );
  
  // Wait and verify the state
  while ( CSL_FEXT(PSC->MDSTAT[module], PSC_MDSTAT_STATE) != state );
  
  return E_PASS;
}


/************************************************************
* Local Function Definitions                                *
************************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/




