/* --------------------------------------------------------------------------
  FILE        : device.h                                                   
  PROJECT     : DA8xx/OMAP-L138/C674x PRU Development
  DESC        : Provides memory overlays, macros for device.
  VERSION     : 1.0
----------------------------------------------------------------------------- */

#ifndef _DEVICE_H_
#define _DEVICE_H_

#include "tistdtypes.h"

#include "csl/cslr.h"
#include "csl/soc_OMAPL138.h"
#include "csl/cslr_syscfg0_OMAPL138.h"

// Prevent C++ name mangling
#ifdef __cplusplus
extern far "c" {
#endif

/***********************************************************
* Global Macro Declarations                                *
***********************************************************/


/******************************************************
* Global Typedef declarations                         *
******************************************************/


/***********************************************************
* Global Variable Declarations                             *
***********************************************************/


/***********************************************************
* Global Function Declarations                             *
***********************************************************/

// Execute LPSC state transition
extern __FAR__ Uint32 DEVICE_LPSCTransition(Uint8 pscnum, Uint8 module, Uint8 domain, Uint8 state);

// Pinmux control function
static inline void DEVICE_pinmuxControl(Uint32 regOffset, Uint32 mask, Uint32 value)
{
  Uint32 *PINMUX = (Uint32 *) &(((CSL_SyscfgRegsOvly) CSL_SYSCFG_0_REGS)->PINMUX0);
  PINMUX[regOffset] = (PINMUX[regOffset] & ~mask) | (mask & value);
}


/***********************************************************
* End file                                                 *
***********************************************************/

#ifdef __cplusplus
}
#endif

#endif // End _DEVICE_H_


