/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_vpif_1.h
*
* Brief: This file contains the Register Description for vpif
*
*********************************************************************/
#ifndef _CSLR_VPIF_H_
#define _CSLR_VPIF_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl/cslr.h>
#include "tistdtypes.h"


/* Minimum unit = 1 byte */
/**************************************************************************\
* Register Overlay Structure for Capture Channel registers
\**************************************************************************/
typedef struct {
    volatile Uint32 TLUMA;
    volatile Uint32 BLUMA;
    volatile Uint32 TCHROMA;
    volatile Uint32 BCHROMA;
    volatile Uint32 THANC;
    volatile Uint32 BHANC;
    volatile Uint32 TVANC;
    volatile Uint32 BVANC;
    volatile Uint8 RSVD2[4];
    volatile Uint32 IMGOFFSET;
    volatile Uint32 HANCOFFSET;
    volatile Uint32 HCFG;
    volatile Uint32 VCFG0;
    volatile Uint32 VCFG1;
    volatile Uint32 VCFG2;
    volatile Uint32 VSIZE;
}CSL_CaptureRegs;

/**************************************************************************\
* Register Overlay Structure for Display Channel registers
\**************************************************************************/
typedef struct {
    volatile Uint32 TLUMA;
    volatile Uint32 BLUMA;
    volatile Uint32 TCHROMA;
    volatile Uint32 BCHROMA;
    volatile Uint32 THANC;
    volatile Uint32 BHANC;
    volatile Uint32 TVANC;
    volatile Uint32 BVANC;
    volatile Uint8 RSVD4[4];
    volatile Uint32 IMGOFFSET;
    volatile Uint32 HANCOFFSET;
    volatile Uint32 HCFG;
    volatile Uint32 VCFG0;
    volatile Uint32 VCFG1;
    volatile Uint32 VCFG2;
    volatile Uint32 VSIZE;
    volatile Uint32 THANCPOS;
    volatile Uint32 THANCSIZE;
    volatile Uint32 BHANCPOS;
    volatile Uint32 BHANCSIZE;
    volatile Uint32 TVANCPOS;
    volatile Uint32 TVANCSIZE;
    volatile Uint32 BVANCPOS;
    volatile Uint32 BVANCSIZE;
    volatile Uint8 RSVD5[32];
}CSL_DisplayRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct {
    volatile Uint32 REVID;
    volatile Uint32 C0CTRL;
    volatile Uint32 C1CTRL;
    volatile Uint32 C2CTRL;
    volatile Uint32 C3CTRL;
    volatile Uint8 RSVD0[12];
    volatile Uint32 INTEN;
    volatile Uint32 INTSET;
    volatile Uint32 INTCLR;
    volatile Uint32 INTSTAT;
    volatile Uint32 INTSTATCLR;
    volatile Uint32 EMUCTRL;
    volatile Uint32 REQSIZE;
    volatile Uint8 RSVD1[4];
    CSL_CaptureRegs CAPTURE[2];
    CSL_DisplayRegs DISPLAY[2];
} CSL_VpifRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_VpifRegs            *CSL_VpifRegsOvly;

/**************************************************************************\
* Overlay structure typedef definition for Capture Channel registers
\**************************************************************************/
typedef volatile CSL_CaptureRegs         *CSL_VpifCapRegsOvly;

/**************************************************************************\
* Overlay structure typedef definition for Display Channel registers
\**************************************************************************/
typedef volatile CSL_DisplayRegs         *CSL_VpifDisRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_VPIF_REVID_REV_MASK          (0xFFFFFFFFu)
#define CSL_VPIF_REVID_REV_SHIFT         (0x00000000u)
#define CSL_VPIF_REVID_REV_RESETVAL      (0x4C080A01u)

#define CSL_VPIF_REVID_RESETVAL          (0x4C080A01u)

/* C0CTRL */

#define CSL_VPIF_C0CTRL_CLKEDGE_MASK     (0x80000000u)
#define CSL_VPIF_C0CTRL_CLKEDGE_SHIFT    (0x0000001Fu)
#define CSL_VPIF_C0CTRL_CLKEDGE_RESETVAL (0x00000000u)
/*----CLKEDGE Tokens----*/
#define CSL_VPIF_C0CTRL_CLKEDGE_RISE     (0x00000000u)
#define CSL_VPIF_C0CTRL_CLKEDGE_FALL     (0x00000001u)


#define CSL_VPIF_C0CTRL_DATAWIDTH_MASK   (0x30000000u)
#define CSL_VPIF_C0CTRL_DATAWIDTH_SHIFT  (0x0000001Cu)
#define CSL_VPIF_C0CTRL_DATAWIDTH_RESETVAL (0x00000000u)
/*----DATAWIDTH Tokens----*/
#define CSL_VPIF_C0CTRL_DATAWIDTH_8BIT   (0x00000000u)
#define CSL_VPIF_C0CTRL_DATAWIDTH_10BIT  (0x00000001u)
#define CSL_VPIF_C0CTRL_DATAWIDTH_12BIT  (0x00000002u)

#define CSL_VPIF_C0CTRL_INTLINE_MASK     (0x0FFF0000u)
#define CSL_VPIF_C0CTRL_INTLINE_SHIFT    (0x00000010u)
#define CSL_VPIF_C0CTRL_INTLINE_RESETVAL (0x00000000u)

#define CSL_VPIF_C0CTRL_FIDINV_MASK      (0x00008000u)
#define CSL_VPIF_C0CTRL_FIDINV_SHIFT     (0x0000000Fu)
#define CSL_VPIF_C0CTRL_FIDINV_RESETVAL  (0x00000000u)
/*----FIDINV Tokens----*/
#define CSL_VPIF_C0CTRL_FIDINV_DISABLE   (0x00000000u)
#define CSL_VPIF_C0CTRL_FIDINV_ENABLE    (0x00000001u)

#define CSL_VPIF_C0CTRL_VVINV_MASK       (0x00004000u)
#define CSL_VPIF_C0CTRL_VVINV_SHIFT      (0x0000000Eu)
#define CSL_VPIF_C0CTRL_VVINV_RESETVAL   (0x00000000u)
/*----VVINV Tokens----*/
#define CSL_VPIF_C0CTRL_VVINV_DISABLE    (0x00000000u)
#define CSL_VPIF_C0CTRL_VVINV_ENABLE     (0x00000001u)

#define CSL_VPIF_C0CTRL_HVINV_MASK       (0x00002000u)
#define CSL_VPIF_C0CTRL_HVINV_SHIFT      (0x0000000Du)
#define CSL_VPIF_C0CTRL_HVINV_RESETVAL   (0x00000000u)
/*----HVINV Tokens----*/
#define CSL_VPIF_C0CTRL_HVINV_DISABLE    (0x00000000u)
#define CSL_VPIF_C0CTRL_HVINV_ENABLE     (0x00000001u)

#define CSL_VPIF_C0CTRL_FIELDFRAME_MASK  (0x00001000u)
#define CSL_VPIF_C0CTRL_FIELDFRAME_SHIFT (0x0000000Cu)
#define CSL_VPIF_C0CTRL_FIELDFRAME_RESETVAL (0x00000000u)
/*----FIELDFRAME Tokens----*/
#define CSL_VPIF_C0CTRL_FIELDFRAME_FIELD (0x00000000u)
#define CSL_VPIF_C0CTRL_FIELDFRAME_FRAME (0x00000001u)


#define CSL_VPIF_C0CTRL_INTRPROG_MASK    (0x00000400u)
#define CSL_VPIF_C0CTRL_INTRPROG_SHIFT   (0x0000000Au)
#define CSL_VPIF_C0CTRL_INTRPROG_RESETVAL (0x00000000u)
/*----INTRPROG Tokens----*/
#define CSL_VPIF_C0CTRL_INTRPROG_INTERLACED (0x00000000u)
#define CSL_VPIF_C0CTRL_INTRPROG_PROGRESSIVE (0x00000001u)

#define CSL_VPIF_C0CTRL_VANC_MASK        (0x00000200u)
#define CSL_VPIF_C0CTRL_VANC_SHIFT       (0x00000009u)
#define CSL_VPIF_C0CTRL_VANC_RESETVAL    (0x00000000u)
/*----VANC Tokens----*/
#define CSL_VPIF_C0CTRL_VANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C0CTRL_VANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C0CTRL_HANC_MASK        (0x00000100u)
#define CSL_VPIF_C0CTRL_HANC_SHIFT       (0x00000008u)
#define CSL_VPIF_C0CTRL_HANC_RESETVAL    (0x00000000u)
/*----HANC Tokens----*/
#define CSL_VPIF_C0CTRL_HANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C0CTRL_HANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C0CTRL_INTFRAME_MASK    (0x000000C0u)
#define CSL_VPIF_C0CTRL_INTFRAME_SHIFT   (0x00000006u)
#define CSL_VPIF_C0CTRL_INTFRAME_RESETVAL (0x00000000u)
/*----INTFRAME Tokens----*/
#define CSL_VPIF_C0CTRL_INTFRAME_TOP     (0x00000000u)
#define CSL_VPIF_C0CTRL_INTFRAME_BOTTOM  (0x00000001u)
#define CSL_VPIF_C0CTRL_INTFRAME_BOTH    (0x00000002u)
#define CSL_VPIF_C0CTRL_INTFRAME_RESV    (0x00000003u)

#define CSL_VPIF_C0CTRL_FID_MASK         (0x00000020u)
#define CSL_VPIF_C0CTRL_FID_SHIFT        (0x00000005u)
#define CSL_VPIF_C0CTRL_FID_RESETVAL     (0x00000000u)
/*----FID Tokens----*/
#define CSL_VPIF_C0CTRL_FID_TOP          (0x00000000u)
#define CSL_VPIF_C0CTRL_FID_BOTTOM       (0x00000001u)


#define CSL_VPIF_C0CTRL_YCMUX_MASK       (0x00000008u)
#define CSL_VPIF_C0CTRL_YCMUX_SHIFT      (0x00000003u)
#define CSL_VPIF_C0CTRL_YCMUX_RESETVAL   (0x00000000u)
/*----YCMUX Tokens----*/
#define CSL_VPIF_C0CTRL_YCMUX_DISABLE    (0x00000000u)
#define CSL_VPIF_C0CTRL_YCMUX_ENABLE     (0x00000001u)

#define CSL_VPIF_C0CTRL_CAPMODE_MASK     (0x00000004u)
#define CSL_VPIF_C0CTRL_CAPMODE_SHIFT    (0x00000002u)
#define CSL_VPIF_C0CTRL_CAPMODE_RESETVAL (0x00000000u)
/*----CAPMODE Tokens----*/
#define CSL_VPIF_C0CTRL_CAPMODE_BTYC     (0x00000000u)
#define CSL_VPIF_C0CTRL_CAPMODE_CCDCMOS  (0x00000001u)


#define CSL_VPIF_C0CTRL_CHANEN_MASK      (0x00000001u)
#define CSL_VPIF_C0CTRL_CHANEN_SHIFT     (0x00000000u)
#define CSL_VPIF_C0CTRL_CHANEN_RESETVAL  (0x00000000u)
/*----CHANEN Tokens----*/
#define CSL_VPIF_C0CTRL_CHANEN_DISABLE   (0x00000000u)
#define CSL_VPIF_C0CTRL_CHANEN_ENABLE    (0x00000001u)

#define CSL_VPIF_C0CTRL_RESETVAL         (0x00000000u)

/* C1CTRL */

#define CSL_VPIF_C1CTRL_CLKEDGE_MASK     (0x80000000u)
#define CSL_VPIF_C1CTRL_CLKEDGE_SHIFT    (0x0000001Fu)
#define CSL_VPIF_C1CTRL_CLKEDGE_RESETVAL (0x00000000u)
/*----CLKEDGE Tokens----*/
#define CSL_VPIF_C1CTRL_CLKEDGE_RISE     (0x00000000u)
#define CSL_VPIF_C1CTRL_CLKEDGE_FALL     (0x00000001u)


#define CSL_VPIF_C1CTRL_INTRPROG_MASK    (0x00000400u)
#define CSL_VPIF_C1CTRL_INTRPROG_SHIFT   (0x0000000Au)
#define CSL_VPIF_C1CTRL_INTRPROG_RESETVAL (0x00000000u)
/*----INTRPROG Tokens----*/
#define CSL_VPIF_C1CTRL_INTRPROG_INTERLACED (0x00000000u)
#define CSL_VPIF_C1CTRL_INTRPROG_PROGRESSIVE (0x00000001u)

#define CSL_VPIF_C1CTRL_VANC_MASK        (0x00000200u)
#define CSL_VPIF_C1CTRL_VANC_SHIFT       (0x00000009u)
#define CSL_VPIF_C1CTRL_VANC_RESETVAL    (0x00000000u)
/*----VANC Tokens----*/
#define CSL_VPIF_C1CTRL_VANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C1CTRL_VANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C1CTRL_HANC_MASK        (0x00000100u)
#define CSL_VPIF_C1CTRL_HANC_SHIFT       (0x00000008u)
#define CSL_VPIF_C1CTRL_HANC_RESETVAL    (0x00000000u)
/*----HANC Tokens----*/
#define CSL_VPIF_C1CTRL_HANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C1CTRL_HANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C1CTRL_INTFRAME_MASK    (0x000000C0u)
#define CSL_VPIF_C1CTRL_INTFRAME_SHIFT   (0x00000006u)
#define CSL_VPIF_C1CTRL_INTFRAME_RESETVAL (0x00000000u)
/*----INTFRAME Tokens----*/
#define CSL_VPIF_C1CTRL_INTFRAME_TOP     (0x00000000u)
#define CSL_VPIF_C1CTRL_INTFRAME_BOTTOM  (0x00000001u)
#define CSL_VPIF_C1CTRL_INTFRAME_BOTH    (0x00000002u)
#define CSL_VPIF_C1CTRL_INTFRAME_RESV    (0x00000003u)

#define CSL_VPIF_C1CTRL_FID_MASK         (0x00000020u)
#define CSL_VPIF_C1CTRL_FID_SHIFT        (0x00000005u)
#define CSL_VPIF_C1CTRL_FID_RESETVAL     (0x00000000u)
/*----FID Tokens----*/
#define CSL_VPIF_C1CTRL_FID_TOP          (0x00000000u)
#define CSL_VPIF_C1CTRL_FID_BOTTOM       (0x00000001u)


#define CSL_VPIF_C1CTRL_YCMUX_MASK       (0x00000008u)
#define CSL_VPIF_C1CTRL_YCMUX_SHIFT      (0x00000003u)
#define CSL_VPIF_C1CTRL_YCMUX_RESETVAL   (0x00000000u)
/*----YCMUX Tokens----*/
#define CSL_VPIF_C1CTRL_YCMUX_DISABLE    (0x00000000u)
#define CSL_VPIF_C1CTRL_YCMUX_ENABLE     (0x00000001u)

#define CSL_VPIF_C1CTRL_CAPMODE_MASK     (0x00000004u)
#define CSL_VPIF_C1CTRL_CAPMODE_SHIFT    (0x00000002u)
#define CSL_VPIF_C1CTRL_CAPMODE_RESETVAL (0x00000000u)
/*----CAPMODE Tokens----*/
#define CSL_VPIF_C1CTRL_CAPMODE_BTYC     (0x00000000u)
#define CSL_VPIF_C1CTRL_CAPMODE_CCDCMOS  (0x00000001u)


#define CSL_VPIF_C1CTRL_CHANEN_MASK      (0x00000001u)
#define CSL_VPIF_C1CTRL_CHANEN_SHIFT     (0x00000000u)
#define CSL_VPIF_C1CTRL_CHANEN_RESETVAL  (0x00000000u)
/*----CHANEN Tokens----*/
#define CSL_VPIF_C1CTRL_CHANEN_DISABLE   (0x00000000u)
#define CSL_VPIF_C1CTRL_CHANEN_ENABLE    (0x00000001u)

#define CSL_VPIF_C1CTRL_RESETVAL         (0x00000000u)

/* C2CTRL */

#define CSL_VPIF_C2CTRL_CLKEDGE_MASK     (0x80000000u)
#define CSL_VPIF_C2CTRL_CLKEDGE_SHIFT    (0x0000001Fu)
#define CSL_VPIF_C2CTRL_CLKEDGE_RESETVAL (0x00000000u)
/*----CLKEDGE Tokens----*/
#define CSL_VPIF_C2CTRL_CLKEDGE_RISE     (0x00000000u)
#define CSL_VPIF_C2CTRL_CLKEDGE_FALL     (0x00000001u)


#define CSL_VPIF_C2CTRL_CLIPANC_MASK     (0x00004000u)
#define CSL_VPIF_C2CTRL_CLIPANC_SHIFT    (0x0000000Eu)
#define CSL_VPIF_C2CTRL_CLIPANC_RESETVAL (0x00000000u)
/*----CLIPANC Tokens----*/
#define CSL_VPIF_C2CTRL_CLIPANC_DISABLE  (0x00000000u)
#define CSL_VPIF_C2CTRL_CLIPANC_ENABLE   (0x00000001u)

#define CSL_VPIF_C2CTRL_CLIPVID_MASK     (0x00002000u)
#define CSL_VPIF_C2CTRL_CLIPVID_SHIFT    (0x0000000Du)
#define CSL_VPIF_C2CTRL_CLIPVID_RESETVAL (0x00000000u)
/*----CLIPVID Tokens----*/
#define CSL_VPIF_C2CTRL_CLIPVID_DISABLE  (0x00000000u)
#define CSL_VPIF_C2CTRL_CLIPVID_ENABLE   (0x00000001u)

#define CSL_VPIF_C2CTRL_FIELDFRAME_MASK  (0x00001000u)
#define CSL_VPIF_C2CTRL_FIELDFRAME_SHIFT (0x0000000Cu)
#define CSL_VPIF_C2CTRL_FIELDFRAME_RESETVAL (0x00000000u)
/*----FIELDFRAME Tokens----*/
#define CSL_VPIF_C2CTRL_FIELDFRAME_FIELD (0x00000000u)
#define CSL_VPIF_C2CTRL_FIELDFRAME_FRAME (0x00000001u)

#define CSL_VPIF_C2CTRL_INTRPROG_MASK    (0x00000800u)
#define CSL_VPIF_C2CTRL_INTRPROG_SHIFT   (0x0000000Bu)
#define CSL_VPIF_C2CTRL_INTRPROG_RESETVAL (0x00000000u)
/*----INTRPROG Tokens----*/
#define CSL_VPIF_C2CTRL_INTRPROG_INTERLACED (0x00000000u)
#define CSL_VPIF_C2CTRL_INTRPROG_PROGRESSIVE (0x00000001u)

#define CSL_VPIF_C2CTRL_PIXEL_MASK       (0x00000400u)
#define CSL_VPIF_C2CTRL_PIXEL_SHIFT      (0x0000000Au)
#define CSL_VPIF_C2CTRL_PIXEL_RESETVAL   (0x00000000u)
/*----PIXEL Tokens----*/
#define CSL_VPIF_C2CTRL_PIXEL_DISABLE    (0x00000000u)
#define CSL_VPIF_C2CTRL_PIXEL_ENABLE     (0x00000001u)

#define CSL_VPIF_C2CTRL_VANC_MASK        (0x00000200u)
#define CSL_VPIF_C2CTRL_VANC_SHIFT       (0x00000009u)
#define CSL_VPIF_C2CTRL_VANC_RESETVAL    (0x00000000u)
/*----VANC Tokens----*/
#define CSL_VPIF_C2CTRL_VANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C2CTRL_VANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C2CTRL_HANC_MASK        (0x00000100u)
#define CSL_VPIF_C2CTRL_HANC_SHIFT       (0x00000008u)
#define CSL_VPIF_C2CTRL_HANC_RESETVAL    (0x00000000u)
/*----HANC Tokens----*/
#define CSL_VPIF_C2CTRL_HANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C2CTRL_HANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C2CTRL_INTFRAME_MASK    (0x000000C0u)
#define CSL_VPIF_C2CTRL_INTFRAME_SHIFT   (0x00000006u)
#define CSL_VPIF_C2CTRL_INTFRAME_RESETVAL (0x00000000u)
/*----INTFRAME Tokens----*/
#define CSL_VPIF_C2CTRL_INTFRAME_TOP     (0x00000000u)
#define CSL_VPIF_C2CTRL_INTFRAME_BOTTOM  (0x00000001u)
#define CSL_VPIF_C2CTRL_INTFRAME_BOTH    (0x00000002u)
#define CSL_VPIF_C2CTRL_INTFRAME_RESV    (0x00000003u)

#define CSL_VPIF_C2CTRL_FID_MASK         (0x00000020u)
#define CSL_VPIF_C2CTRL_FID_SHIFT        (0x00000005u)
#define CSL_VPIF_C2CTRL_FID_RESETVAL     (0x00000000u)
/*----FID Tokens----*/
#define CSL_VPIF_C2CTRL_FID_TOP          (0x00000000u)
#define CSL_VPIF_C2CTRL_FID_BOTTOM       (0x00000001u)


#define CSL_VPIF_C2CTRL_YCMUX_MASK       (0x00000008u)
#define CSL_VPIF_C2CTRL_YCMUX_SHIFT      (0x00000003u)
#define CSL_VPIF_C2CTRL_YCMUX_RESETVAL   (0x00000000u)
/*----YCMUX Tokens----*/
#define CSL_VPIF_C2CTRL_YCMUX_DISABLE    (0x00000000u)
#define CSL_VPIF_C2CTRL_YCMUX_ENABLE     (0x00000001u)


#define CSL_VPIF_C2CTRL_CLKEN_MASK       (0x00000002u)
#define CSL_VPIF_C2CTRL_CLKEN_SHIFT      (0x00000001u)
#define CSL_VPIF_C2CTRL_CLKEN_RESETVAL   (0x00000000u)
/*----CLKEN Tokens----*/
#define CSL_VPIF_C2CTRL_CLKEN_DISABLE    (0x00000000u)
#define CSL_VPIF_C2CTRL_CLKEN_ENABLE     (0x00000001u)

#define CSL_VPIF_C2CTRL_CHANEN_MASK      (0x00000001u)
#define CSL_VPIF_C2CTRL_CHANEN_SHIFT     (0x00000000u)
#define CSL_VPIF_C2CTRL_CHANEN_RESETVAL  (0x00000000u)
/*----CHANEN Tokens----*/
#define CSL_VPIF_C2CTRL_CHANEN_DISABLE   (0x00000000u)
#define CSL_VPIF_C2CTRL_CHANEN_ENABLE    (0x00000001u)

#define CSL_VPIF_C2CTRL_RESETVAL         (0x00000000u)

/* C3CTRL */

#define CSL_VPIF_C3CTRL_CLKEDGE_MASK     (0x80000000u)
#define CSL_VPIF_C3CTRL_CLKEDGE_SHIFT    (0x0000001Fu)
#define CSL_VPIF_C3CTRL_CLKEDGE_RESETVAL (0x00000000u)
/*----CLKEDGE Tokens----*/
#define CSL_VPIF_C3CTRL_CLKEDGE_RISE     (0x00000000u)
#define CSL_VPIF_C3CTRL_CLKEDGE_FALL     (0x00000001u)


#define CSL_VPIF_C3CTRL_CLIPANC_MASK     (0x00004000u)
#define CSL_VPIF_C3CTRL_CLIPANC_SHIFT    (0x0000000Eu)
#define CSL_VPIF_C3CTRL_CLIPANC_RESETVAL (0x00000000u)
/*----CLIPANC Tokens----*/
#define CSL_VPIF_C3CTRL_CLIPANC_DISABLE  (0x00000000u)
#define CSL_VPIF_C3CTRL_CLIPANC_ENABLE   (0x00000001u)

#define CSL_VPIF_C3CTRL_CLIPVID_MASK     (0x00002000u)
#define CSL_VPIF_C3CTRL_CLIPVID_SHIFT    (0x0000000Du)
#define CSL_VPIF_C3CTRL_CLIPVID_RESETVAL (0x00000000u)
/*----CLIPVID Tokens----*/
#define CSL_VPIF_C3CTRL_CLIPVID_DISABLE  (0x00000000u)
#define CSL_VPIF_C3CTRL_CLIPVID_ENABLE   (0x00000001u)


#define CSL_VPIF_C3CTRL_INTRPROG_MASK    (0x00000800u)
#define CSL_VPIF_C3CTRL_INTRPROG_SHIFT   (0x0000000Bu)
#define CSL_VPIF_C3CTRL_INTRPROG_RESETVAL (0x00000000u)
/*----INTRPROG Tokens----*/
#define CSL_VPIF_C3CTRL_INTRPROG_INTERLACED (0x00000000u)
#define CSL_VPIF_C3CTRL_INTRPROG_PROGRESSIVE (0x00000001u)

#define CSL_VPIF_C3CTRL_PIXEL_MASK       (0x00000400u)
#define CSL_VPIF_C3CTRL_PIXEL_SHIFT      (0x0000000Au)
#define CSL_VPIF_C3CTRL_PIXEL_RESETVAL   (0x00000000u)
/*----PIXEL Tokens----*/
#define CSL_VPIF_C3CTRL_PIXEL_DISABLE    (0x00000000u)
#define CSL_VPIF_C3CTRL_PIXEL_ENABLE     (0x00000001u)

#define CSL_VPIF_C3CTRL_VANC_MASK        (0x00000200u)
#define CSL_VPIF_C3CTRL_VANC_SHIFT       (0x00000009u)
#define CSL_VPIF_C3CTRL_VANC_RESETVAL    (0x00000000u)
/*----VANC Tokens----*/
#define CSL_VPIF_C3CTRL_VANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C3CTRL_VANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C3CTRL_HANC_MASK        (0x00000100u)
#define CSL_VPIF_C3CTRL_HANC_SHIFT       (0x00000008u)
#define CSL_VPIF_C3CTRL_HANC_RESETVAL    (0x00000000u)
/*----HANC Tokens----*/
#define CSL_VPIF_C3CTRL_HANC_DISABLE     (0x00000000u)
#define CSL_VPIF_C3CTRL_HANC_ENABLE      (0x00000001u)

#define CSL_VPIF_C3CTRL_INTFRAME_MASK    (0x000000C0u)
#define CSL_VPIF_C3CTRL_INTFRAME_SHIFT   (0x00000006u)
#define CSL_VPIF_C3CTRL_INTFRAME_RESETVAL (0x00000000u)
/*----INTFRAME Tokens----*/
#define CSL_VPIF_C3CTRL_INTFRAME_TOP     (0x00000000u)
#define CSL_VPIF_C3CTRL_INTFRAME_BOTTOM  (0x00000001u)
#define CSL_VPIF_C3CTRL_INTFRAME_BOTH    (0x00000002u)
#define CSL_VPIF_C3CTRL_INTFRAME_RESV    (0x00000003u)

#define CSL_VPIF_C3CTRL_FID_MASK         (0x00000020u)
#define CSL_VPIF_C3CTRL_FID_SHIFT        (0x00000005u)
#define CSL_VPIF_C3CTRL_FID_RESETVAL     (0x00000000u)
/*----FID Tokens----*/
#define CSL_VPIF_C3CTRL_FID_TOP          (0x00000000u)
#define CSL_VPIF_C3CTRL_FID_BOTTOM       (0x00000001u)


#define CSL_VPIF_C3CTRL_YCMUX_MASK       (0x00000008u)
#define CSL_VPIF_C3CTRL_YCMUX_SHIFT      (0x00000003u)
#define CSL_VPIF_C3CTRL_YCMUX_RESETVAL   (0x00000000u)
/*----YCMUX Tokens----*/
#define CSL_VPIF_C3CTRL_YCMUX_DISABLE    (0x00000000u)
#define CSL_VPIF_C3CTRL_YCMUX_ENABLE     (0x00000001u)


#define CSL_VPIF_C3CTRL_CLKEN_MASK       (0x00000002u)
#define CSL_VPIF_C3CTRL_CLKEN_SHIFT      (0x00000001u)
#define CSL_VPIF_C3CTRL_CLKEN_RESETVAL   (0x00000000u)
/*----CLKEN Tokens----*/
#define CSL_VPIF_C3CTRL_CLKEN_DISABLE    (0x00000000u)
#define CSL_VPIF_C3CTRL_CLKEN_ENABLE     (0x00000001u)

#define CSL_VPIF_C3CTRL_CHANEN_MASK      (0x00000001u)
#define CSL_VPIF_C3CTRL_CHANEN_SHIFT     (0x00000000u)
#define CSL_VPIF_C3CTRL_CHANEN_RESETVAL  (0x00000000u)
/*----CHANEN Tokens----*/
#define CSL_VPIF_C3CTRL_CHANEN_DISABLE   (0x00000000u)
#define CSL_VPIF_C3CTRL_CHANEN_ENABLE    (0x00000001u)
#define CSL_VPIF_C3CTRL_CHANEN_ERROR     (0x00000001u)

#define CSL_VPIF_C3CTRL_RESETVAL         (0x00000000u)

/* INTEN */


#define CSL_VPIF_INTEN_ERROR_MASK        (0x00000010u)
#define CSL_VPIF_INTEN_ERROR_SHIFT       (0x00000004u)
#define CSL_VPIF_INTEN_ERROR_RESETVAL    (0x00000000u)
/*----ERROR Tokens----*/
#define CSL_VPIF_INTEN_ERROR_DISABLE     (0x00000000u)
#define CSL_VPIF_INTEN_ERROR_ENABLE      (0x00000001u)

#define CSL_VPIF_INTEN_FRAME3_MASK       (0x00000008u)
#define CSL_VPIF_INTEN_FRAME3_SHIFT      (0x00000003u)
#define CSL_VPIF_INTEN_FRAME3_RESETVAL   (0x00000000u)
/*----FRAME3 Tokens----*/
#define CSL_VPIF_INTEN_FRAME3_DISABLE    (0x00000000u)
#define CSL_VPIF_INTEN_FRAME3_ENABLE     (0x00000001u)

#define CSL_VPIF_INTEN_FRAME2_MASK       (0x00000004u)
#define CSL_VPIF_INTEN_FRAME2_SHIFT      (0x00000002u)
#define CSL_VPIF_INTEN_FRAME2_RESETVAL   (0x00000000u)
/*----FRAME2 Tokens----*/
#define CSL_VPIF_INTEN_FRAME2_DISABLE    (0x00000000u)
#define CSL_VPIF_INTEN_FRAME2_ENABLE     (0x00000001u)

#define CSL_VPIF_INTEN_FRAME1_MASK       (0x00000002u)
#define CSL_VPIF_INTEN_FRAME1_SHIFT      (0x00000001u)
#define CSL_VPIF_INTEN_FRAME1_RESETVAL   (0x00000000u)
/*----FRAME1 Tokens----*/
#define CSL_VPIF_INTEN_FRAME1_DISABLE    (0x00000000u)
#define CSL_VPIF_INTEN_FRAME1_ENABLE     (0x00000001u)

#define CSL_VPIF_INTEN_FRAME0_MASK       (0x00000001u)
#define CSL_VPIF_INTEN_FRAME0_SHIFT      (0x00000000u)
#define CSL_VPIF_INTEN_FRAME0_RESETVAL   (0x00000000u)
/*----FRAME0 Tokens----*/
#define CSL_VPIF_INTEN_FRAME0_DISABLE    (0x00000000u)
#define CSL_VPIF_INTEN_FRAME0_ENABLE     (0x00000001u)

#define CSL_VPIF_INTEN_RESETVAL          (0x00000000u)

/* INTSET */


#define CSL_VPIF_INTSET_ERROR_MASK       (0x00000010u)
#define CSL_VPIF_INTSET_ERROR_SHIFT      (0x00000004u)
#define CSL_VPIF_INTSET_ERROR_RESETVAL   (0x00000000u)
/*----ERROR Tokens----*/
#define CSL_VPIF_INTSET_ERROR_DISABLE    (0x00000000u)
#define CSL_VPIF_INTSET_ERROR_ENABLE     (0x00000001u)

#define CSL_VPIF_INTSET_FRAME3_MASK      (0x00000008u)
#define CSL_VPIF_INTSET_FRAME3_SHIFT     (0x00000003u)
#define CSL_VPIF_INTSET_FRAME3_RESETVAL  (0x00000000u)
/*----FRAME3 Tokens----*/
#define CSL_VPIF_INTSET_FRAME3_DISABLE   (0x00000000u)
#define CSL_VPIF_INTSET_FRAME3_ENABLE    (0x00000001u)

#define CSL_VPIF_INTSET_FRAME2_MASK      (0x00000004u)
#define CSL_VPIF_INTSET_FRAME2_SHIFT     (0x00000002u)
#define CSL_VPIF_INTSET_FRAME2_RESETVAL  (0x00000000u)
/*----FRAME2 Tokens----*/
#define CSL_VPIF_INTSET_FRAME2_DISABLE   (0x00000000u)
#define CSL_VPIF_INTSET_FRAME2_ENABLE    (0x00000001u)

#define CSL_VPIF_INTSET_FRAME1_MASK      (0x00000002u)
#define CSL_VPIF_INTSET_FRAME1_SHIFT     (0x00000001u)
#define CSL_VPIF_INTSET_FRAME1_RESETVAL  (0x00000000u)
/*----FRAME1 Tokens----*/
#define CSL_VPIF_INTSET_FRAME1_DISABLE   (0x00000000u)
#define CSL_VPIF_INTSET_FRAME1_ENABLE    (0x00000001u)

#define CSL_VPIF_INTSET_FRAME0_MASK      (0x00000001u)
#define CSL_VPIF_INTSET_FRAME0_SHIFT     (0x00000000u)
#define CSL_VPIF_INTSET_FRAME0_RESETVAL  (0x00000000u)
/*----FRAME0 Tokens----*/
#define CSL_VPIF_INTSET_FRAME0_DISABLE   (0x00000000u)
#define CSL_VPIF_INTSET_FRAME0_ENABLE    (0x00000001u)

#define CSL_VPIF_INTSET_RESETVAL         (0x00000000u)

/* INTCLR */


#define CSL_VPIF_INTCLR_ERROR_MASK       (0x00000010u)
#define CSL_VPIF_INTCLR_ERROR_SHIFT      (0x00000004u)
#define CSL_VPIF_INTCLR_ERROR_RESETVAL   (0x00000000u)
/*----ERROR Tokens----*/
#define CSL_VPIF_INTCLR_ERROR_NC         (0x00000000u)
#define CSL_VPIF_INTCLR_ERROR_CLR        (0x00000001u)

#define CSL_VPIF_INTCLR_FRAME3_MASK      (0x00000008u)
#define CSL_VPIF_INTCLR_FRAME3_SHIFT     (0x00000003u)
#define CSL_VPIF_INTCLR_FRAME3_RESETVAL  (0x00000000u)
/*----FRAME3 Tokens----*/
#define CSL_VPIF_INTCLR_FRAME3_NC        (0x00000000u)
#define CSL_VPIF_INTCLR_FRAME3_CLR       (0x00000001u)

#define CSL_VPIF_INTCLR_FRAME2_MASK      (0x00000004u)
#define CSL_VPIF_INTCLR_FRAME2_SHIFT     (0x00000002u)
#define CSL_VPIF_INTCLR_FRAME2_RESETVAL  (0x00000000u)
/*----FRAME2 Tokens----*/
#define CSL_VPIF_INTCLR_FRAME2_NC        (0x00000000u)
#define CSL_VPIF_INTCLR_FRAME2_CLR       (0x00000001u)

#define CSL_VPIF_INTCLR_FRAME1_MASK      (0x00000002u)
#define CSL_VPIF_INTCLR_FRAME1_SHIFT     (0x00000001u)
#define CSL_VPIF_INTCLR_FRAME1_RESETVAL  (0x00000000u)
/*----FRAME1 Tokens----*/
#define CSL_VPIF_INTCLR_FRAME1_NC        (0x00000000u)
#define CSL_VPIF_INTCLR_FRAME1_CLR       (0x00000001u)

#define CSL_VPIF_INTCLR_FRAME0_MASK      (0x00000001u)
#define CSL_VPIF_INTCLR_FRAME0_SHIFT     (0x00000000u)
#define CSL_VPIF_INTCLR_FRAME0_RESETVAL  (0x00000000u)
/*----FRAME0 Tokens----*/
#define CSL_VPIF_INTCLR_FRAME0_NC        (0x00000000u)
#define CSL_VPIF_INTCLR_FRAME0_CLR       (0x00000001u)

#define CSL_VPIF_INTCLR_RESETVAL         (0x00000000u)

/* INTSTAT */


#define CSL_VPIF_INTSTAT_ERROR_MASK      (0x00000010u)
#define CSL_VPIF_INTSTAT_ERROR_SHIFT     (0x00000004u)
#define CSL_VPIF_INTSTAT_ERROR_RESETVAL  (0x00000000u)
/*----ERROR Tokens----*/
#define CSL_VPIF_INTSTAT_ERROR_NOPEND    (0x00000000u)
#define CSL_VPIF_INTSTAT_ERROR_PEND      (0x00000001u)

#define CSL_VPIF_INTSTAT_FRAME3_MASK     (0x00000008u)
#define CSL_VPIF_INTSTAT_FRAME3_SHIFT    (0x00000003u)
#define CSL_VPIF_INTSTAT_FRAME3_RESETVAL (0x00000000u)
/*----FRAME3 Tokens----*/
#define CSL_VPIF_INTSTAT_FRAME3_NOPEND   (0x00000000u)
#define CSL_VPIF_INTSTAT_FRAME3_PEND     (0x00000001u)

#define CSL_VPIF_INTSTAT_FRAME2_MASK     (0x00000004u)
#define CSL_VPIF_INTSTAT_FRAME2_SHIFT    (0x00000002u)
#define CSL_VPIF_INTSTAT_FRAME2_RESETVAL (0x00000000u)
/*----FRAME2 Tokens----*/
#define CSL_VPIF_INTSTAT_FRAME2_NOPEND   (0x00000000u)
#define CSL_VPIF_INTSTAT_FRAME2_PEND     (0x00000001u)

#define CSL_VPIF_INTSTAT_FRAME1_MASK     (0x00000002u)
#define CSL_VPIF_INTSTAT_FRAME1_SHIFT    (0x00000001u)
#define CSL_VPIF_INTSTAT_FRAME1_RESETVAL (0x00000000u)
/*----FRAME1 Tokens----*/
#define CSL_VPIF_INTSTAT_FRAME1_NOPEND   (0x00000000u)
#define CSL_VPIF_INTSTAT_FRAME1_PEND     (0x00000001u)

#define CSL_VPIF_INTSTAT_FRAME0_MASK     (0x00000001u)
#define CSL_VPIF_INTSTAT_FRAME0_SHIFT    (0x00000000u)
#define CSL_VPIF_INTSTAT_FRAME0_RESETVAL (0x00000000u)
/*----FRAME0 Tokens----*/
#define CSL_VPIF_INTSTAT_FRAME0_NOPEND   (0x00000000u)
#define CSL_VPIF_INTSTAT_FRAME0_PEND     (0x00000001u)

#define CSL_VPIF_INTSTAT_RESETVAL        (0x00000000u)

/* INTSTATCLR */


#define CSL_VPIF_INTSTATCLR_ERROR_MASK   (0x00000010u)
#define CSL_VPIF_INTSTATCLR_ERROR_SHIFT  (0x00000004u)
#define CSL_VPIF_INTSTATCLR_ERROR_RESETVAL (0x00000000u)
/*----ERROR Tokens----*/
#define CSL_VPIF_INTSTATCLR_ERROR_NC     (0x00000000u)
#define CSL_VPIF_INTSTATCLR_ERROR_CLR    (0x00000001u)

#define CSL_VPIF_INTSTATCLR_FRAME3_MASK  (0x00000008u)
#define CSL_VPIF_INTSTATCLR_FRAME3_SHIFT (0x00000003u)
#define CSL_VPIF_INTSTATCLR_FRAME3_RESETVAL (0x00000000u)
/*----FRAME3 Tokens----*/
#define CSL_VPIF_INTSTATCLR_FRAME3_NC    (0x00000000u)
#define CSL_VPIF_INTSTATCLR_FRAME3_CLR   (0x00000001u)

#define CSL_VPIF_INTSTATCLR_FRAME2_MASK  (0x00000004u)
#define CSL_VPIF_INTSTATCLR_FRAME2_SHIFT (0x00000002u)
#define CSL_VPIF_INTSTATCLR_FRAME2_RESETVAL (0x00000000u)
/*----FRAME2 Tokens----*/
#define CSL_VPIF_INTSTATCLR_FRAME2_NC    (0x00000000u)
#define CSL_VPIF_INTSTATCLR_FRAME2_CLR   (0x00000001u)

#define CSL_VPIF_INTSTATCLR_FRAME1_MASK  (0x00000002u)
#define CSL_VPIF_INTSTATCLR_FRAME1_SHIFT (0x00000001u)
#define CSL_VPIF_INTSTATCLR_FRAME1_RESETVAL (0x00000000u)
/*----FRAME1 Tokens----*/
#define CSL_VPIF_INTSTATCLR_FRAME1_NC    (0x00000000u)
#define CSL_VPIF_INTSTATCLR_FRAME1_CLR   (0x00000001u)

#define CSL_VPIF_INTSTATCLR_FRAME0_MASK  (0x00000001u)
#define CSL_VPIF_INTSTATCLR_FRAME0_SHIFT (0x00000000u)
#define CSL_VPIF_INTSTATCLR_FRAME0_RESETVAL (0x00000000u)
/*----FRAME0 Tokens----*/
#define CSL_VPIF_INTSTATCLR_FRAME0_NC    (0x00000000u)
#define CSL_VPIF_INTSTATCLR_FRAME0_CLR   (0x00000001u)

#define CSL_VPIF_INTSTATCLR_RESETVAL     (0x00000000u)

/* EMUCTRL */


#define CSL_VPIF_EMUCTRL_FREE_MASK       (0x00000001u)
#define CSL_VPIF_EMUCTRL_FREE_SHIFT      (0x00000000u)
#define CSL_VPIF_EMUCTRL_FREE_RESETVAL   (0x00000000u)
/*----FREE Tokens----*/
#define CSL_VPIF_EMUCTRL_FREE_SUSP       (0x00000000u)
#define CSL_VPIF_EMUCTRL_FREE_FREE       (0x00000001u)

#define CSL_VPIF_EMUCTRL_RESETVAL        (0x00000000u)

/* REQSIZE */


#define CSL_VPIF_REQSIZE_BYTES_MASK      (0x000001FFu)
#define CSL_VPIF_REQSIZE_BYTES_SHIFT     (0x00000000u)
#define CSL_VPIF_REQSIZE_BYTES_RESETVAL  (0x00000000u)
/*----BYTES Tokens----*/
#define CSL_VPIF_REQSIZE_BYTES_32        (0x00000020u)
#define CSL_VPIF_REQSIZE_BYTES_64        (0x00000040u)
#define CSL_VPIF_REQSIZE_BYTES_128       (0x00000080u)
#define CSL_VPIF_REQSIZE_BYTES_256       (0x00000100u)

#define CSL_VPIF_REQSIZE_RESETVAL        (0x00000000u)

/* C0TLUMA */

#define CSL_VPIF_C0TLUMA_TLUMA_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C0TLUMA_TLUMA_SHIFT   (0x00000000u)
#define CSL_VPIF_C0TLUMA_TLUMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C0TLUMA_RESETVAL        (0x00000000u)

/* C0BLUMA */

#define CSL_VPIF_C0BLUMA_BLUMA_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C0BLUMA_BLUMA_SHIFT   (0x00000000u)
#define CSL_VPIF_C0BLUMA_BLUMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C0BLUMA_RESETVAL        (0x00000000u)

/* C0TCHROMA */

#define CSL_VPIF_C0TCHROMA_TCHROMA_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C0TCHROMA_TCHROMA_SHIFT (0x00000000u)
#define CSL_VPIF_C0TCHROMA_TCHROMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C0TCHROMA_RESETVAL      (0x00000000u)

/* C0BCHROMA */

#define CSL_VPIF_C0BCHROMA_BCHROMA_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C0BCHROMA_BCHROMA_SHIFT (0x00000000u)
#define CSL_VPIF_C0BCHROMA_BCHROMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C0BCHROMA_RESETVAL      (0x00000000u)

/* C0THANC */

#define CSL_VPIF_C0THANC_THANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C0THANC_THANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C0THANC_THANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C0THANC_RESETVAL        (0x00000000u)

/* C0BHANC */

#define CSL_VPIF_C0BHANC_BHANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C0BHANC_BHANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C0BHANC_BHANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C0BHANC_RESETVAL        (0x00000000u)

/* C0TVANC */

#define CSL_VPIF_C0TVANC_TVANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C0TVANC_TVANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C0TVANC_TVANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C0TVANC_RESETVAL        (0x00000000u)

/* C0BVANC */

#define CSL_VPIF_C0BVANC_BVANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C0BVANC_BVANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C0BVANC_BVANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C0BVANC_RESETVAL        (0x00000000u)

/* C0IMGOFFSET */

#define CSL_VPIF_C0IMGOFFSET_IMGOFFSET_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C0IMGOFFSET_IMGOFFSET_SHIFT (0x00000000u)
#define CSL_VPIF_C0IMGOFFSET_IMGOFFSET_RESETVAL (0x00000000u)

#define CSL_VPIF_C0IMGOFFSET_RESETVAL    (0x00000000u)

/* C0HANCOFFSET */

#define CSL_VPIF_C0HANCOFFSET_HANCOFFSET_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C0HANCOFFSET_HANCOFFSET_SHIFT (0x00000000u)
#define CSL_VPIF_C0HANCOFFSET_HANCOFFSET_RESETVAL (0x00000000u)

#define CSL_VPIF_C0HANCOFFSET_RESETVAL   (0x00000000u)

/* C0HCFG */


#define CSL_VPIF_C0HCFG_EAV2SAV_MASK     (0x1FFF0000u)
#define CSL_VPIF_C0HCFG_EAV2SAV_SHIFT    (0x00000010u)
#define CSL_VPIF_C0HCFG_EAV2SAV_RESETVAL (0x00000000u)


#define CSL_VPIF_C0HCFG_SAV2EAV_MASK     (0x00001FFFu)
#define CSL_VPIF_C0HCFG_SAV2EAV_SHIFT    (0x00000000u)
#define CSL_VPIF_C0HCFG_SAV2EAV_RESETVAL (0x00000000u)

#define CSL_VPIF_C0HCFG_RESETVAL         (0x00000000u)

/* C0VCFG0 */


#define CSL_VPIF_C0VCFG0_L1_MASK         (0x0FFF0000u)
#define CSL_VPIF_C0VCFG0_L1_SHIFT        (0x00000010u)
#define CSL_VPIF_C0VCFG0_L1_RESETVAL     (0x00000000u)


#define CSL_VPIF_C0VCFG0_L3_MASK         (0x00000FFFu)
#define CSL_VPIF_C0VCFG0_L3_SHIFT        (0x00000000u)
#define CSL_VPIF_C0VCFG0_L3_RESETVAL     (0x00000000u)

#define CSL_VPIF_C0VCFG0_RESETVAL        (0x00000000u)

/* C0VCFG1 */


#define CSL_VPIF_C0VCFG1_L5_MASK         (0x0FFF0000u)
#define CSL_VPIF_C0VCFG1_L5_SHIFT        (0x00000010u)
#define CSL_VPIF_C0VCFG1_L5_RESETVAL     (0x00000000u)


#define CSL_VPIF_C0VCFG1_L7_MASK         (0x00000FFFu)
#define CSL_VPIF_C0VCFG1_L7_SHIFT        (0x00000000u)
#define CSL_VPIF_C0VCFG1_L7_RESETVAL     (0x00000000u)

#define CSL_VPIF_C0VCFG1_RESETVAL        (0x00000000u)

/* C0VCFG2 */


#define CSL_VPIF_C0VCFG2_L9_MASK         (0x0FFF0000u)
#define CSL_VPIF_C0VCFG2_L9_SHIFT        (0x00000010u)
#define CSL_VPIF_C0VCFG2_L9_RESETVAL     (0x00000000u)


#define CSL_VPIF_C0VCFG2_L11_MASK        (0x00000FFFu)
#define CSL_VPIF_C0VCFG2_L11_SHIFT       (0x00000000u)
#define CSL_VPIF_C0VCFG2_L11_RESETVAL    (0x00000000u)

#define CSL_VPIF_C0VCFG2_RESETVAL        (0x00000000u)

/* C0VSIZE */


#define CSL_VPIF_C0VSIZE_VSIZE_MASK      (0x00000FFFu)
#define CSL_VPIF_C0VSIZE_VSIZE_SHIFT     (0x00000000u)
#define CSL_VPIF_C0VSIZE_VSIZE_RESETVAL  (0x00000000u)

#define CSL_VPIF_C0VSIZE_RESETVAL        (0x00000000u)

/* C2TLUMA */

#define CSL_VPIF_C2TLUMA_TLUMA_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C2TLUMA_TLUMA_SHIFT   (0x00000000u)
#define CSL_VPIF_C2TLUMA_TLUMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C2TLUMA_RESETVAL        (0x00000000u)

/* C2BLUMA */

#define CSL_VPIF_C2BLUMA_BLUMA_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C2BLUMA_BLUMA_SHIFT   (0x00000000u)
#define CSL_VPIF_C2BLUMA_BLUMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BLUMA_RESETVAL        (0x00000000u)

/* C2TCHROMA */

#define CSL_VPIF_C2TCHROMA_TCHROMA_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C2TCHROMA_TCHROMA_SHIFT (0x00000000u)
#define CSL_VPIF_C2TCHROMA_TCHROMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C2TCHROMA_RESETVAL      (0x00000000u)

/* C2BCHROMA */

#define CSL_VPIF_C2BCHROMA_BCHROMA_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C2BCHROMA_BCHROMA_SHIFT (0x00000000u)
#define CSL_VPIF_C2BCHROMA_BCHROMA_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BCHROMA_RESETVAL      (0x00000000u)

/* C2THANC */

#define CSL_VPIF_C2THANC_THANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C2THANC_THANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C2THANC_THANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C2THANC_RESETVAL        (0x00000000u)

/* C2BHANC */

#define CSL_VPIF_C2BHANC_BHANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C2BHANC_BHANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C2BHANC_BHANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BHANC_RESETVAL        (0x00000000u)

/* C2TVANC */

#define CSL_VPIF_C2TVANC_TVANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C2TVANC_TVANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C2TVANC_TVANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C2TVANC_RESETVAL        (0x00000000u)

/* C2BVANC */

#define CSL_VPIF_C2BVANC_BVANC_MASK    (0xFFFFFFFFu)
#define CSL_VPIF_C2BVANC_BVANC_SHIFT   (0x00000000u)
#define CSL_VPIF_C2BVANC_BVANC_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BVANC_RESETVAL        (0x00000000u)

/* C2IMGOFFSET */

#define CSL_VPIF_C2IMGOFFSET_IMGOFFSET_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C2IMGOFFSET_IMGOFFSET_SHIFT (0x00000000u)
#define CSL_VPIF_C2IMGOFFSET_IMGOFFSET_RESETVAL (0x00000000u)

#define CSL_VPIF_C2IMGOFFSET_RESETVAL    (0x00000000u)

/* C2HANCOFFSET */

#define CSL_VPIF_C2HANCOFFSET_HANCOFFSET_MASK (0xFFFFFFFFu)
#define CSL_VPIF_C2HANCOFFSET_HANCOFFSET_SHIFT (0x00000000u)
#define CSL_VPIF_C2HANCOFFSET_HANCOFFSET_RESETVAL (0x00000000u)

#define CSL_VPIF_C2HANCOFFSET_RESETVAL   (0x00000000u)

/* C2HCFG */


#define CSL_VPIF_C2HCFG_EAV2SAV_MASK     (0x07FF0000u)
#define CSL_VPIF_C2HCFG_EAV2SAV_SHIFT    (0x00000010u)
#define CSL_VPIF_C2HCFG_EAV2SAV_RESETVAL (0x00000000u)


#define CSL_VPIF_C2HCFG_SAV2EAV_MASK     (0x000007FFu)
#define CSL_VPIF_C2HCFG_SAV2EAV_SHIFT    (0x00000000u)
#define CSL_VPIF_C2HCFG_SAV2EAV_RESETVAL (0x00000000u)

#define CSL_VPIF_C2HCFG_RESETVAL         (0x00000000u)

/* C2VCFG0 */


#define CSL_VPIF_C2VCFG0_L1_MASK         (0x07FF0000u)
#define CSL_VPIF_C2VCFG0_L1_SHIFT        (0x00000010u)
#define CSL_VPIF_C2VCFG0_L1_RESETVAL     (0x00000000u)


#define CSL_VPIF_C2VCFG0_L3_MASK         (0x000007FFu)
#define CSL_VPIF_C2VCFG0_L3_SHIFT        (0x00000000u)
#define CSL_VPIF_C2VCFG0_L3_RESETVAL     (0x00000000u)

#define CSL_VPIF_C2VCFG0_RESETVAL        (0x00000000u)

/* C2VCFG1 */


#define CSL_VPIF_C2VCFG1_L5_MASK         (0x07FF0000u)
#define CSL_VPIF_C2VCFG1_L5_SHIFT        (0x00000010u)
#define CSL_VPIF_C2VCFG1_L5_RESETVAL     (0x00000000u)


#define CSL_VPIF_C2VCFG1_L7_MASK         (0x000007FFu)
#define CSL_VPIF_C2VCFG1_L7_SHIFT        (0x00000000u)
#define CSL_VPIF_C2VCFG1_L7_RESETVAL     (0x00000000u)

#define CSL_VPIF_C2VCFG1_RESETVAL        (0x00000000u)

/* C2VCFG2 */


#define CSL_VPIF_C2VCFG2_L9_MASK         (0x07FF0000u)
#define CSL_VPIF_C2VCFG2_L9_SHIFT        (0x00000010u)
#define CSL_VPIF_C2VCFG2_L9_RESETVAL     (0x00000000u)


#define CSL_VPIF_C2VCFG2_L11_MASK        (0x000007FFu)
#define CSL_VPIF_C2VCFG2_L11_SHIFT       (0x00000000u)
#define CSL_VPIF_C2VCFG2_L11_RESETVAL    (0x00000000u)

#define CSL_VPIF_C2VCFG2_RESETVAL        (0x00000000u)

/* C2VSIZE */


#define CSL_VPIF_C2VSIZE_VSIZE_MASK      (0x000007FFu)
#define CSL_VPIF_C2VSIZE_VSIZE_SHIFT     (0x00000000u)
#define CSL_VPIF_C2VSIZE_VSIZE_RESETVAL  (0x00000000u)

#define CSL_VPIF_C2VSIZE_RESETVAL        (0x00000000u)

/* C2THANCPOS */


#define CSL_VPIF_C2THANCPOS_VPOS_MASK    (0x07FF0000u)
#define CSL_VPIF_C2THANCPOS_VPOS_SHIFT   (0x00000010u)
#define CSL_VPIF_C2THANCPOS_VPOS_RESETVAL (0x00000000u)


#define CSL_VPIF_C2THANCPOS_HPOS_MASK    (0x000007FFu)
#define CSL_VPIF_C2THANCPOS_HPOS_SHIFT   (0x00000000u)
#define CSL_VPIF_C2THANCPOS_HPOS_RESETVAL (0x00000000u)

#define CSL_VPIF_C2THANCPOS_RESETVAL     (0x00000000u)

/* C2THANCSIZE */


#define CSL_VPIF_C2THANCSIZE_VSIZE_MASK  (0x07FF0000u)
#define CSL_VPIF_C2THANCSIZE_VSIZE_SHIFT (0x00000010u)
#define CSL_VPIF_C2THANCSIZE_VSIZE_RESETVAL (0x00000000u)


#define CSL_VPIF_C2THANCSIZE_HSIZE_MASK  (0x000007FFu)
#define CSL_VPIF_C2THANCSIZE_HSIZE_SHIFT (0x00000000u)
#define CSL_VPIF_C2THANCSIZE_HSIZE_RESETVAL (0x00000000u)

#define CSL_VPIF_C2THANCSIZE_RESETVAL    (0x00000000u)

/* C2BHANCPOS */


#define CSL_VPIF_C2BHANCPOS_VPOS_MASK    (0x07FF0000u)
#define CSL_VPIF_C2BHANCPOS_VPOS_SHIFT   (0x00000010u)
#define CSL_VPIF_C2BHANCPOS_VPOS_RESETVAL (0x00000000u)


#define CSL_VPIF_C2BHANCPOS_HPOS_MASK    (0x000007FFu)
#define CSL_VPIF_C2BHANCPOS_HPOS_SHIFT   (0x00000000u)
#define CSL_VPIF_C2BHANCPOS_HPOS_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BHANCPOS_RESETVAL     (0x00000000u)

/* C2BHANCSIZE */


#define CSL_VPIF_C2BHANCSIZE_VSIZE_MASK  (0x07FF0000u)
#define CSL_VPIF_C2BHANCSIZE_VSIZE_SHIFT (0x00000010u)
#define CSL_VPIF_C2BHANCSIZE_VSIZE_RESETVAL (0x00000000u)


#define CSL_VPIF_C2BHANCSIZE_HSIZE_MASK  (0x000007FFu)
#define CSL_VPIF_C2BHANCSIZE_HSIZE_SHIFT (0x00000000u)
#define CSL_VPIF_C2BHANCSIZE_HSIZE_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BHANCSIZE_RESETVAL    (0x00000000u)

/* C2TVANCPOS */


#define CSL_VPIF_C2TVANCPOS_VPOS_MASK    (0x07FF0000u)
#define CSL_VPIF_C2TVANCPOS_VPOS_SHIFT   (0x00000010u)
#define CSL_VPIF_C2TVANCPOS_VPOS_RESETVAL (0x00000000u)


#define CSL_VPIF_C2TVANCPOS_HPOS_MASK    (0x000007FFu)
#define CSL_VPIF_C2TVANCPOS_HPOS_SHIFT   (0x00000000u)
#define CSL_VPIF_C2TVANCPOS_HPOS_RESETVAL (0x00000000u)

#define CSL_VPIF_C2TVANCPOS_RESETVAL     (0x00000000u)

/* C2TVANCSIZE */


#define CSL_VPIF_C2TVANCSIZE_VSIZE_MASK  (0x07FF0000u)
#define CSL_VPIF_C2TVANCSIZE_VSIZE_SHIFT (0x00000010u)
#define CSL_VPIF_C2TVANCSIZE_VSIZE_RESETVAL (0x00000000u)


#define CSL_VPIF_C2TVANCSIZE_HSIZE_MASK  (0x000007FFu)
#define CSL_VPIF_C2TVANCSIZE_HSIZE_SHIFT (0x00000000u)
#define CSL_VPIF_C2TVANCSIZE_HSIZE_RESETVAL (0x00000000u)

#define CSL_VPIF_C2TVANCSIZE_RESETVAL    (0x00000000u)

/* C2BVANCPOS */


#define CSL_VPIF_C2BVANCPOS_VPOS_MASK    (0x07FF0000u)
#define CSL_VPIF_C2BVANCPOS_VPOS_SHIFT   (0x00000010u)
#define CSL_VPIF_C2BVANCPOS_VPOS_RESETVAL (0x00000000u)


#define CSL_VPIF_C2BVANCPOS_HPOS_MASK    (0x000007FFu)
#define CSL_VPIF_C2BVANCPOS_HPOS_SHIFT   (0x00000000u)
#define CSL_VPIF_C2BVANCPOS_HPOS_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BVANCPOS_RESETVAL     (0x00000000u)

/* C2BVANCSIZE */


#define CSL_VPIF_C2BVANCSIZE_VSIZE_MASK  (0x07FF0000u)
#define CSL_VPIF_C2BVANCSIZE_VSIZE_SHIFT (0x00000010u)
#define CSL_VPIF_C2BVANCSIZE_VSIZE_RESETVAL (0x00000000u)


#define CSL_VPIF_C2BVANCSIZE_HSIZE_MASK  (0x000007FFu)
#define CSL_VPIF_C2BVANCSIZE_HSIZE_SHIFT (0x00000000u)
#define CSL_VPIF_C2BVANCSIZE_HSIZE_RESETVAL (0x00000000u)

#define CSL_VPIF_C2BVANCSIZE_RESETVAL    (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif
