#ifndef _CSLR__MMCSD_H_
#define _CSLR__MMCSD_H_

#include <csl/cslr.h>

#include "tistdtypes.h"


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 MMCCTL;
    volatile Uint32 MMCCLK;
    volatile Uint32 MMCST0;
    volatile Uint32 MMCST1;
    volatile Uint32 MMCIM;
    volatile Uint32 MMCTOR;
    volatile Uint32 MMCTOD;
    volatile Uint32 MMCBLEN;
    volatile Uint32 MMCNBLK;
    volatile Uint32 MMCNBLC;
    volatile Uint32 MMCDRR;
    volatile Uint32 MMCDXR;
    volatile Uint32 MMCCMD;
    volatile Uint32 MMCARGHL;
    volatile Uint32 MMCRSP01;
    volatile Uint32 MMCRSP23;
    volatile Uint32 MMCRSP45;
    volatile Uint32 MMCRSP67;
    volatile Uint32 MMCDRSP;
    volatile Uint8 RSVD0[4];
    volatile Uint32 MMCCIDX;
    volatile Uint8 RSVD1[16];
    volatile Uint32 SDIOCTL;
    volatile Uint32 SDIOST0;
    volatile Uint32 SDIOIEN;
    volatile Uint32 SDIOIST;
    volatile Uint32 MMCFIFOCTL;
} CSL_MmcsdRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_MmcsdRegs             *CSL_MmcsdRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* MMCCTL */


#define CSL_MMCSD_MMCCTL_PERMDX_MASK     (0x00000400u)
#define CSL_MMCSD_MMCCTL_PERMDX_SHIFT    (0x0000000Au)
#define CSL_MMCSD_MMCCTL_PERMDX_RESETVAL (0x00000000u)
/*----PERMDX Tokens----*/
#define CSL_MMCSD_MMCCTL_PERMDX_LEND     (0x00000000u)
#define CSL_MMCSD_MMCCTL_PERMDX_BEND     (0x00000001u)

#define CSL_MMCSD_MMCCTL_PERMDR_MASK     (0x00000200u)
#define CSL_MMCSD_MMCCTL_PERMDR_SHIFT    (0x00000009u)
#define CSL_MMCSD_MMCCTL_PERMDR_RESETVAL (0x00000000u)
/*----PERMDR Tokens----*/
#define CSL_MMCSD_MMCCTL_PERMDR_LEND     (0x00000000u)
#define CSL_MMCSD_MMCCTL_PERMDR_BEND     (0x00000001u)

/* WIDTH0 and WIDTH1 */


#define CSL_MMCSD_MMCCTL_WIDTH1_WIDTH0_MASK (0x0104u)
#define CSL_MMCSD_MMCCTL_WIDTH1_WIDTH0_SHIFT (0x0002u)
#define CSL_MMCSD_MMCCTL_WIDTH1_WIDTH0_RESETVAL (0x0000u)
/*----WIDTH1_WIDTH0 Tokens----*/
#define CSL_MMCSD_MMCCTL_WIDTH1_WIDTH0_1BIT (0x0000u)
#define CSL_MMCSD_MMCCTL_WIDTH1_WIDTH0_4BIT (0x0004u)
#define CSL_MMCSD_MMCCTL_WIDTH1_WIDTH0_8BIT (0x0100u)

/*NOTE : The WIDTH1 value should be used in conjunction
 with WIDTH0 to set appropriate data width*/
#define CSL_MMCSD_MMCCTL_WIDTH1_MASK       (0x00000100u)
#define CSL_MMCSD_MMCCTL_WIDTH1_SHIFT      (0x00000008u)
#define CSL_MMCSD_MMCCTL_WIDTH1_RESETVAL   (0x00000000u)
/*----WIDTH1 Tokens----*/
#define CSL_MMCSD_MMCCTL_WIDTH1_1BIT_4BIT  (0x00000000u)
#define CSL_MMCSD_MMCCTL_WIDTH1_8BIT       (0x00000100u)

#define CSL_MMCSD_MMCCTL_DATEG_MASK      (0x000000C0u)
#define CSL_MMCSD_MMCCTL_DATEG_SHIFT     (0x00000006u)
#define CSL_MMCSD_MMCCTL_DATEG_RESETVAL  (0x00000000u)
/*----DATEG Tokens----*/
#define CSL_MMCSD_MMCCTL_DATEG_DISABLE   (0x00000000u)
#define CSL_MMCSD_MMCCTL_DATEG_R_EDGE    (0x00000001u)
#define CSL_MMCSD_MMCCTL_DATEG_F_EDGE    (0x00000002u)
#define CSL_MMCSD_MMCCTL_DATEG_RF_EDGE   (0x00000003u)

/*NOTE : The WIDTH0 value should be used in conjunction
 with WIDTH1 to set appropriate data width*/
#define CSL_MMCSD_MMCCTL_WIDTH0_MASK       (0x00000004u)
#define CSL_MMCSD_MMCCTL_WIDTH0_SHIFT      (0x00000002u)
#define CSL_MMCSD_MMCCTL_WIDTH0_RESETVAL   (0x00000000u)
/*----WIDTH0 Tokens----*/
#define CSL_MMCSD_MMCCTL_WIDTH0_1BIT_8BIT  (0x00000000u)
#define CSL_MMCSD_MMCCTL_WIDTH0_4BIT       (0x00000004u)

#define CSL_MMCSD_MMCCTL_CMDRST_MASK     (0x00000002u)
#define CSL_MMCSD_MMCCTL_CMDRST_SHIFT    (0x00000001u)
#define CSL_MMCSD_MMCCTL_CMDRST_RESETVAL (0x00000000u)
/*----CMDRST Tokens----*/
#define CSL_MMCSD_MMCCTL_CMDRST_ENABLE   (0x00000000u)
#define CSL_MMCSD_MMCCTL_CMDRST_DISABLE  (0x00000001u)

#define CSL_MMCSD_MMCCTL_DATRST_MASK     (0x00000001u)
#define CSL_MMCSD_MMCCTL_DATRST_SHIFT    (0x00000000u)
#define CSL_MMCSD_MMCCTL_DATRST_RESETVAL (0x00000000u)
/*----DATRST Tokens----*/
#define CSL_MMCSD_MMCCTL_DATRST_ENABLE   (0x00000000u)
#define CSL_MMCSD_MMCCTL_DATRST_DISABLE  (0x00000001u)

#define CSL_MMCSD_MMCCTL_RESETVAL        (0x00000000u)

/* MMCCLK */


#define CSL_MMCSD_MMCCLK_DIV4_MASK       (0x00000200u)
#define CSL_MMCSD_MMCCLK_DIV4_SHIFT      (0x00000009u)
#define CSL_MMCSD_MMCCLK_DIV4_RESETVAL   (0x00000000u)
/*----DIV4 Tokens----*/
#define CSL_MMCSD_MMCCLK_DIV4_DISABLE    (0x00000000u)
#define CSL_MMCSD_MMCCLK_DIV4_ENABLE     (0x00000001u)

#define CSL_MMCSD_MMCCLK_CLKEN_MASK      (0x00000100u)
#define CSL_MMCSD_MMCCLK_CLKEN_SHIFT     (0x00000008u)
#define CSL_MMCSD_MMCCLK_CLKEN_RESETVAL  (0x00000000u)
/*----CLKEN Tokens----*/
#define CSL_MMCSD_MMCCLK_CLKEN_DISABLE   (0x00000000u)
#define CSL_MMCSD_MMCCLK_CLKEN_ENABLE    (0x00000001u)

#define CSL_MMCSD_MMCCLK_CLKRT_MASK      (0x000000FFu)
#define CSL_MMCSD_MMCCLK_CLKRT_SHIFT     (0x00000000u)
#define CSL_MMCSD_MMCCLK_CLKRT_RESETVAL  (0x000000FFu)

#define CSL_MMCSD_MMCCLK_RESETVAL        (0x000000FFu)

/* MMCST0 */


#define CSL_MMCSD_MMCST0_CCS_MASK        (0x00002000u)
#define CSL_MMCSD_MMCST0_CCS_SHIFT       (0x0000000Du)
#define CSL_MMCSD_MMCST0_CCS_RESETVAL    (0x00000000u)
/*----CCS Tokens----*/
#define CSL_MMCSD_MMCST0_CCS_NOT_COMPLETED (0x00000000u)
#define CSL_MMCSD_MMCST0_CCS_COMPLETED   (0x00000001u)

#define CSL_MMCSD_MMCST0_TRNDNE_MASK     (0x00001000u)
#define CSL_MMCSD_MMCST0_TRNDNE_SHIFT    (0x0000000Cu)
#define CSL_MMCSD_MMCST0_TRNDNE_RESETVAL (0x00000000u)
/*----TRNDNE Tokens----*/
#define CSL_MMCSD_MMCST0_TRNDNE_NOT_DONE (0x00000000u)
#define CSL_MMCSD_MMCST0_TRNDNE_DONE     (0x00000001u)

#define CSL_MMCSD_MMCST0_DATED_MASK      (0x00000800u)
#define CSL_MMCSD_MMCST0_DATED_SHIFT     (0x0000000Bu)
#define CSL_MMCSD_MMCST0_DATED_RESETVAL  (0x00000000u)
/*----DATED Tokens----*/
#define CSL_MMCSD_MMCST0_DATED_NOT_DETECTED (0x00000000u)
#define CSL_MMCSD_MMCST0_DATED_DETECTED  (0x00000001u)

#define CSL_MMCSD_MMCST0_DRRDY_MASK      (0x00000400u)
#define CSL_MMCSD_MMCST0_DRRDY_SHIFT     (0x0000000Au)
#define CSL_MMCSD_MMCST0_DRRDY_RESETVAL  (0x00000000u)
/*----DRRDY Tokens----*/
#define CSL_MMCSD_MMCST0_DRRDY_NOT_READY (0x00000000u)
#define CSL_MMCSD_MMCST0_DRRDY_READY     (0x00000001u)

#define CSL_MMCSD_MMCST0_DXRDY_MASK      (0x00000200u)
#define CSL_MMCSD_MMCST0_DXRDY_SHIFT     (0x00000009u)
#define CSL_MMCSD_MMCST0_DXRDY_RESETVAL  (0x00000001u)
/*----DXRDY Tokens----*/
#define CSL_MMCSD_MMCST0_DXRDY_NOT_READY (0x00000000u)
#define CSL_MMCSD_MMCST0_DXRDY_READY     (0x00000001u)


#define CSL_MMCSD_MMCST0_CRCRS_MASK      (0x00000080u)
#define CSL_MMCSD_MMCST0_CRCRS_SHIFT     (0x00000007u)
#define CSL_MMCSD_MMCST0_CRCRS_RESETVAL  (0x00000000u)
/*----CRCRS Tokens----*/
#define CSL_MMCSD_MMCST0_CRCRS_NOT_DETECTED (0x00000000u)
#define CSL_MMCSD_MMCST0_CRCRS_DETECTED  (0x00000001u)

#define CSL_MMCSD_MMCST0_CRCRD_MASK      (0x00000040u)
#define CSL_MMCSD_MMCST0_CRCRD_SHIFT     (0x00000006u)
#define CSL_MMCSD_MMCST0_CRCRD_RESETVAL  (0x00000000u)
/*----CRCRD Tokens----*/
#define CSL_MMCSD_MMCST0_CRCRD_NOT_DETECTED (0x00000000u)
#define CSL_MMCSD_MMCST0_CRCRD_DETECTED  (0x00000001u)

#define CSL_MMCSD_MMCST0_CRCWR_MASK      (0x00000020u)
#define CSL_MMCSD_MMCST0_CRCWR_SHIFT     (0x00000005u)
#define CSL_MMCSD_MMCST0_CRCWR_RESETVAL  (0x00000000u)
/*----CRCWR Tokens----*/
#define CSL_MMCSD_MMCST0_CRCWR_NOT_DETECTED (0x00000000u)
#define CSL_MMCSD_MMCST0_CRCWR_DETECTED  (0x00000001u)

#define CSL_MMCSD_MMCST0_TOUTRS_MASK     (0x00000010u)
#define CSL_MMCSD_MMCST0_TOUTRS_SHIFT    (0x00000004u)
#define CSL_MMCSD_MMCST0_TOUTRS_RESETVAL (0x00000000u)
/*----TOUTRS Tokens----*/
#define CSL_MMCSD_MMCST0_TOUTRS_NOT_OCCURRED (0x00000000u)
#define CSL_MMCSD_MMCST0_TOUTRS_OCCURRED (0x00000001u)

#define CSL_MMCSD_MMCST0_TOUTRD_MASK     (0x00000008u)
#define CSL_MMCSD_MMCST0_TOUTRD_SHIFT    (0x00000003u)
#define CSL_MMCSD_MMCST0_TOUTRD_RESETVAL (0x00000000u)
/*----TOUTRD Tokens----*/
#define CSL_MMCSD_MMCST0_TOUTRD_NOT_OCCURRED (0x00000000u)
#define CSL_MMCSD_MMCST0_TOUTRD_OCCURRED (0x00000001u)

#define CSL_MMCSD_MMCST0_RSPDNE_MASK     (0x00000004u)
#define CSL_MMCSD_MMCST0_RSPDNE_SHIFT    (0x00000002u)
#define CSL_MMCSD_MMCST0_RSPDNE_RESETVAL (0x00000000u)
/*----RSPDNE Tokens----*/
#define CSL_MMCSD_MMCST0_RSPDNE_NOT_RECEIVED (0x00000000u)
#define CSL_MMCSD_MMCST0_RSPDNE_RECEIVED (0x00000001u)

#define CSL_MMCSD_MMCST0_BSYDNE_MASK     (0x00000002u)
#define CSL_MMCSD_MMCST0_BSYDNE_SHIFT    (0x00000001u)
#define CSL_MMCSD_MMCST0_BSYDNE_RESETVAL (0x00000000u)
/*----BSYDNE Tokens----*/
#define CSL_MMCSD_MMCST0_BSYDNE_NOT_RELEASED (0x00000000u)
#define CSL_MMCSD_MMCST0_BSYDNE_RELEASED (0x00000001u)

#define CSL_MMCSD_MMCST0_DATDNE_MASK     (0x00000001u)
#define CSL_MMCSD_MMCST0_DATDNE_SHIFT    (0x00000000u)
#define CSL_MMCSD_MMCST0_DATDNE_RESETVAL (0x00000000u)
/*----DATDNE Tokens----*/
#define CSL_MMCSD_MMCST0_DATDNE_NOT_DONE (0x00000000u)
#define CSL_MMCSD_MMCST0_DATDNE_DONE     (0x00000001u)

#define CSL_MMCSD_MMCST0_RESETVAL        (0x00000200u)

/* MMCST1 */


#define CSL_MMCSD_MMCST1_FIFOFUL_MASK    (0x00000040u)
#define CSL_MMCSD_MMCST1_FIFOFUL_SHIFT   (0x00000006u)
#define CSL_MMCSD_MMCST1_FIFOFUL_RESETVAL (0x00000000u)
/*----FIFOFUL Tokens----*/
#define CSL_MMCSD_MMCST1_FIFOFUL_NOT_FULL (0x00000000u)
#define CSL_MMCSD_MMCST1_FIFOFUL_FULL    (0x00000001u)

#define CSL_MMCSD_MMCST1_FIFOEMP_MASK    (0x00000020u)
#define CSL_MMCSD_MMCST1_FIFOEMP_SHIFT   (0x00000005u)
#define CSL_MMCSD_MMCST1_FIFOEMP_RESETVAL (0x00000000u)
/*----FIFOEMP Tokens----*/
#define CSL_MMCSD_MMCST1_FIFOEMP_NOT_EMPTY (0x00000000u)
#define CSL_MMCSD_MMCST1_FIFOEMP_EMPTY   (0x00000001u)

#define CSL_MMCSD_MMCST1_DAT3ST_MASK     (0x00000010u)
#define CSL_MMCSD_MMCST1_DAT3ST_SHIFT    (0x00000004u)
#define CSL_MMCSD_MMCST1_DAT3ST_RESETVAL (0x00000000u)
/*----DAT3ST Tokens----*/
#define CSL_MMCSD_MMCST1_DAT3ST_LOW      (0x00000000u)
#define CSL_MMCSD_MMCST1_DAT3ST_HIGH     (0x00000001u)

#define CSL_MMCSD_MMCST1_DRFUL_MASK      (0x00000008u)
#define CSL_MMCSD_MMCST1_DRFUL_SHIFT     (0x00000003u)
#define CSL_MMCSD_MMCST1_DRFUL_RESETVAL  (0x00000000u)
/*----DRFUL Tokens----*/
#define CSL_MMCSD_MMCST1_DRFUL_NOT_FULL  (0x00000000u)
#define CSL_MMCSD_MMCST1_DRFUL_FULL      (0x00000001u)

#define CSL_MMCSD_MMCST1_DXEMP_MASK      (0x00000004u)
#define CSL_MMCSD_MMCST1_DXEMP_SHIFT     (0x00000002u)
#define CSL_MMCSD_MMCST1_DXEMP_RESETVAL  (0x00000000u)
/*----DXEMP Tokens----*/
#define CSL_MMCSD_MMCST1_DXEMP_NOT_EMPTY (0x00000000u)
#define CSL_MMCSD_MMCST1_DXEMP_EMPTY     (0x00000001u)

#define CSL_MMCSD_MMCST1_CLKSTP_MASK     (0x00000002u)
#define CSL_MMCSD_MMCST1_CLKSTP_SHIFT    (0x00000001u)
#define CSL_MMCSD_MMCST1_CLKSTP_RESETVAL (0x00000001u)
/*----CLKSTP Tokens----*/
#define CSL_MMCSD_MMCST1_CLKSTP_LOW      (0x00000000u)
#define CSL_MMCSD_MMCST1_CLKSTP_HIGH     (0x00000001u)

#define CSL_MMCSD_MMCST1_BUSY_MASK       (0x00000001u)
#define CSL_MMCSD_MMCST1_BUSY_SHIFT      (0x00000000u)
#define CSL_MMCSD_MMCST1_BUSY_RESETVAL   (0x00000000u)
/*----BUSY Tokens----*/
#define CSL_MMCSD_MMCST1_BUSY_NOT_DETECTED (0x00000000u)
#define CSL_MMCSD_MMCST1_BUSY_DETECTED   (0x00000001u)

#define CSL_MMCSD_MMCST1_RESETVAL        (0x00000002u)

/* MMCIM */


#define CSL_MMCSD_MMCIM_ECCS_MASK        (0x00002000u)
#define CSL_MMCSD_MMCIM_ECCS_SHIFT       (0x0000000Du)
#define CSL_MMCSD_MMCIM_ECCS_RESETVAL    (0x00000000u)
/*----ECCS Tokens----*/
#define CSL_MMCSD_MMCIM_ECCS_PROHIBIT    (0x00000000u)
#define CSL_MMCSD_MMCIM_ECCS_PERMIT      (0x00000001u)

#define CSL_MMCSD_MMCIM_ETRNDNE_MASK     (0x00001000u)
#define CSL_MMCSD_MMCIM_ETRNDNE_SHIFT    (0x0000000Cu)
#define CSL_MMCSD_MMCIM_ETRNDNE_RESETVAL (0x00000000u)
/*----ETRNDNE Tokens----*/
#define CSL_MMCSD_MMCIM_ETRNDNE_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_ETRNDNE_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_EDATED_MASK      (0x00000800u)
#define CSL_MMCSD_MMCIM_EDATED_SHIFT     (0x0000000Bu)
#define CSL_MMCSD_MMCIM_EDATED_RESETVAL  (0x00000000u)
/*----EDATED Tokens----*/
#define CSL_MMCSD_MMCIM_EDATED_PROHIBIT  (0x00000000u)
#define CSL_MMCSD_MMCIM_EDATED_PERMIT    (0x00000001u)

#define CSL_MMCSD_MMCIM_EDRRDY_MASK      (0x00000400u)
#define CSL_MMCSD_MMCIM_EDRRDY_SHIFT     (0x0000000Au)
#define CSL_MMCSD_MMCIM_EDRRDY_RESETVAL  (0x00000000u)
/*----EDRRDY Tokens----*/
#define CSL_MMCSD_MMCIM_EDRRDY_PROHIBIT  (0x00000000u)
#define CSL_MMCSD_MMCIM_EDRRDY_PERMIT    (0x00000001u)

#define CSL_MMCSD_MMCIM_EDXRDY_MASK      (0x00000200u)
#define CSL_MMCSD_MMCIM_EDXRDY_SHIFT     (0x00000009u)
#define CSL_MMCSD_MMCIM_EDXRDY_RESETVAL  (0x00000000u)
/*----EDXRDY Tokens----*/
#define CSL_MMCSD_MMCIM_EDXRDY_PROHIBIT  (0x00000000u)
#define CSL_MMCSD_MMCIM_EDXRDY_PERMIT    (0x00000001u)

#define CSL_MMCSD_MMCIM_ESPIERR_MASK     (0x00000100u)
#define CSL_MMCSD_MMCIM_ESPIERR_SHIFT    (0x00000008u)
#define CSL_MMCSD_MMCIM_ESPIERR_RESETVAL (0x00000000u)
/*----ESPIERR Tokens----*/
#define CSL_MMCSD_MMCIM_ESPIERR_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_ESPIERR_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_ECRCRS_MASK      (0x00000080u)
#define CSL_MMCSD_MMCIM_ECRCRS_SHIFT     (0x00000007u)
#define CSL_MMCSD_MMCIM_ECRCRS_RESETVAL  (0x00000000u)
/*----ECRCRS Tokens----*/
#define CSL_MMCSD_MMCIM_ECRCRS_PROHIBIT  (0x00000000u)
#define CSL_MMCSD_MMCIM_ECRCRS_PERMIT    (0x00000001u)

#define CSL_MMCSD_MMCIM_ECRCRD_MASK      (0x00000040u)
#define CSL_MMCSD_MMCIM_ECRCRD_SHIFT     (0x00000006u)
#define CSL_MMCSD_MMCIM_ECRCRD_RESETVAL  (0x00000000u)
/*----ECRCRD Tokens----*/
#define CSL_MMCSD_MMCIM_ECRCRD_PROHIBIT  (0x00000000u)
#define CSL_MMCSD_MMCIM_ECRCRD_PERMIT    (0x00000001u)

#define CSL_MMCSD_MMCIM_ECRCWR_MASK      (0x00000020u)
#define CSL_MMCSD_MMCIM_ECRCWR_SHIFT     (0x00000005u)
#define CSL_MMCSD_MMCIM_ECRCWR_RESETVAL  (0x00000000u)
/*----ECRCWR Tokens----*/
#define CSL_MMCSD_MMCIM_ECRCWR_PROHIBIT  (0x00000000u)
#define CSL_MMCSD_MMCIM_ECRCWR_PERMIT    (0x00000001u)

#define CSL_MMCSD_MMCIM_ETOUTRS_MASK     (0x00000010u)
#define CSL_MMCSD_MMCIM_ETOUTRS_SHIFT    (0x00000004u)
#define CSL_MMCSD_MMCIM_ETOUTRS_RESETVAL (0x00000000u)
/*----ETOUTRS Tokens----*/
#define CSL_MMCSD_MMCIM_ETOUTRS_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_ETOUTRS_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_ETOUTRD_MASK     (0x00000008u)
#define CSL_MMCSD_MMCIM_ETOUTRD_SHIFT    (0x00000003u)
#define CSL_MMCSD_MMCIM_ETOUTRD_RESETVAL (0x00000000u)
/*----ETOUTRD Tokens----*/
#define CSL_MMCSD_MMCIM_ETOUTRD_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_ETOUTRD_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_ERSPDNE_MASK     (0x00000004u)
#define CSL_MMCSD_MMCIM_ERSPDNE_SHIFT    (0x00000002u)
#define CSL_MMCSD_MMCIM_ERSPDNE_RESETVAL (0x00000000u)
/*----ERSPDNE Tokens----*/
#define CSL_MMCSD_MMCIM_ERSPDNE_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_ERSPDNE_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_EBSYDNE_MASK     (0x00000002u)
#define CSL_MMCSD_MMCIM_EBSYDNE_SHIFT    (0x00000001u)
#define CSL_MMCSD_MMCIM_EBSYDNE_RESETVAL (0x00000000u)
/*----EBSYDNE Tokens----*/
#define CSL_MMCSD_MMCIM_EBSYDNE_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_EBSYDNE_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_EDATDNE_MASK     (0x00000001u)
#define CSL_MMCSD_MMCIM_EDATDNE_SHIFT    (0x00000000u)
#define CSL_MMCSD_MMCIM_EDATDNE_RESETVAL (0x00000000u)
/*----EDATDNE Tokens----*/
#define CSL_MMCSD_MMCIM_EDATDNE_PROHIBIT (0x00000000u)
#define CSL_MMCSD_MMCIM_EDATDNE_PERMIT   (0x00000001u)

#define CSL_MMCSD_MMCIM_RESETVAL         (0x00000000u)

/* MMCTOR */


#define CSL_MMCSD_MMCTOR_TOD_25_16_MASK  (0x0003FF00u)
#define CSL_MMCSD_MMCTOR_TOD_25_16_SHIFT (0x00000008u)
#define CSL_MMCSD_MMCTOR_TOD_25_16_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCTOR_TOR_MASK        (0x000000FFu)
#define CSL_MMCSD_MMCTOR_TOR_SHIFT       (0x00000000u)
#define CSL_MMCSD_MMCTOR_TOR_RESETVAL    (0x00000000u)

#define CSL_MMCSD_MMCTOR_RESETVAL        (0x00000000u)

/* MMCTOD */


#define CSL_MMCSD_MMCTOD_TOD_15_0_MASK   (0x0000FFFFu)
#define CSL_MMCSD_MMCTOD_TOD_15_0_SHIFT  (0x00000000u)
#define CSL_MMCSD_MMCTOD_TOD_15_0_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCTOD_RESETVAL        (0x00000000u)

/* MMCBLEN */


#define CSL_MMCSD_MMCBLEN_BLEN_MASK      (0x00000FFFu)
#define CSL_MMCSD_MMCBLEN_BLEN_SHIFT     (0x00000000u)
#define CSL_MMCSD_MMCBLEN_BLEN_RESETVAL  (0x00000200u)

#define CSL_MMCSD_MMCBLEN_RESETVAL       (0x00000200u)

/* MMCNBLK */


#define CSL_MMCSD_MMCNBLK_NBLK_MASK      (0x0000FFFFu)
#define CSL_MMCSD_MMCNBLK_NBLK_SHIFT     (0x00000000u)
#define CSL_MMCSD_MMCNBLK_NBLK_RESETVAL  (0x00000000u)

#define CSL_MMCSD_MMCNBLK_RESETVAL       (0x00000000u)

/* MMCNBLC */


#define CSL_MMCSD_MMCNBLC_NBLC_MASK      (0x0000FFFFu)
#define CSL_MMCSD_MMCNBLC_NBLC_SHIFT     (0x00000000u)
#define CSL_MMCSD_MMCNBLC_NBLC_RESETVAL  (0x0000FFFFu)

#define CSL_MMCSD_MMCNBLC_RESETVAL       (0x0000FFFFu)

/* MMCDRR */

#define CSL_MMCSD_MMCDRR_DRR_MASK        (0xFFFFFFFFu)
#define CSL_MMCSD_MMCDRR_DRR_SHIFT       (0x00000000u)
#define CSL_MMCSD_MMCDRR_DRR_RESETVAL    (0x00000000u)

#define CSL_MMCSD_MMCDRR_RESETVAL        (0x00000000u)

/* MMCDXR */

#define CSL_MMCSD_MMCDXR_DXR_MASK        (0xFFFFFFFFu)
#define CSL_MMCSD_MMCDXR_DXR_SHIFT       (0x00000000u)
#define CSL_MMCSD_MMCDXR_DXR_RESETVAL    (0x00000000u)

#define CSL_MMCSD_MMCDXR_RESETVAL        (0x00000000u)

/* MMCCMD */


#define CSL_MMCSD_MMCCMD_DMATRIG_MASK    (0x00010000u)
#define CSL_MMCSD_MMCCMD_DMATRIG_SHIFT   (0x00000010u)
#define CSL_MMCSD_MMCCMD_DMATRIG_RESETVAL (0x00000000u)
/*----DMATRIG Tokens----*/
#define CSL_MMCSD_MMCCMD_DMATRIG_NO      (0x00000000u)
#define CSL_MMCSD_MMCCMD_DMATRIG_YES     (0x00000001u)

#define CSL_MMCSD_MMCCMD_DCLR_MASK       (0x00008000u)
#define CSL_MMCSD_MMCCMD_DCLR_SHIFT      (0x0000000Fu)
#define CSL_MMCSD_MMCCMD_DCLR_RESETVAL   (0x00000000u)
/*----DCLR Tokens----*/
#define CSL_MMCSD_MMCCMD_DCLR_NO         (0x00000000u)
#define CSL_MMCSD_MMCCMD_DCLR_CLEAR      (0x00000001u)

#define CSL_MMCSD_MMCCMD_INITCK_MASK     (0x00004000u)
#define CSL_MMCSD_MMCCMD_INITCK_SHIFT    (0x0000000Eu)
#define CSL_MMCSD_MMCCMD_INITCK_RESETVAL (0x00000000u)
/*----INITCK Tokens----*/
#define CSL_MMCSD_MMCCMD_INITCK_NO       (0x00000000u)
#define CSL_MMCSD_MMCCMD_INITCK_INIT     (0x00000001u)

#define CSL_MMCSD_MMCCMD_WDATX_MASK      (0x00002000u)
#define CSL_MMCSD_MMCCMD_WDATX_SHIFT     (0x0000000Du)
#define CSL_MMCSD_MMCCMD_WDATX_RESETVAL  (0x00000000u)
/*----WDATX Tokens----*/
#define CSL_MMCSD_MMCCMD_WDATX_NO        (0x00000000u)
#define CSL_MMCSD_MMCCMD_WDATX_DATA      (0x00000001u)

#define CSL_MMCSD_MMCCMD_STRMTP_MASK     (0x00001000u)
#define CSL_MMCSD_MMCCMD_STRMTP_SHIFT    (0x0000000Cu)
#define CSL_MMCSD_MMCCMD_STRMTP_RESETVAL (0x00000000u)
/*----STRMTP Tokens----*/
#define CSL_MMCSD_MMCCMD_STRMTP_BLOCK    (0x00000000u)
#define CSL_MMCSD_MMCCMD_STRMTP_STREAM   (0x00000001u)
#define CSL_MMCSD_MMCCMD_STRMTP_NO       (0x00000000u)

#define CSL_MMCSD_MMCCMD_DTRW_MASK       (0x00000800u)
#define CSL_MMCSD_MMCCMD_DTRW_SHIFT      (0x0000000Bu)
#define CSL_MMCSD_MMCCMD_DTRW_RESETVAL   (0x00000000u)
/*----DTRW Tokens----*/
#define CSL_MMCSD_MMCCMD_DTRW_READ       (0x00000000u)
#define CSL_MMCSD_MMCCMD_DTRW_WRITE      (0x00000001u)
#define CSL_MMCSD_MMCCMD_DTRW_NO         (0x00000000u)

#define CSL_MMCSD_MMCCMD_RSPFMT_MASK     (0x00000600u)
#define CSL_MMCSD_MMCCMD_RSPFMT_SHIFT    (0x00000009u)
#define CSL_MMCSD_MMCCMD_RSPFMT_RESETVAL (0x00000000u)
/*----RSPFMT Tokens----*/
#define CSL_MMCSD_MMCCMD_RSPFMT_NORSP    (0x00000000u)
#define CSL_MMCSD_MMCCMD_RSPFMT_R1       (0x00000001u)
#define CSL_MMCSD_MMCCMD_RSPFMT_R2       (0x00000002u)
#define CSL_MMCSD_MMCCMD_RSPFMT_R3       (0x00000003u)
#define CSL_MMCSD_MMCCMD_RSPFMT_R4       (0x00000001u)
#define CSL_MMCSD_MMCCMD_RSPFMT_R5       (0x00000001u)
#define CSL_MMCSD_MMCCMD_RSPFMT_R6       (0x00000001u)

#define CSL_MMCSD_MMCCMD_BSYEXP_MASK     (0x00000100u)
#define CSL_MMCSD_MMCCMD_BSYEXP_SHIFT    (0x00000008u)
#define CSL_MMCSD_MMCCMD_BSYEXP_RESETVAL (0x00000000u)
/*----BSYEXP Tokens----*/
#define CSL_MMCSD_MMCCMD_BSYEXP_NO       (0x00000000u)
#define CSL_MMCSD_MMCCMD_BSYEXP_BUSY     (0x00000001u)

#define CSL_MMCSD_MMCCMD_PPLEN_MASK      (0x00000080u)
#define CSL_MMCSD_MMCCMD_PPLEN_SHIFT     (0x00000007u)
#define CSL_MMCSD_MMCCMD_PPLEN_RESETVAL  (0x00000000u)
/*----PPLEN Tokens----*/
#define CSL_MMCSD_MMCCMD_PPLEN_OD        (0x00000000u)
#define CSL_MMCSD_MMCCMD_PPLEN_PP        (0x00000001u)


#define CSL_MMCSD_MMCCMD_CMD_MASK        (0x0000003Fu)
#define CSL_MMCSD_MMCCMD_CMD_SHIFT       (0x00000000u)
#define CSL_MMCSD_MMCCMD_CMD_RESETVAL    (0x00000000u)

#define CSL_MMCSD_MMCCMD_RESETVAL        (0x00000000u)

/* MMCARGHL */

#define CSL_MMCSD_MMCARGHL_ARGH_MASK     (0xFFFF0000u)
#define CSL_MMCSD_MMCARGHL_ARGH_SHIFT    (0x00000010u)
#define CSL_MMCSD_MMCARGHL_ARGH_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCARGHL_ARGL_MASK     (0x0000FFFFu)
#define CSL_MMCSD_MMCARGHL_ARGL_SHIFT    (0x00000000u)
#define CSL_MMCSD_MMCARGHL_ARGL_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCARGHL_RESETVAL      (0x00000000u)

/* MMCRSP01 */

#define CSL_MMCSD_MMCRSP01_MMCRSP1_MASK  (0xFFFF0000u)
#define CSL_MMCSD_MMCRSP01_MMCRSP1_SHIFT (0x00000010u)
#define CSL_MMCSD_MMCRSP01_MMCRSP1_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP01_MMCRSP0_MASK  (0x0000FFFFu)
#define CSL_MMCSD_MMCRSP01_MMCRSP0_SHIFT (0x00000000u)
#define CSL_MMCSD_MMCRSP01_MMCRSP0_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP01_RESETVAL      (0x00000000u)

/* MMCRSP23 */

#define CSL_MMCSD_MMCRSP23_MMCRSP3_MASK  (0xFFFF0000u)
#define CSL_MMCSD_MMCRSP23_MMCRSP3_SHIFT (0x00000010u)
#define CSL_MMCSD_MMCRSP23_MMCRSP3_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP23_MMCRSP2_MASK  (0x0000FFFFu)
#define CSL_MMCSD_MMCRSP23_MMCRSP2_SHIFT (0x00000000u)
#define CSL_MMCSD_MMCRSP23_MMCRSP2_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP23_RESETVAL      (0x00000000u)

/* MMCRSP45 */

#define CSL_MMCSD_MMCRSP45_MMCRSP5_MASK  (0xFFFF0000u)
#define CSL_MMCSD_MMCRSP45_MMCRSP5_SHIFT (0x00000010u)
#define CSL_MMCSD_MMCRSP45_MMCRSP5_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP45_MMCRSP4_MASK  (0x0000FFFFu)
#define CSL_MMCSD_MMCRSP45_MMCRSP4_SHIFT (0x00000000u)
#define CSL_MMCSD_MMCRSP45_MMCRSP4_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP45_RESETVAL      (0x00000000u)

/* MMCRSP67 */

#define CSL_MMCSD_MMCRSP67_MMCRSP7_MASK  (0xFFFF0000u)
#define CSL_MMCSD_MMCRSP67_MMCRSP7_SHIFT (0x00000010u)
#define CSL_MMCSD_MMCRSP67_MMCRSP7_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP67_MMCRSP6_MASK  (0x0000FFFFu)
#define CSL_MMCSD_MMCRSP67_MMCRSP6_SHIFT (0x00000000u)
#define CSL_MMCSD_MMCRSP67_MMCRSP6_RESETVAL (0x00000000u)

#define CSL_MMCSD_MMCRSP67_RESETVAL      (0x00000000u)

/* MMCDRSP */


#define CSL_MMCSD_MMCDRSP_DRSP_MASK      (0x000000FFu)
#define CSL_MMCSD_MMCDRSP_DRSP_SHIFT     (0x00000000u)
#define CSL_MMCSD_MMCDRSP_DRSP_RESETVAL  (0x00000000u)

#define CSL_MMCSD_MMCDRSP_RESETVAL       (0x00000000u)

/* MMCCIDX */


#define CSL_MMCSD_MMCCIDX_STRT_MASK      (0x00000080u)
#define CSL_MMCSD_MMCCIDX_STRT_SHIFT     (0x00000007u)
#define CSL_MMCSD_MMCCIDX_STRT_RESETVAL  (0x00000000u)

#define CSL_MMCSD_MMCCIDX_XMIT_MASK      (0x00000040u)
#define CSL_MMCSD_MMCCIDX_XMIT_SHIFT     (0x00000006u)
#define CSL_MMCSD_MMCCIDX_XMIT_RESETVAL  (0x00000000u)

#define CSL_MMCSD_MMCCIDX_CIDX_MASK      (0x0000003Fu)
#define CSL_MMCSD_MMCCIDX_CIDX_SHIFT     (0x00000000u)
#define CSL_MMCSD_MMCCIDX_CIDX_RESETVAL  (0x00000000u)

#define CSL_MMCSD_MMCCIDX_RESETVAL       (0x00000000u)

/* SDIOCTL */


#define CSL_MMCSD_SDIOCTL_RDWTCR_MASK    (0x00000002u)
#define CSL_MMCSD_SDIOCTL_RDWTCR_SHIFT   (0x00000001u)
#define CSL_MMCSD_SDIOCTL_RDWTCR_RESETVAL (0x00000000u)
/*----RDWTCR Tokens----*/
#define CSL_MMCSD_SDIOCTL_RDWTCR_DISABLE (0x00000000u)
#define CSL_MMCSD_SDIOCTL_RDWTCR_ENABLE  (0x00000001u)

#define CSL_MMCSD_SDIOCTL_RDWTRQ_MASK    (0x00000001u)
#define CSL_MMCSD_SDIOCTL_RDWTRQ_SHIFT   (0x00000000u)
#define CSL_MMCSD_SDIOCTL_RDWTRQ_RESETVAL (0x00000000u)
/*----RDWTRQ Tokens----*/
#define CSL_MMCSD_SDIOCTL_RDWTRQ_DISABLE (0x00000000u)
#define CSL_MMCSD_SDIOCTL_RDWTRQ_ENABLE  (0x00000001u)

#define CSL_MMCSD_SDIOCTL_RESETVAL       (0x00000000u)

/* SDIOST0 */


#define CSL_MMCSD_SDIOST0_RDWTST_MASK    (0x00000004u)
#define CSL_MMCSD_SDIOST0_RDWTST_SHIFT   (0x00000002u)
#define CSL_MMCSD_SDIOST0_RDWTST_RESETVAL (0x00000000u)
/*----RDWTST Tokens----*/
#define CSL_MMCSD_SDIOST0_RDWTST_CLEAR   (0x00000000u)
#define CSL_MMCSD_SDIOST0_RDWTST_SET     (0x00000001u)

#define CSL_MMCSD_SDIOST0_INTPRD_MASK    (0x00000002u)
#define CSL_MMCSD_SDIOST0_INTPRD_SHIFT   (0x00000001u)
#define CSL_MMCSD_SDIOST0_INTPRD_RESETVAL (0x00000000u)
/*----INTPRD Tokens----*/
#define CSL_MMCSD_SDIOST0_INTPRD_CLEAR   (0x00000000u)
#define CSL_MMCSD_SDIOST0_INTPRD_SET     (0x00000001u)

#define CSL_MMCSD_SDIOST0_DAT1_MASK      (0x00000001u)
#define CSL_MMCSD_SDIOST0_DAT1_SHIFT     (0x00000000u)
#define CSL_MMCSD_SDIOST0_DAT1_RESETVAL  (0x00000001u)
/*----DAT1 Tokens----*/
#define CSL_MMCSD_SDIOST0_DAT1_CLEAR     (0x00000000u)
#define CSL_MMCSD_SDIOST0_DAT1_SET       (0x00000001u)

#define CSL_MMCSD_SDIOST0_RESETVAL       (0x00000001u)

/* SDIOIEN */


#define CSL_MMCSD_SDIOIEN_RWSEN_MASK     (0x00000002u)
#define CSL_MMCSD_SDIOIEN_RWSEN_SHIFT    (0x00000001u)
#define CSL_MMCSD_SDIOIEN_RWSEN_RESETVAL (0x00000000u)
/*----RWSEN Tokens----*/
#define CSL_MMCSD_SDIOIEN_RWSEN_DISABLE  (0x00000000u)
#define CSL_MMCSD_SDIOIEN_RWSEN_ENABLE   (0x00000001u)

#define CSL_MMCSD_SDIOIEN_IOINTEN_MASK   (0x00000001u)
#define CSL_MMCSD_SDIOIEN_IOINTEN_SHIFT  (0x00000000u)
#define CSL_MMCSD_SDIOIEN_IOINTEN_RESETVAL (0x00000000u)
/*----IOINTEN Tokens----*/
#define CSL_MMCSD_SDIOIEN_IOINTEN_DISABLE (0x00000000u)
#define CSL_MMCSD_SDIOIEN_IOINTEN_ENABLE (0x00000001u)

#define CSL_MMCSD_SDIOIEN_RESETVAL       (0x00000000u)

/* SDIOIST */


#define CSL_MMCSD_SDIOIST_RWS_MASK       (0x00000002u)
#define CSL_MMCSD_SDIOIST_RWS_SHIFT      (0x00000001u)
#define CSL_MMCSD_SDIOIST_RWS_RESETVAL   (0x00000000u)
/*----RWS Tokens----*/
#define CSL_MMCSD_SDIOIST_RWS_CLEAR      (0x00000000u)
#define CSL_MMCSD_SDIOIST_RWS_SET        (0x00000001u)

#define CSL_MMCSD_SDIOIST_IOINT_MASK     (0x00000001u)
#define CSL_MMCSD_SDIOIST_IOINT_SHIFT    (0x00000000u)
#define CSL_MMCSD_SDIOIST_IOINT_RESETVAL (0x00000000u)
/*----IOINT Tokens----*/
#define CSL_MMCSD_SDIOIST_IOINT_CLEAR    (0x00000000u)
#define CSL_MMCSD_SDIOIST_IOINT_SET      (0x00000001u)

#define CSL_MMCSD_SDIOIST_RESETVAL       (0x00000000u)

/* MMCFIFOCTL */


#define CSL_MMCSD_MMCFIFOCTL_ACCWD_MASK  (0x00000018u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_SHIFT (0x00000003u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_RESETVAL (0x00000000u)
/*----ACCWD Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_4BYTES (0x00000000u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_3BYTES (0x00000001u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_2BYTES (0x00000002u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_1BYTE (0x00000003u)

#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_MASK (0x00000004u)
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_SHIFT (0x00000002u)
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_RESETVAL (0x00000000u)
/*----FIFOLEV Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_256BIT (0x00000000u)
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_512BIT (0x00000001u)

#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_MASK (0x00000002u)
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_SHIFT (0x00000001u)
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_RESETVAL (0x00000000u)
/*----FIFODIR Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_READ (0x00000000u)
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_WRITE (0x00000001u)

#define CSL_MMCSD_MMCFIFOCTL_FIFORST_MASK (0x00000001u)
#define CSL_MMCSD_MMCFIFOCTL_FIFORST_SHIFT (0x00000000u)
#define CSL_MMCSD_MMCFIFOCTL_FIFORST_RESETVAL (0x00000000u)
/*----FIFORST Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_FIFORST_RESET (0x00000001u)

#define CSL_MMCSD_MMCFIFOCTL_RESETVAL    (0x00000000u)

#endif
