/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_mcbsp.h
*
* Brief: This file contains the Register Description for mcbsp
*
*********************************************************************/
#ifndef _CSLR_MCBSP_H_
#define _CSLR_MCBSP_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl/cslr.h>
#include "tistdtypes.h"

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 DRR;
    volatile Uint32 DXR;
    volatile Uint32 SPCR;
    volatile Uint32 RCR;
    volatile Uint32 XCR;
    volatile Uint32 SRGR;
    volatile Uint32 MCR;
    volatile Uint32 RCERE0;
    volatile Uint32 XCERE0;
    volatile Uint32 PCR;
    volatile Uint32 RCERE1;
    volatile Uint32 XCERE1;
    volatile Uint32 RCERE2;
    volatile Uint32 XCERE2;
    volatile Uint32 RCERE3;
    volatile Uint32 XCERE3;
} CSL_McbspRegs;


/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint8 RSVD0[12];
    volatile Uint32 WFIFOCTL;
    volatile Uint32 WFIFOSTS;
    volatile Uint32 RFIFOCTL;
    volatile Uint32 RFIFOSTS;
} CSL_BfifoRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 DATA_PORT;
    volatile Uint32 RSVD_04;
    volatile Uint32 RSVD_08;
    volatile Uint32 RSVD_0C;
} CSL_BdataRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_McbspRegs          *CSL_McbspRegsOvly;
typedef volatile CSL_BfifoRegs          *CSL_BfifoRegsOvly;
typedef volatile CSL_BdataRegs          *CSL_BdataRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DRR */

#define CSL_MCBSP_DRR_DRR_MASK           (0xFFFFFFFFu)
#define CSL_MCBSP_DRR_DRR_SHIFT          (0x00000000u)
#define CSL_MCBSP_DRR_DRR_RESETVAL       (0x00000000u)

#define CSL_MCBSP_DRR_RESETVAL           (0x00000000u)

/* DXR */

#define CSL_MCBSP_DXR_DXR_MASK           (0xFFFFFFFFu)
#define CSL_MCBSP_DXR_DXR_SHIFT          (0x00000000u)
#define CSL_MCBSP_DXR_DXR_RESETVAL       (0x00000000u)

#define CSL_MCBSP_DXR_RESETVAL           (0x00000000u)

/* SPCR */

#define CSL_MCBSP_SPCR__RSV_MASK         (0xFC000000u)
#define CSL_MCBSP_SPCR__RSV_SHIFT        (0x0000001Au)
#define CSL_MCBSP_SPCR__RSV_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_FREE_MASK         (0x02000000u)
#define CSL_MCBSP_SPCR_FREE_SHIFT        (0x00000019u)
#define CSL_MCBSP_SPCR_FREE_RESETVAL     (0x00000000u)
/*----FREE Tokens----*/
#define CSL_MCBSP_SPCR_FREE_DISABLE      (0x00000000u)
#define CSL_MCBSP_SPCR_FREE_ENABLE       (0x00000001u)

#define CSL_MCBSP_SPCR_SOFT_MASK         (0x01000000u)
#define CSL_MCBSP_SPCR_SOFT_SHIFT        (0x00000018u)
#define CSL_MCBSP_SPCR_SOFT_RESETVAL     (0x00000000u)
/*----SOFT Tokens----*/
#define CSL_MCBSP_SPCR_SOFT_DISABLE      (0x00000000u)
#define CSL_MCBSP_SPCR_SOFT_ENABLE       (0x00000001u)

#define CSL_MCBSP_SPCR_FRST_MASK         (0x00800000u)
#define CSL_MCBSP_SPCR_FRST_SHIFT        (0x00000017u)
#define CSL_MCBSP_SPCR_FRST_RESETVAL     (0x00000000u)
/*----FRST Tokens----*/
#define CSL_MCBSP_SPCR_FRST_RESET        (0x00000000u)
#define CSL_MCBSP_SPCR_FRST_FSG          (0x00000001u)

#define CSL_MCBSP_SPCR_GRST_MASK         (0x00400000u)
#define CSL_MCBSP_SPCR_GRST_SHIFT        (0x00000016u)
#define CSL_MCBSP_SPCR_GRST_RESETVAL     (0x00000000u)
/*----GRST Tokens----*/
#define CSL_MCBSP_SPCR_GRST_RESET        (0x00000000u)
#define CSL_MCBSP_SPCR_GRST_CLKG         (0x00000001u)

#define CSL_MCBSP_SPCR_XINTM_MASK        (0x00300000u)
#define CSL_MCBSP_SPCR_XINTM_SHIFT       (0x00000014u)
#define CSL_MCBSP_SPCR_XINTM_RESETVAL    (0x00000000u)
/*----XINTM Tokens----*/
#define CSL_MCBSP_SPCR_XINTM_XRDY        (0x00000000u)
#define CSL_MCBSP_SPCR_XINTM_FRM         (0x00000002u)
#define CSL_MCBSP_SPCR_XINTM_XSYNCERR    (0x00000003u)

#define CSL_MCBSP_SPCR_XSYNCERR_MASK     (0x00080000u)
#define CSL_MCBSP_SPCR_XSYNCERR_SHIFT    (0x00000013u)
#define CSL_MCBSP_SPCR_XSYNCERR_RESETVAL (0x00000000u)
/*----XSYNCERR Tokens----*/
#define CSL_MCBSP_SPCR_XSYNCERR_NO       (0x00000000u)
#define CSL_MCBSP_SPCR_XSYNCERR_YES      (0x00000001u)

#define CSL_MCBSP_SPCR_XEMPTY_MASK       (0x00040000u)
#define CSL_MCBSP_SPCR_XEMPTY_SHIFT      (0x00000012u)
#define CSL_MCBSP_SPCR_XEMPTY_RESETVAL   (0x00000000u)
/*----XEMPTY Tokens----*/
#define CSL_MCBSP_SPCR_XEMPTY_YES        (0x00000000u)
#define CSL_MCBSP_SPCR_XEMPTY_NO         (0x00000001u)

#define CSL_MCBSP_SPCR_XRDY_MASK         (0x00020000u)
#define CSL_MCBSP_SPCR_XRDY_SHIFT        (0x00000011u)
#define CSL_MCBSP_SPCR_XRDY_RESETVAL     (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCBSP_SPCR_XRDY_NO           (0x00000000u)
#define CSL_MCBSP_SPCR_XRDY_YES          (0x00000001u)

#define CSL_MCBSP_SPCR_XRST_MASK         (0x00010000u)
#define CSL_MCBSP_SPCR_XRST_SHIFT        (0x00000010u)
#define CSL_MCBSP_SPCR_XRST_RESETVAL     (0x00000000u)
/*----XRST Tokens----*/
#define CSL_MCBSP_SPCR_XRST_DISABLE      (0x00000000u)
#define CSL_MCBSP_SPCR_XRST_ENABLE       (0x00000001u)

#define CSL_MCBSP_SPCR_DLB_MASK          (0x00008000u)
#define CSL_MCBSP_SPCR_DLB_SHIFT         (0x0000000Fu)
#define CSL_MCBSP_SPCR_DLB_RESETVAL      (0x00000000u)
/*----DLB Tokens----*/
#define CSL_MCBSP_SPCR_DLB_DISABLE       (0x00000000u)
#define CSL_MCBSP_SPCR_DLB_ENABLE        (0x00000001u)

#define CSL_MCBSP_SPCR_RJUST_MASK        (0x00006000u)
#define CSL_MCBSP_SPCR_RJUST_SHIFT       (0x0000000Du)
#define CSL_MCBSP_SPCR_RJUST_RESETVAL    (0x00000000u)
/*----RJUST Tokens----*/
#define CSL_MCBSP_SPCR_RJUST_RZF         (0x00000000u)
#define CSL_MCBSP_SPCR_RJUST_RSE         (0x00000001u)
#define CSL_MCBSP_SPCR_RJUST_LZF         (0x00000002u)

#define CSL_MCBSP_SPCR_CLKSTP_MASK       (0x00001800u)
#define CSL_MCBSP_SPCR_CLKSTP_SHIFT      (0x0000000Bu)
#define CSL_MCBSP_SPCR_CLKSTP_RESETVAL   (0x00000000u)
/*----CLKSTP Tokens----*/
#define CSL_MCBSP_SPCR_CLKSTP_DISABLE_00 (0x00000000u)
#define CSL_MCBSP_SPCR_CLKSTP_DISABLE_01 (0x00000001u)
#define CSL_MCBSP_SPCR_CLKSTP_NODELAY    (0x00000002u)
#define CSL_MCBSP_SPCR_CLKSTP_DELAY      (0x00000003u)


#define CSL_MCBSP_SPCR_DXENA_MASK        (0x00000080u)
#define CSL_MCBSP_SPCR_DXENA_SHIFT       (0x00000007u)
#define CSL_MCBSP_SPCR_DXENA_RESETVAL    (0x00000000u)
/*----DXENA Tokens----*/
#define CSL_MCBSP_SPCR_DXENA_OFF         (0x00000000u)
#define CSL_MCBSP_SPCR_DXENA_ON          (0x00000001u)


#define CSL_MCBSP_SPCR_RINTM_MASK        (0x00000030u)
#define CSL_MCBSP_SPCR_RINTM_SHIFT       (0x00000004u)
#define CSL_MCBSP_SPCR_RINTM_RESETVAL    (0x00000000u)
/*----RINTM Tokens----*/
#define CSL_MCBSP_SPCR_RINTM_RRDY        (0x00000000u)
#define CSL_MCBSP_SPCR_RINTM_FRM         (0x00000002u)
#define CSL_MCBSP_SPCR_RINTM_RSYNCERR    (0x00000003u)

#define CSL_MCBSP_SPCR_RSYNCERR_MASK     (0x00000008u)
#define CSL_MCBSP_SPCR_RSYNCERR_SHIFT    (0x00000003u)
#define CSL_MCBSP_SPCR_RSYNCERR_RESETVAL (0x00000000u)
/*----RSYNCERR Tokens----*/
#define CSL_MCBSP_SPCR_RSYNCERR_NO       (0x00000000u)
#define CSL_MCBSP_SPCR_RSYNCERR_YES      (0x00000001u)

#define CSL_MCBSP_SPCR_RFULL_MASK        (0x00000004u)
#define CSL_MCBSP_SPCR_RFULL_SHIFT       (0x00000002u)
#define CSL_MCBSP_SPCR_RFULL_RESETVAL    (0x00000000u)
/*----RFULL Tokens----*/
#define CSL_MCBSP_SPCR_RFULL_NO          (0x00000000u)
#define CSL_MCBSP_SPCR_RFULL_YES         (0x00000001u)

#define CSL_MCBSP_SPCR_RRDY_MASK         (0x00000002u)
#define CSL_MCBSP_SPCR_RRDY_SHIFT        (0x00000001u)
#define CSL_MCBSP_SPCR_RRDY_RESETVAL     (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCBSP_SPCR_RRDY_NO           (0x00000000u)
#define CSL_MCBSP_SPCR_RRDY_YES          (0x00000001u)

#define CSL_MCBSP_SPCR_RRST_MASK         (0x00000001u)
#define CSL_MCBSP_SPCR_RRST_SHIFT        (0x00000000u)
#define CSL_MCBSP_SPCR_RRST_RESETVAL     (0x00000000u)
/*----RRST Tokens----*/
#define CSL_MCBSP_SPCR_RRST_DISABLE      (0x00000000u)
#define CSL_MCBSP_SPCR_RRST_ENABLE       (0x00000001u)

#define CSL_MCBSP_SPCR_RESETVAL          (0x00000000u)

/* RCR */

#define CSL_MCBSP_RCR_RPHASE_MASK        (0x80000000u)
#define CSL_MCBSP_RCR_RPHASE_SHIFT       (0x0000001Fu)
#define CSL_MCBSP_RCR_RPHASE_RESETVAL    (0x00000000u)
/*----RPHASE Tokens----*/
#define CSL_MCBSP_RCR_RPHASE_SINGLE_FRM  (0x00000000u)
#define CSL_MCBSP_RCR_RPHASE_DUAL_FRM    (0x00000001u)

#define CSL_MCBSP_RCR_RFRLEN2_MASK       (0x7F000000u)
#define CSL_MCBSP_RCR_RFRLEN2_SHIFT      (0x00000018u)
#define CSL_MCBSP_RCR_RFRLEN2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCR_RWDLEN2_MASK       (0x00E00000u)
#define CSL_MCBSP_RCR_RWDLEN2_SHIFT      (0x00000015u)
#define CSL_MCBSP_RCR_RWDLEN2_RESETVAL   (0x00000000u)
/*----RWDLEN2 Tokens----*/
#define CSL_MCBSP_RCR_RWDLEN2_8BIT       (0x00000000u)
#define CSL_MCBSP_RCR_RWDLEN2_12BIT      (0x00000001u)
#define CSL_MCBSP_RCR_RWDLEN2_16BIT      (0x00000002u)
#define CSL_MCBSP_RCR_RWDLEN2_20BIT      (0x00000003u)
#define CSL_MCBSP_RCR_RWDLEN2_24BIT      (0x00000004u)
#define CSL_MCBSP_RCR_RWDLEN2_32BIT      (0x00000005u)

#define CSL_MCBSP_RCR_RCOMPAND_MASK      (0x00180000u)
#define CSL_MCBSP_RCR_RCOMPAND_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCR_RCOMPAND_RESETVAL  (0x00000000u)
/*----RCOMPAND Tokens----*/
#define CSL_MCBSP_RCR_RCOMPAND_MSB       (0x00000000u)
#define CSL_MCBSP_RCR_RCOMPAND_8BITLSB   (0x00000001u)
#define CSL_MCBSP_RCR_RCOMPAND_ULAW      (0x00000002u)
#define CSL_MCBSP_RCR_RCOMPAND_ALAW      (0x00000003u)

#define CSL_MCBSP_RCR_RFIG_MASK          (0x00040000u)
#define CSL_MCBSP_RCR_RFIG_SHIFT         (0x00000012u)
#define CSL_MCBSP_RCR_RFIG_RESETVAL      (0x00000000u)
/*----RFIG Tokens----*/
#define CSL_MCBSP_RCR_RFIG_YES           (0x00000000u)
#define CSL_MCBSP_RCR_RFIG_NO            (0x00000001u)

#define CSL_MCBSP_RCR_RDATDLY_MASK       (0x00030000u)
#define CSL_MCBSP_RCR_RDATDLY_SHIFT      (0x00000010u)
#define CSL_MCBSP_RCR_RDATDLY_RESETVAL   (0x00000000u)
/*----RDATDLY Tokens----*/
#define CSL_MCBSP_RCR_RDATDLY_0BIT       (0x00000000u)
#define CSL_MCBSP_RCR_RDATDLY_1BIT       (0x00000001u)
#define CSL_MCBSP_RCR_RDATDLY_2BIT       (0x00000002u)


#define CSL_MCBSP_RCR_RFRLEN1_MASK       (0x00007F00u)
#define CSL_MCBSP_RCR_RFRLEN1_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCR_RFRLEN1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCR_RWDLEN1_MASK       (0x000000E0u)
#define CSL_MCBSP_RCR_RWDLEN1_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCR_RWDLEN1_RESETVAL   (0x00000000u)
/*----RWDLEN1 Tokens----*/
#define CSL_MCBSP_RCR_RWDLEN1_8BIT       (0x00000000u)
#define CSL_MCBSP_RCR_RWDLEN1_12BIT      (0x00000001u)
#define CSL_MCBSP_RCR_RWDLEN1_16BIT      (0x00000002u)
#define CSL_MCBSP_RCR_RWDLEN1_20BIT      (0x00000003u)
#define CSL_MCBSP_RCR_RWDLEN1_24BIT      (0x00000004u)
#define CSL_MCBSP_RCR_RWDLEN1_32BIT      (0x00000005u)

#define CSL_MCBSP_RCR_RWDREVRS_MASK      (0x00000010u)
#define CSL_MCBSP_RCR_RWDREVRS_SHIFT     (0x00000004u)
#define CSL_MCBSP_RCR_RWDREVRS_RESETVAL  (0x00000000u)
/*----RWDREVRS Tokens----*/
#define CSL_MCBSP_RCR_RWDREVRS_DISABLED  (0x00000000u)
#define CSL_MCBSP_RCR_RWDREVRS_ENABLED   (0x00000001u)


#define CSL_MCBSP_RCR_RESETVAL           (0x00000000u)

/* XCR */

#define CSL_MCBSP_XCR_XPHASE_MASK        (0x80000000u)
#define CSL_MCBSP_XCR_XPHASE_SHIFT       (0x0000001Fu)
#define CSL_MCBSP_XCR_XPHASE_RESETVAL    (0x00000000u)
/*----XPHASE Tokens----*/
#define CSL_MCBSP_XCR_XPHASE_SINGLE_FRM  (0x00000000u)
#define CSL_MCBSP_XCR_XPHASE_DUAL_FRM    (0x00000001u)

#define CSL_MCBSP_XCR_XFRLEN2_MASK       (0x7F000000u)
#define CSL_MCBSP_XCR_XFRLEN2_SHIFT      (0x00000018u)
#define CSL_MCBSP_XCR_XFRLEN2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCR_XWDLEN2_MASK       (0x00E00000u)
#define CSL_MCBSP_XCR_XWDLEN2_SHIFT      (0x00000015u)
#define CSL_MCBSP_XCR_XWDLEN2_RESETVAL   (0x00000000u)
/*----XWDLEN2 Tokens----*/
#define CSL_MCBSP_XCR_XWDLEN2_8BIT       (0x00000000u)
#define CSL_MCBSP_XCR_XWDLEN2_12BIT      (0x00000001u)
#define CSL_MCBSP_XCR_XWDLEN2_16BIT      (0x00000002u)
#define CSL_MCBSP_XCR_XWDLEN2_20BIT      (0x00000003u)
#define CSL_MCBSP_XCR_XWDLEN2_24BIT      (0x00000004u)
#define CSL_MCBSP_XCR_XWDLEN2_32BIT      (0x00000005u)

#define CSL_MCBSP_XCR_XCOMPAND_MASK      (0x00180000u)
#define CSL_MCBSP_XCR_XCOMPAND_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCR_XCOMPAND_RESETVAL  (0x00000000u)
/*----XCOMPAND Tokens----*/
#define CSL_MCBSP_XCR_XCOMPAND_MSB       (0x00000000u)
#define CSL_MCBSP_XCR_XCOMPAND_8BITLSB   (0x00000001u)
#define CSL_MCBSP_XCR_XCOMPAND_ULAW      (0x00000002u)
#define CSL_MCBSP_XCR_XCOMPAND_ALAW      (0x00000003u)

#define CSL_MCBSP_XCR_XFIG_MASK          (0x00040000u)
#define CSL_MCBSP_XCR_XFIG_SHIFT         (0x00000012u)
#define CSL_MCBSP_XCR_XFIG_RESETVAL      (0x00000000u)
/*----XFIG Tokens----*/
#define CSL_MCBSP_XCR_XFIG_YES           (0x00000000u)
#define CSL_MCBSP_XCR_XFIG_NO            (0x00000001u)

#define CSL_MCBSP_XCR_XDATDLY_MASK       (0x00030000u)
#define CSL_MCBSP_XCR_XDATDLY_SHIFT      (0x00000010u)
#define CSL_MCBSP_XCR_XDATDLY_RESETVAL   (0x00000000u)
/*----XDATDLY Tokens----*/
#define CSL_MCBSP_XCR_XDATDLY_0BIT       (0x00000000u)
#define CSL_MCBSP_XCR_XDATDLY_1BIT       (0x00000001u)
#define CSL_MCBSP_XCR_XDATDLY_2BIT       (0x00000002u)


#define CSL_MCBSP_XCR_XFRLEN1_MASK       (0x00007F00u)
#define CSL_MCBSP_XCR_XFRLEN1_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCR_XFRLEN1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCR_XWDLEN1_MASK       (0x000000E0u)
#define CSL_MCBSP_XCR_XWDLEN1_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCR_XWDLEN1_RESETVAL   (0x00000000u)
/*----XWDLEN1 Tokens----*/
#define CSL_MCBSP_XCR_XWDLEN1_8BIT       (0x00000000u)
#define CSL_MCBSP_XCR_XWDLEN1_12BIT      (0x00000001u)
#define CSL_MCBSP_XCR_XWDLEN1_16BIT      (0x00000002u)
#define CSL_MCBSP_XCR_XWDLEN1_20BIT      (0x00000003u)
#define CSL_MCBSP_XCR_XWDLEN1_24BIT      (0x00000004u)
#define CSL_MCBSP_XCR_XWDLEN1_32BIT      (0x00000005u)

#define CSL_MCBSP_XCR_XWDREVRS_MASK      (0x00000010u)
#define CSL_MCBSP_XCR_XWDREVRS_SHIFT     (0x00000004u)
#define CSL_MCBSP_XCR_XWDREVRS_RESETVAL  (0x00000000u)
/*----XWDREVRS Tokens----*/
#define CSL_MCBSP_XCR_XWDREVRS_DISABLED  (0x00000000u)
#define CSL_MCBSP_XCR_XWDREVRS_ENABLED   (0x00000001u)


#define CSL_MCBSP_XCR_RESETVAL           (0x00000000u)

/* SRGR */

#define CSL_MCBSP_SRGR_GSYNC_MASK        (0x80000000u)
#define CSL_MCBSP_SRGR_GSYNC_SHIFT       (0x0000001Fu)
#define CSL_MCBSP_SRGR_GSYNC_RESETVAL    (0x00000000u)
/*----GSYNC Tokens----*/
#define CSL_MCBSP_SRGR_GSYNC_FREE        (0x00000000u)
#define CSL_MCBSP_SRGR_GSYNC_SYNC        (0x00000001u)

#define CSL_MCBSP_SRGR_CLKSP_MASK        (0x40000000u)
#define CSL_MCBSP_SRGR_CLKSP_SHIFT       (0x0000001Eu)
#define CSL_MCBSP_SRGR_CLKSP_RESETVAL    (0x00000000u)
/*----CLKSP Tokens----*/
#define CSL_MCBSP_SRGR_CLKSP_RISING      (0x00000000u)
#define CSL_MCBSP_SRGR_CLKSP_FALLING     (0x00000001u)

#define CSL_MCBSP_SRGR_CLKSM_MASK        (0x20000000u)
#define CSL_MCBSP_SRGR_CLKSM_SHIFT       (0x0000001Du)
#define CSL_MCBSP_SRGR_CLKSM_RESETVAL    (0x00000001u)
/*----CLKSM Tokens----*/
#define CSL_MCBSP_SRGR_CLKSM_CLKS        (0x00000000u)
#define CSL_MCBSP_SRGR_CLKSM_INTERNAL    (0x00000001u)

#define CSL_MCBSP_SRGR_FSGM_MASK         (0x10000000u)
#define CSL_MCBSP_SRGR_FSGM_SHIFT        (0x0000001Cu)
#define CSL_MCBSP_SRGR_FSGM_RESETVAL     (0x00000000u)
/*----FSGM Tokens----*/
#define CSL_MCBSP_SRGR_FSGM_DXR2XSR      (0x00000000u)
#define CSL_MCBSP_SRGR_FSGM_FSG          (0x00000001u)

#define CSL_MCBSP_SRGR_FPER_MASK         (0x0FFF0000u)
#define CSL_MCBSP_SRGR_FPER_SHIFT        (0x00000010u)
#define CSL_MCBSP_SRGR_FPER_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SRGR_FWID_MASK         (0x0000FF00u)
#define CSL_MCBSP_SRGR_FWID_SHIFT        (0x00000008u)
#define CSL_MCBSP_SRGR_FWID_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SRGR_CLKGDV_MASK       (0x000000FFu)
#define CSL_MCBSP_SRGR_CLKGDV_SHIFT      (0x00000000u)
#define CSL_MCBSP_SRGR_CLKGDV_RESETVAL   (0x00000001u)

#define CSL_MCBSP_SRGR_RESETVAL          (0x20000001u)

/* MCR */


#define CSL_MCBSP_MCR_XMCME_MASK         (0x02000000u)
#define CSL_MCBSP_MCR_XMCME_SHIFT        (0x00000019u)
#define CSL_MCBSP_MCR_XMCME_RESETVAL     (0x00000000u)
/*----XMCME Tokens----*/
#define CSL_MCBSP_MCR_XMCME_2PARTITION   (0x00000000u)
#define CSL_MCBSP_MCR_XMCME_8PARTITION   (0x00000001u)

#define CSL_MCBSP_MCR_XPBBLK_MASK        (0x01800000u)
#define CSL_MCBSP_MCR_XPBBLK_SHIFT       (0x00000017u)
#define CSL_MCBSP_MCR_XPBBLK_RESETVAL    (0x00000000u)
/*----XPBBLK Tokens----*/
#define CSL_MCBSP_MCR_XPBBLK_BLOCK1      (0x00000000u)
#define CSL_MCBSP_MCR_XPBBLK_BLOCK3      (0x00000001u)
#define CSL_MCBSP_MCR_XPBBLK_BLOCK5      (0x00000002u)
#define CSL_MCBSP_MCR_XPBBLK_BLOCK7      (0x00000003u)

#define CSL_MCBSP_MCR_XPABLK_MASK        (0x00600000u)
#define CSL_MCBSP_MCR_XPABLK_SHIFT       (0x00000015u)
#define CSL_MCBSP_MCR_XPABLK_RESETVAL    (0x00000000u)
/*----XPABLK Tokens----*/
#define CSL_MCBSP_MCR_XPABLK_BLOCK0      (0x00000000u)
#define CSL_MCBSP_MCR_XPABLK_BLOCK2      (0x00000001u)
#define CSL_MCBSP_MCR_XPABLK_BLOCK4      (0x00000002u)
#define CSL_MCBSP_MCR_XPABLK_BLOCK6      (0x00000003u)

#define CSL_MCBSP_MCR_XCBLK_MASK         (0x001C0000u)
#define CSL_MCBSP_MCR_XCBLK_SHIFT        (0x00000012u)
#define CSL_MCBSP_MCR_XCBLK_RESETVAL     (0x00000000u)
/*----XCBLK Tokens----*/
#define CSL_MCBSP_MCR_XCBLK_BLOCK0       (0x00000000u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK1       (0x00000001u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK2       (0x00000002u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK3       (0x00000003u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK4       (0x00000004u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK5       (0x00000005u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK6       (0x00000006u)
#define CSL_MCBSP_MCR_XCBLK_BLOCK7       (0x00000007u)

#define CSL_MCBSP_MCR_XMCM_MASK          (0x00030000u)
#define CSL_MCBSP_MCR_XMCM_SHIFT         (0x00000010u)
#define CSL_MCBSP_MCR_XMCM_RESETVAL      (0x00000000u)
/*----XMCM Tokens----*/
#define CSL_MCBSP_MCR_XMCM_ENABLE        (0x00000000u)
#define CSL_MCBSP_MCR_XMCM_DISABLE       (0x00000001u)
#define CSL_MCBSP_MCR_XMCM_ENABLE_MASK   (0x00000002u)
#define CSL_MCBSP_MCR_XMCM_SYMMETRIC     (0x00000003u)



#define CSL_MCBSP_MCR_RMCME_MASK         (0x00000200u)
#define CSL_MCBSP_MCR_RMCME_SHIFT        (0x00000009u)
#define CSL_MCBSP_MCR_RMCME_RESETVAL     (0x00000000u)
/*----RMCME Tokens----*/
#define CSL_MCBSP_MCR_RMCME_2PARTITION   (0x00000000u)
#define CSL_MCBSP_MCR_RMCME_8PARTITION   (0x00000001u)

#define CSL_MCBSP_MCR_RPBBLK_MASK        (0x00000180u)
#define CSL_MCBSP_MCR_RPBBLK_SHIFT       (0x00000007u)
#define CSL_MCBSP_MCR_RPBBLK_RESETVAL    (0x00000000u)
/*----RPBBLK Tokens----*/
#define CSL_MCBSP_MCR_RPBBLK_BLOCK1      (0x00000000u)
#define CSL_MCBSP_MCR_RPBBLK_BLOCK3      (0x00000001u)
#define CSL_MCBSP_MCR_RPBBLK_BLOCK5      (0x00000002u)
#define CSL_MCBSP_MCR_RPBBLK_BLOCK7      (0x00000003u)

#define CSL_MCBSP_MCR_RPABLK_MASK        (0x00000060u)
#define CSL_MCBSP_MCR_RPABLK_SHIFT       (0x00000005u)
#define CSL_MCBSP_MCR_RPABLK_RESETVAL    (0x00000000u)
/*----RPABLK Tokens----*/
#define CSL_MCBSP_MCR_RPABLK_BLOCK0      (0x00000000u)
#define CSL_MCBSP_MCR_RPABLK_BLOCK2      (0x00000001u)
#define CSL_MCBSP_MCR_RPABLK_BLOCK4      (0x00000002u)
#define CSL_MCBSP_MCR_RPABLK_BLOCK6      (0x00000003u)

#define CSL_MCBSP_MCR_RCBLK_MASK         (0x0000001Cu)
#define CSL_MCBSP_MCR_RCBLK_SHIFT        (0x00000002u)
#define CSL_MCBSP_MCR_RCBLK_RESETVAL     (0x00000000u)
/*----RCBLK Tokens----*/
#define CSL_MCBSP_MCR_RCBLK_BLOCK0       (0x00000000u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK1       (0x00000001u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK2       (0x00000002u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK3       (0x00000003u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK4       (0x00000004u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK5       (0x00000005u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK6       (0x00000006u)
#define CSL_MCBSP_MCR_RCBLK_BLOCK7       (0x00000007u)


#define CSL_MCBSP_MCR_RMCM_MASK          (0x00000001u)
#define CSL_MCBSP_MCR_RMCM_SHIFT         (0x00000000u)
#define CSL_MCBSP_MCR_RMCM_RESETVAL      (0x00000000u)
/*----RMCM Tokens----*/
#define CSL_MCBSP_MCR_RMCM_ENABLE        (0x00000000u)
#define CSL_MCBSP_MCR_RMCM_DISABLE       (0x00000001u)

#define CSL_MCBSP_MCR_RESETVAL           (0x00000000u)

/* RCERE0 */

#define CSL_MCBSP_RCERE0_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE0_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE0_RCE31_RESETVAL  (0x00000000u)
/*----RCE31 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE0_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE0_RCE30_RESETVAL  (0x00000000u)
/*----RCE30 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE0_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE0_RCE29_RESETVAL  (0x00000000u)
/*----RCE29 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE0_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE0_RCE28_RESETVAL  (0x00000000u)
/*----RCE28 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE0_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE0_RCE27_RESETVAL  (0x00000000u)
/*----RCE27 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE0_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE0_RCE26_RESETVAL  (0x00000000u)
/*----RCE26 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE0_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE0_RCE25_RESETVAL  (0x00000000u)
/*----RCE25 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE0_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE0_RCE24_RESETVAL  (0x00000000u)
/*----RCE24 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE0_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE0_RCE23_RESETVAL  (0x00000000u)
/*----RCE23 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE0_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE0_RCE22_RESETVAL  (0x00000000u)
/*----RCE22 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE0_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE0_RCE21_RESETVAL  (0x00000000u)
/*----RCE21 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE0_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE0_RCE20_RESETVAL  (0x00000000u)
/*----RCE20 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE0_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE0_RCE19_RESETVAL  (0x00000000u)
/*----RCE19 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE0_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE0_RCE18_RESETVAL  (0x00000000u)
/*----RCE18 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE0_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE0_RCE17_RESETVAL  (0x00000000u)
/*----RCE17 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE0_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE0_RCE16_RESETVAL  (0x00000000u)
/*----RCE16 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE0_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE0_RCE15_RESETVAL  (0x00000000u)
/*----RCE15 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE0_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE0_RCE14_RESETVAL  (0x00000000u)
/*----RCE14 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE0_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE0_RCE13_RESETVAL  (0x00000000u)
/*----RCE13 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE0_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE0_RCE12_RESETVAL  (0x00000000u)
/*----RCE12 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE0_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE0_RCE11_RESETVAL  (0x00000000u)
/*----RCE11 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE0_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE0_RCE10_RESETVAL  (0x00000000u)
/*----RCE10 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE0_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE0_RCE9_RESETVAL   (0x00000000u)
/*----RCE9 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE0_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE0_RCE8_RESETVAL   (0x00000000u)
/*----RCE8 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE0_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE0_RCE7_RESETVAL   (0x00000000u)
/*----RCE7 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE0_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE0_RCE6_RESETVAL   (0x00000000u)
/*----RCE6 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE0_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE0_RCE5_RESETVAL   (0x00000000u)
/*----RCE5 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE0_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE0_RCE4_RESETVAL   (0x00000000u)
/*----RCE4 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE0_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE0_RCE3_RESETVAL   (0x00000000u)
/*----RCE3 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE0_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE0_RCE2_RESETVAL   (0x00000000u)
/*----RCE2 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE0_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE0_RCE1_RESETVAL   (0x00000000u)
/*----RCE1 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE0_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE0_RESETVAL   (0x00000000u)
/*----RCE0 Tokens----*/
#define CSL_MCBSP_RCERE0_RCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE0_RESETVAL        (0x00000000u)

/* XCERE0 */

#define CSL_MCBSP_XCERE0_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE0_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE0_XCE31_RESETVAL  (0x00000000u)
/*----XCE31 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE0_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE0_XCE30_RESETVAL  (0x00000000u)
/*----XCE30 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE0_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE0_XCE29_RESETVAL  (0x00000000u)
/*----XCE29 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE0_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE0_XCE28_RESETVAL  (0x00000000u)
/*----XCE28 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE0_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE0_XCE27_RESETVAL  (0x00000000u)
/*----XCE27 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE0_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE0_XCE26_RESETVAL  (0x00000000u)
/*----XCE26 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE0_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE0_XCE25_RESETVAL  (0x00000000u)
/*----XCE25 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE0_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE0_XCE24_RESETVAL  (0x00000000u)
/*----XCE24 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE0_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE0_XCE23_RESETVAL  (0x00000000u)
/*----XCE23 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE0_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE0_XCE22_RESETVAL  (0x00000000u)
/*----XCE22 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE0_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE0_XCE21_RESETVAL  (0x00000000u)
/*----XCE21 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE0_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE0_XCE20_RESETVAL  (0x00000000u)
/*----XCE20 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE0_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE0_XCE19_RESETVAL  (0x00000000u)
/*----XCE19 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE0_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE0_XCE18_RESETVAL  (0x00000000u)
/*----XCE18 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE0_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE0_XCE17_RESETVAL  (0x00000000u)
/*----XCE17 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE0_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE0_XCE16_RESETVAL  (0x00000000u)
/*----XCE16 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE0_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE0_XCE15_RESETVAL  (0x00000000u)
/*----XCE15 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE0_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE0_XCE14_RESETVAL  (0x00000000u)
/*----XCE14 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE0_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE0_XCE13_RESETVAL  (0x00000000u)
/*----XCE13 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE0_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE0_XCE12_RESETVAL  (0x00000000u)
/*----XCE12 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE0_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE0_XCE11_RESETVAL  (0x00000000u)
/*----XCE11 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE0_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE0_XCE10_RESETVAL  (0x00000000u)
/*----XCE10 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE0_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE0_XCE9_RESETVAL   (0x00000000u)
/*----XCE9 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE0_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE0_XCE8_RESETVAL   (0x00000000u)
/*----XCE8 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE0_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE0_XCE7_RESETVAL   (0x00000000u)
/*----XCE7 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE0_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE0_XCE6_RESETVAL   (0x00000000u)
/*----XCE6 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE0_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE0_XCE5_RESETVAL   (0x00000000u)
/*----XCE5 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE0_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE0_XCE4_RESETVAL   (0x00000000u)
/*----XCE4 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE0_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE0_XCE3_RESETVAL   (0x00000000u)
/*----XCE3 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE0_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE0_XCE2_RESETVAL   (0x00000000u)
/*----XCE2 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE0_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE0_XCE1_RESETVAL   (0x00000000u)
/*----XCE1 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE0_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE0_RESETVAL   (0x00000000u)
/*----XCE0 Tokens----*/
#define CSL_MCBSP_XCERE0_XCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE0_RESETVAL        (0x00000000u)

/* PCR */


#define CSL_MCBSP_PCR_FSXM_MASK          (0x00000800u)
#define CSL_MCBSP_PCR_FSXM_SHIFT         (0x0000000Bu)
#define CSL_MCBSP_PCR_FSXM_RESETVAL      (0x00000000u)
/*----FSXM Tokens----*/
#define CSL_MCBSP_PCR_FSXM_EXTERNAL      (0x00000000u)
#define CSL_MCBSP_PCR_FSXM_INTERNAL      (0x00000001u)

#define CSL_MCBSP_PCR_FSRM_MASK          (0x00000400u)
#define CSL_MCBSP_PCR_FSRM_SHIFT         (0x0000000Au)
#define CSL_MCBSP_PCR_FSRM_RESETVAL      (0x00000000u)
/*----FSRM Tokens----*/
#define CSL_MCBSP_PCR_FSRM_EXTERNAL      (0x00000000u)
#define CSL_MCBSP_PCR_FSRM_INTERNAL      (0x00000001u)

#define CSL_MCBSP_PCR_CLKXM_MASK         (0x00000200u)
#define CSL_MCBSP_PCR_CLKXM_SHIFT        (0x00000009u)
#define CSL_MCBSP_PCR_CLKXM_RESETVAL     (0x00000000u)
/*----CLKXM Tokens----*/
#define CSL_MCBSP_PCR_CLKXM_INPUT        (0x00000000u)
#define CSL_MCBSP_PCR_CLKXM_OUTPUT       (0x00000001u)

#define CSL_MCBSP_PCR_CLKRM_MASK         (0x00000100u)
#define CSL_MCBSP_PCR_CLKRM_SHIFT        (0x00000008u)
#define CSL_MCBSP_PCR_CLKRM_RESETVAL     (0x00000000u)
/*----CLKRM Tokens----*/
#define CSL_MCBSP_PCR_CLKRM_INPUT        (0x00000000u)
#define CSL_MCBSP_PCR_CLKRM_OUTPUT       (0x00000001u)

#define CSL_MCBSP_PCR_SCLKME_MASK        (0x00000080u)
#define CSL_MCBSP_PCR_SCLKME_SHIFT       (0x00000007u)
#define CSL_MCBSP_PCR_SCLKME_RESETVAL    (0x00000000u)
/*----SCLKME Tokens----*/
#define CSL_MCBSP_PCR_SCLKME_NO          (0x00000000u)
#define CSL_MCBSP_PCR_SCLKME_BCLK        (0x00000001u)


#define CSL_MCBSP_PCR_FSXP_MASK          (0x00000008u)
#define CSL_MCBSP_PCR_FSXP_SHIFT         (0x00000003u)
#define CSL_MCBSP_PCR_FSXP_RESETVAL      (0x00000000u)
/*----FSXP Tokens----*/
#define CSL_MCBSP_PCR_FSXP_ACTIVEHIGH    (0x00000000u)
#define CSL_MCBSP_PCR_FSXP_ACTIVELOW     (0x00000001u)

#define CSL_MCBSP_PCR_FSRP_MASK          (0x00000004u)
#define CSL_MCBSP_PCR_FSRP_SHIFT         (0x00000002u)
#define CSL_MCBSP_PCR_FSRP_RESETVAL      (0x00000000u)
/*----FSRP Tokens----*/
#define CSL_MCBSP_PCR_FSRP_ACTIVEHIGH    (0x00000000u)
#define CSL_MCBSP_PCR_FSRP_ACTIVELOW     (0x00000001u)

#define CSL_MCBSP_PCR_CLKXP_MASK         (0x00000002u)
#define CSL_MCBSP_PCR_CLKXP_SHIFT        (0x00000001u)
#define CSL_MCBSP_PCR_CLKXP_RESETVAL     (0x00000000u)
/*----CLKXP Tokens----*/
#define CSL_MCBSP_PCR_CLKXP_RISING       (0x00000000u)
#define CSL_MCBSP_PCR_CLKXP_FALLING      (0x00000001u)

#define CSL_MCBSP_PCR_CLKRP_MASK         (0x00000001u)
#define CSL_MCBSP_PCR_CLKRP_SHIFT        (0x00000000u)
#define CSL_MCBSP_PCR_CLKRP_RESETVAL     (0x00000000u)
/*----CLKRP Tokens----*/
#define CSL_MCBSP_PCR_CLKRP_FALLING      (0x00000000u)
#define CSL_MCBSP_PCR_CLKRP_RISING       (0x00000001u)

#define CSL_MCBSP_PCR_RESETVAL           (0x00000000u)

/* RCERE1 */

#define CSL_MCBSP_RCERE1_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE1_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE1_RCE31_RESETVAL  (0x00000000u)
/*----RCE31 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE1_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE1_RCE30_RESETVAL  (0x00000000u)
/*----RCE30 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE1_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE1_RCE29_RESETVAL  (0x00000000u)
/*----RCE29 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE1_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE1_RCE28_RESETVAL  (0x00000000u)
/*----RCE28 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE1_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE1_RCE27_RESETVAL  (0x00000000u)
/*----RCE27 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE1_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE1_RCE26_RESETVAL  (0x00000000u)
/*----RCE26 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE1_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE1_RCE25_RESETVAL  (0x00000000u)
/*----RCE25 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE1_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE1_RCE24_RESETVAL  (0x00000000u)
/*----RCE24 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE1_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE1_RCE23_RESETVAL  (0x00000000u)
/*----RCE23 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE1_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE1_RCE22_RESETVAL  (0x00000000u)
/*----RCE22 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE1_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE1_RCE21_RESETVAL  (0x00000000u)
/*----RCE21 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE1_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE1_RCE20_RESETVAL  (0x00000000u)
/*----RCE20 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE1_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE1_RCE19_RESETVAL  (0x00000000u)
/*----RCE19 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE1_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE1_RCE18_RESETVAL  (0x00000000u)
/*----RCE18 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE1_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE1_RCE17_RESETVAL  (0x00000000u)
/*----RCE17 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE1_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE1_RCE16_RESETVAL  (0x00000000u)
/*----RCE16 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE1_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE1_RCE15_RESETVAL  (0x00000000u)
/*----RCE15 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE1_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE1_RCE14_RESETVAL  (0x00000000u)
/*----RCE14 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE1_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE1_RCE13_RESETVAL  (0x00000000u)
/*----RCE13 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE1_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE1_RCE12_RESETVAL  (0x00000000u)
/*----RCE12 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE1_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE1_RCE11_RESETVAL  (0x00000000u)
/*----RCE11 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE1_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE1_RCE10_RESETVAL  (0x00000000u)
/*----RCE10 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE1_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE1_RCE9_RESETVAL   (0x00000000u)
/*----RCE9 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE1_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE1_RCE8_RESETVAL   (0x00000000u)
/*----RCE8 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE1_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE1_RCE7_RESETVAL   (0x00000000u)
/*----RCE7 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE1_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE1_RCE6_RESETVAL   (0x00000000u)
/*----RCE6 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE1_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE1_RCE5_RESETVAL   (0x00000000u)
/*----RCE5 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE1_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE1_RCE4_RESETVAL   (0x00000000u)
/*----RCE4 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE1_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE1_RCE3_RESETVAL   (0x00000000u)
/*----RCE3 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE1_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE1_RCE2_RESETVAL   (0x00000000u)
/*----RCE2 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE1_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE1_RCE1_RESETVAL   (0x00000000u)
/*----RCE1 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE1_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE0_RESETVAL   (0x00000000u)
/*----RCE0 Tokens----*/
#define CSL_MCBSP_RCERE1_RCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE1_RESETVAL        (0x00000000u)

/* XCERE1 */

#define CSL_MCBSP_XCERE1_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE1_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE1_XCE31_RESETVAL  (0x00000000u)
/*----XCE31 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE1_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE1_XCE30_RESETVAL  (0x00000000u)
/*----XCE30 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE1_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE1_XCE29_RESETVAL  (0x00000000u)
/*----XCE29 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE1_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE1_XCE28_RESETVAL  (0x00000000u)
/*----XCE28 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE1_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE1_XCE27_RESETVAL  (0x00000000u)
/*----XCE27 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE1_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE1_XCE26_RESETVAL  (0x00000000u)
/*----XCE26 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE1_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE1_XCE25_RESETVAL  (0x00000000u)
/*----XCE25 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE1_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE1_XCE24_RESETVAL  (0x00000000u)
/*----XCE24 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE1_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE1_XCE23_RESETVAL  (0x00000000u)
/*----XCE23 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE1_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE1_XCE22_RESETVAL  (0x00000000u)
/*----XCE22 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE1_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE1_XCE21_RESETVAL  (0x00000000u)
/*----XCE21 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE1_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE1_XCE20_RESETVAL  (0x00000000u)
/*----XCE20 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE1_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE1_XCE19_RESETVAL  (0x00000000u)
/*----XCE19 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE1_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE1_XCE18_RESETVAL  (0x00000000u)
/*----XCE18 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE1_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE1_XCE17_RESETVAL  (0x00000000u)
/*----XCE17 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE1_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE1_XCE16_RESETVAL  (0x00000000u)
/*----XCE16 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE1_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE1_XCE15_RESETVAL  (0x00000000u)
/*----XCE15 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE1_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE1_XCE14_RESETVAL  (0x00000000u)
/*----XCE14 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE1_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE1_XCE13_RESETVAL  (0x00000000u)
/*----XCE13 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE1_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE1_XCE12_RESETVAL  (0x00000000u)
/*----XCE12 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE1_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE1_XCE11_RESETVAL  (0x00000000u)
/*----XCE11 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE1_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE1_XCE10_RESETVAL  (0x00000000u)
/*----XCE10 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE1_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE1_XCE9_RESETVAL   (0x00000000u)
/*----XCE9 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE1_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE1_XCE8_RESETVAL   (0x00000000u)
/*----XCE8 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE1_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE1_XCE7_RESETVAL   (0x00000000u)
/*----XCE7 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE1_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE1_XCE6_RESETVAL   (0x00000000u)
/*----XCE6 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE1_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE1_XCE5_RESETVAL   (0x00000000u)
/*----XCE5 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE1_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE1_XCE4_RESETVAL   (0x00000000u)
/*----XCE4 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE1_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE1_XCE3_RESETVAL   (0x00000000u)
/*----XCE3 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE1_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE1_XCE2_RESETVAL   (0x00000000u)
/*----XCE2 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE1_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE1_XCE1_RESETVAL   (0x00000000u)
/*----XCE1 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE1_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE0_RESETVAL   (0x00000000u)
/*----XCE0 Tokens----*/
#define CSL_MCBSP_XCERE1_XCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE1_RESETVAL        (0x00000000u)

/* RCERE2 */

#define CSL_MCBSP_RCERE2_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE2_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE2_RCE31_RESETVAL  (0x00000000u)
/*----RCE31 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE2_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE2_RCE30_RESETVAL  (0x00000000u)
/*----RCE30 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE2_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE2_RCE29_RESETVAL  (0x00000000u)
/*----RCE29 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE2_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE2_RCE28_RESETVAL  (0x00000000u)
/*----RCE28 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE2_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE2_RCE27_RESETVAL  (0x00000000u)
/*----RCE27 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE2_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE2_RCE26_RESETVAL  (0x00000000u)
/*----RCE26 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE2_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE2_RCE25_RESETVAL  (0x00000000u)
/*----RCE25 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE2_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE2_RCE24_RESETVAL  (0x00000000u)
/*----RCE24 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE2_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE2_RCE23_RESETVAL  (0x00000000u)
/*----RCE23 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE2_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE2_RCE22_RESETVAL  (0x00000000u)
/*----RCE22 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE2_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE2_RCE21_RESETVAL  (0x00000000u)
/*----RCE21 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE2_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE2_RCE20_RESETVAL  (0x00000000u)
/*----RCE20 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE2_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE2_RCE19_RESETVAL  (0x00000000u)
/*----RCE19 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE2_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE2_RCE18_RESETVAL  (0x00000000u)
/*----RCE18 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE2_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE2_RCE17_RESETVAL  (0x00000000u)
/*----RCE17 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE2_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE2_RCE16_RESETVAL  (0x00000000u)
/*----RCE16 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE2_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE2_RCE15_RESETVAL  (0x00000000u)
/*----RCE15 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE2_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE2_RCE14_RESETVAL  (0x00000000u)
/*----RCE14 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE2_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE2_RCE13_RESETVAL  (0x00000000u)
/*----RCE13 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE2_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE2_RCE12_RESETVAL  (0x00000000u)
/*----RCE12 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE2_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE2_RCE11_RESETVAL  (0x00000000u)
/*----RCE11 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE2_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE2_RCE10_RESETVAL  (0x00000000u)
/*----RCE10 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE2_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE2_RCE9_RESETVAL   (0x00000000u)
/*----RCE9 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE2_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE2_RCE8_RESETVAL   (0x00000000u)
/*----RCE8 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE2_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE2_RCE7_RESETVAL   (0x00000000u)
/*----RCE7 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE2_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE2_RCE6_RESETVAL   (0x00000000u)
/*----RCE6 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE2_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE2_RCE5_RESETVAL   (0x00000000u)
/*----RCE5 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE2_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE2_RCE4_RESETVAL   (0x00000000u)
/*----RCE4 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE2_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE2_RCE3_RESETVAL   (0x00000000u)
/*----RCE3 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE2_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE2_RCE2_RESETVAL   (0x00000000u)
/*----RCE2 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE2_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE2_RCE1_RESETVAL   (0x00000000u)
/*----RCE1 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE2_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE0_RESETVAL   (0x00000000u)
/*----RCE0 Tokens----*/
#define CSL_MCBSP_RCERE2_RCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE2_RESETVAL        (0x00000000u)

/* XCERE2 */

#define CSL_MCBSP_XCERE2_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE2_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE2_XCE31_RESETVAL  (0x00000000u)
/*----XCE31 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE2_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE2_XCE30_RESETVAL  (0x00000000u)
/*----XCE30 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE2_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE2_XCE29_RESETVAL  (0x00000000u)
/*----XCE29 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE2_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE2_XCE28_RESETVAL  (0x00000000u)
/*----XCE28 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE2_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE2_XCE27_RESETVAL  (0x00000000u)
/*----XCE27 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE2_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE2_XCE26_RESETVAL  (0x00000000u)
/*----XCE26 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE2_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE2_XCE25_RESETVAL  (0x00000000u)
/*----XCE25 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE2_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE2_XCE24_RESETVAL  (0x00000000u)
/*----XCE24 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE2_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE2_XCE23_RESETVAL  (0x00000000u)
/*----XCE23 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE2_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE2_XCE22_RESETVAL  (0x00000000u)
/*----XCE22 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE2_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE2_XCE21_RESETVAL  (0x00000000u)
/*----XCE21 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE2_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE2_XCE20_RESETVAL  (0x00000000u)
/*----XCE20 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE2_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE2_XCE19_RESETVAL  (0x00000000u)
/*----XCE19 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE2_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE2_XCE18_RESETVAL  (0x00000000u)
/*----XCE18 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE2_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE2_XCE17_RESETVAL  (0x00000000u)
/*----XCE17 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE2_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE2_XCE16_RESETVAL  (0x00000000u)
/*----XCE16 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE2_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE2_XCE15_RESETVAL  (0x00000000u)
/*----XCE15 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE2_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE2_XCE14_RESETVAL  (0x00000000u)
/*----XCE14 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE2_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE2_XCE13_RESETVAL  (0x00000000u)
/*----XCE13 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE2_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE2_XCE12_RESETVAL  (0x00000000u)
/*----XCE12 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE2_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE2_XCE11_RESETVAL  (0x00000000u)
/*----XCE11 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE2_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE2_XCE10_RESETVAL  (0x00000000u)
/*----XCE10 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE2_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE2_XCE9_RESETVAL   (0x00000000u)
/*----XCE9 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE2_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE2_XCE8_RESETVAL   (0x00000000u)
/*----XCE8 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE2_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE2_XCE7_RESETVAL   (0x00000000u)
/*----XCE7 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE2_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE2_XCE6_RESETVAL   (0x00000000u)
/*----XCE6 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE2_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE2_XCE5_RESETVAL   (0x00000000u)
/*----XCE5 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE2_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE2_XCE4_RESETVAL   (0x00000000u)
/*----XCE4 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE2_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE2_XCE3_RESETVAL   (0x00000000u)
/*----XCE3 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE2_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE2_XCE2_RESETVAL   (0x00000000u)
/*----XCE2 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE2_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE2_XCE1_RESETVAL   (0x00000000u)
/*----XCE1 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE2_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE0_RESETVAL   (0x00000000u)
/*----XCE0 Tokens----*/
#define CSL_MCBSP_XCERE2_XCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE2_RESETVAL        (0x00000000u)

/* RCERE3 */

#define CSL_MCBSP_RCERE3_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE3_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE3_RCE31_RESETVAL  (0x00000000u)
/*----RCE31 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE3_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE3_RCE30_RESETVAL  (0x00000000u)
/*----RCE30 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE3_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE3_RCE29_RESETVAL  (0x00000000u)
/*----RCE29 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE3_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE3_RCE28_RESETVAL  (0x00000000u)
/*----RCE28 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE3_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE3_RCE27_RESETVAL  (0x00000000u)
/*----RCE27 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE3_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE3_RCE26_RESETVAL  (0x00000000u)
/*----RCE26 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE3_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE3_RCE25_RESETVAL  (0x00000000u)
/*----RCE25 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE3_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE3_RCE24_RESETVAL  (0x00000000u)
/*----RCE24 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE3_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE3_RCE23_RESETVAL  (0x00000000u)
/*----RCE23 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE3_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE3_RCE22_RESETVAL  (0x00000000u)
/*----RCE22 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE3_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE3_RCE21_RESETVAL  (0x00000000u)
/*----RCE21 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE3_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE3_RCE20_RESETVAL  (0x00000000u)
/*----RCE20 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE3_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE3_RCE19_RESETVAL  (0x00000000u)
/*----RCE19 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE3_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE3_RCE18_RESETVAL  (0x00000000u)
/*----RCE18 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE3_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE3_RCE17_RESETVAL  (0x00000000u)
/*----RCE17 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE3_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE3_RCE16_RESETVAL  (0x00000000u)
/*----RCE16 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE3_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE3_RCE15_RESETVAL  (0x00000000u)
/*----RCE15 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE3_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE3_RCE14_RESETVAL  (0x00000000u)
/*----RCE14 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE3_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE3_RCE13_RESETVAL  (0x00000000u)
/*----RCE13 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE3_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE3_RCE12_RESETVAL  (0x00000000u)
/*----RCE12 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE3_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE3_RCE11_RESETVAL  (0x00000000u)
/*----RCE11 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE3_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE3_RCE10_RESETVAL  (0x00000000u)
/*----RCE10 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE3_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE3_RCE9_RESETVAL   (0x00000000u)
/*----RCE9 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE3_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE3_RCE8_RESETVAL   (0x00000000u)
/*----RCE8 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE3_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE3_RCE7_RESETVAL   (0x00000000u)
/*----RCE7 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE3_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE3_RCE6_RESETVAL   (0x00000000u)
/*----RCE6 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE3_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE3_RCE5_RESETVAL   (0x00000000u)
/*----RCE5 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE3_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE3_RCE4_RESETVAL   (0x00000000u)
/*----RCE4 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE3_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE3_RCE3_RESETVAL   (0x00000000u)
/*----RCE3 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE3_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE3_RCE2_RESETVAL   (0x00000000u)
/*----RCE2 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE3_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE3_RCE1_RESETVAL   (0x00000000u)
/*----RCE1 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE3_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE0_RESETVAL   (0x00000000u)
/*----RCE0 Tokens----*/
#define CSL_MCBSP_RCERE3_RCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_RCERE3_RESETVAL        (0x00000000u)

/* XCERE3 */

#define CSL_MCBSP_XCERE3_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE3_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE3_XCE31_RESETVAL  (0x00000000u)
/*----XCE31 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE31_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE31_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE3_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE3_XCE30_RESETVAL  (0x00000000u)
/*----XCE30 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE30_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE30_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE3_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE3_XCE29_RESETVAL  (0x00000000u)
/*----XCE29 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE29_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE29_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE3_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE3_XCE28_RESETVAL  (0x00000000u)
/*----XCE28 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE28_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE28_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE3_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE3_XCE27_RESETVAL  (0x00000000u)
/*----XCE27 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE27_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE27_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE3_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE3_XCE26_RESETVAL  (0x00000000u)
/*----XCE26 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE26_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE26_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE3_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE3_XCE25_RESETVAL  (0x00000000u)
/*----XCE25 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE25_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE25_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE3_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE3_XCE24_RESETVAL  (0x00000000u)
/*----XCE24 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE24_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE24_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE3_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE3_XCE23_RESETVAL  (0x00000000u)
/*----XCE23 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE23_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE23_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE3_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE3_XCE22_RESETVAL  (0x00000000u)
/*----XCE22 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE22_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE22_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE3_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE3_XCE21_RESETVAL  (0x00000000u)
/*----XCE21 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE21_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE21_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE3_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE3_XCE20_RESETVAL  (0x00000000u)
/*----XCE20 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE20_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE20_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE3_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE3_XCE19_RESETVAL  (0x00000000u)
/*----XCE19 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE19_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE19_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE3_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE3_XCE18_RESETVAL  (0x00000000u)
/*----XCE18 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE18_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE18_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE3_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE3_XCE17_RESETVAL  (0x00000000u)
/*----XCE17 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE17_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE17_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE3_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE3_XCE16_RESETVAL  (0x00000000u)
/*----XCE16 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE16_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE16_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE3_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE3_XCE15_RESETVAL  (0x00000000u)
/*----XCE15 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE15_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE15_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE3_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE3_XCE14_RESETVAL  (0x00000000u)
/*----XCE14 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE14_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE14_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE3_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE3_XCE13_RESETVAL  (0x00000000u)
/*----XCE13 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE13_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE13_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE3_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE3_XCE12_RESETVAL  (0x00000000u)
/*----XCE12 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE12_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE12_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE3_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE3_XCE11_RESETVAL  (0x00000000u)
/*----XCE11 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE11_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE11_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE3_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE3_XCE10_RESETVAL  (0x00000000u)
/*----XCE10 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE10_CHDISABLE (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE10_CHENABLE  (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE3_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE3_XCE9_RESETVAL   (0x00000000u)
/*----XCE9 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE9_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE9_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE3_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE3_XCE8_RESETVAL   (0x00000000u)
/*----XCE8 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE8_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE8_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE3_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE3_XCE7_RESETVAL   (0x00000000u)
/*----XCE7 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE7_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE7_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE3_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE3_XCE6_RESETVAL   (0x00000000u)
/*----XCE6 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE6_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE6_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE3_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE3_XCE5_RESETVAL   (0x00000000u)
/*----XCE5 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE5_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE5_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE3_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE3_XCE4_RESETVAL   (0x00000000u)
/*----XCE4 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE4_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE4_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE3_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE3_XCE3_RESETVAL   (0x00000000u)
/*----XCE3 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE3_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE3_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE3_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE3_XCE2_RESETVAL   (0x00000000u)
/*----XCE2 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE2_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE2_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE3_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE3_XCE1_RESETVAL   (0x00000000u)
/*----XCE1 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE1_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE1_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE3_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE0_RESETVAL   (0x00000000u)
/*----XCE0 Tokens----*/
#define CSL_MCBSP_XCERE3_XCE0_CHDISABLE  (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE0_CHENABLE   (0x00000001u)

#define CSL_MCBSP_XCERE3_RESETVAL        (0x00000000u)

/* REVID */

#define CSL_BFIFO_REVID_REV_MASK         (0xFFFFFFFFu)
#define CSL_BFIFO_REVID_REV_SHIFT        (0x00000000u)
#define CSL_BFIFO_REVID_REV_RESETVAL     (0x44311100u)

#define CSL_BFIFO_REVID_RESETVAL         (0x44311100u)

/* WFIFOCTL */


#define CSL_BFIFO_WFIFOCTL_WENA_MASK        (0x00010000u)
#define CSL_BFIFO_WFIFOCTL_WENA_SHIFT       (0x00000010u)
#define CSL_BFIFO_WFIFOCTL_WENA_RESETVAL    (0x00000000u)
#define CSL_BFIFO_WFIFOCTL_WENA_DISABLED    (0x00000000u)
#define CSL_BFIFO_WFIFOCTL_WENA_ENABLED     (0x00000001u)

#define CSL_BFIFO_WFIFOCTL_WNUMEVT_MASK     (0x0000FF00u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_SHIFT    (0x00000008u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_RESETVAL (0x00000010u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_0WORDS   (0x00000000u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_4WORDS   (0x00000004u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_8WORDS   (0x00000008u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_12WORDS  (0x0000000cu)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_16WORDS  (0x00000010u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_20WORDS  (0x00000014u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_24WORDS  (0x00000018u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_28WORDS  (0x0000001cu)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_32WORDS  (0x00000020u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_36WORDS  (0x00000024u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_40WORDS  (0x00000028u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_44WORDS  (0x0000002cu)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_48WORDS  (0x00000030u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_52WORDS  (0x00000034u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_56WORDS  (0x00000038u)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_60WORDS  (0x0000003cu)
#define CSL_BFIFO_WFIFOCTL_WNUMEVT_64WORDS  (0x00000040u)

#define CSL_BFIFO_WFIFOCTL_WNUMDMA_MASK     (0x000000FFu)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_SHIFT    (0x00000000u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_RESETVAL (0x00000004u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_0WORDS   (0x00000000u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_1WORDS   (0x00000001u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_2WORDS   (0x00000002u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_3WORDS   (0x00000003u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_4WORDS   (0x00000004u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_5WORDS   (0x00000005u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_6WORDS   (0x00000006u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_7WORDS   (0x00000007u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_8WORDS   (0x00000008u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_9WORDS   (0x00000009u)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_10WORDS  (0x0000000au)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_11WORDS  (0x0000000bu)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_12WORDS  (0x0000000cu)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_13WORDS  (0x0000000du)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_14WORDS  (0x0000000eu)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_15WORDS  (0x0000000fu)
#define CSL_BFIFO_WFIFOCTL_WNUMDMA_16WORDS  (0x00000010u)

#define CSL_BFIFO_WFIFOCTL_RESETVAL         (0x00001004u)

/* WFIFOSTS */


#define CSL_BFIFO_WFIFOSTS_WLVL_MASK        (0x000000FFu)
#define CSL_BFIFO_WFIFOSTS_WLVL_SHIFT       (0x00000000u)
#define CSL_BFIFO_WFIFOSTS_WLVL_RESETVAL    (0x00000000u)

#define CSL_BFIFO_WFIFOSTS_RESETVAL         (0x00000000u)

/* RFIFOCTL */


#define CSL_BFIFO_RFIFOCTL_RENA_MASK        (0x00010000u)
#define CSL_BFIFO_RFIFOCTL_RENA_SHIFT       (0x00000010u)
#define CSL_BFIFO_RFIFOCTL_RENA_RESETVAL    (0x00000000u)
#define CSL_BFIFO_RFIFOCTL_RENA_DISABLED    (0x00000000u)
#define CSL_BFIFO_RFIFOCTL_RENA_ENABLED     (0x00000001u)

#define CSL_BFIFO_RFIFOCTL_RNUMEVT_MASK     (0x0000FF00u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_SHIFT    (0x00000008u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_RESETVAL (0x00000010u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_0WORDS   (0x00000000u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_4WORDS   (0x00000004u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_8WORDS   (0x00000008u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_12WORDS  (0x0000000cu)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_16WORDS  (0x00000010u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_20WORDS  (0x00000014u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_24WORDS  (0x00000018u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_28WORDS  (0x0000001cu)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_32WORDS  (0x00000020u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_36WORDS  (0x00000024u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_40WORDS  (0x00000028u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_44WORDS  (0x0000002cu)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_48WORDS  (0x00000030u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_52WORDS  (0x00000034u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_56WORDS  (0x00000038u)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_60WORDS  (0x0000003cu)
#define CSL_BFIFO_RFIFOCTL_RNUMEVT_64WORDS  (0x00000040u)

#define CSL_BFIFO_RFIFOCTL_RNUMDMA_MASK     (0x000000FFu)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_SHIFT    (0x00000000u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_RESETVAL (0x00000004u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_0WORDS   (0x00000000u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_1WORDS   (0x00000001u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_2WORDS   (0x00000002u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_3WORDS   (0x00000003u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_4WORDS   (0x00000004u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_5WORDS   (0x00000005u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_6WORDS   (0x00000006u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_7WORDS   (0x00000007u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_8WORDS   (0x00000008u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_9WORDS   (0x00000009u)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_10WORDS  (0x0000000au)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_11WORDS  (0x0000000bu)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_12WORDS  (0x0000000cu)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_13WORDS  (0x0000000du)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_14WORDS  (0x0000000eu)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_15WORDS  (0x0000000fu)
#define CSL_BFIFO_RFIFOCTL_RNUMDMA_16WORDS  (0x00000010u)

#define CSL_BFIFO_RFIFOCTL_RESETVAL         (0x00001004u)

/* RFIFOSTS */


#define CSL_BFIFO_RFIFOSTS_RLVL_MASK        (0x000000FFu)
#define CSL_BFIFO_RFIFOSTS_RLVL_SHIFT       (0x00000000u)
#define CSL_BFIFO_RFIFOSTS_RLVL_RESETVAL    (0x00000000u)

#define CSL_BFIFO_RFIFOSTS_RESETVAL         (0x00000000u)



/* DATA_PORT */

#define CSL_BDATA_DATA_PORT_DATA_MASK      (0xFFFFFFFFu)
#define CSL_BDATA_DATA_PORT_DATA_SHIFT     (0x00000000u)
#define CSL_BDATA_DATA_PORT_DATA_RESETVAL  (0x00000000u)
#define CSL_BDATA_DATA_PORT_RESETVAL       (0x00000000u)

/* RSVD_04 */


#define CSL_BDATA_RSVD_04_RESETVAL         (0x00000000u)

/* RSVD_08 */


#define CSL_BDATA_RSVD_08_RESETVAL         (0x00000000u)

/* RSVD_0C */


#define CSL_BDATA_RSVD_0C_RESETVAL         (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif

