#ifndef _CSLR_ECAP_H_
#define _CSLR_ECAP_H_

#include <csl/cslr.h>
#include "tistdtypes.h"



/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 TSCTR;
    volatile Uint32 CTRPHS;
    volatile Uint32 CAP1;
    volatile Uint32 CAP2;
    volatile Uint32 CAP3;
    volatile Uint32 CAP4;
    volatile Uint16 RSVD0[8];
    volatile Uint16 ECCTL1;
    volatile Uint16 ECCTL2;
    volatile Uint16 ECEINT;
    volatile Uint16 ECFLG;
    volatile Uint16 ECCLR;
    volatile Uint16 ECFRC;
    volatile Uint16 RSVD1[20];
    volatile Uint32 REVID;
} CSL_EcapRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_EcapRegs         *CSL_EcapRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TSCTR */

#define CSL_ECAP_TSCTR_TSCTR_MASK (0xFFFFFFFFu)
#define CSL_ECAP_TSCTR_TSCTR_SHIFT (0x00000000u)
#define CSL_ECAP_TSCTR_TSCTR_RESETVAL (0x00000000u)

#define CSL_ECAP_TSCTR_RESETVAL (0x00000000u)

/* CTRPHS */

#define CSL_ECAP_CTRPHS_CTRPHS_MASK (0xFFFFFFFFu)
#define CSL_ECAP_CTRPHS_CTRPHS_SHIFT (0x00000000u)
#define CSL_ECAP_CTRPHS_CTRPHS_RESETVAL (0x00000000u)

#define CSL_ECAP_CTRPHS_RESETVAL (0x00000000u)

/* CAP1 */

#define CSL_ECAP_CAP1_CAP1_MASK (0xFFFFFFFFu)
#define CSL_ECAP_CAP1_CAP1_SHIFT (0x00000000u)
#define CSL_ECAP_CAP1_CAP1_RESETVAL (0x00000000u)

#define CSL_ECAP_CAP1_RESETVAL (0x00000000u)

/* CAP2 */

#define CSL_ECAP_CAP2_CAP2_MASK (0xFFFFFFFFu)
#define CSL_ECAP_CAP2_CAP2_SHIFT (0x00000000u)
#define CSL_ECAP_CAP2_CAP2_RESETVAL (0x00000000u)

#define CSL_ECAP_CAP2_RESETVAL (0x00000000u)

/* CAP3 */

#define CSL_ECAP_CAP3_CAP3_MASK (0xFFFFFFFFu)
#define CSL_ECAP_CAP3_CAP3_SHIFT (0x00000000u)
#define CSL_ECAP_CAP3_CAP3_RESETVAL (0x00000000u)

#define CSL_ECAP_CAP3_RESETVAL (0x00000000u)

/* CAP4 */

#define CSL_ECAP_CAP4_CAP4_MASK (0xFFFFFFFFu)
#define CSL_ECAP_CAP4_CAP4_SHIFT (0x00000000u)
#define CSL_ECAP_CAP4_CAP4_RESETVAL (0x00000000u)

#define CSL_ECAP_CAP4_RESETVAL (0x00000000u)

/* ECCTL1 */

#define CSL_ECAP_ECCTL1_FREE_SOFT_MASK (0xC000u)
#define CSL_ECAP_ECCTL1_FREE_SOFT_SHIFT (0x000Eu)
#define CSL_ECAP_ECCTL1_FREE_SOFT_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_FREE_SOFT_STOP (0x0000u)
#define CSL_ECAP_ECCTL1_FREE_SOFT_RUNUNTIL0 (0x0001u)
#define CSL_ECAP_ECCTL1_FREE_SOFT_RUNFREE (0x0002u)
#define CSL_ECAP_ECCTL1_FREE_SOFT_RUNFREE (0x0003u)

#define CSL_ECAP_ECCTL1_PRESCALE_MASK (0x3E00u)
#define CSL_ECAP_ECCTL1_PRESCALE_SHIFT (0x0009u)
#define CSL_ECAP_ECCTL1_PRESCALE_RESETVAL (0x0000u)

#define CSL_ECAP_ECCTL1_CAPLDEN_MASK (0x0100u)
#define CSL_ECAP_ECCTL1_CAPLDEN_SHIFT (0x0008u)
#define CSL_ECAP_ECCTL1_CAPLDEN_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CAPLDEN_DISABLE (0x0000u)
#define CSL_ECAP_ECCTL1_CAPLDEN_ENABLE (0x0001u)

#define CSL_ECAP_ECCTL1_CTRRST4_MASK (0x0080u)
#define CSL_ECAP_ECCTL1_CTRRST4_SHIFT (0x0007u)
#define CSL_ECAP_ECCTL1_CTRRST4_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST4_NORESET (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST4_RESET (0x0001u)

#define CSL_ECAP_ECCTL1_CAP4POL_MASK (0x0040u)
#define CSL_ECAP_ECCTL1_CAP4POL_SHIFT (0x0006u)
#define CSL_ECAP_ECCTL1_CAP4POL_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CAP4POL_RISINGEDGE (0x0000u)
#define CSL_ECAP_ECCTL1_CAP4POL_FALLINGEDGE (0x0001u)

#define CSL_ECAP_ECCTL1_CTRRST3_MASK (0x0020u)
#define CSL_ECAP_ECCTL1_CTRRST3_SHIFT (0x0005u)
#define CSL_ECAP_ECCTL1_CTRRST3_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST3_NORESET (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST3_RESET (0x0001u)

#define CSL_ECAP_ECCTL1_CAP3POL_MASK (0x0010u)
#define CSL_ECAP_ECCTL1_CAP3POL_SHIFT (0x0004u)
#define CSL_ECAP_ECCTL1_CAP3POL_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CAP3POL_RISINGEDGE (0x0000u)
#define CSL_ECAP_ECCTL1_CAP3POL_FALLINGEDGE (0x0001u)

#define CSL_ECAP_ECCTL1_CTRRST2_MASK (0x0008u)
#define CSL_ECAP_ECCTL1_CTRRST2_SHIFT (0x0003u)
#define CSL_ECAP_ECCTL1_CTRRST2_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST2_NORESET (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST2_RESET (0x0001u)

#define CSL_ECAP_ECCTL1_CAP2POL_MASK (0x0004u)
#define CSL_ECAP_ECCTL1_CAP2POL_SHIFT (0x0002u)
#define CSL_ECAP_ECCTL1_CAP2POL_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CAP2POL_RISINGEDGE (0x0000u)
#define CSL_ECAP_ECCTL1_CAP2POL_FALLINGEDGE (0x0001u)

#define CSL_ECAP_ECCTL1_CTRRST1_MASK (0x0002u)
#define CSL_ECAP_ECCTL1_CTRRST1_SHIFT (0x0001u)
#define CSL_ECAP_ECCTL1_CTRRST1_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST1_NORESET (0x0000u)
#define CSL_ECAP_ECCTL1_CTRRST1_RESET (0x0001u)

#define CSL_ECAP_ECCTL1_CAP1POL_MASK (0x0001u)
#define CSL_ECAP_ECCTL1_CAP1POL_SHIFT (0x0000u)
#define CSL_ECAP_ECCTL1_CAP1POL_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL1_CAP1POL_RISINGEDGE (0x0000u)
#define CSL_ECAP_ECCTL1_CAP1POL_FALLINGEDGE (0x0001u)

#define CSL_ECAP_ECCTL1_RESETVAL (0x0000u)

/* ECCTL2 */


#define CSL_ECAP_ECCTL2_APWMPOL_MASK (0x0400u)
#define CSL_ECAP_ECCTL2_APWMPOL_SHIFT (0x000Au)
#define CSL_ECAP_ECCTL2_APWMPOL_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_APWMPOL_ACTIVEHIGH (0x0000u)
#define CSL_ECAP_ECCTL2_APWMPOL_ACTIVELOW (0x0001u)

#define CSL_ECAP_ECCTL2_CAP_APWM_MASK (0x0200u)
#define CSL_ECAP_ECCTL2_CAP_APWM_SHIFT (0x0009u)
#define CSL_ECAP_ECCTL2_CAP_APWM_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_CAP_APWM_CAPMODE (0x0000u)
#define CSL_ECAP_ECCTL2_CAP_APWM_APWMMODE (0x0001u)

#define CSL_ECAP_ECCTL2_SWSYNC_MASK (0x0100u)
#define CSL_ECAP_ECCTL2_SWSYNC_SHIFT (0x0008u)
#define CSL_ECAP_ECCTL2_SWSYNC_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_SWSYNC_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCTL2_SWSYNC_TSCTRLOAD (0x0001u)

#define CSL_ECAP_ECCTL2_SYNCO_SEL_MASK (0x00C0u)
#define CSL_ECAP_ECCTL2_SYNCO_SEL_SHIFT (0x0006u)
#define CSL_ECAP_ECCTL2_SYNCO_SEL_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_SYNCO_SEL_SYNCIN (0x0000u)
#define CSL_ECAP_ECCTL2_SYNCO_SEL_CTREQUALPRD (0x0001u)
#define CSL_ECAP_ECCTL2_SYNCO_SEL_DISABLE (0x0002u)
#define CSL_ECAP_ECCTL2_SYNCO_SEL_DISABLE (0x0003u)

#define CSL_ECAP_ECCTL2_SYNCI_EN_MASK (0x0020u)
#define CSL_ECAP_ECCTL2_SYNCI_EN_SHIFT (0x0005u)
#define CSL_ECAP_ECCTL2_SYNCI_EN_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_SYNCI_EN_DISABLE (0x0000u)
#define CSL_ECAP_ECCTL2_SYNCI_EN_ENABLE (0x0001u)

#define CSL_ECAP_ECCTL2_TSCTRSTOP_MASK (0x0010u)
#define CSL_ECAP_ECCTL2_TSCTRSTOP_SHIFT (0x0004u)
#define CSL_ECAP_ECCTL2_TSCTRSTOP_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_TSCTRSTOP_STOPPED (0x0000u)
#define CSL_ECAP_ECCTL2_TSCTRSTOP_FREERUNNING (0x0001u)

#define CSL_ECAP_ECCTL2_RE_ARM_MASK (0x0008u)
#define CSL_ECAP_ECCTL2_RE_ARM_SHIFT (0x0003u)
#define CSL_ECAP_ECCTL2_RE_ARM_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_RE_ARM_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCTL2_RE_ARM_ARMED (0x0001u)

#define CSL_ECAP_ECCTL2_STOP_WRAP_MASK (0x0006u)
#define CSL_ECAP_ECCTL2_STOP_WRAP_SHIFT (0x0001u)
#define CSL_ECAP_ECCTL2_STOP_WRAP_RESETVAL (0x0003u)
#define CSL_ECAP_ECCTL2_STOP_WRAP_CAP1 (0x0000u)
#define CSL_ECAP_ECCTL2_STOP_WRAP_CAP2 (0x0001u)
#define CSL_ECAP_ECCTL2_STOP_WRAP_CAP3 (0x0002u)
#define CSL_ECAP_ECCTL2_STOP_WRAP_CAP4 (0x0003u)

#define CSL_ECAP_ECCTL2_CONT_ONESHT_MASK (0x0001u)
#define CSL_ECAP_ECCTL2_CONT_ONESHT_SHIFT (0x0000u)
#define CSL_ECAP_ECCTL2_CONT_ONESHT_RESETVAL (0x0000u)
#define CSL_ECAP_ECCTL2_CONT_ONESHT_CONTINUOUS (0x0000u)
#define CSL_ECAP_ECCTL2_CONT_ONESHT_ONESHOT (0x0001u)

#define CSL_ECAP_ECCTL2_RESETVAL (0x0006u)

/* ECEINT */


#define CSL_ECAP_ECEINT_CTR=CMP_MASK (0x0080u)
#define CSL_ECAP_ECEINT_CTR=CMP_SHIFT (0x0007u)
#define CSL_ECAP_ECEINT_CTR=CMP_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CTR=CMP_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CTR=CMP_ENABLE (0x0001u)

#define CSL_ECAP_ECEINT_CTR=PRD_MASK (0x0040u)
#define CSL_ECAP_ECEINT_CTR=PRD_SHIFT (0x0006u)
#define CSL_ECAP_ECEINT_CTR=PRD_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CTR=PRD_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CTR=PRD_ENABLE (0x0001u)

#define CSL_ECAP_ECEINT_CTROVF_MASK (0x0020u)
#define CSL_ECAP_ECEINT_CTROVF_SHIFT (0x0005u)
#define CSL_ECAP_ECEINT_CTROVF_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CTROVF_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CTROVF_ENABLE (0x0001u)

#define CSL_ECAP_ECEINT_CEVT4_MASK (0x0010u)
#define CSL_ECAP_ECEINT_CEVT4_SHIFT (0x0004u)
#define CSL_ECAP_ECEINT_CEVT4_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CEVT4_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CEVT4_ENABLE (0x0001u)

#define CSL_ECAP_ECEINT_CEVT3_MASK (0x0008u)
#define CSL_ECAP_ECEINT_CEVT3_SHIFT (0x0003u)
#define CSL_ECAP_ECEINT_CEVT3_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CEVT3_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CEVT3_ENABLE (0x0001u)

#define CSL_ECAP_ECEINT_CEVT2_MASK (0x0004u)
#define CSL_ECAP_ECEINT_CEVT2_SHIFT (0x0002u)
#define CSL_ECAP_ECEINT_CEVT2_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CEVT2_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CEVT2_ENABLE (0x0001u)

#define CSL_ECAP_ECEINT_CEVT1_MASK (0x0002u)
#define CSL_ECAP_ECEINT_CEVT1_SHIFT (0x0001u)
#define CSL_ECAP_ECEINT_CEVT1_RESETVAL (0x0000u)
#define CSL_ECAP_ECEINT_CEVT1_DISABLE (0x0000u)
#define CSL_ECAP_ECEINT_CEVT1_ENABLE (0x0001u)


#define CSL_ECAP_ECEINT_RESETVAL (0x0000u)

/* ECFLG */


#define CSL_ECAP_ECFLG_CTR=CMP_MASK (0x0080u)
#define CSL_ECAP_ECFLG_CTR=CMP_SHIFT (0x0007u)
#define CSL_ECAP_ECFLG_CTR=CMP_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CTR=CMP_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CTR=CMP_INT (0x0001u)

#define CSL_ECAP_ECFLG_CTR=PRD_MASK (0x0040u)
#define CSL_ECAP_ECFLG_CTR=PRD_SHIFT (0x0006u)
#define CSL_ECAP_ECFLG_CTR=PRD_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CTR=PRD_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CTR=PRD_INT (0x0001u)

#define CSL_ECAP_ECFLG_CTROVF_MASK (0x0020u)
#define CSL_ECAP_ECFLG_CTROVF_SHIFT (0x0005u)
#define CSL_ECAP_ECFLG_CTROVF_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CTROVF_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CTROVF_INT (0x0001u)

#define CSL_ECAP_ECFLG_CEVT4_MASK (0x0010u)
#define CSL_ECAP_ECFLG_CEVT4_SHIFT (0x0004u)
#define CSL_ECAP_ECFLG_CEVT4_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CEVT4_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CEVT4_INT (0x0001u)

#define CSL_ECAP_ECFLG_CEVT3_MASK (0x0008u)
#define CSL_ECAP_ECFLG_CEVT3_SHIFT (0x0003u)
#define CSL_ECAP_ECFLG_CEVT3_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CEVT3_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CEVT3_INT (0x0001u)

#define CSL_ECAP_ECFLG_CEVT2_MASK (0x0004u)
#define CSL_ECAP_ECFLG_CEVT2_SHIFT (0x0002u)
#define CSL_ECAP_ECFLG_CEVT2_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CEVT2_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CEVT2_INT (0x0001u)

#define CSL_ECAP_ECFLG_CEVT1_MASK (0x0002u)
#define CSL_ECAP_ECFLG_CEVT1_SHIFT (0x0001u)
#define CSL_ECAP_ECFLG_CEVT1_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_CEVT1_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_CEVT1_INT (0x0001u)

#define CSL_ECAP_ECFLG_INT_MASK (0x0001u)
#define CSL_ECAP_ECFLG_INT_SHIFT (0x0000u)
#define CSL_ECAP_ECFLG_INT_RESETVAL (0x0000u)
#define CSL_ECAP_ECFLG_INT_NOINT (0x0000u)
#define CSL_ECAP_ECFLG_INT_INT (0x0001u)

#define CSL_ECAP_ECFLG_RESETVAL (0x0000u)

/* ECCLR */


#define CSL_ECAP_ECCLR_CTR=CMP_MASK (0x0080u)
#define CSL_ECAP_ECCLR_CTR=CMP_SHIFT (0x0007u)
#define CSL_ECAP_ECCLR_CTR=CMP_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CTR=CMP_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CTR=CMP_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_CTR=PRD_MASK (0x0040u)
#define CSL_ECAP_ECCLR_CTR=PRD_SHIFT (0x0006u)
#define CSL_ECAP_ECCLR_CTR=PRD_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CTR=PRD_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CTR=PRD_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_CTROVF_MASK (0x0020u)
#define CSL_ECAP_ECCLR_CTROVF_SHIFT (0x0005u)
#define CSL_ECAP_ECCLR_CTROVF_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CTROVF_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CTROVF_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_CEVT4_MASK (0x0010u)
#define CSL_ECAP_ECCLR_CEVT4_SHIFT (0x0004u)
#define CSL_ECAP_ECCLR_CEVT4_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CEVT4_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CEVT4_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_CEVT3_MASK (0x0008u)
#define CSL_ECAP_ECCLR_CEVT3_SHIFT (0x0003u)
#define CSL_ECAP_ECCLR_CEVT3_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CEVT3_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CEVT3_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_CEVT2_MASK (0x0004u)
#define CSL_ECAP_ECCLR_CEVT2_SHIFT (0x0002u)
#define CSL_ECAP_ECCLR_CEVT2_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CEVT2_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CEVT2_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_CEVT1_MASK (0x0002u)
#define CSL_ECAP_ECCLR_CEVT1_SHIFT (0x0001u)
#define CSL_ECAP_ECCLR_CEVT1_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_CEVT1_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_CEVT1_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_INT_MASK (0x0001u)
#define CSL_ECAP_ECCLR_INT_SHIFT (0x0000u)
#define CSL_ECAP_ECCLR_INT_RESETVAL (0x0000u)
#define CSL_ECAP_ECCLR_INT_NOEFFECT (0x0000u)
#define CSL_ECAP_ECCLR_INT_CLEAR (0x0001u)

#define CSL_ECAP_ECCLR_RESETVAL (0x0000u)

/* ECFRC */


#define CSL_ECAP_ECFRC_CTR=CMP_MASK (0x0080u)
#define CSL_ECAP_ECFRC_CTR=CMP_SHIFT (0x0007u)
#define CSL_ECAP_ECFRC_CTR=CMP_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CTR=CMP_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CTR=CMP_FORCE (0x0001u)

#define CSL_ECAP_ECFRC_CTR=PRD_MASK (0x0040u)
#define CSL_ECAP_ECFRC_CTR=PRD_SHIFT (0x0006u)
#define CSL_ECAP_ECFRC_CTR=PRD_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CTR=PRD_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CTR=PRD_FORCE (0x0001u)

#define CSL_ECAP_ECFRC_CTROVF_MASK (0x0020u)
#define CSL_ECAP_ECFRC_CTROVF_SHIFT (0x0005u)
#define CSL_ECAP_ECFRC_CTROVF_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CTROVF_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CTROVF_FORCE (0x0001u)

#define CSL_ECAP_ECFRC_CEVT4_MASK (0x0010u)
#define CSL_ECAP_ECFRC_CEVT4_SHIFT (0x0004u)
#define CSL_ECAP_ECFRC_CEVT4_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CEVT4_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CEVT4_FORCE (0x0001u)

#define CSL_ECAP_ECFRC_CEVT3_MASK (0x0008u)
#define CSL_ECAP_ECFRC_CEVT3_SHIFT (0x0003u)
#define CSL_ECAP_ECFRC_CEVT3_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CEVT3_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CEVT3_FORCE (0x0001u)

#define CSL_ECAP_ECFRC_CEVT2_MASK (0x0004u)
#define CSL_ECAP_ECFRC_CEVT2_SHIFT (0x0002u)
#define CSL_ECAP_ECFRC_CEVT2_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CEVT2_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CEVT2_FORCE (0x0001u)

#define CSL_ECAP_ECFRC_CEVT1_MASK (0x0002u)
#define CSL_ECAP_ECFRC_CEVT1_SHIFT (0x0001u)
#define CSL_ECAP_ECFRC_CEVT1_RESETVAL (0x0000u)
#define CSL_ECAP_ECFRC_CEVT1_NOEFFECT (0x0000u)
#define CSL_ECAP_ECFRC_CEVT1_FORCE (0x0001u)


#define CSL_ECAP_ECFRC_RESETVAL (0x0000u)

/* REVID */

#define CSL_ECAP_REVID_REV_MASK          (0xFFFFFFFFu)
#define CSL_ECAP_REVID_REV_SHIFT         (0x00000000u)
#define CSL_ECAP_REVID_REV_RESETVAL      (0x44D22100u)

#define CSL_ECAP_REVID_RESETVAL          (0x44D22100u)

#endif
