/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006, 2007
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_intc.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for INTC
 *
 *  ============================================================================
 */
#ifndef _CSLR_DSPINTC_H_
#define _CSLR_DSPINTC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl/cslr.h>
#include "tistdtypes.h"


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 EVTFLAG[4];
    volatile Uint8 RSVD0[16];
    volatile Uint32 EVTSET[4];
    volatile Uint8 RSVD1[16];
    volatile Uint32 EVTCLR[4];
    volatile Uint8 RSVD2[48];
    volatile Uint32 EVTMASK[4];
    volatile Uint8 RSVD3[16];
    volatile Uint32 MEVTFLAG[4];
    volatile Uint8 RSVD4[16];
    volatile Uint32 EXPMASK[4];
    volatile Uint8 RSVD5[16];
    volatile Uint32 MEXPFLAG[4];
    volatile Uint8 RSVD6[20];
    volatile Uint32 INTMUX1;
    volatile Uint32 INTMUX2;
    volatile Uint32 INTMUX3;
    volatile Uint8 RSVD7[48];
    volatile Uint32 AEGMUX0;
    volatile Uint32 AEGMUX1;
    volatile Uint8 RSVD8[56];
    volatile Uint32 INTXSTAT;
    volatile Uint32 INTXCLR;
    volatile Uint32 INTDMASK;
    volatile Uint8 RSVD9[52];
    volatile Uint32 EVTASRT;
} CSL_DspintcRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_DspintcRegs         *CSL_DspintcRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* EVTFLAG */

#define CSL_DSPINTC_EVTFLAG_EF31_MASK (0x80000000u)
#define CSL_DSPINTC_EVTFLAG_EF31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_EVTFLAG_EF31_RESETVAL (0x00000000u)
/*----EF31 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF31_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF31_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF30_MASK (0x40000000u)
#define CSL_DSPINTC_EVTFLAG_EF30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_EVTFLAG_EF30_RESETVAL (0x00000000u)
/*----EF30 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF30_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF30_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF29_MASK (0x20000000u)
#define CSL_DSPINTC_EVTFLAG_EF29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_EVTFLAG_EF29_RESETVAL (0x00000000u)
/*----EF29 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF29_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF29_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF28_MASK (0x10000000u)
#define CSL_DSPINTC_EVTFLAG_EF28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_EVTFLAG_EF28_RESETVAL (0x00000000u)
/*----EF28 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF28_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF28_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF27_MASK (0x08000000u)
#define CSL_DSPINTC_EVTFLAG_EF27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_EVTFLAG_EF27_RESETVAL (0x00000000u)
/*----EF27 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF27_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF27_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF26_MASK (0x04000000u)
#define CSL_DSPINTC_EVTFLAG_EF26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_EVTFLAG_EF26_RESETVAL (0x00000000u)
/*----EF26 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF26_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF26_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF25_MASK (0x02000000u)
#define CSL_DSPINTC_EVTFLAG_EF25_SHIFT (0x00000019u)
#define CSL_DSPINTC_EVTFLAG_EF25_RESETVAL (0x00000000u)
/*----EF25 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF25_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF25_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF24_MASK (0x01000000u)
#define CSL_DSPINTC_EVTFLAG_EF24_SHIFT (0x00000018u)
#define CSL_DSPINTC_EVTFLAG_EF24_RESETVAL (0x00000000u)
/*----EF24 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF24_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF24_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF23_MASK (0x00800000u)
#define CSL_DSPINTC_EVTFLAG_EF23_SHIFT (0x00000017u)
#define CSL_DSPINTC_EVTFLAG_EF23_RESETVAL (0x00000000u)
/*----EF23 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF23_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF23_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF22_MASK (0x00400000u)
#define CSL_DSPINTC_EVTFLAG_EF22_SHIFT (0x00000016u)
#define CSL_DSPINTC_EVTFLAG_EF22_RESETVAL (0x00000000u)
/*----EF22 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF22_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF22_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF21_MASK (0x00200000u)
#define CSL_DSPINTC_EVTFLAG_EF21_SHIFT (0x00000015u)
#define CSL_DSPINTC_EVTFLAG_EF21_RESETVAL (0x00000000u)
/*----EF21 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF21_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF21_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF20_MASK (0x00100000u)
#define CSL_DSPINTC_EVTFLAG_EF20_SHIFT (0x00000014u)
#define CSL_DSPINTC_EVTFLAG_EF20_RESETVAL (0x00000000u)
/*----EF20 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF20_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF20_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF19_MASK (0x00080000u)
#define CSL_DSPINTC_EVTFLAG_EF19_SHIFT (0x00000013u)
#define CSL_DSPINTC_EVTFLAG_EF19_RESETVAL (0x00000000u)
/*----EF19 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF19_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF19_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF18_MASK (0x00040000u)
#define CSL_DSPINTC_EVTFLAG_EF18_SHIFT (0x00000012u)
#define CSL_DSPINTC_EVTFLAG_EF18_RESETVAL (0x00000000u)
/*----EF18 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF18_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF18_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF17_MASK (0x00020000u)
#define CSL_DSPINTC_EVTFLAG_EF17_SHIFT (0x00000011u)
#define CSL_DSPINTC_EVTFLAG_EF17_RESETVAL (0x00000000u)
/*----EF17 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF17_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF17_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF16_MASK (0x00010000u)
#define CSL_DSPINTC_EVTFLAG_EF16_SHIFT (0x00000010u)
#define CSL_DSPINTC_EVTFLAG_EF16_RESETVAL (0x00000000u)
/*----EF16 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF16_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF16_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF15_MASK (0x00008000u)
#define CSL_DSPINTC_EVTFLAG_EF15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_EVTFLAG_EF15_RESETVAL (0x00000000u)
/*----EF15 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF15_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF15_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF14_MASK (0x00004000u)
#define CSL_DSPINTC_EVTFLAG_EF14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_EVTFLAG_EF14_RESETVAL (0x00000000u)
/*----EF14 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF14_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF14_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF13_MASK (0x00002000u)
#define CSL_DSPINTC_EVTFLAG_EF13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_EVTFLAG_EF13_RESETVAL (0x00000000u)
/*----EF13 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF13_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF13_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF12_MASK (0x00001000u)
#define CSL_DSPINTC_EVTFLAG_EF12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_EVTFLAG_EF12_RESETVAL (0x00000000u)
/*----EF12 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF12_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF12_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF11_MASK (0x00000800u)
#define CSL_DSPINTC_EVTFLAG_EF11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_EVTFLAG_EF11_RESETVAL (0x00000000u)
/*----EF11 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF11_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF11_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF10_MASK (0x00000400u)
#define CSL_DSPINTC_EVTFLAG_EF10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_EVTFLAG_EF10_RESETVAL (0x00000000u)
/*----EF10 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF10_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF10_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF9_MASK (0x00000200u)
#define CSL_DSPINTC_EVTFLAG_EF9_SHIFT (0x00000009u)
#define CSL_DSPINTC_EVTFLAG_EF9_RESETVAL (0x00000000u)
/*----EF9 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF9_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF9_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF8_MASK (0x00000100u)
#define CSL_DSPINTC_EVTFLAG_EF8_SHIFT (0x00000008u)
#define CSL_DSPINTC_EVTFLAG_EF8_RESETVAL (0x00000000u)
/*----EF8 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF8_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF8_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF7_MASK (0x00000080u)
#define CSL_DSPINTC_EVTFLAG_EF7_SHIFT (0x00000007u)
#define CSL_DSPINTC_EVTFLAG_EF7_RESETVAL (0x00000000u)
/*----EF7 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF7_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF7_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF6_MASK (0x00000040u)
#define CSL_DSPINTC_EVTFLAG_EF6_SHIFT (0x00000006u)
#define CSL_DSPINTC_EVTFLAG_EF6_RESETVAL (0x00000000u)
/*----EF6 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF6_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF6_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF5_MASK (0x00000020u)
#define CSL_DSPINTC_EVTFLAG_EF5_SHIFT (0x00000005u)
#define CSL_DSPINTC_EVTFLAG_EF5_RESETVAL (0x00000000u)
/*----EF5 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF5_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF5_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF4_MASK (0x00000010u)
#define CSL_DSPINTC_EVTFLAG_EF4_SHIFT (0x00000004u)
#define CSL_DSPINTC_EVTFLAG_EF4_RESETVAL (0x00000000u)
/*----EF4 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF4_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF4_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF3_MASK (0x00000008u)
#define CSL_DSPINTC_EVTFLAG_EF3_SHIFT (0x00000003u)
#define CSL_DSPINTC_EVTFLAG_EF3_RESETVAL (0x00000000u)
/*----EF3 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF3_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF3_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF2_MASK (0x00000004u)
#define CSL_DSPINTC_EVTFLAG_EF2_SHIFT (0x00000002u)
#define CSL_DSPINTC_EVTFLAG_EF2_RESETVAL (0x00000000u)
/*----EF2 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF2_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF2_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF1_MASK (0x00000002u)
#define CSL_DSPINTC_EVTFLAG_EF1_SHIFT (0x00000001u)
#define CSL_DSPINTC_EVTFLAG_EF1_RESETVAL (0x00000000u)
/*----EF1 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF1_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF1_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_EF0_MASK (0x00000001u)
#define CSL_DSPINTC_EVTFLAG_EF0_SHIFT (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF0_RESETVAL (0x00000000u)
/*----EF0 Tokens----*/
#define CSL_DSPINTC_EVTFLAG_EF0_NO (0x00000000u)
#define CSL_DSPINTC_EVTFLAG_EF0_YES (0x00000001u)

#define CSL_DSPINTC_EVTFLAG_RESETVAL (0x00000000u)

/* EVTSET */

#define CSL_DSPINTC_EVTSET_ES31_MASK (0x80000000u)
#define CSL_DSPINTC_EVTSET_ES31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_EVTSET_ES31_RESETVAL (0x00000000u)
/*----ES31 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES31_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES30_MASK (0x40000000u)
#define CSL_DSPINTC_EVTSET_ES30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_EVTSET_ES30_RESETVAL (0x00000000u)
/*----ES30 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES30_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES29_MASK (0x20000000u)
#define CSL_DSPINTC_EVTSET_ES29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_EVTSET_ES29_RESETVAL (0x00000000u)
/*----ES29 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES29_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES28_MASK (0x10000000u)
#define CSL_DSPINTC_EVTSET_ES28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_EVTSET_ES28_RESETVAL (0x00000000u)
/*----ES28 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES28_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES27_MASK (0x08000000u)
#define CSL_DSPINTC_EVTSET_ES27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_EVTSET_ES27_RESETVAL (0x00000000u)
/*----ES27 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES27_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES26_MASK (0x04000000u)
#define CSL_DSPINTC_EVTSET_ES26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_EVTSET_ES26_RESETVAL (0x00000000u)
/*----ES26 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES26_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES25_MASK (0x02000000u)
#define CSL_DSPINTC_EVTSET_ES25_SHIFT (0x00000019u)
#define CSL_DSPINTC_EVTSET_ES25_RESETVAL (0x00000000u)
/*----ES25 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES25_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES24_MASK (0x01000000u)
#define CSL_DSPINTC_EVTSET_ES24_SHIFT (0x00000018u)
#define CSL_DSPINTC_EVTSET_ES24_RESETVAL (0x00000000u)
/*----ES24 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES24_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES23_MASK (0x00800000u)
#define CSL_DSPINTC_EVTSET_ES23_SHIFT (0x00000017u)
#define CSL_DSPINTC_EVTSET_ES23_RESETVAL (0x00000000u)
/*----ES23 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES23_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES22_MASK (0x00400000u)
#define CSL_DSPINTC_EVTSET_ES22_SHIFT (0x00000016u)
#define CSL_DSPINTC_EVTSET_ES22_RESETVAL (0x00000000u)
/*----ES22 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES22_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES21_MASK (0x00200000u)
#define CSL_DSPINTC_EVTSET_ES21_SHIFT (0x00000015u)
#define CSL_DSPINTC_EVTSET_ES21_RESETVAL (0x00000000u)
/*----ES21 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES21_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES20_MASK (0x00100000u)
#define CSL_DSPINTC_EVTSET_ES20_SHIFT (0x00000014u)
#define CSL_DSPINTC_EVTSET_ES20_RESETVAL (0x00000000u)
/*----ES20 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES20_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES19_MASK (0x00080000u)
#define CSL_DSPINTC_EVTSET_ES19_SHIFT (0x00000013u)
#define CSL_DSPINTC_EVTSET_ES19_RESETVAL (0x00000000u)
/*----ES19 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES19_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES18_MASK (0x00040000u)
#define CSL_DSPINTC_EVTSET_ES18_SHIFT (0x00000012u)
#define CSL_DSPINTC_EVTSET_ES18_RESETVAL (0x00000000u)
/*----ES18 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES18_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES17_MASK (0x00020000u)
#define CSL_DSPINTC_EVTSET_ES17_SHIFT (0x00000011u)
#define CSL_DSPINTC_EVTSET_ES17_RESETVAL (0x00000000u)
/*----ES17 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES17_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES16_MASK (0x00010000u)
#define CSL_DSPINTC_EVTSET_ES16_SHIFT (0x00000010u)
#define CSL_DSPINTC_EVTSET_ES16_RESETVAL (0x00000000u)
/*----ES16 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES16_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES15_MASK (0x00008000u)
#define CSL_DSPINTC_EVTSET_ES15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_EVTSET_ES15_RESETVAL (0x00000000u)
/*----ES15 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES15_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES14_MASK (0x00004000u)
#define CSL_DSPINTC_EVTSET_ES14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_EVTSET_ES14_RESETVAL (0x00000000u)
/*----ES14 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES14_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES13_MASK (0x00002000u)
#define CSL_DSPINTC_EVTSET_ES13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_EVTSET_ES13_RESETVAL (0x00000000u)
/*----ES13 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES13_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES12_MASK (0x00001000u)
#define CSL_DSPINTC_EVTSET_ES12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_EVTSET_ES12_RESETVAL (0x00000000u)
/*----ES12 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES12_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES11_MASK (0x00000800u)
#define CSL_DSPINTC_EVTSET_ES11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_EVTSET_ES11_RESETVAL (0x00000000u)
/*----ES11 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES11_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES10_MASK (0x00000400u)
#define CSL_DSPINTC_EVTSET_ES10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_EVTSET_ES10_RESETVAL (0x00000000u)
/*----ES10 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES10_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES9_MASK (0x00000200u)
#define CSL_DSPINTC_EVTSET_ES9_SHIFT (0x00000009u)
#define CSL_DSPINTC_EVTSET_ES9_RESETVAL (0x00000000u)
/*----ES9 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES9_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES8_MASK (0x00000100u)
#define CSL_DSPINTC_EVTSET_ES8_SHIFT (0x00000008u)
#define CSL_DSPINTC_EVTSET_ES8_RESETVAL (0x00000000u)
/*----ES8 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES8_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES7_MASK (0x00000080u)
#define CSL_DSPINTC_EVTSET_ES7_SHIFT (0x00000007u)
#define CSL_DSPINTC_EVTSET_ES7_RESETVAL (0x00000000u)
/*----ES7 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES7_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES6_MASK (0x00000040u)
#define CSL_DSPINTC_EVTSET_ES6_SHIFT (0x00000006u)
#define CSL_DSPINTC_EVTSET_ES6_RESETVAL (0x00000000u)
/*----ES6 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES6_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES5_MASK (0x00000020u)
#define CSL_DSPINTC_EVTSET_ES5_SHIFT (0x00000005u)
#define CSL_DSPINTC_EVTSET_ES5_RESETVAL (0x00000000u)
/*----ES5 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES5_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES4_MASK (0x00000010u)
#define CSL_DSPINTC_EVTSET_ES4_SHIFT (0x00000004u)
#define CSL_DSPINTC_EVTSET_ES4_RESETVAL (0x00000000u)
/*----ES4 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES4_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES3_MASK (0x00000008u)
#define CSL_DSPINTC_EVTSET_ES3_SHIFT (0x00000003u)
#define CSL_DSPINTC_EVTSET_ES3_RESETVAL (0x00000000u)
/*----ES3 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES3_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES2_MASK (0x00000004u)
#define CSL_DSPINTC_EVTSET_ES2_SHIFT (0x00000002u)
#define CSL_DSPINTC_EVTSET_ES2_RESETVAL (0x00000000u)
/*----ES2 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES2_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES1_MASK (0x00000002u)
#define CSL_DSPINTC_EVTSET_ES1_SHIFT (0x00000001u)
#define CSL_DSPINTC_EVTSET_ES1_RESETVAL (0x00000000u)
/*----ES1 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES1_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_ES0_MASK (0x00000001u)
#define CSL_DSPINTC_EVTSET_ES0_SHIFT (0x00000000u)
#define CSL_DSPINTC_EVTSET_ES0_RESETVAL (0x00000000u)
/*----ES0 Tokens----*/
#define CSL_DSPINTC_EVTSET_ES0_SET (0x00000001u)

#define CSL_DSPINTC_EVTSET_RESETVAL (0x00000000u)

/* EVTCLR */

#define CSL_DSPINTC_EVTCLR_EC31_MASK (0x80000000u)
#define CSL_DSPINTC_EVTCLR_EC31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_EVTCLR_EC31_RESETVAL (0x00000000u)
/*----EC31 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC31_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC30_MASK (0x40000000u)
#define CSL_DSPINTC_EVTCLR_EC30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_EVTCLR_EC30_RESETVAL (0x00000000u)
/*----EC30 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC30_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC29_MASK (0x20000000u)
#define CSL_DSPINTC_EVTCLR_EC29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_EVTCLR_EC29_RESETVAL (0x00000000u)
/*----EC29 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC29_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC28_MASK (0x10000000u)
#define CSL_DSPINTC_EVTCLR_EC28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_EVTCLR_EC28_RESETVAL (0x00000000u)
/*----EC28 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC28_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC27_MASK (0x08000000u)
#define CSL_DSPINTC_EVTCLR_EC27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_EVTCLR_EC27_RESETVAL (0x00000000u)
/*----EC27 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC27_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC26_MASK (0x04000000u)
#define CSL_DSPINTC_EVTCLR_EC26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_EVTCLR_EC26_RESETVAL (0x00000000u)
/*----EC26 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC26_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC25_MASK (0x02000000u)
#define CSL_DSPINTC_EVTCLR_EC25_SHIFT (0x00000019u)
#define CSL_DSPINTC_EVTCLR_EC25_RESETVAL (0x00000000u)
/*----EC25 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC25_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC24_MASK (0x01000000u)
#define CSL_DSPINTC_EVTCLR_EC24_SHIFT (0x00000018u)
#define CSL_DSPINTC_EVTCLR_EC24_RESETVAL (0x00000000u)
/*----EC24 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC24_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC23_MASK (0x00800000u)
#define CSL_DSPINTC_EVTCLR_EC23_SHIFT (0x00000017u)
#define CSL_DSPINTC_EVTCLR_EC23_RESETVAL (0x00000000u)
/*----EC23 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC23_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC22_MASK (0x00400000u)
#define CSL_DSPINTC_EVTCLR_EC22_SHIFT (0x00000016u)
#define CSL_DSPINTC_EVTCLR_EC22_RESETVAL (0x00000000u)
/*----EC22 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC22_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC21_MASK (0x00200000u)
#define CSL_DSPINTC_EVTCLR_EC21_SHIFT (0x00000015u)
#define CSL_DSPINTC_EVTCLR_EC21_RESETVAL (0x00000000u)
/*----EC21 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC21_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC20_MASK (0x00100000u)
#define CSL_DSPINTC_EVTCLR_EC20_SHIFT (0x00000014u)
#define CSL_DSPINTC_EVTCLR_EC20_RESETVAL (0x00000000u)
/*----EC20 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC20_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC19_MASK (0x00080000u)
#define CSL_DSPINTC_EVTCLR_EC19_SHIFT (0x00000013u)
#define CSL_DSPINTC_EVTCLR_EC19_RESETVAL (0x00000000u)
/*----EC19 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC19_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC18_MASK (0x00040000u)
#define CSL_DSPINTC_EVTCLR_EC18_SHIFT (0x00000012u)
#define CSL_DSPINTC_EVTCLR_EC18_RESETVAL (0x00000000u)
/*----EC18 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC18_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC17_MASK (0x00020000u)
#define CSL_DSPINTC_EVTCLR_EC17_SHIFT (0x00000011u)
#define CSL_DSPINTC_EVTCLR_EC17_RESETVAL (0x00000000u)
/*----EC17 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC17_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC16_MASK (0x00010000u)
#define CSL_DSPINTC_EVTCLR_EC16_SHIFT (0x00000010u)
#define CSL_DSPINTC_EVTCLR_EC16_RESETVAL (0x00000000u)
/*----EC16 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC16_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC15_MASK (0x00008000u)
#define CSL_DSPINTC_EVTCLR_EC15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_EVTCLR_EC15_RESETVAL (0x00000000u)
/*----EC15 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC15_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC14_MASK (0x00004000u)
#define CSL_DSPINTC_EVTCLR_EC14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_EVTCLR_EC14_RESETVAL (0x00000000u)
/*----EC14 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC14_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC13_MASK (0x00002000u)
#define CSL_DSPINTC_EVTCLR_EC13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_EVTCLR_EC13_RESETVAL (0x00000000u)
/*----EC13 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC13_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC12_MASK (0x00001000u)
#define CSL_DSPINTC_EVTCLR_EC12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_EVTCLR_EC12_RESETVAL (0x00000000u)
/*----EC12 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC12_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC11_MASK (0x00000800u)
#define CSL_DSPINTC_EVTCLR_EC11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_EVTCLR_EC11_RESETVAL (0x00000000u)
/*----EC11 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC11_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC10_MASK (0x00000400u)
#define CSL_DSPINTC_EVTCLR_EC10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_EVTCLR_EC10_RESETVAL (0x00000000u)
/*----EC10 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC10_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC9_MASK (0x00000200u)
#define CSL_DSPINTC_EVTCLR_EC9_SHIFT (0x00000009u)
#define CSL_DSPINTC_EVTCLR_EC9_RESETVAL (0x00000000u)
/*----EC9 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC9_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC8_MASK (0x00000100u)
#define CSL_DSPINTC_EVTCLR_EC8_SHIFT (0x00000008u)
#define CSL_DSPINTC_EVTCLR_EC8_RESETVAL (0x00000000u)
/*----EC8 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC8_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC7_MASK (0x00000080u)
#define CSL_DSPINTC_EVTCLR_EC7_SHIFT (0x00000007u)
#define CSL_DSPINTC_EVTCLR_EC7_RESETVAL (0x00000000u)
/*----EC7 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC7_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC6_MASK (0x00000040u)
#define CSL_DSPINTC_EVTCLR_EC6_SHIFT (0x00000006u)
#define CSL_DSPINTC_EVTCLR_EC6_RESETVAL (0x00000000u)
/*----EC6 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC6_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC5_MASK (0x00000020u)
#define CSL_DSPINTC_EVTCLR_EC5_SHIFT (0x00000005u)
#define CSL_DSPINTC_EVTCLR_EC5_RESETVAL (0x00000000u)
/*----EC5 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC5_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC4_MASK (0x00000010u)
#define CSL_DSPINTC_EVTCLR_EC4_SHIFT (0x00000004u)
#define CSL_DSPINTC_EVTCLR_EC4_RESETVAL (0x00000000u)
/*----EC4 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC4_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC3_MASK (0x00000008u)
#define CSL_DSPINTC_EVTCLR_EC3_SHIFT (0x00000003u)
#define CSL_DSPINTC_EVTCLR_EC3_RESETVAL (0x00000000u)
/*----EC3 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC3_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC2_MASK (0x00000004u)
#define CSL_DSPINTC_EVTCLR_EC2_SHIFT (0x00000002u)
#define CSL_DSPINTC_EVTCLR_EC2_RESETVAL (0x00000000u)
/*----EC2 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC2_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC1_MASK (0x00000002u)
#define CSL_DSPINTC_EVTCLR_EC1_SHIFT (0x00000001u)
#define CSL_DSPINTC_EVTCLR_EC1_RESETVAL (0x00000000u)
/*----EC1 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC1_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_EC0_MASK (0x00000001u)
#define CSL_DSPINTC_EVTCLR_EC0_SHIFT (0x00000000u)
#define CSL_DSPINTC_EVTCLR_EC0_RESETVAL (0x00000000u)
/*----EC0 Tokens----*/
#define CSL_DSPINTC_EVTCLR_EC0_SET (0x00000001u)

#define CSL_DSPINTC_EVTCLR_RESETVAL (0x00000000u)

/* EVTMASK */

#define CSL_DSPINTC_EVTMASK_EM31_MASK (0x80000000u)
#define CSL_DSPINTC_EVTMASK_EM31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_EVTMASK_EM31_RESETVAL (0x00000000u)
/*----EM31 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM31_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM31_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM30_MASK (0x40000000u)
#define CSL_DSPINTC_EVTMASK_EM30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_EVTMASK_EM30_RESETVAL (0x00000000u)
/*----EM30 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM30_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM30_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM29_MASK (0x20000000u)
#define CSL_DSPINTC_EVTMASK_EM29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_EVTMASK_EM29_RESETVAL (0x00000000u)
/*----EM29 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM29_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM29_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM28_MASK (0x10000000u)
#define CSL_DSPINTC_EVTMASK_EM28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_EVTMASK_EM28_RESETVAL (0x00000000u)
/*----EM28 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM28_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM28_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM27_MASK (0x08000000u)
#define CSL_DSPINTC_EVTMASK_EM27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_EVTMASK_EM27_RESETVAL (0x00000000u)
/*----EM27 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM27_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM27_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM26_MASK (0x04000000u)
#define CSL_DSPINTC_EVTMASK_EM26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_EVTMASK_EM26_RESETVAL (0x00000000u)
/*----EM26 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM26_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM26_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM25_MASK (0x02000000u)
#define CSL_DSPINTC_EVTMASK_EM25_SHIFT (0x00000019u)
#define CSL_DSPINTC_EVTMASK_EM25_RESETVAL (0x00000000u)
/*----EM25 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM25_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM25_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM24_MASK (0x01000000u)
#define CSL_DSPINTC_EVTMASK_EM24_SHIFT (0x00000018u)
#define CSL_DSPINTC_EVTMASK_EM24_RESETVAL (0x00000000u)
/*----EM24 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM24_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM24_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM23_MASK (0x00800000u)
#define CSL_DSPINTC_EVTMASK_EM23_SHIFT (0x00000017u)
#define CSL_DSPINTC_EVTMASK_EM23_RESETVAL (0x00000000u)
/*----EM23 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM23_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM23_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM22_MASK (0x00400000u)
#define CSL_DSPINTC_EVTMASK_EM22_SHIFT (0x00000016u)
#define CSL_DSPINTC_EVTMASK_EM22_RESETVAL (0x00000000u)
/*----EM22 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM22_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM22_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM21_MASK (0x00200000u)
#define CSL_DSPINTC_EVTMASK_EM21_SHIFT (0x00000015u)
#define CSL_DSPINTC_EVTMASK_EM21_RESETVAL (0x00000000u)
/*----EM21 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM21_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM21_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM20_MASK (0x00100000u)
#define CSL_DSPINTC_EVTMASK_EM20_SHIFT (0x00000014u)
#define CSL_DSPINTC_EVTMASK_EM20_RESETVAL (0x00000000u)
/*----EM20 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM20_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM20_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM19_MASK (0x00080000u)
#define CSL_DSPINTC_EVTMASK_EM19_SHIFT (0x00000013u)
#define CSL_DSPINTC_EVTMASK_EM19_RESETVAL (0x00000000u)
/*----EM19 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM19_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM19_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM18_MASK (0x00040000u)
#define CSL_DSPINTC_EVTMASK_EM18_SHIFT (0x00000012u)
#define CSL_DSPINTC_EVTMASK_EM18_RESETVAL (0x00000000u)
/*----EM18 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM18_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM18_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM17_MASK (0x00020000u)
#define CSL_DSPINTC_EVTMASK_EM17_SHIFT (0x00000011u)
#define CSL_DSPINTC_EVTMASK_EM17_RESETVAL (0x00000000u)
/*----EM17 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM17_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM17_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM16_MASK (0x00010000u)
#define CSL_DSPINTC_EVTMASK_EM16_SHIFT (0x00000010u)
#define CSL_DSPINTC_EVTMASK_EM16_RESETVAL (0x00000000u)
/*----EM16 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM16_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM16_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM15_MASK (0x00008000u)
#define CSL_DSPINTC_EVTMASK_EM15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_EVTMASK_EM15_RESETVAL (0x00000000u)
/*----EM15 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM15_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM15_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM14_MASK (0x00004000u)
#define CSL_DSPINTC_EVTMASK_EM14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_EVTMASK_EM14_RESETVAL (0x00000000u)
/*----EM14 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM14_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM14_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM13_MASK (0x00002000u)
#define CSL_DSPINTC_EVTMASK_EM13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_EVTMASK_EM13_RESETVAL (0x00000000u)
/*----EM13 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM13_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM13_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM12_MASK (0x00001000u)
#define CSL_DSPINTC_EVTMASK_EM12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_EVTMASK_EM12_RESETVAL (0x00000000u)
/*----EM12 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM12_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM12_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM11_MASK (0x00000800u)
#define CSL_DSPINTC_EVTMASK_EM11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_EVTMASK_EM11_RESETVAL (0x00000000u)
/*----EM11 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM11_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM11_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM10_MASK (0x00000400u)
#define CSL_DSPINTC_EVTMASK_EM10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_EVTMASK_EM10_RESETVAL (0x00000000u)
/*----EM10 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM10_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM10_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM9_MASK (0x00000200u)
#define CSL_DSPINTC_EVTMASK_EM9_SHIFT (0x00000009u)
#define CSL_DSPINTC_EVTMASK_EM9_RESETVAL (0x00000000u)
/*----EM9 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM9_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM9_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM8_MASK (0x00000100u)
#define CSL_DSPINTC_EVTMASK_EM8_SHIFT (0x00000008u)
#define CSL_DSPINTC_EVTMASK_EM8_RESETVAL (0x00000000u)
/*----EM8 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM8_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM8_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM7_MASK (0x00000080u)
#define CSL_DSPINTC_EVTMASK_EM7_SHIFT (0x00000007u)
#define CSL_DSPINTC_EVTMASK_EM7_RESETVAL (0x00000000u)
/*----EM7 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM7_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM7_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM6_MASK (0x00000040u)
#define CSL_DSPINTC_EVTMASK_EM6_SHIFT (0x00000006u)
#define CSL_DSPINTC_EVTMASK_EM6_RESETVAL (0x00000000u)
/*----EM6 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM6_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM6_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM5_MASK (0x00000020u)
#define CSL_DSPINTC_EVTMASK_EM5_SHIFT (0x00000005u)
#define CSL_DSPINTC_EVTMASK_EM5_RESETVAL (0x00000000u)
/*----EM5 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM5_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM5_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM4_MASK (0x00000010u)
#define CSL_DSPINTC_EVTMASK_EM4_SHIFT (0x00000004u)
#define CSL_DSPINTC_EVTMASK_EM4_RESETVAL (0x00000000u)
/*----EM4 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM4_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM4_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM3_MASK (0x00000008u)
#define CSL_DSPINTC_EVTMASK_EM3_SHIFT (0x00000003u)
#define CSL_DSPINTC_EVTMASK_EM3_RESETVAL (0x00000000u)
/*----EM3 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM3_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM3_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM2_MASK (0x00000004u)
#define CSL_DSPINTC_EVTMASK_EM2_SHIFT (0x00000002u)
#define CSL_DSPINTC_EVTMASK_EM2_RESETVAL (0x00000000u)
/*----EM2 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM2_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM2_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM1_MASK (0x00000002u)
#define CSL_DSPINTC_EVTMASK_EM1_SHIFT (0x00000001u)
#define CSL_DSPINTC_EVTMASK_EM1_RESETVAL (0x00000000u)
/*----EM1 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM1_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM1_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_EM0_MASK (0x00000001u)
#define CSL_DSPINTC_EVTMASK_EM0_SHIFT (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM0_RESETVAL (0x00000000u)
/*----EM0 Tokens----*/
#define CSL_DSPINTC_EVTMASK_EM0_COMBINE (0x00000000u)
#define CSL_DSPINTC_EVTMASK_EM0_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EVTMASK_RESETVAL (0x00000000u)

/* MEVTFLAG */

#define CSL_DSPINTC_MEVTFLAG_MEF31_MASK (0x80000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_MEVTFLAG_MEF31_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF30_MASK (0x40000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_MEVTFLAG_MEF30_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF29_MASK (0x20000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_MEVTFLAG_MEF29_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF28_MASK (0x10000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_MEVTFLAG_MEF28_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF27_MASK (0x08000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_MEVTFLAG_MEF27_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF26_MASK (0x04000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_MEVTFLAG_MEF26_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF25_MASK (0x02000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF25_SHIFT (0x00000019u)
#define CSL_DSPINTC_MEVTFLAG_MEF25_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF24_MASK (0x01000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF24_SHIFT (0x00000018u)
#define CSL_DSPINTC_MEVTFLAG_MEF24_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF23_MASK (0x00800000u)
#define CSL_DSPINTC_MEVTFLAG_MEF23_SHIFT (0x00000017u)
#define CSL_DSPINTC_MEVTFLAG_MEF23_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF22_MASK (0x00400000u)
#define CSL_DSPINTC_MEVTFLAG_MEF22_SHIFT (0x00000016u)
#define CSL_DSPINTC_MEVTFLAG_MEF22_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF21_MASK (0x00200000u)
#define CSL_DSPINTC_MEVTFLAG_MEF21_SHIFT (0x00000015u)
#define CSL_DSPINTC_MEVTFLAG_MEF21_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF20_MASK (0x00100000u)
#define CSL_DSPINTC_MEVTFLAG_MEF20_SHIFT (0x00000014u)
#define CSL_DSPINTC_MEVTFLAG_MEF20_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF19_MASK (0x00080000u)
#define CSL_DSPINTC_MEVTFLAG_MEF19_SHIFT (0x00000013u)
#define CSL_DSPINTC_MEVTFLAG_MEF19_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF18_MASK (0x00040000u)
#define CSL_DSPINTC_MEVTFLAG_MEF18_SHIFT (0x00000012u)
#define CSL_DSPINTC_MEVTFLAG_MEF18_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF17_MASK (0x00020000u)
#define CSL_DSPINTC_MEVTFLAG_MEF17_SHIFT (0x00000011u)
#define CSL_DSPINTC_MEVTFLAG_MEF17_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF16_MASK (0x00010000u)
#define CSL_DSPINTC_MEVTFLAG_MEF16_SHIFT (0x00000010u)
#define CSL_DSPINTC_MEVTFLAG_MEF16_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF15_MASK (0x00008000u)
#define CSL_DSPINTC_MEVTFLAG_MEF15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_MEVTFLAG_MEF15_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF14_MASK (0x00004000u)
#define CSL_DSPINTC_MEVTFLAG_MEF14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_MEVTFLAG_MEF14_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF13_MASK (0x00002000u)
#define CSL_DSPINTC_MEVTFLAG_MEF13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_MEVTFLAG_MEF13_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF12_MASK (0x00001000u)
#define CSL_DSPINTC_MEVTFLAG_MEF12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_MEVTFLAG_MEF12_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF11_MASK (0x00000800u)
#define CSL_DSPINTC_MEVTFLAG_MEF11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_MEVTFLAG_MEF11_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF10_MASK (0x00000400u)
#define CSL_DSPINTC_MEVTFLAG_MEF10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_MEVTFLAG_MEF10_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF9_MASK (0x00000200u)
#define CSL_DSPINTC_MEVTFLAG_MEF9_SHIFT (0x00000009u)
#define CSL_DSPINTC_MEVTFLAG_MEF9_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF8_MASK (0x00000100u)
#define CSL_DSPINTC_MEVTFLAG_MEF8_SHIFT (0x00000008u)
#define CSL_DSPINTC_MEVTFLAG_MEF8_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF7_MASK (0x00000080u)
#define CSL_DSPINTC_MEVTFLAG_MEF7_SHIFT (0x00000007u)
#define CSL_DSPINTC_MEVTFLAG_MEF7_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF6_MASK (0x00000040u)
#define CSL_DSPINTC_MEVTFLAG_MEF6_SHIFT (0x00000006u)
#define CSL_DSPINTC_MEVTFLAG_MEF6_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF5_MASK (0x00000020u)
#define CSL_DSPINTC_MEVTFLAG_MEF5_SHIFT (0x00000005u)
#define CSL_DSPINTC_MEVTFLAG_MEF5_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF4_MASK (0x00000010u)
#define CSL_DSPINTC_MEVTFLAG_MEF4_SHIFT (0x00000004u)
#define CSL_DSPINTC_MEVTFLAG_MEF4_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF3_MASK (0x00000008u)
#define CSL_DSPINTC_MEVTFLAG_MEF3_SHIFT (0x00000003u)
#define CSL_DSPINTC_MEVTFLAG_MEF3_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF2_MASK (0x00000004u)
#define CSL_DSPINTC_MEVTFLAG_MEF2_SHIFT (0x00000002u)
#define CSL_DSPINTC_MEVTFLAG_MEF2_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF1_MASK (0x00000002u)
#define CSL_DSPINTC_MEVTFLAG_MEF1_SHIFT (0x00000001u)
#define CSL_DSPINTC_MEVTFLAG_MEF1_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_MEF0_MASK (0x00000001u)
#define CSL_DSPINTC_MEVTFLAG_MEF0_SHIFT (0x00000000u)
#define CSL_DSPINTC_MEVTFLAG_MEF0_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEVTFLAG_RESETVAL (0x00000000u)

/* EXPMASK */

#define CSL_DSPINTC_EXPMASK_XM31_MASK (0x80000000u)
#define CSL_DSPINTC_EXPMASK_XM31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_EXPMASK_XM31_RESETVAL (0x00000001u)
/*----XM31 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM31_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM31_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM30_MASK (0x40000000u)
#define CSL_DSPINTC_EXPMASK_XM30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_EXPMASK_XM30_RESETVAL (0x00000001u)
/*----XM30 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM30_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM30_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM29_MASK (0x20000000u)
#define CSL_DSPINTC_EXPMASK_XM29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_EXPMASK_XM29_RESETVAL (0x00000001u)
/*----XM29 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM29_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM29_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM28_MASK (0x10000000u)
#define CSL_DSPINTC_EXPMASK_XM28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_EXPMASK_XM28_RESETVAL (0x00000001u)
/*----XM28 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM28_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM28_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM27_MASK (0x08000000u)
#define CSL_DSPINTC_EXPMASK_XM27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_EXPMASK_XM27_RESETVAL (0x00000001u)
/*----XM27 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM27_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM27_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM26_MASK (0x04000000u)
#define CSL_DSPINTC_EXPMASK_XM26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_EXPMASK_XM26_RESETVAL (0x00000001u)
/*----XM26 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM26_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM26_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM25_MASK (0x02000000u)
#define CSL_DSPINTC_EXPMASK_XM25_SHIFT (0x00000019u)
#define CSL_DSPINTC_EXPMASK_XM25_RESETVAL (0x00000001u)
/*----XM25 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM25_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM25_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM24_MASK (0x01000000u)
#define CSL_DSPINTC_EXPMASK_XM24_SHIFT (0x00000018u)
#define CSL_DSPINTC_EXPMASK_XM24_RESETVAL (0x00000001u)
/*----XM24 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM24_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM24_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM23_MASK (0x00800000u)
#define CSL_DSPINTC_EXPMASK_XM23_SHIFT (0x00000017u)
#define CSL_DSPINTC_EXPMASK_XM23_RESETVAL (0x00000001u)
/*----XM23 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM23_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM23_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM22_MASK (0x00400000u)
#define CSL_DSPINTC_EXPMASK_XM22_SHIFT (0x00000016u)
#define CSL_DSPINTC_EXPMASK_XM22_RESETVAL (0x00000001u)
/*----XM22 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM22_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM22_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM21_MASK (0x00200000u)
#define CSL_DSPINTC_EXPMASK_XM21_SHIFT (0x00000015u)
#define CSL_DSPINTC_EXPMASK_XM21_RESETVAL (0x00000001u)
/*----XM21 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM21_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM21_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM20_MASK (0x00100000u)
#define CSL_DSPINTC_EXPMASK_XM20_SHIFT (0x00000014u)
#define CSL_DSPINTC_EXPMASK_XM20_RESETVAL (0x00000001u)
/*----XM20 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM20_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM20_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM19_MASK (0x00080000u)
#define CSL_DSPINTC_EXPMASK_XM19_SHIFT (0x00000013u)
#define CSL_DSPINTC_EXPMASK_XM19_RESETVAL (0x00000001u)
/*----XM19 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM19_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM19_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM18_MASK (0x00040000u)
#define CSL_DSPINTC_EXPMASK_XM18_SHIFT (0x00000012u)
#define CSL_DSPINTC_EXPMASK_XM18_RESETVAL (0x00000001u)
/*----XM18 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM18_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM18_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM17_MASK (0x00020000u)
#define CSL_DSPINTC_EXPMASK_XM17_SHIFT (0x00000011u)
#define CSL_DSPINTC_EXPMASK_XM17_RESETVAL (0x00000001u)
/*----XM17 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM17_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM17_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM16_MASK (0x00010000u)
#define CSL_DSPINTC_EXPMASK_XM16_SHIFT (0x00000010u)
#define CSL_DSPINTC_EXPMASK_XM16_RESETVAL (0x00000001u)
/*----XM16 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM16_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM16_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM15_MASK (0x00008000u)
#define CSL_DSPINTC_EXPMASK_XM15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_EXPMASK_XM15_RESETVAL (0x00000001u)
/*----XM15 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM15_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM15_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM14_MASK (0x00004000u)
#define CSL_DSPINTC_EXPMASK_XM14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_EXPMASK_XM14_RESETVAL (0x00000001u)
/*----XM14 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM14_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM14_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM13_MASK (0x00002000u)
#define CSL_DSPINTC_EXPMASK_XM13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_EXPMASK_XM13_RESETVAL (0x00000001u)
/*----XM13 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM13_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM13_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM12_MASK (0x00001000u)
#define CSL_DSPINTC_EXPMASK_XM12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_EXPMASK_XM12_RESETVAL (0x00000001u)
/*----XM12 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM12_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM12_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM11_MASK (0x00000800u)
#define CSL_DSPINTC_EXPMASK_XM11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_EXPMASK_XM11_RESETVAL (0x00000001u)
/*----XM11 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM11_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM11_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM10_MASK (0x00000400u)
#define CSL_DSPINTC_EXPMASK_XM10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_EXPMASK_XM10_RESETVAL (0x00000001u)
/*----XM10 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM10_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM10_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM9_MASK (0x00000200u)
#define CSL_DSPINTC_EXPMASK_XM9_SHIFT (0x00000009u)
#define CSL_DSPINTC_EXPMASK_XM9_RESETVAL (0x00000001u)
/*----XM9 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM9_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM9_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM8_MASK (0x00000100u)
#define CSL_DSPINTC_EXPMASK_XM8_SHIFT (0x00000008u)
#define CSL_DSPINTC_EXPMASK_XM8_RESETVAL (0x00000001u)
/*----XM8 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM8_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM8_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM7_MASK (0x00000080u)
#define CSL_DSPINTC_EXPMASK_XM7_SHIFT (0x00000007u)
#define CSL_DSPINTC_EXPMASK_XM7_RESETVAL (0x00000001u)
/*----XM7 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM7_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM7_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM6_MASK (0x00000040u)
#define CSL_DSPINTC_EXPMASK_XM6_SHIFT (0x00000006u)
#define CSL_DSPINTC_EXPMASK_XM6_RESETVAL (0x00000001u)
/*----XM6 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM6_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM6_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM5_MASK (0x00000020u)
#define CSL_DSPINTC_EXPMASK_XM5_SHIFT (0x00000005u)
#define CSL_DSPINTC_EXPMASK_XM5_RESETVAL (0x00000001u)
/*----XM5 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM5_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM5_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM4_MASK (0x00000010u)
#define CSL_DSPINTC_EXPMASK_XM4_SHIFT (0x00000004u)
#define CSL_DSPINTC_EXPMASK_XM4_RESETVAL (0x00000001u)
/*----XM4 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM4_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM4_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM3_MASK (0x00000008u)
#define CSL_DSPINTC_EXPMASK_XM3_SHIFT (0x00000003u)
#define CSL_DSPINTC_EXPMASK_XM3_RESETVAL (0x00000001u)
/*----XM3 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM3_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM3_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM2_MASK (0x00000004u)
#define CSL_DSPINTC_EXPMASK_XM2_SHIFT (0x00000002u)
#define CSL_DSPINTC_EXPMASK_XM2_RESETVAL (0x00000001u)
/*----XM2 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM2_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM2_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM1_MASK (0x00000002u)
#define CSL_DSPINTC_EXPMASK_XM1_SHIFT (0x00000001u)
#define CSL_DSPINTC_EXPMASK_XM1_RESETVAL (0x00000001u)
/*----XM1 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM1_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM1_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_XM0_MASK (0x00000001u)
#define CSL_DSPINTC_EXPMASK_XM0_SHIFT (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM0_RESETVAL (0x00000001u)
/*----XM0 Tokens----*/
#define CSL_DSPINTC_EXPMASK_XM0_COMBINE (0x00000000u)
#define CSL_DSPINTC_EXPMASK_XM0_NOTCOMBINE (0x00000001u)

#define CSL_DSPINTC_EXPMASK_RESETVAL (0xFFFFFFFFu)

/* MEXPFLAG */

#define CSL_DSPINTC_MEXPFLAG_MXF31_MASK (0x80000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF31_SHIFT (0x0000001Fu)
#define CSL_DSPINTC_MEXPFLAG_MXF31_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF30_MASK (0x40000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF30_SHIFT (0x0000001Eu)
#define CSL_DSPINTC_MEXPFLAG_MXF30_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF29_MASK (0x20000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF29_SHIFT (0x0000001Du)
#define CSL_DSPINTC_MEXPFLAG_MXF29_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF28_MASK (0x10000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF28_SHIFT (0x0000001Cu)
#define CSL_DSPINTC_MEXPFLAG_MXF28_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF27_MASK (0x08000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF27_SHIFT (0x0000001Bu)
#define CSL_DSPINTC_MEXPFLAG_MXF27_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF26_MASK (0x04000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF26_SHIFT (0x0000001Au)
#define CSL_DSPINTC_MEXPFLAG_MXF26_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF25_MASK (0x02000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF25_SHIFT (0x00000019u)
#define CSL_DSPINTC_MEXPFLAG_MXF25_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF24_MASK (0x01000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF24_SHIFT (0x00000018u)
#define CSL_DSPINTC_MEXPFLAG_MXF24_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF23_MASK (0x00800000u)
#define CSL_DSPINTC_MEXPFLAG_MXF23_SHIFT (0x00000017u)
#define CSL_DSPINTC_MEXPFLAG_MXF23_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF22_MASK (0x00400000u)
#define CSL_DSPINTC_MEXPFLAG_MXF22_SHIFT (0x00000016u)
#define CSL_DSPINTC_MEXPFLAG_MXF22_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF21_MASK (0x00200000u)
#define CSL_DSPINTC_MEXPFLAG_MXF21_SHIFT (0x00000015u)
#define CSL_DSPINTC_MEXPFLAG_MXF21_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF20_MASK (0x00100000u)
#define CSL_DSPINTC_MEXPFLAG_MXF20_SHIFT (0x00000014u)
#define CSL_DSPINTC_MEXPFLAG_MXF20_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF19_MASK (0x00080000u)
#define CSL_DSPINTC_MEXPFLAG_MXF19_SHIFT (0x00000013u)
#define CSL_DSPINTC_MEXPFLAG_MXF19_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF18_MASK (0x00040000u)
#define CSL_DSPINTC_MEXPFLAG_MXF18_SHIFT (0x00000012u)
#define CSL_DSPINTC_MEXPFLAG_MXF18_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF17_MASK (0x00020000u)
#define CSL_DSPINTC_MEXPFLAG_MXF17_SHIFT (0x00000011u)
#define CSL_DSPINTC_MEXPFLAG_MXF17_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF16_MASK (0x00010000u)
#define CSL_DSPINTC_MEXPFLAG_MXF16_SHIFT (0x00000010u)
#define CSL_DSPINTC_MEXPFLAG_MXF16_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF15_MASK (0x00008000u)
#define CSL_DSPINTC_MEXPFLAG_MXF15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_MEXPFLAG_MXF15_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF14_MASK (0x00004000u)
#define CSL_DSPINTC_MEXPFLAG_MXF14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_MEXPFLAG_MXF14_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF13_MASK (0x00002000u)
#define CSL_DSPINTC_MEXPFLAG_MXF13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_MEXPFLAG_MXF13_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF12_MASK (0x00001000u)
#define CSL_DSPINTC_MEXPFLAG_MXF12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_MEXPFLAG_MXF12_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF11_MASK (0x00000800u)
#define CSL_DSPINTC_MEXPFLAG_MXF11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_MEXPFLAG_MXF11_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF10_MASK (0x00000400u)
#define CSL_DSPINTC_MEXPFLAG_MXF10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_MEXPFLAG_MXF10_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF9_MASK (0x00000200u)
#define CSL_DSPINTC_MEXPFLAG_MXF9_SHIFT (0x00000009u)
#define CSL_DSPINTC_MEXPFLAG_MXF9_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF8_MASK (0x00000100u)
#define CSL_DSPINTC_MEXPFLAG_MXF8_SHIFT (0x00000008u)
#define CSL_DSPINTC_MEXPFLAG_MXF8_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF7_MASK (0x00000080u)
#define CSL_DSPINTC_MEXPFLAG_MXF7_SHIFT (0x00000007u)
#define CSL_DSPINTC_MEXPFLAG_MXF7_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF6_MASK (0x00000040u)
#define CSL_DSPINTC_MEXPFLAG_MXF6_SHIFT (0x00000006u)
#define CSL_DSPINTC_MEXPFLAG_MXF6_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF5_MASK (0x00000020u)
#define CSL_DSPINTC_MEXPFLAG_MXF5_SHIFT (0x00000005u)
#define CSL_DSPINTC_MEXPFLAG_MXF5_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF4_MASK (0x00000010u)
#define CSL_DSPINTC_MEXPFLAG_MXF4_SHIFT (0x00000004u)
#define CSL_DSPINTC_MEXPFLAG_MXF4_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF3_MASK (0x00000008u)
#define CSL_DSPINTC_MEXPFLAG_MXF3_SHIFT (0x00000003u)
#define CSL_DSPINTC_MEXPFLAG_MXF3_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF2_MASK (0x00000004u)
#define CSL_DSPINTC_MEXPFLAG_MXF2_SHIFT (0x00000002u)
#define CSL_DSPINTC_MEXPFLAG_MXF2_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF1_MASK (0x00000002u)
#define CSL_DSPINTC_MEXPFLAG_MXF1_SHIFT (0x00000001u)
#define CSL_DSPINTC_MEXPFLAG_MXF1_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_MXF0_MASK (0x00000001u)
#define CSL_DSPINTC_MEXPFLAG_MXF0_SHIFT (0x00000000u)
#define CSL_DSPINTC_MEXPFLAG_MXF0_RESETVAL (0x00000000u)

#define CSL_DSPINTC_MEXPFLAG_RESETVAL (0x00000000u)

/* INTMUX1 */


#define CSL_DSPINTC_INTMUX1_INTSEL7_MASK (0x7F000000u)
#define CSL_DSPINTC_INTMUX1_INTSEL7_SHIFT (0x00000018u)
#define CSL_DSPINTC_INTMUX1_INTSEL7_RESETVAL (0x00000007u)


#define CSL_DSPINTC_INTMUX1_INTSEL6_MASK (0x007F0000u)
#define CSL_DSPINTC_INTMUX1_INTSEL6_SHIFT (0x00000010u)
#define CSL_DSPINTC_INTMUX1_INTSEL6_RESETVAL (0x00000006u)


#define CSL_DSPINTC_INTMUX1_INTSEL5_MASK (0x00007F00u)
#define CSL_DSPINTC_INTMUX1_INTSEL5_SHIFT (0x00000008u)
#define CSL_DSPINTC_INTMUX1_INTSEL5_RESETVAL (0x00000005u)


#define CSL_DSPINTC_INTMUX1_INTSEL4_MASK (0x0000007Fu)
#define CSL_DSPINTC_INTMUX1_INTSEL4_SHIFT (0x00000000u)
#define CSL_DSPINTC_INTMUX1_INTSEL4_RESETVAL (0x00000004u)

#define CSL_DSPINTC_INTMUX1_RESETVAL (0x07060504u)

/* INTMUX2 */


#define CSL_DSPINTC_INTMUX2_INTSEL11_MASK (0x7F000000u)
#define CSL_DSPINTC_INTMUX2_INTSEL11_SHIFT (0x00000018u)
#define CSL_DSPINTC_INTMUX2_INTSEL11_RESETVAL (0x0000000Bu)


#define CSL_DSPINTC_INTMUX2_INTSEL10_MASK (0x007F0000u)
#define CSL_DSPINTC_INTMUX2_INTSEL10_SHIFT (0x00000010u)
#define CSL_DSPINTC_INTMUX2_INTSEL10_RESETVAL (0x0000000Au)


#define CSL_DSPINTC_INTMUX2_INTSEL9_MASK (0x00007F00u)
#define CSL_DSPINTC_INTMUX2_INTSEL9_SHIFT (0x00000008u)
#define CSL_DSPINTC_INTMUX2_INTSEL9_RESETVAL (0x00000009u)


#define CSL_DSPINTC_INTMUX2_INTSEL8_MASK (0x0000007Fu)
#define CSL_DSPINTC_INTMUX2_INTSEL8_SHIFT (0x00000000u)
#define CSL_DSPINTC_INTMUX2_INTSEL8_RESETVAL (0x00000008u)

#define CSL_DSPINTC_INTMUX2_RESETVAL (0x0B0A0908u)

/* INTMUX3 */


#define CSL_DSPINTC_INTMUX3_INTSEL15_MASK (0x7F000000u)
#define CSL_DSPINTC_INTMUX3_INTSEL15_SHIFT (0x00000018u)
#define CSL_DSPINTC_INTMUX3_INTSEL15_RESETVAL (0x0000000Fu)


#define CSL_DSPINTC_INTMUX3_INTSEL14_MASK (0x007F0000u)
#define CSL_DSPINTC_INTMUX3_INTSEL14_SHIFT (0x00000010u)
#define CSL_DSPINTC_INTMUX3_INTSEL14_RESETVAL (0x0000000Eu)


#define CSL_DSPINTC_INTMUX3_INTSEL13_MASK (0x00007F00u)
#define CSL_DSPINTC_INTMUX3_INTSEL13_SHIFT (0x00000008u)
#define CSL_DSPINTC_INTMUX3_INTSEL13_RESETVAL (0x0000000Du)


#define CSL_DSPINTC_INTMUX3_INTSEL12_MASK (0x0000007Fu)
#define CSL_DSPINTC_INTMUX3_INTSEL12_SHIFT (0x00000000u)
#define CSL_DSPINTC_INTMUX3_INTSEL12_RESETVAL (0x0000000Cu)

#define CSL_DSPINTC_INTMUX3_RESETVAL (0x0F0E0D0Cu)

/* AEGMUX0 */

#define CSL_DSPINTC_AEGMUX0_AEGSEL3_MASK (0xFF000000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_SHIFT (0x00000018u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_RESETVAL (0x00000003u)
/*----AEGSEL3 Tokens----*/
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL3_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX0_AEGSEL2_MASK (0x00FF0000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_SHIFT (0x00000010u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_RESETVAL (0x00000002u)
/*----AEGSEL2 Tokens----*/
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL2_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX0_AEGSEL1_MASK (0x0000FF00u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_SHIFT (0x00000008u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_RESETVAL (0x00000001u)
/*----AEGSEL1 Tokens----*/
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL1_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX0_AEGSEL0_MASK (0x000000FFu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_SHIFT (0x00000000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_RESETVAL (0x00000000u)
/*----AEGSEL0 Tokens----*/
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX0_AEGSEL0_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX0_RESETVAL (0x03020100u)

/* AEGMUX1 */

#define CSL_DSPINTC_AEGMUX1_AEGSEL7_MASK (0xFF000000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_SHIFT (0x00000018u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_RESETVAL (0x00000007u)
/*----AEGSEL7 Tokens----*/
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL7_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX1_AEGSEL6_MASK (0x00FF0000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_SHIFT (0x00000010u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_RESETVAL (0x00000006u)
/*----AEGSEL6 Tokens----*/
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL6_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX1_AEGSEL5_MASK (0x0000FF00u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_SHIFT (0x00000008u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_RESETVAL (0x00000005u)
/*----AEGSEL5 Tokens----*/
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL5_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX1_AEGSEL4_MASK (0x000000FFu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_SHIFT (0x00000000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_RESETVAL (0x00000004u)
/*----AEGSEL4 Tokens----*/
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM0 (0x00000000u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM1 (0x00000001u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM2 (0x00000002u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM3 (0x00000003u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM4 (0x00000004u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM5 (0x00000005u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM6 (0x00000006u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM7 (0x00000007u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM8 (0x00000008u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM9 (0x00000009u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM10 (0x0000000Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM13 (0x0000000Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM15 (0x0000000Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM16 (0x00000010u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM17 (0x00000011u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM18 (0x00000012u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM19 (0x00000013u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM20 (0x00000014u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM21 (0x00000015u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM22 (0x00000016u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM23 (0x00000017u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM24 (0x00000018u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM25 (0x00000019u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM26 (0x0000001Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM27 (0x0000001Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM28 (0x0000001Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM29 (0x0000001Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM30 (0x0000001Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM31 (0x0000001Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM32 (0x00000020u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM33 (0x00000021u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM34 (0x00000022u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM35 (0x00000023u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM36 (0x00000024u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM37 (0x00000025u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM38 (0x00000026u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM39 (0x00000027u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM40 (0x00000028u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM41 (0x00000029u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM42 (0x0000002Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM43 (0x0000002Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM44 (0x0000002Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM45 (0x0000002Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM46 (0x0000002Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM47 (0x0000002Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM48 (0x00000030u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM49 (0x00000031u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM50 (0x00000032u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM51 (0x00000033u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM52 (0x00000034u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM53 (0x00000035u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM54 (0x00000036u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM55 (0x00000037u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM56 (0x00000038u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM57 (0x00000039u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM58 (0x0000003Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM59 (0x0000003Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM60 (0x0000003Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM61 (0x0000003Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM62 (0x0000003Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM63 (0x0000003Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM64 (0x00000040u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM65 (0x00000041u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM66 (0x00000042u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM67 (0x00000043u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM68 (0x00000044u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM69 (0x00000045u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM70 (0x00000046u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM71 (0x00000047u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM72 (0x00000048u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM73 (0x00000049u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM74 (0x0000004Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM75 (0x0000004Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM76 (0x0000004Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM77 (0x0000004Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM78 (0x0000004Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM79 (0x0000004Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM80 (0x00000050u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM81 (0x00000051u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM82 (0x00000052u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM83 (0x00000053u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM84 (0x00000054u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM85 (0x00000055u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM86 (0x00000056u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM87 (0x00000057u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM88 (0x00000058u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM89 (0x00000059u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM90 (0x0000005Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM91 (0x0000005Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM92 (0x0000005Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM93 (0x0000005Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM94 (0x0000005Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM95 (0x0000005Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM96 (0x00000060u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM97 (0x00000061u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM98 (0x00000062u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM99 (0x00000063u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM100 (0x00000064u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM101 (0x00000065u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM102 (0x00000066u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM103 (0x00000067u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM104 (0x00000068u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM105 (0x00000069u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM106 (0x0000006Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM107 (0x0000006Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM108 (0x0000006Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM109 (0x0000006Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM110 (0x0000006Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM111 (0x0000006Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM112 (0x00000070u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM113 (0x00000071u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM114 (0x00000072u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM115 (0x00000073u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM116 (0x00000074u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM117 (0x00000075u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM118 (0x00000076u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM119 (0x00000077u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM120 (0x00000078u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM121 (0x00000079u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM122 (0x0000007Au)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM123 (0x0000007Bu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM124 (0x0000007Cu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM125 (0x0000007Du)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM126 (0x0000007Eu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NUM127 (0x0000007Fu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_EXCP (0x000000C0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_NMI (0x000000C1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT4 (0x000000C4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT5 (0x000000C5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT6 (0x000000C6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT7 (0x000000C7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT8 (0x000000C8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT9 (0x000000C9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT10 (0x000000CAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT11 (0x000000CBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT12 (0x000000CCu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT13 (0x000000CDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT14 (0x000000CEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_CPUINT15 (0x000000CFu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK (0x000000E0u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_EACK (0x000000E1u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK4 (0x000000E4u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK5 (0x000000E5u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK6 (0x000000E6u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK7 (0x000000E7u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK8 (0x000000E8u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK9 (0x000000E9u)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK10 (0x000000EAu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK11 (0x000000EBu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK12 (0x000000ECu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK13 (0x000000EDu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK14 (0x000000EEu)
#define CSL_DSPINTC_AEGMUX1_AEGSEL4_IACK15 (0x000000EFu)

#define CSL_DSPINTC_AEGMUX1_RESETVAL (0x07060504u)

/* INTXSTAT */

#define CSL_DSPINTC_INTXSTAT_SYSINT_MASK (0xFF000000u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_SHIFT (0x00000018u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_RESETVAL (0x00000000u)
/*----SYSINT Tokens----*/
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT0 (0x00000000u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT1 (0x00000001u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT2 (0x00000002u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT3 (0x00000003u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT4 (0x00000004u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT5 (0x00000005u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT6 (0x00000006u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT7 (0x00000007u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT8 (0x00000008u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT9 (0x00000009u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT10 (0x0000000Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT11 (0x0000000Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT12 (0x0000000Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT13 (0x0000000Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT14 (0x0000000Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT15 (0x0000000Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT16 (0x00000010u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT17 (0x00000011u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT18 (0x00000012u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT19 (0x00000013u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT20 (0x00000014u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT21 (0x00000015u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT22 (0x00000016u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT23 (0x00000017u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT24 (0x00000018u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT25 (0x00000019u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT26 (0x0000001Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT27 (0x0000001Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT28 (0x0000001Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT29 (0x0000001Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT30 (0x0000001Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT31 (0x0000001Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT32 (0x00000020u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT33 (0x00000021u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT34 (0x00000022u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT35 (0x00000023u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT36 (0x00000024u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT37 (0x00000025u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT38 (0x00000026u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT39 (0x00000027u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT40 (0x00000028u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT41 (0x00000029u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT42 (0x0000002Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT43 (0x0000002Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT44 (0x0000002Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT45 (0x0000002Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT46 (0x0000002Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT47 (0x0000002Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT48 (0x00000030u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT49 (0x00000031u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT50 (0x00000032u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT51 (0x00000033u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT52 (0x00000034u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT53 (0x00000035u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT54 (0x00000036u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT55 (0x00000037u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT56 (0x00000038u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT57 (0x00000039u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT58 (0x0000003Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT59 (0x0000003Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT60 (0x0000003Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT61 (0x0000003Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT62 (0x0000003Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT63 (0x0000003Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT64 (0x00000040u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT65 (0x00000041u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT66 (0x00000042u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT67 (0x00000043u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT68 (0x00000044u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT69 (0x00000045u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT70 (0x00000046u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT71 (0x00000047u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT72 (0x00000048u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT73 (0x00000049u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT74 (0x0000004Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT75 (0x0000004Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT76 (0x0000004Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT77 (0x0000004Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT78 (0x0000004Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT79 (0x0000004Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT80 (0x00000050u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT81 (0x00000051u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT82 (0x00000052u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT83 (0x00000053u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT84 (0x00000054u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT85 (0x00000055u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT86 (0x00000056u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT87 (0x00000057u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT88 (0x00000058u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT89 (0x00000059u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT90 (0x0000005Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT91 (0x0000005Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT92 (0x0000005Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT93 (0x0000005Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT94 (0x0000005Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT95 (0x0000005Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT96 (0x00000060u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT97 (0x00000061u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT98 (0x00000062u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT99 (0x00000063u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT100 (0x00000064u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT101 (0x00000065u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT102 (0x00000066u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT103 (0x00000067u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT104 (0x00000068u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT105 (0x00000069u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT106 (0x0000006Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT107 (0x0000006Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT108 (0x0000006Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT109 (0x0000006Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT110 (0x0000006Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT111 (0x0000006Fu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT112 (0x00000070u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT113 (0x00000071u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT114 (0x00000072u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT115 (0x00000073u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT116 (0x00000074u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT117 (0x00000075u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT118 (0x00000076u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT119 (0x00000077u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT120 (0x00000078u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT121 (0x00000079u)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT122 (0x0000007Au)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT123 (0x0000007Bu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT124 (0x0000007Cu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT125 (0x0000007Du)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT126 (0x0000007Eu)
#define CSL_DSPINTC_INTXSTAT_SYSINT_EVT127 (0x0000007Fu)

#define CSL_DSPINTC_INTXSTAT_CPUINT_MASK (0x00FF0000u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_SHIFT (0x00000010u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_RESETVAL (0x00000000u)
/*----CPUINT Tokens----*/
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM0 (0x00000000u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM1 (0x00000001u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM2 (0x00000002u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM3 (0x00000003u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM4 (0x00000004u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM5 (0x00000005u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM6 (0x00000006u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM7 (0x00000007u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM8 (0x00000008u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM9 (0x00000009u)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM10 (0x0000000Au)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM11 (0x0000000Bu)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM12 (0x0000000Cu)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM13 (0x0000000Du)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM14 (0x0000000Eu)
#define CSL_DSPINTC_INTXSTAT_CPUINT_NUM15 (0x0000000Fu)


#define CSL_DSPINTC_INTXSTAT_DROP_MASK (0x00000001u)
#define CSL_DSPINTC_INTXSTAT_DROP_SHIFT (0x00000000u)
#define CSL_DSPINTC_INTXSTAT_DROP_RESETVAL (0x00000000u)
/*----DROP Tokens----*/
#define CSL_DSPINTC_INTXSTAT_DROP_NO (0x00000000u)
#define CSL_DSPINTC_INTXSTAT_DROP_YES (0x00000001u)

#define CSL_DSPINTC_INTXSTAT_RESETVAL (0x00000000u)

/* INTXCLR */


#define CSL_DSPINTC_INTXCLR_CLEAR_MASK (0x00000001u)
#define CSL_DSPINTC_INTXCLR_CLEAR_SHIFT (0x00000000u)
#define CSL_DSPINTC_INTXCLR_CLEAR_RESETVAL (0x00000000u)
/*----CLEAR Tokens----*/
#define CSL_DSPINTC_INTXCLR_CLEAR_YES (0x00000001u)

#define CSL_DSPINTC_INTXCLR_RESETVAL (0x00000000u)

/* INTDMASK */


#define CSL_DSPINTC_INTDMASK_IDM15_MASK (0x00008000u)
#define CSL_DSPINTC_INTDMASK_IDM15_SHIFT (0x0000000Fu)
#define CSL_DSPINTC_INTDMASK_IDM15_RESETVAL (0x00000000u)
/*----IDM15 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM15_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM14_MASK (0x00004000u)
#define CSL_DSPINTC_INTDMASK_IDM14_SHIFT (0x0000000Eu)
#define CSL_DSPINTC_INTDMASK_IDM14_RESETVAL (0x00000000u)
/*----IDM14 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM14_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM13_MASK (0x00002000u)
#define CSL_DSPINTC_INTDMASK_IDM13_SHIFT (0x0000000Du)
#define CSL_DSPINTC_INTDMASK_IDM13_RESETVAL (0x00000000u)
/*----IDM13 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM13_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM12_MASK (0x00001000u)
#define CSL_DSPINTC_INTDMASK_IDM12_SHIFT (0x0000000Cu)
#define CSL_DSPINTC_INTDMASK_IDM12_RESETVAL (0x00000000u)
/*----IDM12 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM12_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM11_MASK (0x00000800u)
#define CSL_DSPINTC_INTDMASK_IDM11_SHIFT (0x0000000Bu)
#define CSL_DSPINTC_INTDMASK_IDM11_RESETVAL (0x00000000u)
/*----IDM11 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM11_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM10_MASK (0x00000400u)
#define CSL_DSPINTC_INTDMASK_IDM10_SHIFT (0x0000000Au)
#define CSL_DSPINTC_INTDMASK_IDM10_RESETVAL (0x00000000u)
/*----IDM10 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM10_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM9_MASK (0x00000200u)
#define CSL_DSPINTC_INTDMASK_IDM9_SHIFT (0x00000009u)
#define CSL_DSPINTC_INTDMASK_IDM9_RESETVAL (0x00000000u)
/*----IDM9 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM9_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM8_MASK (0x00000100u)
#define CSL_DSPINTC_INTDMASK_IDM8_SHIFT (0x00000008u)
#define CSL_DSPINTC_INTDMASK_IDM8_RESETVAL (0x00000000u)
/*----IDM8 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM8_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM7_MASK (0x00000080u)
#define CSL_DSPINTC_INTDMASK_IDM7_SHIFT (0x00000007u)
#define CSL_DSPINTC_INTDMASK_IDM7_RESETVAL (0x00000000u)
/*----IDM7 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM7_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM6_MASK (0x00000040u)
#define CSL_DSPINTC_INTDMASK_IDM6_SHIFT (0x00000006u)
#define CSL_DSPINTC_INTDMASK_IDM6_RESETVAL (0x00000000u)
/*----IDM6 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM6_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM5_MASK (0x00000020u)
#define CSL_DSPINTC_INTDMASK_IDM5_SHIFT (0x00000005u)
#define CSL_DSPINTC_INTDMASK_IDM5_RESETVAL (0x00000000u)
/*----IDM5 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM5_IGNORED (0x00000001u)

#define CSL_DSPINTC_INTDMASK_IDM4_MASK (0x00000010u)
#define CSL_DSPINTC_INTDMASK_IDM4_SHIFT (0x00000004u)
#define CSL_DSPINTC_INTDMASK_IDM4_RESETVAL (0x00000000u)
/*----IDM4 Tokens----*/
#define CSL_DSPINTC_INTDMASK_IDM4_IGNORED (0x00000001u)


#define CSL_DSPINTC_INTDMASK_RESETVAL (0x00000000u)

/* EVTASRT */


#define CSL_DSPINTC_EVTASRT_EA7_MASK (0x00000080u)
#define CSL_DSPINTC_EVTASRT_EA7_SHIFT (0x00000007u)
#define CSL_DSPINTC_EVTASRT_EA7_RESETVAL (0x00000000u)
/*----EA7 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA7_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA6_MASK (0x00000040u)
#define CSL_DSPINTC_EVTASRT_EA6_SHIFT (0x00000006u)
#define CSL_DSPINTC_EVTASRT_EA6_RESETVAL (0x00000000u)
/*----EA6 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA6_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA5_MASK (0x00000020u)
#define CSL_DSPINTC_EVTASRT_EA5_SHIFT (0x00000005u)
#define CSL_DSPINTC_EVTASRT_EA5_RESETVAL (0x00000000u)
/*----EA5 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA5_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA4_MASK (0x00000010u)
#define CSL_DSPINTC_EVTASRT_EA4_SHIFT (0x00000004u)
#define CSL_DSPINTC_EVTASRT_EA4_RESETVAL (0x00000000u)
/*----EA4 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA4_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA3_MASK (0x00000008u)
#define CSL_DSPINTC_EVTASRT_EA3_SHIFT (0x00000003u)
#define CSL_DSPINTC_EVTASRT_EA3_RESETVAL (0x00000000u)
/*----EA3 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA3_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA2_MASK (0x00000004u)
#define CSL_DSPINTC_EVTASRT_EA2_SHIFT (0x00000002u)
#define CSL_DSPINTC_EVTASRT_EA2_RESETVAL (0x00000000u)
/*----EA2 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA2_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA1_MASK (0x00000002u)
#define CSL_DSPINTC_EVTASRT_EA1_SHIFT (0x00000001u)
#define CSL_DSPINTC_EVTASRT_EA1_RESETVAL (0x00000000u)
/*----EA1 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA1_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_EA0_MASK (0x00000001u)
#define CSL_DSPINTC_EVTASRT_EA0_SHIFT (0x00000000u)
#define CSL_DSPINTC_EVTASRT_EA0_RESETVAL (0x00000000u)
/*----EA0 Tokens----*/
#define CSL_DSPINTC_EVTASRT_EA0_SET (0x00000001u)

#define CSL_DSPINTC_EVTASRT_RESETVAL (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif

