#ifndef _CSLR_AINTC_H_
#define _CSLR_AINTC_H_

#include <csl/cslr.h>
#include "tistdtypes.h"

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 CR;
    volatile Uint8 RSVD0[8];
    volatile Uint32 GER;
    volatile Uint8 RSVD1[8];
    volatile Uint32 GNLR;
    volatile Uint32 SISR;
    volatile Uint32 SICR;
    volatile Uint32 EISR;
    volatile Uint32 EICR;
    volatile Uint8 RSVD2[4];
    volatile Uint32 HIEISR;
    volatile Uint32 HIDISR;
    volatile Uint8 RSVD3[20];
    volatile Uint32 VBR;
    volatile Uint32 VSR;
    volatile Uint32 VNR;
    volatile Uint8 RSVD4[36];
    volatile Uint32 GPIR;
    volatile Uint32 GPVR;
    volatile Uint8 RSVD5[376];
    volatile Uint32 SRSR1;
    volatile Uint32 SRSR2;
    volatile Uint32 SRSR3;
    volatile Uint8 RSVD6[116];
    volatile Uint32 SECR1;
    volatile Uint32 SECR2;
    volatile Uint32 SECR3;
    volatile Uint8 RSVD7[116];
    volatile Uint32 ESR1;
    volatile Uint32 ESR2;
    volatile Uint32 ESR3;
    volatile Uint8 RSVD8[116];
    volatile Uint32 ECR1;
    volatile Uint32 ECR2;
    volatile Uint32 ECR3;
    volatile Uint8 RSVD9[116];
    volatile Uint32 CMR0;
    volatile Uint32 CMR1;
    volatile Uint32 CMR2;
    volatile Uint32 CMR3;
    volatile Uint32 CMR4;
    volatile Uint32 CMR5;
    volatile Uint32 CMR6;
    volatile Uint32 CMR7;
    volatile Uint32 CMR8;
    volatile Uint32 CMR9;
    volatile Uint32 CMR10;
    volatile Uint32 CMR11;
    volatile Uint32 CMR12;
    volatile Uint32 CMR13;
    volatile Uint32 CMR14;
    volatile Uint32 CMR15;
    volatile Uint32 CMR16;
    volatile Uint32 CMR17;
    volatile Uint32 CMR18;
    volatile Uint32 CMR19;
    volatile Uint32 CMR20;
    volatile Uint32 CMR21;
    volatile Uint32 CMR22;
    volatile Uint32 CMR23;
    volatile Uint32 CMR24;
    volatile Uint32 CMR25;
    volatile Uint32 CMR26;
    volatile Uint32 CMR27;
    volatile Uint32 CMR28;
    volatile Uint32 CMR29;
    volatile Uint32 CMR30;
    volatile Uint32 CMR31;
    volatile Uint8 RSVD10[1152];
    volatile Uint32 HIPIR1;
    volatile Uint32 HIPIR2;
    volatile Uint8 RSVD11[1144];
    volatile Uint32 SITR1;
    volatile Uint32 SITR2;
    volatile Uint32 SITR3;
    volatile Uint8 RSVD12[372];
    volatile Uint32 DSR1;
    volatile Uint32 DSR2;
    volatile Uint8 RSVD13[504];
    volatile Uint32 HINLR1;
    volatile Uint32 HINLR2;
    volatile Uint8 RSVD14[1016];
    volatile Uint32 HIER;
    volatile Uint8 RSVD15[252];
    volatile Uint32 HIPVR1;
    volatile Uint32 HIPVR2;
} CSL_AintcRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_AintcRegs         *CSL_AintcRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_AINTC_REVID_REV_MASK         (0xFFFFFFFFu)
#define CSL_AINTC_REVID_REV_SHIFT        (0x00000000u)
#define CSL_AINTC_REVID_REV_RESETVAL     (0x4E820100u)

#define CSL_AINTC_REVID_RESETVAL         (0x4E820100u)

/* CR */


#define CSL_AINTC_CR_PRHOLDMODE_MASK     (0x00000010u)
#define CSL_AINTC_CR_PRHOLDMODE_SHIFT    (0x00000004u)
#define CSL_AINTC_CR_PRHOLDMODE_RESETVAL (0x00000000u)
/*----PRHOLDMODE Tokens----*/
#define CSL_AINTC_CR_PRHOLDMODE_NO_PRHOLD (0x00000000u)
#define CSL_AINTC_CR_PRHOLDMODE_PRHOLD   (0x00000001u)

#define CSL_AINTC_CR_NESTMODE_MASK       (0x0000000Cu)
#define CSL_AINTC_CR_NESTMODE_SHIFT      (0x00000002u)
#define CSL_AINTC_CR_NESTMODE_RESETVAL   (0x00000000u)
/*----NESTMODE Tokens----*/
#define CSL_AINTC_CR_NESTMODE_NONEST     (0x00000000u)
#define CSL_AINTC_CR_NESTMODE_INDIVIDUAL (0x00000001u)
#define CSL_AINTC_CR_NESTMODE_GLOBAL     (0x00000002u)
#define CSL_AINTC_CR_NESTMODE_MANUAL     (0x00000003u)


#define CSL_AINTC_CR_RESETVAL            (0x00000000u)

/* GER */


#define CSL_AINTC_GER_ENABLE_MASK        (0x00000001u)
#define CSL_AINTC_GER_ENABLE_SHIFT       (0x00000000u)
#define CSL_AINTC_GER_ENABLE_RESETVAL    (0x00000000u)

#define CSL_AINTC_GER_RESETVAL           (0x00000000u)

/* GNLR */

#define CSL_AINTC_GNLR_OVERRIDE_MASK     (0x80000000u)
#define CSL_AINTC_GNLR_OVERRIDE_SHIFT    (0x0000001Fu)
#define CSL_AINTC_GNLR_OVERRIDE_RESETVAL (0x00000000u)


#define CSL_AINTC_GNLR_NESTLVL_MASK      (0x000001FFu)
#define CSL_AINTC_GNLR_NESTLVL_SHIFT     (0x00000000u)
#define CSL_AINTC_GNLR_NESTLVL_RESETVAL  (0x00000020u)

#define CSL_AINTC_GNLR_RESETVAL          (0x00000020u)

/* SISR */


#define CSL_AINTC_SISR_INDEX_MASK        (0x000003FFu)
#define CSL_AINTC_SISR_INDEX_SHIFT       (0x00000000u)
#define CSL_AINTC_SISR_INDEX_RESETVAL    (0x00000000u)

#define CSL_AINTC_SISR_RESETVAL          (0x00000000u)

/* SICR */


#define CSL_AINTC_SICR_INDEX_MASK        (0x000003FFu)
#define CSL_AINTC_SICR_INDEX_SHIFT       (0x00000000u)
#define CSL_AINTC_SICR_INDEX_RESETVAL    (0x00000000u)

#define CSL_AINTC_SICR_RESETVAL          (0x00000000u)

/* EISR */


#define CSL_AINTC_EISR_INDEX_MASK        (0x000003FFu)
#define CSL_AINTC_EISR_INDEX_SHIFT       (0x00000000u)
#define CSL_AINTC_EISR_INDEX_RESETVAL    (0x00000000u)

#define CSL_AINTC_EISR_RESETVAL          (0x00000000u)

/* EICR */


#define CSL_AINTC_EICR_INDEX_MASK        (0x000003FFu)
#define CSL_AINTC_EICR_INDEX_SHIFT       (0x00000000u)
#define CSL_AINTC_EICR_INDEX_RESETVAL    (0x00000000u)

#define CSL_AINTC_EICR_RESETVAL          (0x00000000u)

/* HIEISR */


#define CSL_AINTC_HIEISR_INDEX_MASK      (0x000003FFu)
#define CSL_AINTC_HIEISR_INDEX_SHIFT     (0x00000000u)
#define CSL_AINTC_HIEISR_INDEX_RESETVAL  (0x00000000u)

#define CSL_AINTC_HIEISR_RESETVAL        (0x00000000u)

/* HIDISR */


#define CSL_AINTC_HIDISR_INDEX_MASK      (0x000003FFu)
#define CSL_AINTC_HIDISR_INDEX_SHIFT     (0x00000000u)
#define CSL_AINTC_HIDISR_INDEX_RESETVAL  (0x00000000u)

#define CSL_AINTC_HIDISR_RESETVAL        (0x00000000u)

/* VBR */

#define CSL_AINTC_VBR_BASE_MASK          (0xFFFFFFFFu)
#define CSL_AINTC_VBR_BASE_SHIFT         (0x00000000u)
#define CSL_AINTC_VBR_BASE_RESETVAL      (0x00000000u)

#define CSL_AINTC_VBR_RESETVAL           (0x00000000u)

/* VSR */


#define CSL_AINTC_VSR_SIZE_MASK          (0x000000FFu)
#define CSL_AINTC_VSR_SIZE_SHIFT         (0x00000000u)
#define CSL_AINTC_VSR_SIZE_RESETVAL      (0x00000000u)

#define CSL_AINTC_VSR_RESETVAL           (0x00000000u)

/* VNR */

#define CSL_AINTC_VNR_NULL_MASK          (0xFFFFFFFFu)
#define CSL_AINTC_VNR_NULL_SHIFT         (0x00000000u)
#define CSL_AINTC_VNR_NULL_RESETVAL      (0x00000000u)

#define CSL_AINTC_VNR_RESETVAL           (0x00000000u)

/* GPIR */

#define CSL_AINTC_GPIR_NONE_MASK         (0x80000000u)
#define CSL_AINTC_GPIR_NONE_SHIFT        (0x0000001Fu)
#define CSL_AINTC_GPIR_NONE_RESETVAL     (0x00000001u)


#define CSL_AINTC_GPIR_PRI_INDX_MASK     (0x000003FFu)
#define CSL_AINTC_GPIR_PRI_INDX_SHIFT    (0x00000000u)
#define CSL_AINTC_GPIR_PRI_INDX_RESETVAL (0x00000000u)

#define CSL_AINTC_GPIR_RESETVAL          (0x80000000u)

/* GPVR */

#define CSL_AINTC_GPVR_ADDR_MASK         (0xFFFFFFFFu)
#define CSL_AINTC_GPVR_ADDR_SHIFT        (0x00000000u)
#define CSL_AINTC_GPVR_ADDR_RESETVAL     (0x00000000u)

#define CSL_AINTC_GPVR_RESETVAL          (0x00000000u)

/* SRSR1 */

#define CSL_AINTC_SRSR1_RAW_STATUS_MASK  (0xFFFFFFFFu)
#define CSL_AINTC_SRSR1_RAW_STATUS_SHIFT (0x00000000u)
#define CSL_AINTC_SRSR1_RAW_STATUS_RESETVAL (0x00000000u)

#define CSL_AINTC_SRSR1_RESETVAL         (0x00000000u)

/* SRSR2 */

#define CSL_AINTC_SRSR2_RAW_STATUS_MASK  (0xFFFFFFFFu)
#define CSL_AINTC_SRSR2_RAW_STATUS_SHIFT (0x00000000u)
#define CSL_AINTC_SRSR2_RAW_STATUS_RESETVAL (0x00000000u)

#define CSL_AINTC_SRSR2_RESETVAL         (0x00000000u)

/* SRSR3 */


#define CSL_AINTC_SRSR3_RAW_STATUS_MASK  (0x07FFFFFFu)
#define CSL_AINTC_SRSR3_RAW_STATUS_SHIFT (0x00000000u)
#define CSL_AINTC_SRSR3_RAW_STATUS_RESETVAL (0x00000000u)

#define CSL_AINTC_SRSR3_RESETVAL         (0x00000000u)

/* SECR1 */

#define CSL_AINTC_SECR1_ENBL_STATUS_MASK (0xFFFFFFFFu)
#define CSL_AINTC_SECR1_ENBL_STATUS_SHIFT (0x00000000u)
#define CSL_AINTC_SECR1_ENBL_STATUS_RESETVAL (0x00000000u)

#define CSL_AINTC_SECR1_RESETVAL         (0x00000000u)

/* SECR2 */

#define CSL_AINTC_SECR2_ENBL_STATUS_MASK (0xFFFFFFFFu)
#define CSL_AINTC_SECR2_ENBL_STATUS_SHIFT (0x00000000u)
#define CSL_AINTC_SECR2_ENBL_STATUS_RESETVAL (0x00000000u)

#define CSL_AINTC_SECR2_RESETVAL         (0x00000000u)

/* SECR3 */


#define CSL_AINTC_SECR3_ENBL_STATUS_MASK (0x07FFFFFFu)
#define CSL_AINTC_SECR3_ENBL_STATUS_SHIFT (0x00000000u)
#define CSL_AINTC_SECR3_ENBL_STATUS_RESETVAL (0x00000000u)

#define CSL_AINTC_SECR3_RESETVAL         (0x00000000u)

/* ESR1 */

#define CSL_AINTC_ESR1_ENABLE_MASK       (0xFFFFFFFFu)
#define CSL_AINTC_ESR1_ENABLE_SHIFT      (0x00000000u)
#define CSL_AINTC_ESR1_ENABLE_RESETVAL   (0x00000000u)

#define CSL_AINTC_ESR1_RESETVAL          (0x00000000u)

/* ESR2 */

#define CSL_AINTC_ESR2_ENABLE_MASK       (0xFFFFFFFFu)
#define CSL_AINTC_ESR2_ENABLE_SHIFT      (0x00000000u)
#define CSL_AINTC_ESR2_ENABLE_RESETVAL   (0x00000000u)

#define CSL_AINTC_ESR2_RESETVAL          (0x00000000u)

/* ESR3 */


#define CSL_AINTC_ESR3_ENABLE_MASK       (0x07FFFFFFu)
#define CSL_AINTC_ESR3_ENABLE_SHIFT      (0x00000000u)
#define CSL_AINTC_ESR3_ENABLE_RESETVAL   (0x00000000u)

#define CSL_AINTC_ESR3_RESETVAL          (0x00000000u)

/* ECR1 */

#define CSL_AINTC_ECR1_DISABLE_MASK      (0xFFFFFFFFu)
#define CSL_AINTC_ECR1_DISABLE_SHIFT     (0x00000000u)
#define CSL_AINTC_ECR1_DISABLE_RESETVAL  (0x00000000u)

#define CSL_AINTC_ECR1_RESETVAL          (0x00000000u)

/* ECR2 */

#define CSL_AINTC_ECR2_DISABLE_MASK      (0xFFFFFFFFu)
#define CSL_AINTC_ECR2_DISABLE_SHIFT     (0x00000000u)
#define CSL_AINTC_ECR2_DISABLE_RESETVAL  (0x00000000u)

#define CSL_AINTC_ECR2_RESETVAL          (0x00000000u)

/* ECR3 */


#define CSL_AINTC_ECR3_DISABLE_MASK      (0x07FFFFFFu)
#define CSL_AINTC_ECR3_DISABLE_SHIFT     (0x00000000u)
#define CSL_AINTC_ECR3_DISABLE_RESETVAL  (0x00000000u)

#define CSL_AINTC_ECR3_RESETVAL          (0x00000000u)

/* CMR0 */

#define CSL_AINTC_CMR0_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR0_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR0_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR0_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR0_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR0_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR0_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR0_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR0_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR0_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR0_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR0_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR0_RESETVAL          (0x00000000u)

/* CMR1 */

#define CSL_AINTC_CMR1_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR1_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR1_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR1_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR1_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR1_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR1_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR1_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR1_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR1_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR1_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR1_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR1_RESETVAL          (0x00000000u)

/* CMR2 */

#define CSL_AINTC_CMR2_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR2_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR2_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR2_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR2_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR2_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR2_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR2_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR2_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR2_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR2_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR2_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR2_RESETVAL          (0x00000000u)

/* CMR3 */

#define CSL_AINTC_CMR3_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR3_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR3_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR3_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR3_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR3_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR3_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR3_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR3_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR3_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR3_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR3_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR3_RESETVAL          (0x00000000u)

/* CMR4 */

#define CSL_AINTC_CMR4_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR4_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR4_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR4_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR4_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR4_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR4_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR4_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR4_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR4_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR4_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR4_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR4_RESETVAL          (0x00000000u)

/* CMR5 */

#define CSL_AINTC_CMR5_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR5_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR5_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR5_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR5_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR5_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR5_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR5_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR5_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR5_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR5_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR5_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR5_RESETVAL          (0x00000000u)

/* CMR6 */

#define CSL_AINTC_CMR6_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR6_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR6_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR6_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR6_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR6_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR6_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR6_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR6_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR6_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR6_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR6_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR6_RESETVAL          (0x00000000u)

/* CMR7 */

#define CSL_AINTC_CMR7_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR7_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR7_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR7_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR7_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR7_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR7_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR7_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR7_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR7_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR7_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR7_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR7_RESETVAL          (0x00000000u)

/* CMR8 */

#define CSL_AINTC_CMR8_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR8_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR8_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR8_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR8_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR8_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR8_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR8_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR8_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR8_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR8_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR8_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR8_RESETVAL          (0x00000000u)

/* CMR9 */

#define CSL_AINTC_CMR9_CHNL_NPLUS3_MASK  (0xFF000000u)
#define CSL_AINTC_CMR9_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR9_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR9_CHNL_NPLUS2_MASK  (0x00FF0000u)
#define CSL_AINTC_CMR9_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR9_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR9_CHNL_NPLUS1_MASK  (0x0000FF00u)
#define CSL_AINTC_CMR9_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR9_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR9_CHNL_N_MASK       (0x000000FFu)
#define CSL_AINTC_CMR9_CHNL_N_SHIFT      (0x00000000u)
#define CSL_AINTC_CMR9_CHNL_N_RESETVAL   (0x00000000u)

#define CSL_AINTC_CMR9_RESETVAL          (0x00000000u)

/* CMR10 */

#define CSL_AINTC_CMR10_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR10_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR10_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR10_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR10_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR10_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR10_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR10_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR10_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR10_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR10_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR10_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR10_RESETVAL         (0x00000000u)

/* CMR11 */

#define CSL_AINTC_CMR11_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR11_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR11_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR11_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR11_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR11_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR11_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR11_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR11_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR11_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR11_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR11_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR11_RESETVAL         (0x00000000u)

/* CMR12 */

#define CSL_AINTC_CMR12_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR12_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR12_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR12_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR12_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR12_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR12_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR12_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR12_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR12_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR12_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR12_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR12_RESETVAL         (0x00000000u)

/* CMR13 */

#define CSL_AINTC_CMR13_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR13_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR13_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR13_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR13_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR13_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR13_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR13_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR13_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR13_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR13_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR13_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR13_RESETVAL         (0x00000000u)

/* CMR14 */

#define CSL_AINTC_CMR14_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR14_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR14_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR14_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR14_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR14_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR14_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR14_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR14_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR14_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR14_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR14_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR14_RESETVAL         (0x00000000u)

/* CMR15 */

#define CSL_AINTC_CMR15_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR15_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR15_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR15_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR15_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR15_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR15_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR15_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR15_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR15_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR15_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR15_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR15_RESETVAL         (0x00000000u)

/* CMR16 */

#define CSL_AINTC_CMR16_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR16_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR16_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR16_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR16_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR16_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR16_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR16_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR16_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR16_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR16_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR16_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR16_RESETVAL         (0x00000000u)

/* CMR17 */

#define CSL_AINTC_CMR17_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR17_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR17_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR17_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR17_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR17_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR17_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR17_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR17_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR17_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR17_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR17_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR17_RESETVAL         (0x00000000u)

/* CMR18 */

#define CSL_AINTC_CMR18_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR18_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR18_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR18_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR18_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR18_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR18_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR18_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR18_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR18_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR18_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR18_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR18_RESETVAL         (0x00000000u)

/* CMR19 */

#define CSL_AINTC_CMR19_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR19_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR19_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR19_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR19_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR19_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR19_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR19_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR19_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR19_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR19_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR19_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR19_RESETVAL         (0x00000000u)

/* CMR20 */

#define CSL_AINTC_CMR20_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR20_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR20_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR20_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR20_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR20_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR20_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR20_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR20_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR20_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR20_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR20_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR20_RESETVAL         (0x00000000u)

/* CMR21 */

#define CSL_AINTC_CMR21_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR21_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR21_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR21_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR21_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR21_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR21_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR21_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR21_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR21_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR21_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR21_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR21_RESETVAL         (0x00000000u)

/* CMR22 */

#define CSL_AINTC_CMR22_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR22_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR22_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR22_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR22_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR22_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR22_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR22_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR22_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR22_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR22_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR22_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR22_RESETVAL         (0x00000000u)

/* CMR23 */

#define CSL_AINTC_CMR23_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR23_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR23_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR23_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR23_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR23_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR23_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR23_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR23_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR23_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR23_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR23_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR23_RESETVAL         (0x00000000u)

/* CMR24 */

#define CSL_AINTC_CMR24_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR24_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR24_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR24_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR24_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR24_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR24_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR24_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR24_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR24_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR24_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR24_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR24_RESETVAL         (0x00000000u)

/* CMR25 */

#define CSL_AINTC_CMR25_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR25_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR25_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR25_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR25_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR25_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR25_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR25_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR25_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR25_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR25_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR25_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR25_RESETVAL         (0x00000000u)

/* CMR26 */

#define CSL_AINTC_CMR26_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR26_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR26_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR26_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR26_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR26_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR26_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR26_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR26_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR26_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR26_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR26_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR26_RESETVAL         (0x00000000u)

/* CMR27 */

#define CSL_AINTC_CMR27_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR27_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR27_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR27_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR27_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR27_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR27_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR27_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR27_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR27_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR27_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR27_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR27_RESETVAL         (0x00000000u)

/* CMR28 */

#define CSL_AINTC_CMR28_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR28_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR28_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR28_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR28_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR28_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR28_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR28_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR28_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR28_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR28_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR28_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR28_RESETVAL         (0x00000000u)

/* CMR29 */

#define CSL_AINTC_CMR29_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR29_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR29_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR29_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR29_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR29_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR29_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR29_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR29_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR29_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR29_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR29_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR29_RESETVAL         (0x00000000u)

/* CMR30 */

#define CSL_AINTC_CMR30_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR30_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR30_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR30_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR30_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR30_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR30_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR30_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR30_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR30_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR30_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR30_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR30_RESETVAL         (0x00000000u)

/* CMR31 */

#define CSL_AINTC_CMR31_CHNL_NPLUS3_MASK (0xFF000000u)
#define CSL_AINTC_CMR31_CHNL_NPLUS3_SHIFT (0x00000018u)
#define CSL_AINTC_CMR31_CHNL_NPLUS3_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR31_CHNL_NPLUS2_MASK (0x00FF0000u)
#define CSL_AINTC_CMR31_CHNL_NPLUS2_SHIFT (0x00000010u)
#define CSL_AINTC_CMR31_CHNL_NPLUS2_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR31_CHNL_NPLUS1_MASK (0x0000FF00u)
#define CSL_AINTC_CMR31_CHNL_NPLUS1_SHIFT (0x00000008u)
#define CSL_AINTC_CMR31_CHNL_NPLUS1_RESETVAL (0x00000000u)

#define CSL_AINTC_CMR31_CHNL_N_MASK      (0x000000FFu)
#define CSL_AINTC_CMR31_CHNL_N_SHIFT     (0x00000000u)
#define CSL_AINTC_CMR31_CHNL_N_RESETVAL  (0x00000000u)

#define CSL_AINTC_CMR31_RESETVAL         (0x00000000u)

/* HIPIR1 */

#define CSL_AINTC_HIPIR1_NONE_MASK       (0x80000000u)
#define CSL_AINTC_HIPIR1_NONE_SHIFT      (0x0000001Fu)
#define CSL_AINTC_HIPIR1_NONE_RESETVAL   (0x00000001u)


#define CSL_AINTC_HIPIR1_PRI_INDX_MASK   (0x000003FFu)
#define CSL_AINTC_HIPIR1_PRI_INDX_SHIFT  (0x00000000u)
#define CSL_AINTC_HIPIR1_PRI_INDX_RESETVAL (0x00000000u)

#define CSL_AINTC_HIPIR1_RESETVAL        (0x80000000u)

/* HIPIR2 */

#define CSL_AINTC_HIPIR2_NONE_MASK       (0x80000000u)
#define CSL_AINTC_HIPIR2_NONE_SHIFT      (0x0000001Fu)
#define CSL_AINTC_HIPIR2_NONE_RESETVAL   (0x00000001u)


#define CSL_AINTC_HIPIR2_PRI_INDX_MASK   (0x000003FFu)
#define CSL_AINTC_HIPIR2_PRI_INDX_SHIFT  (0x00000000u)
#define CSL_AINTC_HIPIR2_PRI_INDX_RESETVAL (0x00000000u)

#define CSL_AINTC_HIPIR2_RESETVAL        (0x80000000u)

/* SITR1 */

#define CSL_AINTC_SITR1_TYPE_MASK        (0xFFFFFFFFu)
#define CSL_AINTC_SITR1_TYPE_SHIFT       (0x00000000u)
#define CSL_AINTC_SITR1_TYPE_RESETVAL    (0x00000000u)
/*----TYPE Tokens----*/
#define CSL_AINTC_SITR1_TYPE_LEVEL       (0x00000000u)
#define CSL_AINTC_SITR1_TYPE_EDGE        (0x00000001u)

#define CSL_AINTC_SITR1_RESETVAL         (0x00000000u)

/* SITR2 */

#define CSL_AINTC_SITR2_TYPE_MASK        (0xFFFFFFFFu)
#define CSL_AINTC_SITR2_TYPE_SHIFT       (0x00000000u)
#define CSL_AINTC_SITR2_TYPE_RESETVAL    (0x00000000u)
/*----TYPE Tokens----*/
#define CSL_AINTC_SITR2_TYPE_LEVEL       (0x00000000u)
#define CSL_AINTC_SITR2_TYPE_EDGE        (0x00000001u)

#define CSL_AINTC_SITR2_RESETVAL         (0x00000000u)

/* SITR3 */


#define CSL_AINTC_SITR3_TYPE_MASK        (0x07FFFFFFu)
#define CSL_AINTC_SITR3_TYPE_SHIFT       (0x00000000u)
#define CSL_AINTC_SITR3_TYPE_RESETVAL    (0x00000000u)
/*----TYPE Tokens----*/
#define CSL_AINTC_SITR3_TYPE_LEVEL       (0x00000000u)
#define CSL_AINTC_SITR3_TYPE_EDGE        (0x00000001u)

#define CSL_AINTC_SITR3_RESETVAL         (0x00000000u)

/* DSR1 */

#define CSL_AINTC_DSR1_ENABLE_MASK       (0x80000000u)
#define CSL_AINTC_DSR1_ENABLE_SHIFT      (0x0000001Fu)
#define CSL_AINTC_DSR1_ENABLE_RESETVAL   (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_AINTC_DSR1_ENABLE_DISABLE    (0x00000000u)
#define CSL_AINTC_DSR1_ENABLE_ENABLE     (0x00000001u)


#define CSL_AINTC_DSR1_SELECT_MASK       (0x00001FFFu)
#define CSL_AINTC_DSR1_SELECT_SHIFT      (0x00000000u)
#define CSL_AINTC_DSR1_SELECT_RESETVAL   (0x00000000u)

#define CSL_AINTC_DSR1_RESETVAL          (0x00000000u)

/* DSR2 */

#define CSL_AINTC_DSR2_ENABLE_MASK       (0x80000000u)
#define CSL_AINTC_DSR2_ENABLE_SHIFT      (0x0000001Fu)
#define CSL_AINTC_DSR2_ENABLE_RESETVAL   (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_AINTC_DSR2_ENABLE_DISABLE    (0x00000000u)
#define CSL_AINTC_DSR2_ENABLE_ENABLE     (0x00000001u)


#define CSL_AINTC_DSR2_SELECT_MASK       (0x00001FFFu)
#define CSL_AINTC_DSR2_SELECT_SHIFT      (0x00000000u)
#define CSL_AINTC_DSR2_SELECT_RESETVAL   (0x00000000u)

#define CSL_AINTC_DSR2_RESETVAL          (0x00000000u)

/* HINLR1 */

#define CSL_AINTC_HINLR1_OVERRIDE_MASK   (0x80000000u)
#define CSL_AINTC_HINLR1_OVERRIDE_SHIFT  (0x0000001Fu)
#define CSL_AINTC_HINLR1_OVERRIDE_RESETVAL (0x00000000u)


#define CSL_AINTC_HINLR1_NEST_LVL_MASK   (0x000001FFu)
#define CSL_AINTC_HINLR1_NEST_LVL_SHIFT  (0x00000000u)
#define CSL_AINTC_HINLR1_NEST_LVL_RESETVAL (0x00000000u)

#define CSL_AINTC_HINLR1_RESETVAL        (0x00000000u)

/* HINLR2 */

#define CSL_AINTC_HINLR2_OVERRIDE_MASK   (0x80000000u)
#define CSL_AINTC_HINLR2_OVERRIDE_SHIFT  (0x0000001Fu)
#define CSL_AINTC_HINLR2_OVERRIDE_RESETVAL (0x00000000u)


#define CSL_AINTC_HINLR2_NEST_LVL_MASK   (0x000001FFu)
#define CSL_AINTC_HINLR2_NEST_LVL_SHIFT  (0x00000000u)
#define CSL_AINTC_HINLR2_NEST_LVL_RESETVAL (0x00000000u)

#define CSL_AINTC_HINLR2_RESETVAL        (0x00000000u)

/* HIER */


#define CSL_AINTC_HIER_IRQ_MASK          (0x00000002u)
#define CSL_AINTC_HIER_IRQ_SHIFT         (0x00000001u)
#define CSL_AINTC_HIER_IRQ_RESETVAL      (0x00000000u)
/*----IRQ Tokens----*/
#define CSL_AINTC_HIER_IRQ_DISABLE       (0x00000000u)
#define CSL_AINTC_HIER_IRQ_ENABLE        (0x00000001u)

#define CSL_AINTC_HIER_FIQ_MASK          (0x00000001u)
#define CSL_AINTC_HIER_FIQ_SHIFT         (0x00000000u)
#define CSL_AINTC_HIER_FIQ_RESETVAL      (0x00000000u)
/*----FIQ Tokens----*/
#define CSL_AINTC_HIER_FIQ_DISABLE       (0x00000000u)
#define CSL_AINTC_HIER_FIQ_ENABLE        (0x00000001u)

#define CSL_AINTC_HIER_RESETVAL          (0x00000000u)

/* HIPVR1 */

#define CSL_AINTC_HIPVR1_ADDR_MASK       (0xFFFFFFFFu)
#define CSL_AINTC_HIPVR1_ADDR_SHIFT      (0x00000000u)
#define CSL_AINTC_HIPVR1_ADDR_RESETVAL   (0x00000000u)

#define CSL_AINTC_HIPVR1_RESETVAL        (0x00000000u)

/* HIPVR2 */

#define CSL_AINTC_HIPVR2_ADDR_MASK       (0xFFFFFFFFu)
#define CSL_AINTC_HIPVR2_ADDR_SHIFT      (0x00000000u)
#define CSL_AINTC_HIPVR2_ADDR_RESETVAL   (0x00000000u)

#define CSL_AINTC_HIPVR2_RESETVAL        (0x00000000u)

#endif
