//=============================================================================
// File: PRU_PRUtoDSP_Interrupt.p 
// Desc: PRU example to Configure INTC registers to interrupt the DSP by generating PRUSS_EVT0
// Vers: 1.0
//                             
//  Copyright (c) 2009 Texas instruments,Incorporated
//  All rights reserved
//
//=============================================================================
// PRU Example iluustrates configuring PRU interrupts to host ports 2-9 
// to generate PRUSS SYS_EVT that can be used to interrupt the DSP. 
// The code configures INTC registers and connects the SYS_EVT32 to the channel number
// which intun is hooked to the host port 2 which generates the SYS_EVT0 for the DSP.
// The event is generated by the event out mapping procedure of the PRU wherein the PRU
// writes into its own status register31 to generate a internal system event. 
// 
//=============================================================================


.origin 0
.entrypoint PRUTODSP_INTERRUPT

#include "PRU_PRUtoDSP_Interrupt.hp"


PRUTODSP_INTERRUPT:
    // Initialize pointer to INTC registers
    MOV32     regOffset, 0x00000000
    //Clear SYS_EVT32
    MOV32     r31, 0x00000000

    // Global enable the all host interrupts
    LDI       regVal.w0, 0x0001
    SBCO      regVal, CONST_PRUSSINTC, GER_OFFSET, 2
    SBCO      regVal, CONST_DDR, 0x04, 2

    // Enable host interrupt 0
    MOV32     regVal, (0x00000000 | HOST_NUM)
    SBCO      regVal, CONST_PRUSSINTC, HIESR_OFFSET, 4

    // Map channel 0 to host 2
    LDI       regOffset.w0, INTC_HOSTMAP_REGS_OFFSET
    ADD       regOffset.w0, regOffset.w0, HOST_NUM
    LDI       regVal.w0, CHN_NUM
    SBCO      regVal, CONST_PRUSSINTC, regOffset.w0, 1

    // Map SYS_EVT32 interrupt to channel 0
    LDI       regOffset.w0, INTC_CHNMAP_REGS_OFFSET
    ADD       regOffset, regOffset, SYS_EVT
    LDI       regVal.b0, CHN_NUM
    SBCO      regVal.b0, CONST_PRUSSINTC, regOffset.w0, 1

    // Make sure the SYS_EVT32 system interrupt is cleared
    MOV32     regVal, SYS_EVT
    SBCO      regVal, CONST_PRUSSINTC, SICR_OFFSET, 4

    // Enable SYS_EVT32 system interrupt
    SBCO      regVal, CONST_PRUSSINTC, EISR_OFFSET,  4

    //Generate SYS_EVT32 by event out mapping
    MOV32     r31, SYS_EVT
    SBCO      regVal, CONST_DDR, 0x04, 4


DONE:
    MOV32     regVal, 0x0B
    SBCO      regVal, CONST_DDR, 0x04, 4
    
// Clear the status of the interrupt
    LDI	regVal.w2,	0x0000
    LDI	regVal.w0,	SYS_EVT
    SBCO	regVal,	CONST_PRUSSINTC,	0x24,        4
    
    HALT

//===================================================================================
// End of file PRU_PRUtoDSP_Interrupt.p 
//
//  Copyright (c) 2009 Texas instruments,Incorporated
//  All rights reserved
//===================================================================================
